/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.textparser;

import com.elluminate.gui.textparser.TextParser;
import com.elluminate.gui.textparser.TextParserAppender;
import com.elluminate.gui.textparser.attributeset.HyperlinkAttributeSet;
import com.elluminate.gui.textparser.attributeset.ParsedTextAttributeSet;
import com.elluminate.gui.textparser.attributeset.SmileyAttributeSet;
import com.elluminate.gui.textparser.helper.ParseEvent;
import com.elluminate.gui.textparser.helper.ParseListener;
import com.elluminate.gui.textparser.helper.SmileyPosition;
import com.elluminate.gui.textparser.helper.SmileyPositionComparator;
import com.elluminate.util.net.VClassURI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;

public class TextParserStyledDocument
extends DefaultStyledDocument
implements ParseListener,
TextParserAppender {
    private TextParser textParser = new TextParser(this);
    private boolean parseSmileys = true;
    static final int maximumSmileysInAMessage = 25;

    public TextParserStyledDocument() {
        this(true);
    }

    public TextParserStyledDocument(boolean parseSmileys) {
        this.textParser.addParseListener(this);
        this.parseSmileys = parseSmileys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.writeLock();
        try {
            this.textParser.normalizeAfterDelete(this.getText(0, this.getLength()), offset);
            String existingText = this.getText(0, this.getLength());
            String wordBefore = this.textParser.getWordBeforeOffset(existingText, offset);
            String wordAfter = this.textParser.getWordAfterOffset(existingText, offset);
            this.textParser.processMultipleCharacters(offset - wordBefore.length(), wordBefore + wordAfter, this.getText(0, this.getLength()));
        }
        finally {
            this.writeUnlock();
        }
    }

    public void superRemove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
    }

    @Override
    public void insertString(int offset, String text, AttributeSet attr) throws BadLocationException {
        this.insertString(offset, text, attr, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertString(int offset, String text, AttributeSet attr, boolean doNormalization) throws BadLocationException {
        if (text.length() != 1) {
            this.writeLock();
            try {
                this.textParser.normalizeAttributeSet(attr);
            }
            finally {
                this.writeUnlock();
            }
            super.insertString(offset, text, attr);
            this.writeLock();
            try {
                this.textParser.processMultipleCharacters(offset, text, this.getText(0, this.getLength()), false, doNormalization);
            }
            finally {
                this.writeUnlock();
            }
        }
        this.writeLock();
        try {
            this.textParser.normalizeAttributeSet(attr);
        }
        finally {
            this.writeUnlock();
        }
        super.insertString(offset, text, attr);
        this.writeLock();
        try {
            String existingText = this.getText(0, this.getLength());
            String wordBefore = this.textParser.getWordBeforeOffset(existingText, offset);
            String wordAfter = this.textParser.getWordAfterOffset(existingText, offset + text.length());
            this.textParser.processMultipleCharacters(offset - wordBefore.length(), wordBefore + text + wordAfter, this.getText(0, this.getLength()), false, doNormalization);
        }
        finally {
            this.writeUnlock();
        }
        if (this.parseSmileys) {
            this.processSmileys(this.getText(0, this.getLength()), offset, text);
        }
    }

    public void appendString(String text, AttributeSet attr) throws BadLocationException {
        this.appendString(text, attr, this);
    }

    void appendString(String text, AttributeSet attr, TextParserAppender appender) throws BadLocationException {
        StringTokenizer st = new StringTokenizer(text, " \n", true);
        int tokenIndex = 0;
        int tokenOffset = 0;
        int startOfText = 0;
        List smileys = this.textParser.getAllSmileys(text);
        Collections.sort(smileys, new SmileyPositionComparator());
        SmileyPosition sPos = null;
        int smileyIndex = 0;
        HyperlinkAttributeSet LINK_ATTRIBUTES = new HyperlinkAttributeSet(null);
        int numberOfSmileys = 0;
        sPos = this.getSmileyAtPosition(smileys, smileyIndex++);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (this.isURI(token)) {
                if (tokenOffset != startOfText) {
                    String insertString = text.substring(startOfText, tokenOffset);
                    appender.superInsertString(appender.getLength(), insertString, attr);
                }
                HyperlinkAttributeSet hyperAttr = (HyperlinkAttributeSet)((ParsedTextAttributeSet)LINK_ATTRIBUTES).copy(attr);
                appender.superInsertString(appender.getLength(), token, hyperAttr);
                ++tokenIndex;
                startOfText = tokenOffset += token.length();
                while (sPos != null && sPos.smileyStartPosition < tokenOffset) {
                    sPos = this.getSmileyAtPosition(smileys, smileyIndex++);
                }
                continue;
            }
            if (sPos != null && sPos.smileyStartPosition < tokenOffset + token.length()) {
                String previousPart = text.substring(tokenOffset, sPos.smileyStartPosition);
                if (!this.isURI(previousPart)) {
                    String insertString = text.substring(startOfText, sPos.smileyStartPosition);
                    if (insertString != null && !insertString.equals("")) {
                        appender.superInsertString(appender.getLength(), insertString, attr);
                    }
                    startOfText = sPos.smileyStartPosition;
                    while (sPos != null && sPos.smileyStartPosition < tokenOffset + token.length()) {
                        SmileyAttributeSet smileyAttr = (SmileyAttributeSet)sPos.attr.copy(attr);
                        String smileyPattern = smileyAttr.getTextPattern();
                        if (numberOfSmileys++ < 25) {
                            appender.superInsertString(appender.getLength(), " ", smileyAttr);
                            appender.superInsertString(appender.getLength(), " ", attr);
                        }
                        int smileyLength = smileyPattern.length();
                        startOfText = sPos.smileyStartPosition + smileyLength;
                        sPos = this.getSmileyAtPosition(smileys, smileyIndex++);
                    }
                } else {
                    while (sPos != null && sPos.smileyStartPosition < tokenOffset + token.length()) {
                        sPos = this.getSmileyAtPosition(smileys, smileyIndex++);
                    }
                }
            }
            tokenOffset += token.length();
            ++tokenIndex;
        }
        String insertString = text.substring(startOfText);
        if (insertString != null && !insertString.equals("")) {
            appender.superInsertString(appender.getLength(), insertString, attr);
        }
    }

    private boolean isURI(String text) {
        try {
            new VClassURI(text);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private SmileyPosition getSmileyAtPosition(List smileys, int smileyIndex) {
        if (smileys.size() > smileyIndex) {
            return (SmileyPosition)smileys.get(smileyIndex++);
        }
        return null;
    }

    @Override
    public void superInsertString(int offset, String text, AttributeSet attr) throws BadLocationException {
        super.insertString(offset, text, attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws BadLocationException {
        if (this.getLength() > 0) {
            String rawText = this.getRawText();
            this.writeLock();
            try {
                this.textParser.processMultipleCharacters(0, rawText, rawText, true);
            }
            finally {
                this.writeUnlock();
            }
            if (this.parseSmileys) {
                this.processSmileys(rawText, 0, rawText);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHyperlinkSelected(boolean isSelected, int offset, String text) {
        this.writeLock();
        try {
            AttributeSet attr = this.getCharacterElement(offset).getAttributes();
            this.textParser.setHyperlinkSelected(isSelected, offset, text, attr);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSmileys(String existingText, int offset, String insertedText) throws BadLocationException {
        String wordBefore = this.textParser.getWordBeforeOffset(existingText, offset);
        String wordAfter = this.textParser.getWordAfterOffset(existingText, offset + insertedText.length());
        String smileyCheckWord = wordBefore + insertedText + wordAfter;
        List smileys = this.textParser.getAllSmileys(smileyCheckWord);
        Collections.sort(smileys, new SmileyPositionComparator());
        offset -= wordBefore.length();
        for (int i = smileys.size() - 1; i >= 0; --i) {
            SmileyPosition sPos = (SmileyPosition)smileys.get(i);
            int smileyIndexInWord = sPos.smileyStartPosition;
            if (this.textParser.isPotentialHyperlink(this.textParser.getWordBeforeOffset(smileyCheckWord, smileyIndexInWord))) continue;
            int smileyOffset = offset + smileyIndexInWord;
            AttributeSet defaultAttr = this.getCharacterElement(smileyOffset).getAttributes();
            SmileyAttributeSet smileyAttr = (SmileyAttributeSet)sPos.attr.copy(defaultAttr);
            String smileyPattern = smileyAttr.getTextPattern();
            super.remove(smileyOffset, smileyPattern.length());
            int totalSpacePadding = this.getSmileySpacePadding(smileyPattern);
            int spacesBefore = totalSpacePadding / 2;
            if (spacesBefore > 0) {
                super.insertString(smileyOffset, this.createSpacesString(spacesBefore), defaultAttr);
                smileyOffset += spacesBefore;
            }
            super.insertString(smileyOffset, " ", smileyAttr);
            this.writeLock();
            try {
                this.textParser.normalizeAttributeSet(defaultAttr);
            }
            finally {
                this.writeUnlock();
            }
            int spacesAfter = totalSpacePadding / 2 + totalSpacePadding % 2;
            if (spacesAfter < 1) {
                spacesAfter = 1;
            }
            super.insertString(smileyOffset + 1, this.createSpacesString(spacesAfter), defaultAttr);
        }
    }

    private String createSpacesString(int numberOfSpaces) {
        String s = "";
        for (int i = 0; i < numberOfSpaces; ++i) {
            s = s + " ";
        }
        return s;
    }

    protected int getSmileySpacePadding(String smileyPattern) {
        return 1;
    }

    public String getHyperlinkAtOffset(int offset) {
        try {
            String existingText = this.getText(0, this.getLength());
            int linkStartOffset = -1;
            int linkEndOffset = -1;
            Element element = this.getCharacterElement(offset);
            AttributeSet attr = element.getAttributes();
            if (!this.textParser.isHyperlinkAttribute(attr)) {
                return null;
            }
            while (attr != null && this.textParser.isHyperlinkAttribute(attr)) {
                attr = null;
                linkStartOffset = element.getStartOffset();
                if (linkStartOffset <= 0) continue;
                element = this.getCharacterElement(linkStartOffset - 1);
                attr = element.getAttributes();
            }
            element = this.getCharacterElement(offset);
            attr = element.getAttributes();
            while (attr != null && this.textParser.isHyperlinkAttribute(attr)) {
                attr = null;
                linkEndOffset = element.getEndOffset();
                if (linkEndOffset >= existingText.length()) continue;
                element = this.getCharacterElement(linkEndOffset);
                attr = element.getAttributes();
            }
            return existingText.substring(linkStartOffset, linkEndOffset);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getRawText() {
        return this.getRawText(0, this.getLength());
    }

    public String getRawText(int startPos, int length) {
        String existingText = "";
        try {
            existingText = this.getText(startPos, length);
            List smileyPositions = this.getSmileyPositions(startPos, length, existingText);
            if (smileyPositions != null && smileyPositions.size() > 0) {
                for (int i = smileyPositions.size() - 1; i >= 0; --i) {
                    SmileyPosition sp = (SmileyPosition)smileyPositions.get(i);
                    String pattern = sp.smileyPattern;
                    int totalSpaceFiller = this.getSmileySpacePadding(pattern);
                    int spacesBefore = totalSpaceFiller / 2;
                    int spacesAfter = totalSpaceFiller / 2 + totalSpaceFiller % 2;
                    if (spacesAfter < 0) {
                        spacesAfter = 1;
                    }
                    String textBefore = existingText.substring(0, sp.smileyStartPosition - spacesBefore);
                    String textAfter = existingText.substring(sp.smileyStartPosition + 1 + spacesAfter);
                    existingText = textBefore + pattern + textAfter;
                }
            }
        }
        catch (Exception e) {
            return "";
        }
        return existingText;
    }

    public List getSmileyPositions(int startPos, int length, String existingText) {
        LinkedList<SmileyPosition> smileyPositions = new LinkedList<SmileyPosition>();
        int startOffset = startPos;
        int endOffset = startPos;
        while (endOffset < startPos + length - 1) {
            Element element = this.getCharacterElement(startOffset);
            startOffset = element.getStartOffset();
            endOffset = element.getEndOffset();
            MutableAttributeSet attr = (MutableAttributeSet)element.getAttributes();
            if (attr.getAttribute("SmileyAttributeSet_Pattern") != null) {
                String pattern = (String)attr.getAttribute("SmileyAttributeSet_Pattern");
                SmileyPosition sp = new SmileyPosition(startOffset, pattern, null, existingText);
                smileyPositions.add(sp);
            }
            startOffset = endOffset;
        }
        return smileyPositions;
    }

    @Override
    public void textTypeChanged(ParseEvent event) {
        AttributeSet attr = event.getAttributeSet();
        if (attr != null) {
            this.setCharacterAttributes(event.getStartPosition(), event.getOrigText().length(), attr, false);
        }
    }
}

