/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.textparser;

import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.textparser.CursorInfo;
import com.elluminate.gui.textparser.OpenBrowserThread;
import com.elluminate.gui.textparser.StringsProperties;
import com.elluminate.gui.textparser.TextParserStyledDocument;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.net.VClassURI;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;

public class HyperlinkMouseHandler
implements MouseListener,
MouseMotionListener,
HyperlinkListener {
    private static I18n i18n = I18n.create(HyperlinkMouseHandler.class);
    private static Cursor handCursor = new Cursor(12);
    private Cursor previousCursor;

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = event.getURL();
            Object source = event.getSource();
            if (url != null) {
                JComponent sourceComp = null;
                if (source instanceof JComponent) {
                    sourceComp = (JComponent)source;
                }
                new OpenBrowserThread(url.toString(), sourceComp, i18n).start();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        JTextComponent sourceComponent = null;
        if (e.getSource() instanceof JTextComponent) {
            sourceComponent = (JTextComponent)e.getSource();
        }
        if (HyperlinkMouseHandler.isLink(sourceComponent, e.getPoint())) {
            if (sourceComponent.getCursor() != handCursor) {
                this.previousCursor = sourceComponent.getCursor();
            }
            sourceComponent.setCursor(handCursor);
        } else if (sourceComponent.getCursor() == handCursor) {
            if (sourceComponent instanceof CursorInfo) {
                CursorInfo cur = (CursorInfo)((Object)sourceComponent);
                sourceComponent.setCursor(cur.getCursor());
            } else {
                sourceComponent.setCursor(this.previousCursor);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        JTextComponent sourceComponent = null;
        if (e.getSource() instanceof JTextComponent) {
            sourceComponent = (JTextComponent)e.getSource();
            HyperlinkMouseHandler.mouseReleased(e, sourceComponent);
        }
    }

    public static void mouseReleased(MouseEvent e, JTextComponent sourceComponent) {
        HyperlinkMouseHandler.mouseReleased(e.getPoint(), e, sourceComponent);
    }

    public static void mouseReleased(Point pnt, MouseEvent e, JTextComponent sourceComponent) {
        String urlString;
        if (SwingUtilities.isLeftMouseButton(e) && (urlString = HyperlinkMouseHandler.selectUrl(sourceComponent, pnt)) != null) {
            VClassURI uri = null;
            try {
                uri = new VClassURI(urlString);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (uri == null || !uri.isHostValid()) {
                ModalDialog.showMessageDialog(e.getComponent(), i18n.getString((PropertiesEnum)StringsProperties.HYPERLINKMOUSEHANDLER_INVALIDHOST, new Object[]{urlString}), i18n.getString((PropertiesEnum)StringsProperties.HYPERLINKMOUSEHANDLER_INVALIDHOSTTITLE), 0);
                e.consume();
            } else {
                new OpenBrowserThread(urlString, sourceComponent, i18n).start();
                e.consume();
            }
        }
    }

    private static String selectUrl(JTextComponent component, Point point) {
        if (!(component.getDocument() instanceof TextParserStyledDocument)) {
            return null;
        }
        int modelLocation = component.viewToModel(point);
        if (modelLocation >= 0) {
            TextParserStyledDocument doc = (TextParserStyledDocument)component.getDocument();
            try {
                String string = doc.getHyperlinkAtOffset(modelLocation);
                if (string != null && string.length() > 0) {
                    return string;
                }
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static boolean isLink(JTextComponent component, Point point) {
        StyledDocument doc;
        Element element;
        AttributeSet attr;
        int modelLocation = -1;
        try {
            modelLocation = component.viewToModel(point);
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            return false;
        }
        if (modelLocation >= 0 && (attr = (element = (doc = (StyledDocument)component.getDocument()).getCharacterElement(modelLocation)).getAttributes()) != null && attr.getAttribute("ParsedTextAttributeSet_TextType") != null) {
            return (Integer)attr.getAttribute("ParsedTextAttributeSet_TextType") == 1;
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

