/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.event;

import com.elluminate.gui.GuiUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class PopupGestureHandler
extends MouseAdapter {
    public static final int TRIGGER_PLATFORM = 0;
    public static final int TRIGGER_ANY_BUTTON_DOWN = 1;
    public static final int TRIGGER_ANY_BUTTON_UP = 2;
    protected JPopupMenu menu = null;
    private int triggerMode = 0;
    private boolean popupTriggered = false;

    public PopupGestureHandler(JPopupMenu menu) {
        this(menu, 0);
    }

    public PopupGestureHandler(JPopupMenu menu, int triggerMode) {
        this.menu = menu;
        this.triggerMode = triggerMode;
    }

    public JPopupMenu getMenu() {
        return this.menu;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.popupTriggered = this.checkPopup(me);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        boolean triggered = this.checkPopup(me);
        if (!this.popupTriggered) {
            this.popupTriggered = triggered;
        }
    }

    private boolean checkPopup(MouseEvent me) {
        if (me.isConsumed()) {
            return false;
        }
        if (this.isTriggerEvent(me)) {
            me.consume();
            if (this.menu.isVisible()) {
                return true;
            }
            if (!this.prepareToShow(me)) {
                return true;
            }
            Component c = this.determineComponent(me);
            Point loc = this.determineInitialPosition(me, c);
            loc = this.determinePopupLocation(c, loc);
            if (this.menu.getComponentCount() < 1) {
                LogSupport.message((Object)this, (String)"checkPopup", (String)"Attempted to show empty popup meu.");
                return true;
            }
            this.menu.show(c, loc.x, loc.y);
            return true;
        }
        return false;
    }

    protected boolean wasPopupTriggered() {
        return this.popupTriggered;
    }

    protected boolean isTriggerEvent(MouseEvent me) {
        boolean result;
        switch (this.triggerMode) {
            case 1: {
                result = me.getID() == 501;
                break;
            }
            case 2: {
                result = me.getID() == 502;
                break;
            }
            default: {
                result = me.isPopupTrigger();
            }
        }
        return result;
    }

    protected Dimension getMenuSize() {
        return this.menu.getPreferredSize();
    }

    protected Component determineComponent(MouseEvent me) {
        return me.getComponent();
    }

    protected Point determineInitialPosition(MouseEvent me, Component c) {
        Point loc = me.getPoint();
        return SwingUtilities.convertPoint(me.getComponent(), loc, c);
    }

    protected Point determinePopupLocation(Component c, Point loc) {
        Dimension dim = this.getMenuSize();
        if (dim.width <= 0 || dim.height <= 0) {
            return loc;
        }
        Rectangle disp = GuiUtils.getDeviceBounds(loc, c);
        SwingUtilities.convertPointToScreen(loc, c);
        if (loc.x + dim.width >= disp.x + disp.width && loc.x - disp.x > dim.width) {
            loc.x = loc.x - dim.width - 1;
        }
        if (loc.y + dim.height >= disp.y + disp.height && loc.y - disp.y > dim.height) {
            loc.y = loc.y - dim.height - 1;
        }
        SwingUtilities.convertPointFromScreen(loc, c);
        return loc;
    }

    protected boolean prepareToShow(MouseEvent me) {
        return true;
    }
}

