/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.dnd;

import com.elluminate.gui.GUIDebug;
import com.elluminate.gui.dnd.DataFlavorManager;
import com.elluminate.gui.dnd.DropHelperInterface;
import com.elluminate.platform.Platform;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

public class DTListener
implements DropTargetListener {
    public static final int DEFAULT_DROP_ACTIONS = 1;
    private static final boolean NO_FLAVOR_UNTIL_DROP = Platform.getOS() == 202 && !Platform.checkJavaVersion((String)"1.5.0_16+");
    private DataFlavorManager dfManager;
    private int dropActions = 0;
    private DropHelperInterface prevHelper = null;

    public static DropTarget createSimpleDropTarget(Component cmp, DataFlavor flavor, DropHelperInterface helper) {
        DataFlavorManager mgr = new DataFlavorManager();
        mgr.addDataFlavor(flavor, helper, 1);
        DTListener dtl = new DTListener(mgr);
        return new DropTarget(cmp, dtl.getDropActions(), dtl);
    }

    public static DropTarget createSimpleDropTarget(Component cmp, DataFlavor flavor, DropHelperInterface helper, int dropActions) {
        DataFlavorManager mgr = new DataFlavorManager();
        mgr.addDataFlavor(flavor, helper, 1);
        DTListener dtl = new DTListener(mgr, dropActions);
        return new DropTarget(cmp, dtl.getDropActions(), dtl);
    }

    protected DTListener() {
        this.dfManager = new DataFlavorManager();
    }

    public DTListener(DataFlavorManager dfManager) {
        this(dfManager, 1);
    }

    public DTListener(DataFlavorManager dfManager, int dropActions) {
        this.dfManager = dfManager;
        this.dropActions = dropActions;
    }

    public int getDropActions() {
        return this.dropActions;
    }

    public void setDropActions(int actions) {
        this.dropActions = actions;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        try {
            boolean accepted;
            if (GUIDebug.DATA_FLAVORS.show()) {
                LogSupport.message(DTListener.class, (String)"dragEnter", (String)"available DataFlavors:");
                DataFlavor[] fl = e.getCurrentDataFlavors();
                for (int i = 0; i < fl.length; ++i) {
                    LogSupport.message(DTListener.class, (String)"dragEnter", (String)(i + 1 + ": " + fl[i].getMimeType()));
                }
            }
            if (accepted = this.isDragOk(e)) {
                e.acceptDrag(e.getDropAction());
            } else {
                if (GUIDebug.DATA_FLAVORS.show()) {
                    LogSupport.message(DTListener.class, (String)"dragEnter", (String)"Flavour not suported");
                }
                e.rejectDrag();
            }
            DataFlavor chosen = this.dfManager.chooseBestFlavor(e.getTransferable());
            DropHelperInterface helper = this.dfManager.getDropHelper(chosen);
            if (!(this.prevHelper == null || this.prevHelper == helper && accepted)) {
                this.prevHelper.updateUI(3, e.getDropTargetContext(), null, e.getDropAction(), e.getLocation());
                this.prevHelper = null;
            }
            if (accepted) {
                if (helper != null) {
                    helper.updateUI(1, e.getDropTargetContext(), chosen, e.getDropAction(), e.getLocation());
                }
                this.prevHelper = helper;
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"dragEnter", (Throwable)t, (boolean)true);
            e.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        try {
            boolean accepted = this.isDragOk(e);
            if (accepted) {
                e.acceptDrag(e.getDropAction());
            } else {
                if (GUIDebug.DATA_FLAVORS.show()) {
                    LogSupport.message(DTListener.class, (String)"dragOver", (String)"Flavour not suported");
                }
                e.rejectDrag();
            }
            DataFlavor chosen = this.dfManager.chooseBestFlavor(e.getTransferable());
            DropHelperInterface helper = this.dfManager.getDropHelper(chosen);
            if (!(this.prevHelper == null || this.prevHelper == helper && accepted)) {
                this.prevHelper.updateUI(3, e.getDropTargetContext(), null, e.getDropAction(), e.getLocation());
                this.prevHelper = null;
            }
            if (accepted) {
                if (this.prevHelper == null) {
                    helper.updateUI(1, e.getDropTargetContext(), chosen, e.getDropAction(), e.getLocation());
                }
                if (helper != null) {
                    helper.updateUI(2, e.getDropTargetContext(), chosen, e.getDropAction(), e.getLocation());
                }
                this.prevHelper = helper;
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"dragOver", (Throwable)t, (boolean)true);
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        try {
            boolean accepted = this.isDragOk(e);
            if (accepted) {
                e.acceptDrag(e.getDropAction());
            } else {
                if (GUIDebug.DATA_FLAVORS.show()) {
                    LogSupport.message(DTListener.class, (String)"dropActionChanged", (String)"Flavour not suported");
                }
                e.rejectDrag();
            }
            DataFlavor chosen = this.dfManager.chooseBestFlavor(e.getTransferable());
            DropHelperInterface helper = this.dfManager.getDropHelper(chosen);
            if (!(this.prevHelper == null || this.prevHelper == helper && accepted)) {
                this.prevHelper.updateUI(3, e.getDropTargetContext(), null, e.getDropAction(), e.getLocation());
                this.prevHelper = null;
            }
            if (accepted) {
                if (this.prevHelper == null) {
                    helper.updateUI(1, e.getDropTargetContext(), chosen, e.getDropAction(), e.getLocation());
                }
                if (helper != null) {
                    helper.updateUI(4, e.getDropTargetContext(), chosen, e.getDropAction(), e.getLocation());
                }
                this.prevHelper = helper;
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"dropActionChanged", (Throwable)t, (boolean)true);
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        if (this.prevHelper != null) {
            this.prevHelper.updateUI(3, e.getDropTargetContext(), null, 0, null);
            this.prevHelper = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(this.dropActions);
        try {
            DataFlavor chosen = this.dfManager.chooseBestFlavor(e.getTransferable());
            if (GUIDebug.DATA_FLAVORS.show()) {
                LogSupport.message(DTListener.class, (String)"drop", (String)("Flavour: " + chosen));
            }
            if (chosen == null) {
                e.dropComplete(false);
                return;
            }
            DropHelperInterface helper = this.dfManager.getDropHelper(chosen);
            if (GUIDebug.DATA_FLAVORS.show()) {
                LogSupport.message(DTListener.class, (String)"drop", (String)("helper: " + helper));
            }
            if (!helper.isDataValid(e.getTransferable(), chosen, e.getDropAction(), e.getLocation())) {
                e.dropComplete(false);
                return;
            }
            if (helper.objectDropped(e.getTransferable(), chosen, new Point(e.getLocation()), null)) {
                e.dropComplete(true);
            } else {
                e.dropComplete(false);
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"drop", (Throwable)t, (boolean)true);
            e.dropComplete(false);
            return;
        }
        finally {
            this.prevHelper = null;
        }
    }

    private boolean isDragOk(DropTargetDragEvent e) {
        if (NO_FLAVOR_UNTIL_DROP) {
            return true;
        }
        try {
            Transferable xfer = e.getTransferable();
            if (!this.dfManager.isFlavorSupported(xfer)) {
                return false;
            }
            DataFlavor chosen = this.dfManager.chooseBestFlavor(e.getTransferable());
            if (chosen == null) {
                return false;
            }
            if (!this.dfManager.getDropHelper(chosen).isDataValid(xfer, chosen, e.getDropAction(), e.getLocation())) {
                return false;
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"isDragOk", (Throwable)t, (boolean)true);
            return false;
        }
        return true;
    }
}

