/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.ScreenSnapshot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;

public class SeeThruPane
extends JPanel {
    private ScreenSnapshot snapshot = null;
    private ComponentListener clisten = null;
    private Component topWin = null;

    public static boolean isAvailable() {
        return ScreenSnapshot.isAvailable();
    }

    public SeeThruPane() {
        this.initComponents();
        if (ScreenSnapshot.isAvailable()) {
            this.snapshot = new ScreenSnapshot();
        }
    }

    public void register() {
        if (this.topWin != null) {
            throw new IllegalStateException("Component Listener already registered on top-level component: " + this.topWin);
        }
        this.topWin = this.findTop();
        if (this.topWin == null) {
            throw new IllegalStateException("Component not in a container.");
        }
        this.clisten = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                SeeThruPane.this.frameMoved(e);
            }
        };
        this.topWin.addComponentListener(this.clisten);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister() {
        if (this.topWin == null || this.clisten == null) {
            return;
        }
        try {
            this.topWin.removeComponentListener(this.clisten);
        }
        finally {
            this.topWin = null;
            this.clisten = null;
        }
    }

    public boolean isRegistered() {
        return this.topWin != null && this.clisten != null;
    }

    public boolean refresh() {
        if (this.snapshot != null) {
            return this.snapshot.takeSnapshot();
        }
        return true;
    }

    public void clearSnapshot() {
        if (this.snapshot != null) {
            this.snapshot.clear();
        }
    }

    public ScreenSnapshot getSnapshot() {
        return this.snapshot;
    }

    public Image getImage() {
        if (this.snapshot == null || !this.snapshot.hasSnapshot()) {
            return null;
        }
        return this.snapshot.getImage();
    }

    public Image getImage(Rectangle area) {
        if (this.snapshot == null || !this.snapshot.hasSnapshot()) {
            return null;
        }
        return this.snapshot.getImage(area);
    }

    private void initComponents() {
        this.setDoubleBuffered(false);
    }

    private Component findTop() {
        Container c = this.getParent();
        if (c == null) {
            return null;
        }
        while (!(c instanceof Window) && c.getParent() != null) {
            c = c.getParent();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        try {
            super.removeNotify();
        }
        finally {
            this.deregister();
            this.clearSnapshot();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!this.isShowing()) {
            return;
        }
        Rectangle bounds = this.getBounds();
        Insets ins = this.getInsets();
        bounds.x = ins.left;
        bounds.y = ins.top;
        bounds.width -= ins.left + ins.right;
        bounds.height -= ins.top + ins.bottom;
        Rectangle screenBounds = this.getDisplayBounds();
        Rectangle clip = null;
        clip = this.snapshot != null && this.snapshot.hasSnapshot() ? this.snapshot.getBounds().intersection(screenBounds) : new Rectangle(screenBounds);
        if (clip.isEmpty()) {
            return;
        }
        if (this.snapshot == null || !this.snapshot.hasSnapshot()) {
            g.setColor(Color.gray);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        } else {
            Image img = this.snapshot.getImage(clip);
            int imgX = Math.max(0, this.snapshot.getBounds().x - screenBounds.x);
            int imgY = Math.max(0, this.snapshot.getBounds().y - screenBounds.y);
            if (imgX > bounds.x) {
                g.setColor(Color.black);
                g.fillRect(bounds.x, bounds.y, imgX - bounds.x, bounds.height);
            }
            if (imgX + clip.width < bounds.x + bounds.width) {
                g.setColor(Color.black);
                g.fillRect(imgX + clip.width, bounds.y, bounds.x + bounds.width - imgX - clip.width, bounds.height);
            }
            if (imgY > bounds.y) {
                g.setColor(Color.black);
                g.fillRect(imgX, bounds.y, clip.width, imgY - bounds.y);
            }
            if (imgY + clip.height < bounds.y + bounds.height) {
                g.setColor(Color.black);
                g.fillRect(imgX, imgY + clip.height, clip.width, bounds.y + bounds.height - imgY - clip.height);
            }
            g.drawImage(img, imgX, imgY, null);
        }
    }

    public Rectangle getDisplayBounds() {
        Rectangle bounds = new Rectangle(this.getBounds());
        Point loc = this.getScreenLocation();
        bounds.x = loc.x;
        bounds.y = loc.y;
        Insets ins = this.getInsets();
        bounds.x += ins.left;
        bounds.y += ins.top;
        bounds.width -= ins.left + ins.right;
        bounds.height -= ins.top + ins.bottom;
        return bounds;
    }

    private void frameMoved(ComponentEvent e) {
        this.repaint();
    }

    public Point getScreenLocation() {
        Point loc = new Point();
        try {
            loc.setLocation(this.getLocationOnScreen());
        }
        catch (Throwable t) {
            loc.setLocation(Integer.MIN_VALUE, Integer.MIN_VALUE);
            return loc;
        }
        return loc;
    }
}

