/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.ProgressDialog;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class ProgressSteps {
    private ProgressDialog monitor = null;
    private int numSteps = 1;
    private int curStep = 0;
    private String[] steps = null;

    public ProgressSteps(Component parent, Object message, String title, String[] steps) {
        this(parent, null, message, title, steps, false);
    }

    public ProgressSteps(Component parent, Icon icon, Object message, String title, String[] steps) {
        this(parent, icon, message, title, steps, false);
    }

    public ProgressSteps(Component parent, Icon icon, Object message, String title, String[] steps, boolean modal) {
        String initStep = null;
        if (steps != null && steps.length > 0) {
            this.steps = steps;
            initStep = steps[0];
            this.numSteps = steps.length;
        }
        this.monitor = new ProgressDialog(parent, icon, message, title, initStep, 0, this.numSteps, modal);
        this.monitor.pack();
        ModalDialog.positionWindow(this.monitor, parent);
        this.monitor.show();
    }

    public void checkCanceled(String message) {
        if (this.isCanceled()) {
            throw new CanceledOperationException(message);
        }
    }

    public void checkCanceled() {
        this.checkCanceled("operation canceled by user.");
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public boolean isDone() {
        return this.curStep >= this.numSteps;
    }

    public ProgressDialog getDialog() {
        return this.monitor;
    }

    public int getStep() {
        return this.curStep;
    }

    public String getStepText() {
        if (this.curStep >= 0 && this.curStep < this.steps.length) {
            return this.steps[this.curStep];
        }
        return "";
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public boolean nextStep() {
        String note = null;
        ++this.curStep;
        if (this.steps != null && this.curStep >= 0 && this.curStep < this.steps.length) {
            note = this.steps[this.curStep];
        }
        this.monitor.setProgress(this.curStep, note);
        return this.isDone();
    }

    public void close() {
        this.monitor.close();
    }

    public String toString() {
        return super.toString() + " " + this.getStepText() + " (" + (this.curStep + 1) + "/" + this.numSteps + ")";
    }

    public static void main(String[] args) {
        final ImageIcon telIcon = new ImageIcon("vClass/com/elluminate/groupware/telephony/images/TelephoneSmall.png");
        String testMsg = "Connecting to 1-800-555-1212";
        final String[] testSteps = new String[]{"Dialing...", "Ringing...", "Authenticating..."};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                final JFrame parent = new JFrame("Main Frame");
                parent.setBounds(32, 32, 800, 440);
                parent.setDefaultCloseOperation(2);
                parent.show();
                final ProgressSteps progress = new ProgressSteps(parent, telIcon, "Connecting to 1-800-555-1212", "Connection Progress", testSteps);
                Runnable r2 = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                        while (!progress.isDone()) {
                            try {
                                Thread.sleep(4000L);
                            }
                            catch (Throwable ignored) {
                                // empty catch block
                            }
                            if (progress.isCanceled()) break;
                            progress.nextStep();
                            System.err.println("Progress steps: " + progress);
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                        Runnable r3 = new Runnable(){

                            @Override
                            public void run() {
                                parent.dispose();
                            }
                        };
                        SwingRunnerSupport.invokeLater((Runnable)r3);
                    }
                };
                Thread t = new Thread(r2);
                t.start();
            }
        };
        SwingRunnerSupport.invokeLater((Runnable)r);
    }

    public class CanceledOperationException
    extends RuntimeException {
        public CanceledOperationException(String message) {
            super(message);
        }
    }
}

