/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends EasyDialog
implements ActionListener,
Runnable {
    public static final String CANCEL_COMMAND = "cancel";
    public static final int CANCEL_EVENT = 23107;
    private static final I18n i18n = I18n.create(ProgressDialog.class);
    private static final Icon defaultIcon = i18n.getIcon("ProgressDialog.iconImage");
    private Icon icon = null;
    private JLabel iconLabel = null;
    private Component body = null;
    private JLabel noteLabel = null;
    private JButton cancelBtn = null;
    private JProgressBar bar = null;
    private int minValue;
    private int maxValue;
    private int curValue;
    private String noteText = null;
    private Icon noteIcon = null;
    private boolean canceled = false;
    private boolean rangeChanged = false;
    private boolean autoHide = true;
    private ArrayList cancelListeners = new ArrayList();
    private final Object interlock = new Object();
    private final Object listenerLock = new Object();

    public ProgressDialog(Component parent, Object message, String title, String note) {
        this(parent, message, title, note, 0, -1);
    }

    public ProgressDialog(Component parent, Icon dlgIcon, Object message, String title, String note, int min, int max) {
        this(parent, dlgIcon, message, title, note, min, max, true);
    }

    public ProgressDialog(Component parent, Object message, String title, String note, int min, int max) {
        this(parent, message, title, note, min, max, true);
    }

    public ProgressDialog(Component parent, Object message, String note, int min, int max) {
        this(parent, message, null, note, min, max, true);
    }

    public ProgressDialog(Component parent, Object message, String title, String note, int min, int max, boolean modal) {
        this(parent, null, message, title, note, min, max, modal);
    }

    public ProgressDialog(Component parent, Icon dlgIcon, Object message, String title, String note, int min, int max, boolean modal) {
        super(parent, "", modal);
        this.setDefaultCloseOperation(0);
        this.getRootPane().putClientProperty("Window.style", "small");
        if (title != null) {
            this.setTitle(title);
        } else {
            this.setTitle(i18n.getString((PropertiesEnum)StringsProperties.PROGRESSDIALOG_DEFAULTTITLE));
        }
        this.minValue = min;
        this.maxValue = max;
        this.curValue = this.minValue;
        this.bar = new JProgressBar();
        if (this.maxValue < this.minValue) {
            this.bar.setIndeterminate(true);
        } else {
            this.bar.setMinimum(this.minValue);
            this.bar.setMaximum(this.maxValue);
            this.bar.setValue(this.curValue);
        }
        this.cancelBtn = this.makeButton(0);
        this.addCancelButton(this.cancelBtn);
        this.cancelBtn.addActionListener(this);
        this.icon = dlgIcon != null ? dlgIcon : defaultIcon;
        this.iconLabel = new JLabel(this.icon);
        this.body = this.convertMessageToComponent(message);
        if (note != null) {
            this.noteText = note;
            this.noteLabel = new JLabel(this.noteText);
            this.noteLabel.setIconTextGap(8);
            Font f = this.noteLabel.getFont();
            f = f.deriveFont((float)Math.max(10, f.getSize() - 1));
            this.noteLabel.setFont(f);
        }
        this.layoutComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAutoHideEnabled() {
        Object object = this.interlock;
        synchronized (object) {
            return this.autoHide;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoHideEnabled(boolean b) {
        Object object = this.interlock;
        synchronized (object) {
            this.autoHide = b;
        }
    }

    public void setCancelVisible(boolean vis) {
        this.cancelBtn.setVisible(vis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancelEnabled(boolean enabled) {
        Object object = this.interlock;
        synchronized (object) {
            if (this.canceled) {
                enabled = false;
            }
        }
        this.cancelBtn.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximum() {
        Object object = this.interlock;
        synchronized (object) {
            return this.maxValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximum(int max) {
        Object object = this.interlock;
        synchronized (object) {
            if (max == this.maxValue) {
                return;
            }
            this.maxValue = max;
            this.rangeChanged = true;
        }
        SwingRunnerSupport.invokeLater((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinimum() {
        Object object = this.interlock;
        synchronized (object) {
            return this.minValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimum(int min) {
        Object object = this.interlock;
        synchronized (object) {
            if (min == this.minValue) {
                return;
            }
            this.minValue = min;
            this.rangeChanged = true;
        }
        SwingRunnerSupport.invokeLater((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRange(int min, int max) {
        Object object = this.interlock;
        synchronized (object) {
            if (min == this.minValue && max == this.maxValue) {
                return;
            }
            this.minValue = min;
            this.maxValue = max;
            this.rangeChanged = true;
        }
        SwingRunnerSupport.invokeLater((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProgress() {
        Object object = this.interlock;
        synchronized (object) {
            return this.curValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgress(int progress) {
        if (progress < this.minValue) {
            progress = this.minValue;
        }
        if (progress > this.maxValue) {
            progress = this.maxValue;
        }
        Object object = this.interlock;
        synchronized (object) {
            this.curValue = progress;
        }
        SwingRunnerSupport.invokeLater((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgress(int progress, String note) {
        if (progress < this.minValue) {
            progress = this.minValue;
        }
        if (progress > this.maxValue) {
            progress = this.maxValue;
        }
        Object object = this.interlock;
        synchronized (object) {
            this.curValue = progress;
            this.noteText = note == null ? "" : note;
        }
        SwingRunnerSupport.invokeLater((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgress(int progress, String note, Icon newIcon) {
        if (progress < this.minValue) {
            progress = this.minValue;
        }
        if (progress > this.maxValue) {
            progress = this.maxValue;
        }
        Object object = this.interlock;
        synchronized (object) {
            this.curValue = progress;
            this.noteText = note == null ? "" : note;
            this.noteIcon = newIcon;
        }
        SwingRunnerSupport.invokeLater((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNote() {
        Object object = this.interlock;
        synchronized (object) {
            return this.noteText;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getNoteIcon() {
        Object object = this.interlock;
        synchronized (object) {
            return this.noteIcon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(String note) {
        Object object = this.interlock;
        synchronized (object) {
            this.noteText = note == null ? "" : note;
        }
        SwingRunnerSupport.invokeLater((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(String note, Icon newIcon) {
        Object object = this.interlock;
        synchronized (object) {
            this.noteText = note == null ? "" : note;
            this.noteIcon = newIcon;
        }
        SwingRunnerSupport.invokeLater((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoteIcon(Icon newIcon) {
        Object object = this.interlock;
        synchronized (object) {
            this.noteIcon = newIcon;
        }
        SwingRunnerSupport.invokeLater((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon() {
        Object object = this.interlock;
        synchronized (object) {
            return this.icon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIcon(Icon newIcon) {
        Object object = this.interlock;
        synchronized (object) {
            this.icon = newIcon;
        }
        SwingRunnerSupport.invokeLater((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.interlock;
        synchronized (object) {
            return this.canceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.interlock;
        synchronized (object) {
            this.canceled = true;
        }
        this.fireCancelListeners();
        SwingRunnerSupport.invokeLater((Runnable)this);
    }

    public void close() {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.cancelBtn) {
            Object object = this.interlock;
            synchronized (object) {
                this.canceled = true;
            }
            this.cancelBtn.setEnabled(false);
            this.fireCancelListeners();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean repackRequired = false;
        Object object = this.interlock;
        synchronized (object) {
            if (this.rangeChanged) {
                this.bar.setMinimum(this.minValue);
                this.bar.setMaximum(this.maxValue);
                this.bar.setIndeterminate(this.maxValue < this.minValue);
                this.rangeChanged = false;
            }
            if (this.curValue >= this.minValue && this.curValue <= this.maxValue) {
                this.bar.setValue(this.curValue);
            }
            if (this.noteLabel != null) {
                this.noteLabel.setText(this.noteText);
                this.noteLabel.setIcon(this.noteIcon);
                int prefWidth = this.noteLabel.getPreferredSize().width;
                if (prefWidth > this.noteLabel.getWidth()) {
                    this.noteLabel.invalidate();
                    repackRequired = true;
                }
            }
            if (this.iconLabel != null) {
                this.iconLabel.setIcon(this.icon);
            }
            if (this.canceled) {
                this.cancelBtn.setEnabled(false);
            }
            if (this.autoHide && this.curValue >= this.maxValue && this.maxValue >= this.minValue) {
                Runnable closer = new Runnable(){

                    @Override
                    public void run() {
                        ProgressDialog.this.setVisible(false);
                    }
                };
                LightweightTimer timer = new LightweightTimer(2, closer);
                timer.scheduleIn(500L);
                repackRequired = false;
            }
        }
        if (repackRequired) {
            this.pack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCancelListener(ActionListener l) {
        if (l == null) {
            return;
        }
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.cancelListeners.contains(l)) {
                return;
            }
            ArrayList<ActionListener> copy = new ArrayList<ActionListener>(this.cancelListeners.size() + 1);
            copy.addAll(this.cancelListeners);
            copy.add(l);
            this.cancelListeners = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCancelListener(ActionListener l) {
        if (l == null) {
            return;
        }
        Object object = this.listenerLock;
        synchronized (object) {
            if (!this.cancelListeners.contains(l)) {
                return;
            }
            ArrayList copy = new ArrayList(this.cancelListeners);
            copy.remove(l);
            this.cancelListeners = copy;
        }
    }

    private void fireCancelListeners() {
        ActionEvent ev = null;
        Iterator it = this.cancelListeners.iterator();
        while (it.hasNext()) {
            try {
                ActionListener l = (ActionListener)it.next();
                if (l == null) continue;
                if (ev == null) {
                    ev = new ActionEvent(this, 23107, CANCEL_COMMAND);
                }
                l.actionPerformed(ev);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireCancelListeners", (Throwable)t, (boolean)true);
            }
        }
    }

    private Component convertMessageToComponent(Object message) {
        if (message == null) {
            return null;
        }
        if (message instanceof Component) {
            return (Component)message;
        }
        if (message instanceof Object[]) {
            Object[] list = (Object[])message;
            Box box = Box.createVerticalBox();
            for (int ix = 0; ix < list.length; ++ix) {
                if (list[ix] == null) continue;
                if (ix > 0) {
                    box.add(Box.createVerticalGlue());
                }
                box.add(this.convertMessageToComponent(list[ix]));
            }
            return box;
        }
        JLabel result = new JLabel();
        if (message instanceof Icon) {
            result.setIcon((Icon)message);
        } else if (message instanceof Image) {
            result.setIcon(new ImageIcon((Image)message));
        } else {
            result.setText(message.toString());
        }
        return result;
    }

    private void layoutComponents() {
        JPanel upperPane = new JPanel(new BorderLayout(10, 0));
        JPanel mainPane = new JPanel(new BorderLayout(0, 6));
        JPanel infoPane = new JPanel(new BorderLayout(0, 6));
        JPanel barPane = new JPanel(new BorderLayout());
        if (this.body != null) {
            infoPane.add(this.body, "Center");
        }
        if (this.noteLabel != null) {
            infoPane.add((Component)this.noteLabel, "South");
        }
        upperPane.add((Component)infoPane, "Center");
        upperPane.add((Component)this.iconLabel, "West");
        this.bar.setPreferredSize(new Dimension(340, this.bar.getPreferredSize().height));
        barPane.add((Component)this.bar, "Center");
        barPane.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
        upperPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 32));
        mainPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        mainPane.add((Component)barPane, "Center");
        mainPane.add((Component)upperPane, "North");
        this.setContent(mainPane);
    }
}

