/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.swing.CDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PaletteWindow
extends CDialog {
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int NONE = -1;
    private static final Color DEFAULT_BAR_COLOUR = new Color(128, 128, 160);
    private TitlePane titleBar = null;
    private Container palettePane = null;
    private int barEdge = -1;
    private Color barColour;
    private String title = null;
    private boolean showCloseBox = false;
    private WindowDragListener dragListener = null;
    private boolean movingWindow = false;

    public PaletteWindow() {
        this.initialize(null, 1);
    }

    public PaletteWindow(JFrame owner) {
        super((Frame)owner, false);
        this.initialize(null, 1);
    }

    public PaletteWindow(JDialog owner) {
        super((Dialog)owner, false);
        this.initialize(null, 1);
    }

    public PaletteWindow(JFrame owner, String title, int edge) {
        super((Frame)owner, false);
        this.initialize(title, edge);
    }

    public PaletteWindow(JDialog owner, String title, int edge) {
        super((Dialog)owner, false);
        this.initialize(title, edge);
    }

    private void initialize(String title, int edge) {
        this.setUndecorated(true);
        this.setFocusableWindowState(false);
        this.titleBar = new TitlePane();
        this.palettePane = new JPanel(new BorderLayout());
        this.setTitleBarColor(DEFAULT_BAR_COLOUR);
        Container content = super.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)this.palettePane, "Center");
        this.setTitleBarEdge(edge);
        this.setTitle(title);
        this.setResizable(false);
        this.dragListener = new WindowDragListener();
        this.addMouseListener(this.dragListener);
        this.addMouseMotionListener(this.dragListener);
    }

    public Color getTitleBarColor() {
        return this.barColour;
    }

    public void setTitleBarColor(Color c) {
        this.barColour = c;
        this.titleBar.setBackground(this.barColour);
        this.titleBar.repaint();
    }

    public boolean isShowingCloseBox() {
        return this.showCloseBox;
    }

    public void setShowingCloseBox(boolean showCloseBox) {
        this.showCloseBox = showCloseBox;
        this.titleBar.repaint();
    }

    @Override
    public Container getContentPane() {
        return this.palettePane;
    }

    @Override
    public void setContentPane(Container contentPane) {
        this.palettePane = contentPane;
        super.getContentPane().add((Component)this.palettePane, "Center");
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        super.setTitle(title);
        this.titleBar.repaint();
    }

    public void setTitleBarEdge(int edge) {
        if (edge != 1 && edge != 2 && edge != -1) {
            throw new IllegalArgumentException("Invalid edge: " + edge);
        }
        if (this.barEdge == edge) {
            return;
        }
        this.barEdge = edge;
        Container content = super.getContentPane();
        content.remove(this.titleBar);
        switch (edge) {
            case 1: {
                content.add((Component)this.titleBar, "North");
                break;
            }
            case 2: {
                content.add((Component)this.titleBar, "West");
                break;
            }
        }
        this.titleBar.repaint();
    }

    private class TitlePane
    extends JPanel {
        TitlePane() {
            this.setLayout(null);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(12, 12);
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(PaletteWindow.this.barColour);
            g.fill3DRect(0, 0, this.getWidth(), this.getHeight(), !PaletteWindow.this.movingWindow);
        }
    }

    private class WindowDragListener
    implements MouseListener,
    MouseMotionListener {
        private int dragOffsetX = Integer.MIN_VALUE;
        private int dragOffsetY = Integer.MIN_VALUE;
        private Rectangle dragBounds = null;

        private WindowDragListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
        }

        @Override
        public void mouseExited(MouseEvent me) {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isConsumed()) {
                return;
            }
            if (PaletteWindow.this.barEdge == -1) {
                return;
            }
            if (!PaletteWindow.this.isVisible()) {
                return;
            }
            Point pt = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), PaletteWindow.this);
            if (PaletteWindow.this.titleBar.getBounds().contains(pt)) {
                this.dragOffsetX = pt.x;
                this.dragOffsetY = pt.y;
                this.dragBounds = GuiUtils.getDesktopBounds();
                PaletteWindow.this.movingWindow = true;
                me.consume();
                PaletteWindow.this.titleBar.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            PaletteWindow.this.movingWindow = false;
            this.dragOffsetX = Integer.MIN_VALUE;
            this.dragOffsetY = Integer.MIN_VALUE;
            this.dragBounds = null;
            PaletteWindow.this.titleBar.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            if (me.isConsumed()) {
                return;
            }
            if (PaletteWindow.this.barEdge == -1) {
                return;
            }
            if (!PaletteWindow.this.movingWindow) {
                return;
            }
            if (!PaletteWindow.this.isVisible()) {
                return;
            }
            Point pt = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), PaletteWindow.this);
            Point cur = PaletteWindow.this.getLocationOnScreen();
            cur.x += pt.x - this.dragOffsetX;
            cur.y += pt.y - this.dragOffsetY;
            if (this.dragBounds == null) {
                return;
            }
            if (!this.dragBounds.contains(cur)) {
                return;
            }
            if (!this.dragBounds.contains(cur.x + PaletteWindow.this.getWidth(), cur.y + PaletteWindow.this.getHeight())) {
                return;
            }
            PaletteWindow.this.setLocation(cur);
        }

        @Override
        public void mouseMoved(MouseEvent me) {
        }
    }
}

