/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;

public class OverlayPane
extends JPanel {
    private static final Object LAYER = JLayeredPane.DEFAULT_LAYER;
    private JLayeredPane layer = new JLayeredPane();
    private boolean layoutFixed = true;

    public OverlayPane() {
        super(null);
        super.setLayout(new BorderLayout());
        this.layer.setLayout(new OverlayLayout(this.layer));
        super.add((Component)this.layer, "Center");
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (this.layoutFixed || layout != null) {
            throw new RuntimeException("Cannot set layout on " + this);
        }
        super.setLayout(layout);
    }

    @Override
    public Component add(Component c) {
        this.addOverlay(c, LAYER, 0);
        return c;
    }

    @Override
    public Component add(Component c, int pos) {
        this.addOverlay(c, LAYER, pos);
        return c;
    }

    @Override
    public void add(Component c, Object o) {
        this.addOverlay(c, LAYER, 0);
    }

    @Override
    public void add(Component c, Object o, int pos) {
        this.addOverlay(c, LAYER, pos);
    }

    @Override
    public void removeAll() {
        this.layer.removeAll();
    }

    public int getOverlayCount() {
        return this.layer.getComponentCount();
    }

    public Component getOverlayComponent(int which) {
        return this.layer.getComponent(which);
    }

    public Component[] getOverlayComponents() {
        return this.layer.getComponents();
    }

    public Component getFront() {
        return this.layer.getComponent(0);
    }

    public Component getBack() {
        return this.layer.getComponent(this.layer.getComponentCount() - 1);
    }

    public int getOverlayLevel(Component c) {
        return this.layer.getPosition(c);
    }

    public void moveToFront(Component c) {
        this.layer.moveToFront(c);
    }

    public void moveToBack(Component c) {
        this.layer.moveToBack(c);
    }

    public void setPosition(Component c, int pos) {
        this.layer.setPosition(c, pos);
    }

    protected void addOverlay(Component component, Object constraints, int position) {
        this.layer.add(component, constraints, position);
    }

    protected LayoutManager getOverlayLayout() {
        return this.layer.getLayout();
    }

    protected void setOverlayLayout(LayoutManager layout) {
        this.layer.setLayout(layout);
    }

    protected JLayeredPane getLayeredPane() {
        return this.layer;
    }
}

