/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.event.Operation;
import com.elluminate.util.event.OperationEvent;
import com.elluminate.util.event.OperationListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class OperationDialog
extends EasyDialog {
    private static final int REFRESH_INTERVAL = 50;
    private static final int REACH_TARGET_INTERVAL = 1000;
    private Operation operation;
    private JLabel messageLabel;
    private JProgressBar progressBar;
    private JButton cancelButton;
    private JLabel statusLabel;
    private Timer animationTimer;
    private float animationValue = 0.0f;
    private int animationTarget = 0;
    private float animationStep = 0.0f;

    public static void trackProgress(Operation operation, Component owner) {
        OperationDialog.trackProgress(operation, owner, 1000);
    }

    public static void trackProgress(Operation operation, Component owner, int delay) {
        operation.addOperationListener((OperationListener)new ProgressListener(operation, owner, delay));
    }

    public static void trackProgressAndWait(Operation operation, Component owner) {
        ProgressListener l = new ProgressListener(operation, owner);
        operation.addOperationListener((OperationListener)l);
        l.showDialog();
    }

    public OperationDialog(Component owner) {
        this(owner, (Operation)null);
    }

    public OperationDialog(Component owner, Operation operation) {
        super(owner, null);
        this.operation = operation;
        I18n i18n = I18n.create((Object)this);
        this.setTitle(i18n.getString((PropertiesEnum)StringsProperties.OPERATIONDIALOG_TITLE));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (OperationDialog.this.operation != null) {
                    OperationDialog.this.operation.cancel();
                }
            }
        });
        JPanel c = new JPanel(new GridBagLayout());
        this.setContent(c);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        this.messageLabel = new JLabel(" ");
        this.messageLabel.setVisible(false);
        c.add((Component)this.messageLabel, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(250, this.progressBar.getPreferredSize().height));
        this.progressBar.setIndeterminate(true);
        c.add((Component)this.progressBar, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets.left = 6;
        this.cancelButton = new JButton(i18n.getString((PropertiesEnum)StringsProperties.OPERATIONDIALOG_CANCELBUTTON));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OperationDialog.this.operation != null) {
                    OperationDialog.this.operation.cancel();
                }
            }
        });
        c.add((Component)this.cancelButton, gbc);
        ++gbc.gridy;
        gbc.insets.top = 6;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(0, 11.0f));
        this.statusLabel.setVisible(false);
        c.add((Component)this.statusLabel, gbc);
        this.pack();
        this.animationTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OperationDialog.this.progressBar.isIndeterminate()) {
                    OperationDialog.this.progressBar.setIndeterminate(false);
                }
                if (OperationDialog.this.progressBar.getValue() != OperationDialog.this.animationTarget) {
                    OperationDialog.this.animationValue += OperationDialog.this.animationStep;
                    OperationDialog.this.progressBar.setValue((int)OperationDialog.this.animationValue);
                } else {
                    OperationDialog.this.animationTimer.stop();
                }
            }
        });
    }

    public void setMessage(final String message) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OperationDialog.this.messageLabel.setText(message);
                if (message != null && message.trim().length() != 0) {
                    if (!OperationDialog.this.messageLabel.isVisible()) {
                        OperationDialog.this.messageLabel.setVisible(true);
                        OperationDialog.this.pack();
                    }
                } else if (OperationDialog.this.messageLabel.isVisible()) {
                    OperationDialog.this.messageLabel.setVisible(false);
                    OperationDialog.this.pack();
                }
            }
        });
    }

    public void setProgress(int progress) {
        this.setProgress(progress, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgress(int progress, boolean gradually) {
        if (progress < 0) {
            if (!this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(true);
            }
        } else {
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
            }
            if (gradually) {
                this.animationTarget = progress;
                this.animationStep = (float)((progress - this.progressBar.getValue()) * 50) / 1000.0f;
                Timer timer = this.animationTimer;
                synchronized (timer) {
                    if (!this.animationTimer.isRunning()) {
                        this.animationTimer.start();
                    }
                }
            } else {
                this.animationTimer.stop();
                this.animationValue = progress;
                this.animationTarget = progress;
                this.animationStep = 0.0f;
                this.progressBar.setValue(progress);
            }
        }
    }

    public void setStatus(final String status) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OperationDialog.this.statusLabel.setText(status);
                if (status != null && status.trim().length() != 0) {
                    if (!OperationDialog.this.statusLabel.isVisible()) {
                        OperationDialog.this.statusLabel.setVisible(true);
                        OperationDialog.this.pack();
                    }
                } else if (OperationDialog.this.statusLabel.isVisible()) {
                    OperationDialog.this.statusLabel.setVisible(false);
                    OperationDialog.this.pack();
                }
            }
        });
    }

    public void addCancelListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    public void removeCancelListener(ActionListener l) {
        this.cancelButton.removeActionListener(l);
    }

    @Override
    public void dispose() {
        this.animationTimer.stop();
        super.dispose();
    }

    private static class ProgressListener
    implements ActionListener,
    OperationListener {
        private Operation operation;
        private Component owner;
        private Timer showTimer;
        private OperationDialog dialog;

        public ProgressListener(Operation operation, Component owner) {
            this(operation, owner, -1);
        }

        public ProgressListener(Operation operation, Component owner, int delay) {
            this.operation = operation;
            this.owner = owner;
            if (delay != -1) {
                this.showTimer = new Timer(delay, this);
                this.showTimer.setRepeats(false);
            }
            if (operation.isFinished()) {
                operation.removeOperationListener((OperationListener)this);
            } else if (operation.isRunning() && this.showTimer != null) {
                this.showTimer.start();
            }
        }

        public void showDialog() {
            this.actionPerformed(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.showTimer != null) {
                this.showTimer.stop();
            }
            if (this.operation.isFinished()) {
                return;
            }
            this.dialog = new OperationDialog(this.owner, this.operation);
            this.dialog.setMessage(this.operation.getName());
            this.dialog.setStatus(this.operation.getProgressStatus());
            long size = this.operation.getSize();
            if (size == -1L) {
                this.dialog.setProgress(-1);
            } else {
                this.dialog.setProgress((int)((double)(100L * this.operation.getProgressSize()) / (double)size), false);
            }
            this.dialog.setVisible(true);
        }

        public void progressStarted(OperationEvent e) {
            if (this.showTimer != null) {
                this.showTimer.start();
            }
        }

        public void progressChanged(OperationEvent e) {
            if (this.dialog != null) {
                long size = this.operation.getSize();
                if (size == -1L) {
                    this.dialog.setProgress(-1);
                } else {
                    this.dialog.setProgress((int)((double)(100L * this.operation.getProgressSize()) / (double)size));
                }
                this.dialog.setStatus(this.operation.getProgressStatus());
            }
        }

        public void progressFinished(OperationEvent e) {
            this.operation.removeOperationListener((OperationListener)this);
            if (this.showTimer != null) {
                this.showTimer.stop();
            }
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }

        public void progressCanceled(OperationEvent e) {
            this.operation.removeOperationListener((OperationListener)this);
            if (this.showTimer != null) {
                this.showTimer.stop();
            }
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }

        public void progressError(OperationEvent e) {
            this.operation.removeOperationListener((OperationListener)this);
            if (this.showTimer != null) {
                this.showTimer.stop();
            }
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
            }
        }
    }
}

