/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.component.NullableActionButton;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;

public class NullableTimedActionButton
extends NullableActionButton {
    long startDelay = 1000L;
    long repeatDelay = 250L;
    Timer timer = null;

    public NullableTimedActionButton() {
        this(null, null);
    }

    public NullableTimedActionButton(Icon icon) {
        this(null, icon);
    }

    public NullableTimedActionButton(String text) {
        this(text, null);
    }

    public NullableTimedActionButton(String text, Icon icon) {
        super(text, icon);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                NullableTimedActionButton.this.timer = new Timer(true);
                NullableTimedActionButton.this.timer.scheduleAtFixedRate((TimerTask)new ButtonTimerTask(), NullableTimedActionButton.this.startDelay, NullableTimedActionButton.this.repeatDelay);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (NullableTimedActionButton.this.timer != null) {
                    NullableTimedActionButton.this.timer.cancel();
                }
                NullableTimedActionButton.this.timer = null;
            }
        });
    }

    public long getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(long delay) {
        this.startDelay = delay;
    }

    public long getRepeatDelay() {
        return this.repeatDelay;
    }

    public void setRepeatDelay(long delay) {
        this.repeatDelay = delay;
    }

    public class ButtonTimerTask
    extends TimerTask {
        @Override
        public void run() {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (NullableTimedActionButton.this.getModel().isPressed()) {
                        NullableTimedActionButton.this.fireActionPerformed(new ActionEvent(NullableTimedActionButton.this, 1001, "Pressed"));
                    } else {
                        if (NullableTimedActionButton.this.timer != null) {
                            NullableTimedActionButton.this.timer.cancel();
                        }
                        NullableTimedActionButton.this.timer = null;
                    }
                }
            });
        }
    }
}

