/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;

public class GrowableHeightPlaceholder
extends JComponent
implements ContainerListener {
    private Dimension minSize = new Dimension(1, 1);
    private boolean fixedHeight = false;

    public GrowableHeightPlaceholder() {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void componentAdded(ContainerEvent e) {
        if (e == null || e.getComponent() == null || this.fixedHeight) {
            return;
        }
        Dimension dimension = this.minSize;
        synchronized (dimension) {
            Component addedComp = e.getComponent();
            if (addedComp.getPreferredSize().getHeight() > this.minSize.getHeight()) {
                this.minSize.setSize(1.0, addedComp.getPreferredSize().getHeight());
                this.registerComponent(addedComp);
                this.registerChildren(addedComp);
            }
        }
    }

    private void registerChildren(Component comp) {
        if (comp == null) {
            return;
        }
        if (comp instanceof JComponent) {
            Component[] children;
            for (Component child : children = ((JComponent)comp).getComponents()) {
                this.registerComponent(child);
            }
        }
    }

    private void registerComponent(Component comp) {
        if (comp == null) {
            return;
        }
        comp.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Component changed;
                if (GrowableHeightPlaceholder.this.isVisible()) {
                    return;
                }
                if (e.getChangeFlags() == 4L && (changed = e.getChanged()) != null && changed.isVisible()) {
                    GrowableHeightPlaceholder.this.setVisible(true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Dimension dimension = this.minSize;
        synchronized (dimension) {
            this.minSize.setSize(1.0, 1.0);
            this.fixedHeight = false;
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeight(double height) {
        Dimension dimension = this.minSize;
        synchronized (dimension) {
            this.fixedHeight = true;
            this.minSize.setSize(1.0, height);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
    }

    @Override
    public Dimension getPreferredSize() {
        return this.minSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minSize;
    }
}

