/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.StringsProperties;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringUtils;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.util.HashMap;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class FileSaveDialog
extends CFileChooser {
    private static final boolean DIR_CANWRITE_BUG = Platform.getPlatform() == 1;
    protected I18n i18n = I18n.create((Object)this);
    private OverwriteMode overwriteMode = OverwriteMode.QUERY_ON_OVERWRITE;
    private String defaultSuffix = null;
    private HashMap<FileFilter, String> filterSuffixMap = null;
    private boolean silentlyApplyExtension = false;

    public FileSaveDialog() {
        super.setDialogType(1);
    }

    public FileSaveDialog(File currentDirectory) {
        super(currentDirectory);
        super.setDialogType(1);
    }

    public FileSaveDialog(String currentDirectory) {
        super(currentDirectory);
        super.setDialogType(1);
    }

    public FileSaveDialog(FileSystemView fsv) {
        super(fsv);
        super.setDialogType(1);
    }

    public FileSaveDialog(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        super.setDialogType(1);
    }

    public FileSaveDialog(String currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        super.setDialogType(1);
    }

    public void setDefaultRequiredSuffix(String s) {
        this.defaultSuffix = StringUtils.ltrim((String)s, (String)".");
    }

    public String getDefaultRequiredSuffix() {
        return this.defaultSuffix;
    }

    public void setRequiredSuffix(FileFilter filter, String s) {
        if (this.filterSuffixMap == null) {
            this.filterSuffixMap = new HashMap();
        }
        this.filterSuffixMap.put(filter, StringUtils.ltrim((String)s, (String)"."));
    }

    public String getRequiredSuffix() {
        String s;
        if (this.filterSuffixMap != null && (s = this.filterSuffixMap.get(this.getFileFilter())) != null) {
            return s;
        }
        return this.defaultSuffix;
    }

    public void setOverwriteMode(OverwriteMode mode) {
        this.overwriteMode = mode;
    }

    public OverwriteMode getOverwriteMode() {
        return this.overwriteMode;
    }

    public void applyExtensionSilently(boolean applyExtension) {
        this.silentlyApplyExtension = applyExtension;
    }

    @Override
    public void approveSelection() {
        String ext;
        File f = this.getSelectedFile();
        if (f == null) {
            String msg = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_NOFILEMSG);
            String title = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_INVALIDFILETITLE);
            ModalDialog.showMessageDialog(this, msg, title, 0);
            return;
        }
        String suffix = this.getRequiredSuffix();
        if (suffix != null && !suffix.equalsIgnoreCase(ext = FileSysUtils.getExtension((File)f))) {
            String title;
            String msg;
            int which;
            File f2 = FileSysUtils.setExtensionDefault((File)f, (String)suffix);
            if (this.silentlyApplyExtension) {
                if (ext != null) {
                    String replaceFilename = FileSysUtils.replaceExtension((String)f.getName(), (String)suffix);
                    f2 = new File(f.getParent(), replaceFilename);
                }
            } else if (ext == null ? (which = ModalDialog.showConfirmDialog(this, msg = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_NOSUFFIXMSG, new Object[]{f.getName(), "." + suffix, f2.getName()}), title = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_INVALIDFILETITLE), 0, 2)) != 0 : (which = ModalDialog.showConfirmDialog(this, msg = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_BADSUFFIXMSG, new Object[]{f.getName(), "." + ext, "." + suffix, f2.getName()}), title = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_INVALIDFILETITLE), 0, 2)) != 0) {
                return;
            }
            this.setSelectedFile(f2);
            f = f2;
        }
        if (!this.approveSelectedFile(f)) {
            this.setSelectedFile(null);
            return;
        }
        super.approveSelection();
    }

    protected boolean approveSelectedFile(File f) {
        if (f.exists()) {
            int which;
            String title;
            String msg;
            if (this.overwriteMode == OverwriteMode.FORBID_OVERWRITE) {
                msg = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_FILEEXISTSMSG, new Object[]{f.getName()});
                title = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_FILEEXISTSTITLE);
                ModalDialog.showMessageDialog(this, msg, title, 0);
            } else if (this.overwriteMode == OverwriteMode.QUERY_ON_OVERWRITE && (which = ModalDialog.showConfirmDialog(this, msg = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_FILEEXISTSOVERWRITEMSG, new Object[]{f.getName()}), title = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_FILEEXISTSTITLE), 0, 2)) != 0) {
                return false;
            }
            if (f.isDirectory()) {
                if (this.getFileSelectionMode() == 0) {
                    msg = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_SELECTEDDIRMSG, new Object[]{f.getName()});
                    title = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_INVALIDFILETITLE);
                    ModalDialog.showMessageDialog(this, msg, title, 0);
                    return false;
                }
            } else if (f.isFile() && this.getFileSelectionMode() == 1) {
                msg = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_SELECTEDNONDIRMSG, new Object[]{f.getName()});
                title = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_INVALIDFILETITLE);
                ModalDialog.showMessageDialog(this, msg, title, 0);
                return false;
            }
            if (!f.canWrite()) {
                msg = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_FILENOTWRITABLEMSG, new Object[]{f.getName()});
                title = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_INVALIDFILETITLE);
                ModalDialog.showMessageDialog(this, msg, title, 0);
                return false;
            }
        } else {
            File dir = f.getParentFile();
            if (dir != null) {
                int which;
                String title;
                String msg;
                if (!dir.exists()) {
                    msg = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_NOPARENTDIRMSG, new Object[]{dir.getPath()});
                    which = ModalDialog.showConfirmDialog(this, msg, title = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_INVALIDFILETITLE), 0, 2);
                    if (which != 0) {
                        return false;
                    }
                    boolean success = false;
                    try {
                        success = dir.mkdirs();
                    }
                    catch (Throwable t) {
                        success = false;
                        LogSupport.message((Object)this, (String)"approveSelectedFile", (String)("Error creating directory " + dir + ": " + t));
                    }
                    if (!success || !dir.isDirectory()) {
                        msg = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_DIRCREATEFAILEDMSG, new Object[]{dir.getPath()});
                        title = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_DIRCREATEFAILEDTITLE);
                        ModalDialog.showMessageDialog(this, msg, title, 0);
                        return false;
                    }
                } else if (!dir.isDirectory()) {
                    String msg2 = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_PARENTNOTDIRMSG, new Object[]{dir.getPath()});
                    String title2 = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_INVALIDFILETITLE);
                    ModalDialog.showMessageDialog(this, msg2, title2, 0);
                    return false;
                }
                if (!DIR_CANWRITE_BUG && !dir.canWrite() && (which = ModalDialog.showConfirmDialog(this, msg = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_PARENTNOTWRITABLEMSG, new Object[]{dir.getPath()}), title = this.i18n.getString((PropertiesEnum)StringsProperties.FILESAVEDIALOG_PARENTNOTWRITABLETITLE), 0, 2)) != 0) {
                    return false;
                }
            }
        }
        return true;
    }

    public static enum OverwriteMode {
        PERMIT_OVERWRITE,
        QUERY_ON_OVERWRITE,
        FORBID_OVERWRITE;

    }
}

