/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import com.elluminate.gui.FontUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.FileSaveDialog;
import com.elluminate.gui.component.StringsProperties;
import com.elluminate.gui.swing.CList;
import com.elluminate.gui.swing.CPopupMenu;
import com.elluminate.platform.Platform;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.I18n;
import com.elluminate.util.JWSUtils;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.ThreadDump;
import com.elluminate.util.ThreadUtils;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.log.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DebugDialog
extends EasyDialog
implements ListSelectionListener {
    JPanel debugPanel = new JPanel();
    JButton cancelButton = new JButton();
    BorderLayout debugLayout = new BorderLayout();
    JPanel flagPanel = new JPanel();
    JPanel outputPanel = new JPanel();
    TitledBorder outputBorder;
    GridLayout outputLayout = new GridLayout();
    JCheckBox consoleButton = new JCheckBox();
    JPanel filePanel = new JPanel();
    GridBagLayout fileLayout = new GridBagLayout();
    JCheckBox fileButton = new JCheckBox();
    JButton browseButton = new JButton();
    JTextField filePath = new JTextField();
    TitledBorder flagBorder;
    BorderLayout flagLayout = new BorderLayout();
    JScrollPane flagScroller = new JScrollPane();
    JList flagList = new CList();
    JButton addButton = new JButton();
    JButton removeButton = new JButton();
    JPanel editPanel = new JPanel();
    GridBagLayout editPanelLayout = new GridBagLayout();
    DefaultListModel model = new DefaultListModel();
    ListSelectionModel selection = this.flagList.getSelectionModel();
    JButton okButton = new JButton();
    JButton applyButton = new JButton();
    JPanel contentPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JComboBox timestamps = new JComboBox();
    JToggleButton actionButton = new JToggleButton();
    JPopupMenu actionMenu = new CPopupMenu();
    TreeMap<String, DebugFlag> flags = new TreeMap();
    boolean modified = false;
    static I18n i18n;

    private static void initDeadlockTester() {
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if (UtilDebug.DEADLOCK_TEST.show()) {
                    final Object lock1 = new Object();
                    final Object lock2 = new Object();
                    Thread t1 = new Thread("Deadlock Test T1"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = lock1;
                            synchronized (object) {
                                try {
                                    Thread.sleep(1500L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                Object object2 = lock2;
                                synchronized (object2) {
                                    try {
                                        Thread.sleep(300000L);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    lock2.notify();
                                }
                                lock1.notify();
                            }
                        }
                    };
                    Thread t2 = new Thread("Deadlock Test T2"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = lock2;
                            synchronized (object) {
                                try {
                                    Thread.sleep(1500L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                Object object2 = lock1;
                                synchronized (object2) {
                                    try {
                                        Thread.sleep(300000L);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    lock1.notify();
                                }
                                lock2.notify();
                            }
                        }
                    };
                    LogSupport.message(ThreadUtils.class, (String)"createTestDeadlock", (String)"Creating deadlock for testing.");
                    t1.start();
                    t2.start();
                }
            }
        };
        UtilDebug.DEADLOCK_TEST.addPropertyChangeListener(pcl);
    }

    public DebugDialog(Frame parent) {
        super((Component)parent, "");
        this.setResizable(true);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"DebugDialog", (Throwable)e, (boolean)true);
        }
        this.fill();
    }

    public DebugDialog(Frame parent, String title) {
        super((Component)parent, title);
        this.setResizable(true);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"DebugDialog", (Throwable)e, (boolean)true);
        }
        this.fill();
    }

    private void fill() {
        DebugFlag flag;
        this.flags.clear();
        Iterator<Map.Entry<String, DebugFlag>> i = DebugFlag.iterator();
        while (i.hasNext()) {
            flag = (DebugFlag)i.next();
            if (flag.isEnabled()) {
                this.model.addElement(flag.getName());
            }
            this.flags.put(flag.getName(), flag);
        }
        if (DebugFlag.get((String)"PrintFlags").isEnabled()) {
            i = this.flags.entrySet().iterator();
            while (i.hasNext()) {
                flag = i.next().getValue();
                System.out.println(flag.toString());
            }
        }
        this.fileButton.setSelected(LogSupport.isLoggingToFile());
        if (this.fileButton.isSelected()) {
            File f = LogSupport.getLogFile();
            String path = "";
            try {
                path = f.getAbsolutePath();
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fill", (Throwable)ex, (boolean)false);
            }
            this.filePath.setText(path);
            this.filePath.setEnabled(true);
            this.browseButton.setEnabled(true);
        }
        this.consoleButton.setSelected(LogSupport.isLoggingToConsole());
        Logger logger = LogSupport.getInstance();
        this.timestamps.setSelectedIndex(logger.getTimestampType());
        this.setCanSave(false);
    }

    private void jbInit() throws Exception {
        this.outputBorder = new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_DESTINATION));
        this.flagBorder = new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_FLAGBORDER));
        this.cancelButton.setText(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_CANCEL));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.debugPanel.setLayout(this.debugLayout);
        this.debugLayout.setVgap(6);
        this.outputPanel.setBorder(BorderFactory.createCompoundBorder(this.outputBorder, BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.outputPanel.setLayout(this.outputLayout);
        this.outputLayout.setRows(2);
        this.consoleButton.setText(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_CONSOLE));
        this.consoleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugDialog.this.consoleButton_actionPerformed(e);
            }
        });
        this.filePanel.setLayout(this.fileLayout);
        this.fileButton.setText(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_LOGFILE));
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugDialog.this.fileButton_actionPerformed(e);
            }
        });
        this.browseButton.setEnabled(false);
        this.browseButton.setText(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_BROWSE));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugDialog.this.browseButton_actionPerformed(e);
            }
        });
        this.flagPanel.setBorder(BorderFactory.createCompoundBorder(this.flagBorder, BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.flagPanel.setLayout(this.flagLayout);
        this.flagLayout.setHgap(6);
        this.addButton.setText(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_ADD));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugDialog.this.addButton_actionPerformed(e);
            }
        });
        this.removeButton.setEnabled(false);
        this.removeButton.setText(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_REMOVE));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugDialog.this.removeButton_actionPerformed(e);
            }
        });
        this.flagList.setModel(this.model);
        this.okButton.setText(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_OK));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugDialog.this.okButton_actionPerformed(e);
            }
        });
        this.applyButton.setText(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_APPLY));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugDialog.this.applyButton_actionPerformed(e);
            }
        });
        this.actionButton.setIcon(i18n.getIcon("DebugDialog.actionIcon"));
        this.actionButton.setText(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_ACTIONMENU));
        this.actionButton.setHorizontalTextPosition(2);
        if (Platform.getLAF() == 502) {
            boolean leopard15 = Platform.checkJavaVersion((String)"1.5+") && Platform.checkOSVersion((int)202, (String)"10.5+");
            this.actionButton.putClientProperty("JButton.buttonType", leopard15 ? "square" : "toolbar");
            Font f = UIManager.getFont("Button.font");
            this.actionButton.setFont(FontUtils.setFontStyleAndSize(f, f.getStyle(), f.getSize()));
            Insets m = this.actionButton.getMargin();
            this.actionButton.setMargin(leopard15 ? new Insets(m.top + 2, m.left + 4, m.bottom + 2, m.right + 4) : new Insets(m.top, m.left + 4, m.bottom, m.right + 4));
        }
        this.actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugDialog.this.actionMenu.show(DebugDialog.this.actionButton, 0, DebugDialog.this.actionButton.getSize().height);
            }
        });
        this.actionMenu.setLabel(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_ACTIONTITLE));
        this.actionMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                DebugDialog.this.actionButton.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                DebugDialog.this.actionButton.setSelected(false);
            }
        });
        this.addAction(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_GARBAGECOLLECT), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        if (ThreadDump.isAvailable()) {
            this.addAction(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_THREADDUMP), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ThreadDump.print();
                }
            });
        }
        if (JWSUtils.isConsoleAvailable()) {
            this.addAction(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_SHOWCONSOLEACTION), new ActionListener(){
                private final Runnable autoraise = new Runnable(){

                    @Override
                    public void run() {
                        DebugDialog.this.toFront();
                    }
                };

                @Override
                public void actionPerformed(ActionEvent ev) {
                    JWSUtils.showConsole();
                    SwingRunnerSupport.invokeLater((Runnable)this.autoraise);
                }
            });
        }
        if (ThreadUtils.isTrackingDeadlocksSupported()) {
            String itemText = i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_TRACKDEADLOCKSACTION);
            final JCheckBoxMenuItem trackerItem = new JCheckBoxMenuItem(itemText);
            trackerItem.setSelected(ThreadUtils.isTrackingDeadlocksEnabled());
            ChangeListener cl = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ThreadUtils.setTrackingDeadlocksEnabled((boolean)trackerItem.isSelected());
                }
            };
            trackerItem.addChangeListener(cl);
            this.actionMenu.add(trackerItem);
            ActionListener checker = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String report = ThreadUtils.reportDeadlocks(null);
                    if (report == null) {
                        LogSupport.message((Object)this, (String)"actionPerformed", (String)"No deadlocks detected.");
                    } else {
                        LogSupport.message((Object)this, (String)"actionPerformed", (String)report);
                    }
                }
            };
            this.addAction(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_CHECKDEADLOCKSACTION), checker);
        }
        this.timestamps.addItem(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_NOTIMESTAMPS));
        this.timestamps.addItem(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_TSTIME));
        this.timestamps.addItem(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_TSDATETIME));
        this.timestamps.addItem(i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_TSMILLISECOND));
        this.timestamps.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DebugDialog.this.timestamps_itemStateChanged(e);
            }
        });
        this.filePath.setEnabled(false);
        this.contentPanel.setLayout(this.borderLayout1);
        this.borderLayout1.setVgap(6);
        this.debugPanel.add((Component)this.flagPanel, "Center");
        this.flagPanel.add((Component)this.editPanel, "East");
        this.editPanel.setLayout(this.editPanelLayout);
        this.editPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editPanel.add((Component)this.removeButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 0, 0, 0), 0, 0));
        this.editPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.flagPanel.add((Component)this.contentPanel, "Center");
        this.contentPanel.add((Component)this.flagScroller, "Center");
        this.contentPanel.add((Component)this.timestamps, "South");
        this.flagScroller.setViewportView(this.flagList);
        this.flagScroller.setVerticalScrollBarPolicy(22);
        this.debugPanel.add((Component)this.outputPanel, "South");
        this.outputPanel.add(this.consoleButton);
        this.outputPanel.add(this.filePanel);
        this.filePanel.add((Component)this.fileButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.filePanel.add((Component)this.filePath, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
        this.filePanel.add((Component)this.browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.selection.addListSelectionListener(this);
        this.setContent(this.debugPanel);
        this.addPassiveComponent(this.actionButton);
        this.addActionButton(this.okButton, true);
        this.addAlternateActionButton(this.applyButton);
        this.addCancelButton(this.cancelButton);
        this.setInitialFocus(this.flagList);
        WindowAdapter winlstnr = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                DebugDialog.this.toFront();
            }
        };
        this.addWindowListener(winlstnr);
    }

    public void addAction(String labelText, ActionListener al) {
        JMenuItem menu = new JMenuItem(labelText);
        menu.addActionListener(al);
        this.actionMenu.add(menu);
    }

    private void setCanSave(boolean mod) {
        this.modified = mod;
        this.applyButton.setEnabled(this.modified);
        this.okButton.setEnabled(this.modified);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object[] values = this.flagList.getSelectedValues();
        this.removeButton.setEnabled(values.length > 0);
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    void addButton_actionPerformed(ActionEvent e) {
        String flag = ModalDialog.showInputDialog(this, i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_ADDPROMPT), i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_ADDTITLE), 3);
        if (flag == null) {
            return;
        }
        if ((flag = flag.trim()).equals("")) {
            ModalDialog.showMessageDialogAsync(-1, this, i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_BLANKMSG), i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_BLANKTITLE), 0);
        } else if (this.model.contains(flag)) {
            ModalDialog.showMessageDialogAsync(-1, this, i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_DUPMSG, new Object[]{flag}), i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_DUPTITLE), 0);
        } else {
            if (!DebugFlag.exists((String)flag) && ModalDialog.showConfirmDialog(this, i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_UNKNOWNMSG, new Object[]{flag}), i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_UNKNOWNTITLE), 2) != 0) {
                return;
            }
            this.model.addElement(flag);
            this.setCanSave(true);
        }
    }

    void removeButton_actionPerformed(ActionEvent e) {
        int[] which = this.flagList.getSelectedIndices();
        for (int i = which.length - 1; i >= 0; --i) {
            this.model.remove(which[i]);
        }
        this.removeButton.setEnabled(false);
        this.setCanSave(true);
    }

    void fileButton_actionPerformed(ActionEvent e) {
        this.filePath.setEnabled(true);
        this.browseButton.setEnabled(true);
        this.setCanSave(true);
    }

    void consoleButton_actionPerformed(ActionEvent e) {
        this.filePath.setEnabled(false);
        this.browseButton.setEnabled(false);
        this.setCanSave(true);
    }

    void timestamps_itemStateChanged(ItemEvent e) {
        this.setCanSave(true);
    }

    void browseButton_actionPerformed(ActionEvent e) {
        String curPath = this.filePath.getText();
        File f = new File(curPath);
        if (!f.isAbsolute() && new File("").getAbsolutePath().equals(File.separator)) {
            f = new File(Platform.getDefaultDir(), curPath);
        }
        FileSaveDialog dlg = new FileSaveDialog();
        if (f.isDirectory()) {
            dlg.setCurrentDirectory(f);
        } else if (f.isFile()) {
            dlg.setSelectedFile(f);
            dlg.ensureFileIsVisible(f);
        }
        if (dlg.showSaveDialog(this) == 0) {
            f = dlg.getSelectedFile();
            this.filePath.setText(f.getAbsolutePath());
            this.setCanSave(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    void applyButton_actionPerformed(ActionEvent event) {
        if (this.fileButton.isSelected()) {
            path = this.filePath.getText();
            if (path == null || path.trim().equals("")) {
                ModalDialog.showMessageDialogAsync(-1, this, DebugDialog.i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_BLANKPATHMSG), DebugDialog.i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_INVALIDPATHTITLE), 0);
                return;
            }
            try {
                f = new File(path);
                if (!f.isAbsolute()) {
                    f = new File(Platform.getLogRelPathRoot(), path);
                }
                LogSupport.setLogFile((File)f);
                logStrm = LogSupport.getLogStream();
                if (logStrm == null) ** GOTO lbl21
                LogSupport.replayHistory((PrintStream)logStrm);
            }
            catch (Exception ex) {
                ModalDialog.showMessageDialogAsync(-1, this, DebugDialog.i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_INVALIDPATHMSG, new Object[]{ex.getMessage()}), DebugDialog.i18n.getString((PropertiesEnum)StringsProperties.DEBUGDIALOG_INVALIDPATHTITLE), 0);
                return;
            }
        } else {
            LogSupport.setLoggingToFile((boolean)false);
        }
lbl21:
        // 3 sources

        LogSupport.setLoggingToConsole((boolean)this.consoleButton.isSelected());
        ts = this.timestamps.getSelectedIndex();
        logger = LogSupport.getInstance();
        logger.setTimestampType((byte)ts);
        flags = new ArrayList<String>();
        i = DebugFlag.iterator();
        while (i.hasNext()) {
            f = (DebugFlag)i.next();
            if (!f.isEnabled()) continue;
            flags.add(f.getName());
        }
        for (String s : flags) {
            if (this.model.contains(s)) continue;
            f = DebugFlag.get((String)s);
            f.setEnabled(false);
        }
        e = this.model.elements();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            f = DebugFlag.get((String)s);
            f.setEnabled(true);
        }
        this.setCanSave(false);
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.applyButton_actionPerformed(e);
        if (!this.modified) {
            this.cancelButton_actionPerformed(e);
        }
    }

    static {
        DebugDialog.initDeadlockTester();
        i18n = I18n.create(DebugDialog.class);
    }
}

