/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private Color color;
    private int width;
    private int height;

    public ColorIcon() {
        this(Color.gray, 15, 15);
    }

    public ColorIcon(Color color, int width, int height) {
        this.color = color;
        this.width = width;
        this.height = height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.color == null) {
            g.setColor(c.getBackground());
            g.fillRect(x, y, this.width - 1, this.height - 1);
            int checkerboard = 4;
            Color c1 = Color.LIGHT_GRAY.brighter();
            Color c2 = Color.GRAY;
            int w = checkerboard;
            int h = checkerboard;
            for (int col = 0; col < (this.height + checkerboard - 1) / checkerboard; ++col) {
                w = checkerboard;
                if ((col + 1) * checkerboard > this.height) {
                    h = checkerboard - ((col + 1) * checkerboard - this.height);
                }
                for (int row = 0; row < (this.width + checkerboard - 1) / checkerboard; ++row) {
                    if ((row + 1) * checkerboard > this.width) {
                        w = checkerboard - ((row + 1) * checkerboard - this.width);
                    }
                    g.setColor(col % 2 == row % 2 ? c1 : c2);
                    g.fillRect(x + row * checkerboard, y + col * checkerboard, w, h);
                }
            }
        } else {
            if (c.isEnabled()) {
                g.setColor(this.color);
            } else {
                g.setColor(this.color.darker());
            }
            g.fillRect(x, y, this.width - 1, this.height - 1);
        }
        g.setColor(Color.gray);
        g.drawRect(x, y, this.width - 1, this.height - 1);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

