/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import com.elluminate.gui.AccessibilityUtils;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class I18nUI
extends I18n {
    private static final String ACCESSIBLE_NAME_EXT = ".accessibleName";
    private static final String ACCESSIBLE_DESC_EXT = ".accessibleDescription";
    private final boolean HAS_NSIMAGE = Platform.checkOSVersion((int)202, (String)"10.5+");

    public I18nUI(Object obj) {
        super(obj);
    }

    private ImageIcon getImageIcon(String key) {
        String path = this.getString(key);
        String desc = null;
        if (path == null) {
            return null;
        }
        try {
            desc = this.getString(key + ".desc");
        }
        catch (Throwable t) {
            desc = null;
        }
        Image img = this.loadImage(path, key);
        if (img == null) {
            throw new IllegalArgumentException("Image resource " + path + " not found for " + key);
        }
        return new ImageIcon(img, desc);
    }

    public ImageIcon getIcon(String key) {
        ImageIcon icon = this.getImageIcon(key);
        if (icon == null) {
            return null;
        }
        String name = icon.toString();
        String axName = null;
        String axDesc = null;
        try {
            axName = this.getString(key + ACCESSIBLE_NAME_EXT);
            axDesc = this.getString(key + ACCESSIBLE_DESC_EXT);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (axName == null) {
            return icon;
        }
        AccessibilityUtils.AccessibleValues values = new AccessibilityUtils.AccessibleValues(name, null, axName, axDesc);
        AccessibilityUtils.setAccessibleValues(icon, values);
        return icon;
    }

    public ImageIcon getIcon(PropertiesEnum propKey) {
        return this.getIcon(propKey.propName());
    }

    public byte[] getBytes(PropertiesEnum propKey) throws IOException {
        return this.getBytes(propKey.propName());
    }

    public static Icon getIcon(I18nMessage msg) {
        ImageIcon icon = null;
        Class cls = I18n.getMessageContext((I18nMessage)msg);
        if (cls != null) {
            I18n rsrc = I18n.create((Object)cls);
            try {
                icon = rsrc.getIcon(I18n.getMessageName((I18nMessage)msg));
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        return icon;
    }

    protected Image loadImage(String path, String key) {
        Image result;
        if (path.toLowerCase(Locale.ENGLISH).endsWith(".gif")) {
            try {
                result = null;
                try {
                    URL url = this.getURLforPath(path);
                    if (url != null) {
                        result = Toolkit.getDefaultToolkit().getImage(url);
                    } else {
                        LogSupport.message((Object)((Object)this), (String)"loadImage", (String)("Failed to get URL for GIF resource" + path + " key=" + key));
                    }
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)((Object)this), (String)"loadImage", (Throwable)t, (boolean)true, (String)("Failed to resolve GIF image resource " + path + " for " + key));
                }
                if (result != null) {
                    if (ImageSupport.waitForImage((Image)result)) {
                        return result;
                    }
                    LogSupport.message((Object)((Object)this), (String)"loadImage", (String)("Failed to load GIF image resource " + path + " key=" + key));
                }
            }
            catch (Throwable t) {
                LogSupport.exception((Object)((Object)this), (String)"loadImage", (Throwable)t, (boolean)true, (String)("Failure while loading GIF image resource " + path + " for " + key));
            }
        }
        if (this.HAS_NSIMAGE && path.startsWith("NSImage://")) {
            try {
                result = Toolkit.getDefaultToolkit().getImage(path);
                if (result != null && ImageSupport.waitForImage((Image)result) && result.getWidth(null) > 0 && result.getHeight(null) > 0) {
                    return result;
                }
                LogSupport.message((Object)((Object)this), (String)"loadImage", (String)("No image for NSImage resource " + path + " for " + key));
            }
            catch (Throwable t) {
                LogSupport.exception((Object)((Object)this), (String)"loadImage", (Throwable)t, (boolean)true, (String)("Failed to resolve NSImage resource " + path + " for " + key));
            }
        }
        return super.loadImage(path, key);
    }
}

