/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.browser.proxy;

import com.elluminate.browser.proxy.BrowserMsg;
import com.elluminate.browser.proxy.Message;
import com.elluminate.browser.proxy.ProxyDebug;
import com.elluminate.browser.proxy.ProxyMsgHandler;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointListener;
import com.elluminate.util.Debug;
import com.elluminate.util.ProcessUtils;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;

public class ProxyManager
implements Runnable {
    public static final int STOP_NONE = 0;
    public static final int STOP_CLOSE = 1;
    public static final int STOP_KILL = 2;
    File path = null;
    Endpoint ep = null;
    Process proc = null;
    DataInputStream istr = null;
    DataOutputStream ostr = null;
    ProxyMsgHandler[] slots = null;
    Thread thread = null;
    volatile boolean shutdown = false;

    public ProxyManager(File path) {
        this(path, 32);
    }

    public ProxyManager(File path, int nSlots) {
        this.path = path;
        this.slots = new ProxyMsgHandler[nSlots];
        this.spawn();
    }

    public boolean isAvailable() {
        return this.ep != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short acquireSlot(ProxyMsgHandler handler) {
        ProxyManager proxyManager = this;
        synchronized (proxyManager) {
            for (short i = 0; i < this.slots.length; i = (short)((short)(i + 1))) {
                if (this.slots[i] != null) continue;
                this.slots[i] = handler;
                return i;
            }
        }
        throw new RuntimeException("No more proxy slots available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSlot(ProxyMsgHandler handler, short slot) {
        ProxyManager proxyManager = this;
        synchronized (proxyManager) {
            if (this.slots[slot] == handler) {
                this.slots[slot] = null;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(Message msg) {
        short slot = msg.getContext();
        if (ProxyDebug.PROXY_MSG.show()) {
            LogSupport.message((Object)this, (String)"transmit", (String)("XMIT: " + BrowserMsg.toString(msg)));
        }
        if (slot < 0 || slot > this.slots.length) {
            LogSupport.message((Object)this, (String)"transmit", (String)("Bad slot " + slot + ", failed to transmit message: " + BrowserMsg.toString(msg)));
            return;
        }
        if (this.ostr == null) {
            LogSupport.message((Object)this, (String)"transmit", (String)("No stream, failed to transmit message: " + BrowserMsg.toString(msg)));
            return;
        }
        ProxyManager proxyManager = this;
        synchronized (proxyManager) {
            block9: {
                if (this.slots[slot] != null) {
                    try {
                        msg.writeMessage(this.ostr);
                        this.ostr.flush();
                    }
                    catch (IOException ioe) {
                        if (this.thread == null) break block9;
                        this.thread.interrupt();
                    }
                }
            }
        }
    }

    public boolean shutdown(int method) {
        this.shutdown = true;
        Endpoint stopEp = this.ep;
        Process stopProc = this.proc;
        switch (method) {
            case 1: {
                if (stopEp != null) {
                    this.ep = null;
                    stopEp.closeForce();
                    return true;
                }
                return false;
            }
            case 2: {
                if (stopProc != null) {
                    this.proc = null;
                    stopProc.destroy();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void shutdown() {
        this.shutdown(2);
    }

    private void spawn() {
        try {
            EndpointListener lst = new EndpointListener("direct", 0);
            int port = lst.getLocalPort();
            lst.setSoTimeout(30000);
            String command = this.path.getAbsolutePath() + " -port " + port;
            if (ProxyDebug.NATIVE.show()) {
                command = command + " -debug";
            }
            if (ProxyDebug.HELPER.show()) {
                LogSupport.message((Object)this, (String)"spawn", (String)("Spawning new helper instance: '" + command + "'"));
            }
            this.proc = Runtime.getRuntime().exec(command);
            ProcessUtils.ignoreProcessOutput((Process)this.proc);
            this.ep = lst.accept();
            this.istr = new DataInputStream(this.ep.getInputStream());
            this.ostr = new DataOutputStream(this.ep.getOutputStream());
            lst.closeForce();
            HashSet<ProxyMsgHandler> reconnectSet = new HashSet<ProxyMsgHandler>();
            for (int i = 0; i < this.slots.length; ++i) {
                if (this.slots[i] == null) continue;
                reconnectSet.add(this.slots[i]);
            }
            for (ProxyMsgHandler pmh : reconnectSet) {
                pmh.onReconnect();
            }
            this.thread = new WorkerThread((Runnable)this, "ProxyManager msg listener", 6);
            this.thread.setDaemon(true);
            this.thread.start();
        }
        catch (IOException ex) {
            if (!this.shutdown) {
                LogSupport.message((Object)this, (String)"spawn", (String)("Failed to spawn helper instance: " + Debug.getStackTrace((Throwable)ex)));
            }
            if (this.proc != null) {
                this.proc.destroy();
            }
            this.ep = null;
            this.istr = null;
            this.ostr = null;
        }
    }

    @Override
    public void run() {
        block6: {
            try {
                Message msg;
                while ((msg = new Message(this.istr)) != null) {
                    short slot;
                    if (ProxyDebug.PROXY_MSG.show()) {
                        LogSupport.message((Object)this, (String)"run", (String)("RECV: " + BrowserMsg.toString(msg)));
                    }
                    if ((slot = msg.getContext()) < 0 || slot >= this.slots.length) {
                        LogSupport.message((Object)this, (String)"run", (String)("No context for message: " + BrowserMsg.toString(msg)));
                        continue;
                    }
                    if (this.slots[slot] == null) continue;
                    this.slots[slot].onMessage(msg);
                }
            }
            catch (Throwable t) {
                if (!ProxyDebug.PROXY_MSG.show()) break block6;
                LogSupport.message((Object)this, (String)"run", (String)("An exception occured with message " + t.getMessage()));
            }
        }
        if (!this.shutdown) {
            this.spawn();
        }
    }
}

