/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.browser.macosx;

import com.apple.eawt.CocoaComponent;
import com.elluminate.browser.BrowserDebug;
import com.elluminate.browser.macosx.WebKitElementInfo;
import com.elluminate.browser.macosx.WebKitFrameFactory;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public abstract class DMWebKitView
extends CocoaComponent {
    public static final int storeJavaObject = 1;
    public static final int loadURL = 2;
    public static final int resizeFrame = 3;
    public static final int stopLoading = 4;
    public static final int goBack = 5;
    public static final int goForward = 6;
    public static final int updateCursor = 7;
    public static final int runJS = 8;
    public static final int textLarger = 9;
    public static final int textSmaller = 10;
    public static final int search = 11;
    public static final int dispose = 12;
    public static final int ordercallback = 13;
    public static final int loadURLFromString = 14;
    public static final int reload = 15;
    public static final int setDownloadDir = 16;
    public static final int loadURLinFrame = 17;
    public static final int clear = 18;
    public static final int makeFirstResponder = 19;
    public static final int repaintView = 20;
    public static final int WEB_VIEW_POLICY_NONE = 0;
    public static final int WEB_VIEW_POLICY_IN_OLD_WINDOW = 1;
    public static final int WEB_VIEW_POLICY_IN_NEW_WINDOW = 2;
    protected static final boolean IS_TIGER;
    protected int newWebViewCreatingPolicy = 2;
    static WebKitElementInfo webKitElementInfo;
    private static boolean available;
    private static WebKitFrameFactory frameFactory;
    protected volatile boolean needResize = false;
    private Vector hyperlinkListeners = new Vector();
    private URL lastURL = null;
    private String lastURLString = null;
    protected boolean peerReady = false;
    protected long nsObject = 0L;
    private File downloadDir = null;
    protected int prefWidth = 0;
    protected int prefHeight = 0;

    public void closeWindow() {
    }

    public void errorOccurred(String errorDesc, String url) {
        System.err.println("ERROR: " + errorDesc + ": " + url);
    }

    public void pageLoadError(String errorDesc, String url, int code) {
        System.err.println("ERROR: " + code + " (" + errorDesc + "): " + url);
    }

    public void startURLLoading(String url) {
    }

    public void finishURLLoading() {
    }

    public void startFrameLoading(String name, String url) {
    }

    public void finishFrameLoading(String name) {
    }

    public void setURLTitle(String title) {
    }

    public void setURLIcon(ByteBuffer buffer) {
    }

    public void setStatusText(String statusStr) {
    }

    public void setBackButtonEnable(boolean v) {
    }

    public void setForwardButtonEnable(boolean v) {
    }

    private static native long createViewOnMainThreadNative();

    private native long createNSViewNative();

    public static boolean isAvailable() {
        return available;
    }

    public static void createNewFrameForView(final String initURL, final long nativeView, final int creatingPolicy, final int initX, final int initY, final int initWidth, final int initHeight, final boolean isResizable, final boolean hasToolbars, final boolean hasStatusBar) {
        final WebKitFrameFactory factory = frameFactory;
        if (factory != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    factory.createNewFrameForView(initURL, nativeView, creatingPolicy, initX, initY, initWidth, initHeight, isResizable, hasToolbars, hasStatusBar);
                }
            });
        }
    }

    public static void setFrameFactory(WebKitFrameFactory factory) {
        frameFactory = factory;
    }

    static long createViewOnMainThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Cannot create WebKitView from Swing thread.");
        }
        return DMWebKitView.createViewOnMainThreadNative();
    }

    public DMWebKitView() {
        this.initialize();
    }

    public DMWebKitView(long nativeView) {
        this.nsObject = nativeView;
        this.initialize();
    }

    private void initialize() {
        if (!available) {
            throw new RuntimeException("Native webkit library is not available.");
        }
        if (!IS_TIGER) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mev) {
                    DMWebKitView.this.sendFocus();
                }
            });
        }
    }

    void setNativeView(long nativeView) {
        if (this.nsObject != 0L) {
            throw new RuntimeException("WebKitView already initialized.");
        }
        this.nsObject = nativeView;
    }

    public void changedWebViewSize(final int w, final int h) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DMWebKitView.this.prefWidth = w;
                DMWebKitView.this.prefHeight = h;
                DMWebKitView.this.invalidate();
                DMWebKitView.this.repaint();
            }
        });
    }

    public int createNSView() {
        return (int)this.createNSViewLong();
    }

    public long createNSViewLong() {
        if (this.nsObject == 0L) {
            this.nsObject = this.createNSViewNative();
        }
        return this.nsObject;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize() {
        return new Dimension(96, 64);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    public boolean isFocusable() {
        return true;
    }

    public void paint(Graphics g) {
        this.sendRepaintView();
    }

    public void requestFocus() {
        super.requestFocus();
        this.sendFocus();
    }

    public int getNewWebViewCreatingPolicy() {
        return this.newWebViewCreatingPolicy;
    }

    public void setNewWebViewCreatingPolicy(int newWebViewCreatingPolicy) {
        this.newWebViewCreatingPolicy = newWebViewCreatingPolicy;
        if (this.newWebViewCreatingPolicy < 0 || this.newWebViewCreatingPolicy > 2) {
            this.newWebViewCreatingPolicy = 1;
        }
    }

    public void addHyperlinkListener(HyperlinkListener l) {
        if (l == null) {
            return;
        }
        if (!this.hyperlinkListeners.contains(l)) {
            this.hyperlinkListeners.addElement(l);
        }
    }

    public void removeHyperlinkListener(HyperlinkListener l) {
        if (l == null) {
            return;
        }
        if (this.hyperlinkListeners.contains(l)) {
            this.hyperlinkListeners.removeElement(l);
        }
    }

    void notifyHyperlinkListeners(HyperlinkEvent e) {
        if (this.hyperlinkListeners == null || this.hyperlinkListeners.size() < 1) {
            return;
        }
        final HyperlinkEvent evt = e;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < DMWebKitView.this.hyperlinkListeners.size(); ++i) {
                    HyperlinkListener l = (HyperlinkListener)DMWebKitView.this.hyperlinkListeners.elementAt(i);
                    try {
                        l.hyperlinkUpdate(evt);
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        });
    }

    public Object getWebKitElementInfo() {
        if (webKitElementInfo == null) {
            webKitElementInfo = new WebKitElementInfo();
        }
        return webKitElementInfo;
    }

    public void addNotify() {
        super.addNotify();
        this.peerReady = true;
        this.sendMessage(1, (Object)this);
        if (BrowserDebug.WEBKIT.show()) {
            LogSupport.message((String)("Registered " + ((Object)((Object)this)).hashCode() + " for native view " + this.nsObject));
        }
        if (this.downloadDir != null) {
            this.setDownloadLocation(this.downloadDir);
        }
    }

    public void removeNotify() {
        if (BrowserDebug.WEBKIT.show()) {
            LogSupport.message((String)("Removed " + ((Object)((Object)this)).hashCode() + " from its container, native view is " + this.nsObject));
        }
        this.peerReady = false;
        super.removeNotify();
    }

    public void refresh(boolean force) {
        if (force) {
            this.needResize = true;
        }
        this.refresh();
    }

    public void refresh() {
        if (!this.peerReady) {
            return;
        }
        this.sendMessage(3, (Object)this);
        Container c = this.getParent();
        if (c != null) {
            c.repaint();
        }
        if (this.needResize) {
            this.needResize = false;
            Dimension cd = this.getSize();
            ++cd.width;
            ++cd.height;
            this.setSize(cd);
            --cd.width;
            --cd.height;
            this.setSize(cd);
        }
    }

    public void sendMessage(int messageID) {
        if (!this.peerReady) {
            return;
        }
        try {
            this.sendMessage(messageID, null);
        }
        catch (Throwable t) {
            LogSupport.exception((Object)((Object)this), (String)"sendMessage", (Throwable)t, (boolean)true, (String)("Sending " + messageID));
        }
    }

    public String runJS(String js) {
        StringBuffer sb = new StringBuffer();
        Object[] args = new Object[]{js, sb};
        if (this.peerReady) {
            this.sendMessage(8, args);
        }
        return sb.toString();
    }

    public void loadPage(final String url) {
        if (!this.peerReady) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DMWebKitView.this.sendMessage(2, url);
            }
        };
        Thread t = new Thread(r, "WebKit Page Loader");
        t.setDaemon(true);
        t.setPriority(5);
        t.start();
    }

    public void loadFrame(String frameName, String url) {
        if (!this.peerReady) {
            return;
        }
        final String[] args = new String[]{frameName, url};
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DMWebKitView.this.sendMessage(17, args);
            }
        };
        Thread t = new Thread(r, "WebKit Frame Loader");
        t.setDaemon(true);
        t.setPriority(5);
        t.start();
    }

    public void reload() {
        this.sendMessage(15);
    }

    public void stopLoadingPage() {
        if (!this.peerReady) {
            return;
        }
        this.sendMessage(4);
    }

    public void forwardPage() {
        this.sendMessage(6);
    }

    public void backPage() {
        this.sendMessage(5);
    }

    public void updateCursor() {
        this.sendMessage(7);
    }

    public void makeTextLarger() {
        this.sendMessage(9);
    }

    public void makeTextSmaller() {
        this.sendMessage(10);
    }

    protected void reRenderDocument() {
        this.makeTextLarger();
        this.makeTextSmaller();
    }

    public void setDownloadLocation(File f) {
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("Download location must be a directory: " + f);
        }
        this.downloadDir = f;
        if (!this.peerReady) {
            return;
        }
        String path = null;
        try {
            path = f.getCanonicalPath();
        }
        catch (Throwable t) {
            path = f.getAbsolutePath();
        }
        if (path != null) {
            this.sendMessage(16, path);
        }
    }

    public void clearPage() {
        if (!this.peerReady) {
            return;
        }
        this.sendMessage(18);
    }

    public void sendFocus() {
        if (!this.peerReady) {
            return;
        }
        if (!IS_TIGER) {
            this.sendMessage(19);
        }
    }

    public void sendRepaintView() {
        if (!this.peerReady) {
            return;
        }
        this.sendMessage(20);
    }

    public void validate() {
        super.validate();
    }

    public void dispose() {
        block5: {
            Container papa = this.getParent();
            if (papa != null) {
                papa.remove((Component)((Object)this));
            }
            if (this.nsObject == 0L) {
                return;
            }
            try {
                super.sendMessage(12, null);
            }
            catch (NullPointerException npe) {
            }
            catch (Throwable t) {
                if (!BrowserDebug.BROWSER.show()) break block5;
                LogSupport.message((Object)((Object)this), (String)"dispose", (String)Debug.getStackTrace((Throwable)t));
            }
        }
    }

    protected void orderCallback() {
        this.sendMessage(13);
    }

    protected void callback(Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }

    public boolean runJavaScriptAlertPanelWithMessage(String message) {
        return true;
    }

    public void invokeFromWebKitThread(Runnable runnable) {
        if (!this.peerReady) {
            return;
        }
        this.sendMessage(13, runnable);
    }

    public boolean searchForString(String stringToFind, boolean forward, boolean caseFlag, boolean wrap) {
        Object[] args = new Object[]{stringToFind, new boolean[4]};
        ((boolean[])args[1])[0] = forward;
        ((boolean[])args[1])[1] = caseFlag;
        ((boolean[])args[1])[2] = wrap;
        ((boolean[])args[1])[3] = false;
        if (this.peerReady) {
            this.sendMessage(11, args);
        }
        return ((boolean[])args[1])[3];
    }

    public void mouseDidMoveOverElement(final Object elementInfoObject) {
        if (!(elementInfoObject instanceof WebKitElementInfo)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String urlString = ((WebKitElementInfo)elementInfoObject).linkURLString;
                HyperlinkEvent.EventType eventType = null;
                URL url = null;
                if (DMWebKitView.this.lastURL != null && urlString == null) {
                    url = DMWebKitView.this.lastURL;
                    eventType = HyperlinkEvent.EventType.EXITED;
                    DMWebKitView.this.lastURL = null;
                    DMWebKitView.this.lastURLString = null;
                } else if (DMWebKitView.this.lastURL == null && urlString != null) {
                    try {
                        url = new URL(urlString);
                    }
                    catch (Throwable t) {
                        url = null;
                    }
                    DMWebKitView.this.lastURL = url;
                    DMWebKitView.this.lastURLString = urlString;
                    if (url != null) {
                        eventType = HyperlinkEvent.EventType.ENTERED;
                    }
                } else {
                    try {
                        url = new URL(urlString);
                    }
                    catch (Throwable t) {
                        url = null;
                    }
                    if (url == null) {
                        url = DMWebKitView.this.lastURL;
                        eventType = HyperlinkEvent.EventType.EXITED;
                        DMWebKitView.this.lastURL = null;
                        DMWebKitView.this.lastURLString = null;
                    } else if (!urlString.equals(DMWebKitView.this.lastURLString)) {
                        DMWebKitView.this.notifyHyperlinkListeners(new HyperlinkEvent(this, HyperlinkEvent.EventType.EXITED, DMWebKitView.this.lastURL));
                        DMWebKitView.this.lastURL = url;
                        DMWebKitView.this.lastURLString = urlString;
                        eventType = HyperlinkEvent.EventType.ENTERED;
                    }
                }
                if (url != null && eventType != null) {
                    DMWebKitView.this.notifyHyperlinkListeners(new HyperlinkEvent(this, eventType, url));
                }
            }
        });
    }

    static {
        block2: {
            IS_TIGER = Platform.checkOSVersion((int)202, (String)"10.4+");
            webKitElementInfo = null;
            available = false;
            frameFactory = null;
            try {
                System.loadLibrary("webkit");
                available = true;
            }
            catch (Throwable t) {
                available = false;
                if (!BrowserDebug.BROWSER.show()) break block2;
                LogSupport.message(DMWebKitView.class, (String)"<clinit>", (String)Debug.getStackTrace((Throwable)t));
            }
        }
    }
}

