/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.browser;

import com.elluminate.browser.BrowserPaneImpl;
import com.elluminate.browser.NavigationEvent;
import com.elluminate.browser.NavigationListener;
import com.elluminate.browser.UIListener;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class BrowserPaneImplAdapter
implements BrowserPaneImpl {
    private HashMap<String, Object> props = new HashMap();
    protected final Object propsLock = new Object();
    private ArrayList navListeners = new ArrayList();
    private ArrayList uiListeners = new ArrayList();
    private final Object listenerLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNavigationListener(NavigationListener l) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (!this.navListeners.contains(l)) {
                ArrayList nlist = (ArrayList)this.navListeners.clone();
                nlist.add(l);
                this.navListeners = nlist;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNavigationListener(NavigationListener l) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.navListeners.contains(l)) {
                ArrayList nlist = (ArrayList)this.navListeners.clone();
                nlist.remove(l);
                this.navListeners = nlist;
            }
        }
    }

    protected void fireOnNavigate(String frame, String url) {
        NavigationEvent e = new NavigationEvent(this, frame, url);
        for (NavigationListener l : this.navListeners) {
            try {
                l.onNavigate(e);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireOnNavigate", (Throwable)t, (boolean)true);
            }
        }
    }

    protected void fireOnNavigate(String url) {
        this.fireOnNavigate(null, url);
    }

    protected void fireStop() {
        for (NavigationListener l : this.navListeners) {
            try {
                l.onStop();
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireStop", (Throwable)t, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUIListener(UIListener l) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (!this.uiListeners.contains(l)) {
                ArrayList nlist = (ArrayList)this.uiListeners.clone();
                nlist.add(l);
                this.uiListeners = nlist;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUIListener(UIListener l) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.uiListeners.contains(l)) {
                ArrayList nlist = (ArrayList)this.uiListeners.clone();
                nlist.remove(l);
                this.uiListeners = nlist;
            }
        }
    }

    protected void fireSetCurrentURL(String url) {
        for (UIListener l : this.uiListeners) {
            try {
                l.setCurrentURL(url);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireSetCurrentURL", (Throwable)t, (boolean)true);
            }
        }
    }

    protected void fireSetPageTitle(String title) {
        for (UIListener l : this.uiListeners) {
            try {
                l.setPageTitle(title);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireSetPageTitle", (Throwable)t, (boolean)true);
            }
        }
    }

    protected void fireSetBackEnabled(boolean enabled) {
        for (UIListener l : this.uiListeners) {
            try {
                l.setBackEnabled(enabled);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireSetBackEnabled", (Throwable)t, (boolean)true);
            }
        }
    }

    protected void fireSetFwdEnabled(boolean enabled) {
        for (UIListener l : this.uiListeners) {
            try {
                l.setFwdEnabled(enabled);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireSetFwdEnabled", (Throwable)t, (boolean)true);
            }
        }
    }

    @Override
    public boolean hasFrameSupport() {
        return false;
    }

    @Override
    public void openURL(String frame, String url) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void repaintContent() {
    }

    @Override
    public boolean isPropertySupported(String prop) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String prop, Object val) {
        Object object = this.propsLock;
        synchronized (object) {
            this.props.put(prop, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String prop) {
        Object object = this.propsLock;
        synchronized (object) {
            return this.props.get(prop);
        }
    }
}

