/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.transfer;

import com.elluminate.groupware.transfer.StreamCache;
import com.elluminate.groupware.transfer.StreamEvent;
import com.elluminate.groupware.transfer.StreamListener;
import com.elluminate.groupware.transfer.TransferLibraryEntry;
import com.elluminate.groupware.transfer.XferDebug;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.jinx.XmitWindow;
import com.elluminate.util.log.LogSupport;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class StreamProxy {
    private Channel chnl;
    private short addr;
    private HashMap streams = new HashMap();

    public StreamProxy(Channel ch, short uid) {
        this.addr = uid;
        this.chnl = ch;
    }

    public void connect(TransferLibraryEntry ent) {
        this.connect(ent, -1);
    }

    public void connect(TransferLibraryEntry ent, int req) {
        short myAddr = this.chnl.getConnection().getAddress();
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)this.addr, (byte)2);
        try {
            DataOutputStream str = e.write();
            str.writeInt(req);
            ent.encodeStatus(str, myAddr, 0L);
            str.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"connect", (Throwable)ex, (boolean)true);
        }
        this.chnl.onChannelData(e);
        this.reconnect(ent, 0L);
    }

    public void reconnect(TransferLibraryEntry ent, long from) {
        StreamCache c = ent.getCache();
        Integer key = new Integer(c.getStreamID());
        StreamInfo si = new StreamInfo(c);
        this.streams.put(key, si);
        si.attach(from);
    }

    public void disconnect(TransferLibraryEntry ent) {
        Integer key = new Integer(ent.getUID());
        StreamInfo si = (StreamInfo)this.streams.remove(key);
        if (si != null) {
            si.dispose();
        }
    }

    public void dispose() {
        for (StreamInfo si : this.streams.values()) {
            si.dispose();
        }
    }

    public boolean isConnected(TransferLibraryEntry ent) {
        return this.streams.containsKey(new Integer(ent.getUID()));
    }

    public long getLocation(TransferLibraryEntry ent) {
        StreamInfo si = (StreamInfo)this.streams.get(new Integer(ent.getUID()));
        if (si == null) {
            return -1L;
        }
        return si.getLocation();
    }

    public short getAddress() {
        return this.addr;
    }

    public void ack(int streamid, int nBytes) {
        Integer key = new Integer(streamid);
        StreamInfo si = (StreamInfo)this.streams.get(key);
        if (si != null) {
            si.ack(nBytes);
        }
    }

    public void onTransmitStatusChanged(TransmitStatusEvent e) {
        try {
            StreamInfo si = (StreamInfo)e.getContext();
            si.setQuiesced();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUrgent(int streamid, byte delta) {
        Integer key = new Integer(streamid);
        StreamInfo si = (StreamInfo)this.streams.get(key);
        si.setUrgent(delta);
    }

    class StreamInfo
    implements StreamListener {
        StreamCache cache;
        XmitWindow window = new XmitWindow(3000L, 1024, 32768);
        volatile byte urgency = 0;
        volatile boolean quiescing = false;
        long loc;

        public StreamInfo(StreamCache c) {
            this.cache = c;
            this.loc = 0L;
            this.window.setTraceFlag(XferDebug.WINDOW);
        }

        public void attach(long f) {
            this.loc = f;
            this.cache.addStreamListener(this, f);
        }

        public void dispose() {
            this.cache.suspendStreamListener(this);
            this.cache.removeStreamListener(this);
            this.cache = null;
        }

        @Override
        public void streamingData(StreamEvent e) {
            boolean suspend;
            ProtocolBuffer buf = e.getBuffer();
            ChannelDataEvent cde = null;
            if (this.quiescing) {
                LogSupport.error((Object)this, (String)"streamingData", (String)"Data received while quiescing stream");
                suspend = false;
            } else {
                int size = buf.getSize();
                suspend = !this.window.xmit(size);
                this.loc += (long)size;
                try {
                    DataOutputStream ostr = buf.addHeader();
                    ostr.writeInt(e.getStreamID());
                    ostr.close();
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)this, (String)"streamingData", (Throwable)ex, (boolean)true);
                    return;
                }
                cde = ChannelDataEvent.getInstance((Object)this, (short)StreamProxy.this.addr, (byte)6, (ProtocolBuffer)buf);
            }
            if (cde != null) {
                if (suspend && this.cache != null) {
                    this.cache.suspendStreamListener(this);
                }
                StreamProxy.this.chnl.onChannelData(cde, (byte)(-2 + this.urgency));
            }
            e.dispose();
        }

        @Override
        public void streamAbort(StreamEvent e) {
        }

        public void ack(int nBytes) {
            boolean resume;
            boolean bl = resume = this.window.ack(nBytes) && !this.quiescing;
            if (resume) {
                this.cache.resumeStreamListener(this);
            }
        }

        public void setUrgent(byte delta) {
            if (delta < 0) {
                delta = 0;
            }
            if (!this.quiescing && delta > this.urgency) {
                this.quiescing = true;
                this.cache.suspendStreamListener(this);
                StreamProxy.this.chnl.requestCompletionNotify(StreamProxy.this.addr, (byte)(-2 + this.urgency), (Object)this);
            }
            this.urgency = delta;
        }

        public void setQuiesced() {
            this.quiescing = false;
            if (this.window.isOpen()) {
                this.cache.resumeStreamListener(this);
            }
        }

        public long getLocation() {
            return this.loc;
        }
    }
}

