/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.timer.module;

import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.timer.TimerInfo;
import com.elluminate.groupware.timer.module.StringsProperties;
import com.elluminate.gui.FixedLengthDocument;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.TimerSpinnerField;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class TimerSetupDialog
implements PropertyChangeListener,
ItemListener {
    private static I18n i18n = I18n.create(TimerSetupDialog.class);
    private ClientList clients;
    private JRadioButton countUp;
    private JRadioButton countDown;
    private JRadioButton visibilityAll;
    private JRadioButton visibilityModerators;
    private JCheckBox visualAlert;
    private JCheckBox audioAlert;
    private TimerSpinnerField timeField;
    private JTextField messageFld;
    private JButton startButton;
    private JButton cancelButton;
    private Frame dialogContainer;
    private String dialogTitle;
    private long previousStateTimeSpinner = 300L;
    private boolean previousStateCountUp = false;
    private boolean previousStateCountDown = true;
    private boolean previousStateVisibilityAll = true;
    private boolean previousStateVisibilityModerators = false;
    private boolean previousStateAudioAlert = true;
    private boolean previousStateVisualAlert = true;
    private String previousMessage = null;
    private JLabel alertTitleLabel;

    public TimerSetupDialog(Frame container, String dialogTitle, ClientList clients) {
        this.dialogContainer = container;
        this.dialogTitle = dialogTitle;
        this.clients = clients;
    }

    private void createGUI(final EasyDialog dialog) throws Exception {
        this.countUp = new JRadioButton(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_COUNTUP), false);
        this.countUp.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_COUNTUPTOOLTIP));
        this.countUp.addItemListener(this);
        this.countDown = new JRadioButton(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_COUNTDOWN), true);
        this.countDown.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_COUNTDOWNTOOLTIP));
        this.countDown.addItemListener(this);
        ButtonGroup counterTypeGroup = new ButtonGroup();
        counterTypeGroup.add(this.countUp);
        counterTypeGroup.add(this.countDown);
        this.alertTitleLabel = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_ALERTTITLE));
        this.visualAlert = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_VISUALALERT), true);
        this.visualAlert.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_VISUALALERTTOOLTIP));
        this.audioAlert = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_AUDIOALERT), true);
        this.audioAlert.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_AUDIOALERTTOOLTIP));
        this.timeField = new TimerSpinnerField(1);
        this.timeField.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_TIMESPINNERTOOLTIP));
        this.timeField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (TimerSetupDialog.this.countDown.isSelected()) {
                    TimerSetupDialog.this.startButton.setEnabled(TimerSetupDialog.this.timeField.getTotalSeconds() > 0L);
                } else {
                    TimerSetupDialog.this.startButton.setEnabled(true);
                }
            }
        });
        this.timeField.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (TimerSetupDialog.this.timeField.hasFocus() || TimerSetupDialog.this.timeField.getEditor().hasFocus()) {
                    if (TimerSetupDialog.this.countDown.isSelected()) {
                        TimerSetupDialog.this.startButton.setEnabled(TimerSetupDialog.this.timeField.getTotalSecondsFromText() > 0L);
                    } else {
                        TimerSetupDialog.this.startButton.setEnabled(true);
                    }
                }
            }
        });
        JPanel typeGroupPanel = new JPanel(new GridBagLayout());
        typeGroupPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_TYPEGROUPTITLE)), BorderFactory.createEmptyBorder(4, 10, 10, 10)));
        typeGroupPanel.add((Component)this.countDown, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, 6, 0), 0, 0));
        typeGroupPanel.add((Component)this.timeField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 1, new Insets(0, 6, 6, 0), 0, 0));
        typeGroupPanel.add((Component)this.alertTitleLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 1, new Insets(0, 20, 6, 0), 0, 0));
        typeGroupPanel.add((Component)this.visualAlert, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 21, 1, new Insets(0, 40, 0, 0), 0, 0));
        typeGroupPanel.add((Component)this.audioAlert, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 21, 1, new Insets(0, 40, 6, 0), 0, 0));
        typeGroupPanel.add((Component)this.countUp, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        String chairDesc = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderators");
        String sessionDesc = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.session");
        this.visibilityAll = new JRadioButton(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_VISIBILITYALL), true);
        this.visibilityAll.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_VISIBILITYALLTOOLTIP, new Object[]{sessionDesc}));
        this.visibilityModerators = new JRadioButton(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_VISIBILITYMODERATORS, new Object[]{chairDesc}));
        this.visibilityModerators.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_VISIBILITYMODERATORSTOOLTIP, new Object[]{chairDesc, sessionDesc}));
        ButtonGroup visibilityGroup = new ButtonGroup();
        visibilityGroup.add(this.visibilityAll);
        visibilityGroup.add(this.visibilityModerators);
        JPanel visibilityPanel = new JPanel(new GridBagLayout());
        visibilityPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_VISIBILITYTITLE)), BorderFactory.createEmptyBorder(4, 10, 10, 10)));
        visibilityPanel.add((Component)this.visibilityAll, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        visibilityPanel.add((Component)this.visibilityModerators, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel messagePanel = new JPanel(new GridBagLayout());
        messagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_MESSAGE_TITLE)), BorderFactory.createEmptyBorder(4, 10, 10, 10)));
        this.messageFld = new JTextField(30);
        this.messageFld.setDocument((Document)new FixedLengthDocument(30));
        this.messageFld.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_MESSAGE_TOOL_TIP));
        messagePanel.add(this.messageFld);
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.add((Component)typeGroupPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, 6, 0), 0, 0));
        contentPanel.add((Component)visibilityPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)messagePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.startButton = new JButton(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_TIMERSTARTBUTTON));
        this.startButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_TIMERSTARTBUTTONTOOLTIP));
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimerSetupDialog.this.timeField.getTotalSeconds() == 0L && TimerSetupDialog.this.countDown.isSelected()) {
                    ModalDialog.showMessageDialogAsync((int)-1, (Component)TimerSetupDialog.this.dialogContainer, (Object)i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_INVALIDCOUNTOWNTIMEMSG), (String)i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_INVALIDCOUNTOWNTIMETITLE), (int)0);
                    return;
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        this.cancelButton = dialog.makeButton(0);
        this.cancelButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_TIMERCANCELBUTTONTOOLTIP));
        dialog.setContent((Component)contentPanel);
        dialog.setInitialFocus((Component)this.timeField);
        dialog.addCancelButton(this.cancelButton, false);
        dialog.addActionButton(this.startButton, true);
    }

    public TimerInfo getBuiltInTimer() {
        EasyDialog dialog = new EasyDialog((Component)this.dialogContainer, this.dialogTitle, true);
        try {
            this.createGUI(dialog);
            this.populatePreviousSelections();
            this.enableDisableCountDownComponents(this.countDown.isSelected());
            dialog.getRootPane().setDefaultButton(this.startButton);
            this.timeField.setDefaultButton(this.startButton);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"TimerSetupDialog Constructor", (Throwable)e, (boolean)true);
        }
        dialog.show();
        if (dialog.wasCanceled()) {
            return null;
        }
        TimerInfo timer = new TimerInfo();
        short timerType = this.countUp.isSelected() ? (short)1 : 2;
        short visibility = this.visibilityAll.isSelected() ? (short)2 : 1;
        timer.setIsAudibleAlert(this.audioAlert.isSelected());
        timer.setIsVisibleAlert(this.visualAlert.isSelected());
        timer.setTimerType(timerType);
        timer.setTime(this.countUp.isSelected() ? 0L : this.timeField.getTotalSeconds() * 1000L);
        timer.setTimerVisibility(visibility);
        timer.setConfigurableString(this.messageFld.getText());
        this.previousStateTimeSpinner = this.timeField.getTotalSeconds();
        this.previousStateCountUp = this.countUp.isSelected();
        this.previousStateCountDown = this.countDown.isSelected();
        this.previousStateVisibilityAll = this.visibilityAll.isSelected();
        this.previousStateVisibilityModerators = this.visibilityModerators.isSelected();
        this.previousStateAudioAlert = this.audioAlert.isSelected();
        this.previousStateVisualAlert = this.visualAlert.isSelected();
        this.previousMessage = this.messageFld.getText();
        return timer;
    }

    private void populatePreviousSelections() {
        this.countUp.setSelected(this.previousStateCountUp);
        this.countDown.setSelected(this.previousStateCountDown);
        this.visibilityAll.setSelected(this.previousStateVisibilityAll);
        this.visibilityModerators.setSelected(this.previousStateVisibilityModerators);
        this.audioAlert.setSelected(this.previousStateAudioAlert);
        this.visualAlert.setSelected(this.previousStateVisualAlert);
        this.timeField.setValue(this.previousStateTimeSpinner);
        this.messageFld.setText(this.previousMessage);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!e.getPropertyName().equals("chair")) {
            return;
        }
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String chairDesc = LabelProps.get((PropertyAccessAPI)TimerSetupDialog.this.clients, (String)"Label.moderators");
                String sessionDesc = LabelProps.get((PropertyAccessAPI)TimerSetupDialog.this.clients, (String)"Label.session");
                TimerSetupDialog.this.visibilityModerators.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.TIMERSETUPDIALOG_VISIBILITYMODERATORSTOOLTIP, new Object[]{chairDesc, sessionDesc}));
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource() == this.countUp || event.getSource() == this.countDown) {
            this.enableDisableCountDownComponents(this.countDown.isSelected());
            this.startButton.setEnabled(event.getSource() == this.countUp || event.getSource() == this.countDown && this.timeField.getTotalSeconds() > 0L);
        }
    }

    private void enableDisableCountDownComponents(boolean enabled) {
        this.timeField.setEnabled(enabled);
        this.alertTitleLabel.setEnabled(enabled);
        this.visualAlert.setEnabled(enabled);
        this.audioAlert.setEnabled(enabled);
    }
}

