/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.timer.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.timer.TimerInfo;
import com.elluminate.groupware.timer.module.PauseTimerCmd;
import com.elluminate.groupware.timer.module.ResumeTimerCmd;
import com.elluminate.groupware.timer.module.StartTimerCmd;
import com.elluminate.groupware.timer.module.StopTimerCmd;
import com.elluminate.groupware.timer.module.StringsProperties;
import com.elluminate.groupware.timer.module.TimerBean;
import com.elluminate.groupware.timer.module.TimerController;
import com.elluminate.groupware.timer.module.TimerEvent;
import com.elluminate.groupware.timer.module.TimerListener;
import com.elluminate.groupware.timer.module.TimerSetupDialog;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class TimerModule
extends AbstractClientModule
implements PropertyChangeListener,
TimerListener,
ModulePublisherInfo {
    private static final String MODULE_NAME = "Timer";
    private static I18n i18n = I18n.create(TimerModule.class);
    private static final String TIMER_EXPIRED_NOTIFICATION = "/timer/timerExpired";
    private ClientList clients = null;
    private TimerSetupDialog timerSetupDialog;
    private boolean makeTimerVisible = true;
    private TimerBean timerBean = null;
    private Provider<TimerBean> beanProvider;
    private Provider<StartTimerCmd> startTimerCmdProvider;
    private Provider<StopTimerCmd> stopTimerCmdProvider;
    private Provider<PauseTimerCmd> pauseTimerCmdProvider;
    private Provider<ResumeTimerCmd> resumeTimerCmdProvider;
    private ClientProvider clientProvider;
    private ConferencingEngine confEngine;
    private DialogParentProvider parentProvider;
    private FeatureBroker broker;
    private boolean updating;
    private ActionFeature startTimerFeature;
    private ActionFeature stopTimerFeature;
    private ComponentFeature timerFeature;

    @Inject
    public void initTimerBeanProvider(Provider<TimerBean> bp) {
        this.beanProvider = bp;
    }

    @Inject
    public TimerModule(ComponentRegistrar registrar) {
        registrar.registerComponent((Object)this);
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initStartTimerCmd(Provider<StartTimerCmd> commandProvider) {
        this.startTimerCmdProvider = commandProvider;
    }

    @Inject
    public void initStopTimerCmd(Provider<StopTimerCmd> commandProvider) {
        this.stopTimerCmdProvider = commandProvider;
    }

    @Inject
    public void initPauseTimerCmd(Provider<PauseTimerCmd> commandProvider) {
        this.pauseTimerCmdProvider = commandProvider;
    }

    @Inject
    public void initResumeTimerCmd(Provider<ResumeTimerCmd> commandProvider) {
        this.resumeTimerCmdProvider = commandProvider;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initParentProvider(DialogParentProvider p) {
        this.parentProvider = p;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return i18n.getString((PropertiesEnum)StringsProperties.TIMERMODULE_EMPTYTITLE);
    }

    public Icon getModuleIcon() {
        return i18n.getIcon("TimerModule.moduleIcon");
    }

    public boolean requestClose() {
        this.makeTimerVisible = false;
        this.publishTimerFeature(false);
        this.updateFeatures();
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("chair")) {
            this.updateFeatures();
        } else if (prop.equals("timer.state") && e.getNewValue() != null) {
            TimerController.getInstance().changeState((Byte)e.getNewValue());
        }
    }

    private void startTimer() {
        TimerInfo timer;
        if (this.timerSetupDialog == null) {
            this.timerSetupDialog = new TimerSetupDialog(this.parentProvider.getDialogParent(), i18n.getString((PropertiesEnum)StringsProperties.TIMERMODULE_TIMERSETUPDIALOGTITLE), this.clients);
        }
        if ((timer = this.timerSetupDialog.getBuiltInTimer()) == null) {
            return;
        }
        if (TimerController.getInstance().timerIsShowing()) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this.parentProvider.getDialogParent(), (Object)i18n.getString((PropertiesEnum)StringsProperties.TIMERMODULE_ALREADYSTARTEDMSG), (String)i18n.getString((PropertiesEnum)StringsProperties.TIMERMODULE_ALREADYSTARTEDTITLE), (int)0);
            return;
        }
        this.timerBean.startTimer(timer);
    }

    public boolean isTimerVisible() {
        return this.makeTimerVisible;
    }

    void publishTimerFeature(boolean show) {
        this.broker.setFeaturePublished((Feature)this.timerFeature, show);
    }

    void postTimerExpiredNotification(String message) {
        this.broker.sendNotification((Object)this, TIMER_EXPIRED_NOTIFICATION, message, this.clientProvider.get().getSessionTime());
    }

    void abortTimerExpiredNotification() {
        this.broker.abortNotification((Object)this, TIMER_EXPIRED_NOTIFICATION);
    }

    @Override
    public void changedState(TimerEvent event) {
        if (event.getOldState() == event.getNewState()) {
            return;
        }
        this.updateFeatures();
    }

    protected TimerBean getTimerBean() {
        return this.timerBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFeatures() {
        ChairProtocol chairProtocol = new ChairProtocol();
        boolean isChair = chairProtocol.fetchChair(this.clients).isMe();
        boolean isTimerVisible = this.isTimerVisible();
        boolean isTimerRunning = this.timerBean.isTimerRunning() || this.timerBean.isTimerPaused();
        TimerModule timerModule = this;
        synchronized (timerModule) {
            if (this.updating) {
                return;
            }
            this.updating = true;
        }
        this.createFeatures(isTimerVisible);
        this.startTimerFeature.setEnabled(isChair && !isTimerRunning);
        this.stopTimerFeature.setEnabled(isChair && isTimerRunning);
        this.broker.setFeaturePublished((Feature)this.startTimerFeature, isChair && !isTimerRunning);
        this.broker.setFeaturePublished((Feature)this.stopTimerFeature, isChair && isTimerRunning);
        timerModule = this;
        synchronized (timerModule) {
            this.updating = false;
        }
    }

    private boolean createFeatures(boolean isTimerVisible) {
        if (this.startTimerFeature != null) {
            return false;
        }
        this.startTimerFeature = this.broker.createActionFeature((Object)this, "/timer/start", i18n.getString((PropertiesEnum)StringsProperties.TIMERMODULE_STARTTIMERTOPBARMENUITEM), i18n.getString((PropertiesEnum)StringsProperties.TIMERMODULE_STARTTIMERTOOLTIP));
        this.startTimerFeature.setInteractive(true);
        ActionFeatureListener startTimerActionListener = new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                TimerModule.this.startTimer();
                TimerModule.this.updateFeatures();
            }
        };
        this.startTimerFeature.addActionFeatureListener(startTimerActionListener);
        this.stopTimerFeature = this.broker.createActionFeature((Object)this, "/timer/menu/stop", i18n.getString((PropertiesEnum)StringsProperties.TIMERMODULE_STOPTIMERTOPBARMENUITEM), i18n.getString((PropertiesEnum)StringsProperties.TIMERMODULE_STOPTIMERTOOLTIP));
        ActionFeatureListener stopTimerActionListener = new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                TimerModule.this.publishTimerFeature(false);
                TimerModule.this.timerBean.stopTimer();
                TimerModule.this.updateFeatures();
            }
        };
        this.stopTimerFeature.addActionFeatureListener(stopTimerActionListener);
        if (this.timerBean != null && this.timerFeature == null) {
            this.timerFeature = this.broker.createComponentFeature((Object)this, "/timer/timer", new ComponentProvider(){

                public Component get(ComponentFeature feature) {
                    return TimerModule.this.timerBean;
                }
            }, i18n.getString((PropertiesEnum)StringsProperties.TIMERMODULE_EMPTYTITLE), i18n.getString((PropertiesEnum)StringsProperties.TIMERMODULE_EMPTYTITLE));
        }
        return true;
    }

    public void start() {
        this.confEngine.registerCommand(this.startTimerCmdProvider);
        this.confEngine.registerCommand(this.stopTimerCmdProvider);
        this.confEngine.registerCommand(this.pauseTimerCmdProvider);
        this.confEngine.registerCommand(this.resumeTimerCmdProvider);
    }

    public void attach() {
        this.clients = this.clientProvider.get().getClientList();
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("timer.state", (PropertyChangeListener)this);
        this.timerBean = (TimerBean)this.beanProvider.get();
        this.timerBean.setClients();
        TimerController.getInstance().addTimerListener(this);
        this.broker.announceNotification((Object)this, TIMER_EXPIRED_NOTIFICATION);
        this.updateFeatures();
    }

    public void setupUI() {
    }

    public void cleanupUI() {
    }

    public void detach() {
        if (this.clients != null) {
            this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
            this.clients.removePropertyChangeListener("timer.state", (PropertyChangeListener)this);
        }
        this.clients = null;
        this.timerBean = null;
        TimerController.getInstance().removeTimerListener(this);
    }

    public void stop() {
    }
}

