/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module.macosx;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.module.AppSharingHost;
import com.elluminate.groupware.appshare.module.ApplicationInformation;
import com.elluminate.groupware.appshare.module.ButtonInputEvent;
import com.elluminate.groupware.appshare.module.KeyInputEvent;
import com.elluminate.groupware.appshare.module.MouseMoveEvent;
import com.elluminate.groupware.appshare.module.ScrollWheelEvent;
import com.elluminate.groupware.appshare.module.common.ASKeyUtils;
import com.elluminate.groupware.appshare.module.macosx.MacXAppInfo;
import com.elluminate.groupware.appshare.module.macosx.StringsProperties;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.macosx.MacGuiSupport;
import com.elluminate.platform.MacOSXPlatform;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class MacXHost
extends AppSharingHost {
    private static final String JNI_LIB_NAME = "appsharemac";
    private static boolean libLoaded = false;
    private static volatile boolean libInited = false;
    private static final int LIB_DEFAULT_VERSION = 2;
    private static final boolean TIGER_INTEL_CURSOR_BUG = Platform.getArch() == 101 && Platform.checkOSVersion((int)202, (String)"10.4*");
    public static final DebugFlag FRAME = DebugFlag.get((String)"appShare.mac.frame");
    public static final DebugFlag NO_OPEN_GL = DebugFlag.get((String)"appShare.mac.noOpenGL");
    public static final DebugFlag USE_QUARTZ = DebugFlag.get((String)"appShare.mac.useQuartz");
    static final boolean IS_MAC_LION = Platform.checkOSVersion((int)202, (String)"10.7+");
    static final boolean IS_MAC_MAVERICKS = Platform.checkOSVersion((int)202, (String)"10.9+");
    private Thread tileScanner = null;
    private int mode = 0;
    private boolean sharing = false;
    private short bkgCol = 0;
    private int colReduceMode = 2;
    private int cacheLen = Short.MAX_VALUE;
    private boolean excludeMenuBar = true;
    private boolean useOpenGL = true;
    private Object[] runningApps = null;
    private FloatingWindowListener floatingWindowListener = null;

    public static boolean isLoaded() {
        return libLoaded;
    }

    public MacXHost() throws Exception {
        if (!MacXHost.isLoaded()) {
            throw new RuntimeException("AppShare hosting is not available: native library is not loaded.");
        }
        if (!libInited) {
            MacXHost.initializeLibrary();
        }
    }

    @Override
    public int getBaseCapabilities() {
        return 3;
    }

    @Override
    public boolean isExcludeMenuBarSupported() {
        return true;
    }

    @Override
    public boolean isOpenGLSupported() {
        return true;
    }

    @Override
    public Rectangle[] getWindowRects() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Cannot call from Swing thread");
        }
        return this.getWindowListNative();
    }

    @Override
    public ApplicationInformation[] getApplicationList(ApplicationInformation[] prevList, String me) {
        ApplicationInformation[] list = this.getApplicationListNative(me, this.i18n.getString((PropertiesEnum)StringsProperties.MACXHOST_BLUEBOXNAME));
        if (prevList == null) {
            return list;
        }
        if (prevList.length != list.length) {
            return list;
        }
        for (int ix = 0; ix < list.length; ++ix) {
            if (list[ix].equals(prevList[ix])) continue;
            return list;
        }
        return prevList;
    }

    @Override
    public Rectangle getAppDisplayBounds(Object[] appList) {
        long[] procs = this.getProcessIDs(appList);
        Rectangle r = this.getApplicationBoundsNative(procs, this.excludeMenuBar);
        return r;
    }

    @Override
    public void setBackgroundColor(Color colour) {
        int blue5 = colour.getBlue() >> 3;
        int green5 = colour.getGreen() >> 3;
        int red5 = colour.getRed() >> 3;
        this.bkgCol = (short)(red5 << 10 | green5 << 5 | blue5);
    }

    @Override
    public void setHistoryCount(int historyCnt) {
        this.cacheLen = historyCnt;
    }

    @Override
    public void setColorReduction(int reduceMode) {
        this.colReduceMode = reduceMode;
        this.setColourReductionModeNative(reduceMode);
    }

    @Override
    public void setExcludeMenuBar(boolean exclude) {
        this.excludeMenuBar = exclude;
    }

    @Override
    public boolean getExcludeMenuBar() {
        return this.excludeMenuBar;
    }

    @Override
    public boolean setIgnoredWindow(Window w) {
        return this.setIgnoredWindowNative(w);
    }

    @Override
    public void setWindowFloating(Window w, boolean floating) {
        if (floating) {
            if (this.floatingWindowListener == null) {
                this.floatingWindowListener = new FloatingWindowListener();
            }
            w.addComponentListener(this.floatingWindowListener);
        } else {
            w.removeComponentListener(this.floatingWindowListener);
        }
        if (w.isShowing()) {
            this.raiseWindowLevelNative(w, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showRegion(final Rectangle rgn) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Cannot start AppShare hosting from Swing thread.");
        }
        if (rgn.isEmpty()) {
            LogSupport.message((Object)this, (String)"showRegion", (String)"Empty AppSharing region.");
            throw new RuntimeException("Empty AppSharing region.");
        }
        this.areaOfInterest.setBounds(rgn);
        Debug.lockEnter((Object)this, (String)"showRegion", (String)"Start/Stop Lock", (Object)this);
        try {
            MacXHost macXHost = this;
            synchronized (macXHost) {
                if (this.isShowing()) {
                    LogSupport.message((Object)this, (String)"showRegion", (String)"AppSharing already running.");
                    throw new RuntimeException("AppSharing already running.");
                }
                this.tileScanner = null;
                this.runningApps = null;
                try {
                    this.setIsLionNative(IS_MAC_LION || USE_QUARTZ.show());
                    this.initializeNative(this.bkgCol, this.cacheLen, this.colReduceMode, this.excludeMenuBar, this.useOpenGL);
                    WorkerThread tmp = new WorkerThread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                if (AppShareDebug.HOST.show()) {
                                    LogSupport.message((Object)this, (String)"run", (String)("entering startRegionNative: " + rgn + (MacXHost.this.useOpenGL ? " using OpenGL" : "")));
                                }
                                MacXHost.this.startRegionNative(rgn.x, rgn.y, rgn.width, rgn.height);
                            }
                            catch (Throwable t) {
                                LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)true);
                                MacXHost.this.fireShutDown(4);
                            }
                            finally {
                                if (AppShareDebug.HOST.show()) {
                                    LogSupport.message((Object)this, (String)"run", (String)"exited startRegionNative.");
                                }
                            }
                        }
                    }, "AppSharingTileScanner-Region");
                    tmp.setDaemon(true);
                    tmp.start();
                    this.tileScanner = tmp;
                }
                catch (RuntimeException rex) {
                    LogSupport.exception((Object)this, (String)"showRegion", (Throwable)rex, (boolean)true);
                    throw rex;
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"showRegion", (Throwable)t, (boolean)true);
                    throw new RuntimeException("Failed to start AppSharing: " + t);
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"showRegion", (String)"Start/Stop Lock", (Object)this);
        }
    }

    @Override
    public boolean isLiveRegionResizeAvailable() {
        return true;
    }

    @Override
    public void changeRegion(Rectangle region) {
        this.changeRegionNative(region.x, region.y, region.width, region.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showApplications(final Object[] appList, final boolean raise) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Cannot start AppShare hosting from Swing thread.");
        }
        this.areaOfInterest.setBounds(0, 0, 0, 0);
        Debug.lockEnter((Object)this, (String)"showApplications", (String)"Start/Stop Lock", (Object)this);
        try {
            MacXHost macXHost = this;
            synchronized (macXHost) {
                int which;
                if (this.isShowing()) {
                    LogSupport.message((Object)this, (String)"showApplications", (String)"AppSharing already running.");
                    throw new RuntimeException("AppSharing already running.");
                }
                this.tileScanner = null;
                if (appList == null || appList.length == 0) {
                    LogSupport.message((Object)this, (String)"showApplications", (String)"Empty AppSharing application list.");
                    throw new RuntimeException("Empty AppSharing application list.");
                }
                final long[] procs = this.getProcessIDs(appList);
                if (procs == null || procs.length == 0) {
                    LogSupport.message((Object)this, (String)"showApplications", (String)"Invalid AppSharing process ID list.");
                    throw new RuntimeException("Invalid AppSharing process ID list.");
                }
                if (this.appsIncludesClassic(appList) && !this.excludeMenuBar && (which = ModalDialog.showConfirmDialog((Component)this.appFrame, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.MACXHOST_CLASSICMENUMESSAGE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.MACXHOST_CLASSICMENUTITLE), (int)0)) == 1) {
                    this.excludeMenuBar = true;
                }
                try {
                    this.setIsLionNative(IS_MAC_LION || USE_QUARTZ.show());
                    this.initializeNative(this.bkgCol, this.cacheLen, this.colReduceMode, this.excludeMenuBar, this.useOpenGL);
                    WorkerThread tmp = new WorkerThread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                if (AppShareDebug.HOST.show()) {
                                    StringBuffer appNames = new StringBuffer(256);
                                    for (int ix = 0; ix < appList.length; ++ix) {
                                        if (appNames.length() > 0) {
                                            appNames.append(", ");
                                        }
                                        appNames.append(appList[ix]);
                                    }
                                    LogSupport.message((Object)this, (String)"run", (String)("entering startAppNative: " + appNames.toString() + (MacXHost.this.excludeMenuBar ? ", Excluding menu bar" : "") + (MacXHost.this.useOpenGL ? ", using OpenGL" : "") + (raise ? ", raising windows" : "")));
                                }
                                MacXHost.this.startAppNative(procs, raise);
                            }
                            catch (Throwable t) {
                                LogSupport.exception((Object)this, (String)"run", (Throwable)t, (boolean)true);
                                MacXHost.this.fireShutDown(4);
                            }
                            finally {
                                if (AppShareDebug.HOST.show()) {
                                    LogSupport.message((Object)this, (String)"run", (String)"exited startAppNative.");
                                }
                            }
                        }
                    }, "AppSharingTileScanner-Apps");
                    tmp.setDaemon(true);
                    tmp.start();
                    this.tileScanner = tmp;
                    this.runningApps = appList;
                }
                catch (RuntimeException rex) {
                    LogSupport.exception((Object)this, (String)"showApplications", (Throwable)rex, (boolean)true);
                    throw rex;
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"showApplications", (Throwable)t, (boolean)true);
                    throw new RuntimeException("Failed to start AppSharing: " + t);
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"showApplications", (String)"Start/Stop Lock", (Object)this);
        }
    }

    @Override
    public boolean isShowing() {
        Thread tmp = this.tileScanner;
        if (tmp == null) {
            return false;
        }
        return tmp.isAlive();
    }

    public boolean isSharing() {
        return this.sharing;
    }

    @Override
    public boolean isShowingRegion() {
        return this.isShowing() && this.runningApps == null;
    }

    @Override
    public boolean isShowingApplications() {
        return this.isShowing() && this.runningApps != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSharing(boolean on) {
        if (AppShareDebug.HOST.show()) {
            LogSupport.message((Object)this, (String)"setSharing", (String)("sharing=" + on));
        }
        Debug.lockEnter((Object)this, (String)"setSharing", (String)"Start/Stop Lock", (Object)this);
        try {
            MacXHost macXHost = this;
            synchronized (macXHost) {
                if (on) {
                    if (!this.isShowing()) {
                        throw new IllegalStateException("App show not enabled before sharing turned on.");
                    }
                    this.sharing = true;
                } else {
                    this.sharing = false;
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"setSharing", (String)"Start/Stop Lock", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (SwingUtilities.isEventDispatchThread()) {
            WorkerThread worker = new WorkerThread(){

                public void run() {
                    MacXHost.this.stop();
                }
            };
            worker.start();
            return;
        }
        this.hideAperture();
        this.areaOfInterest.setBounds(0, 0, 0, 0);
        Debug.lockEnter((Object)this, (String)"stop", (String)"Start/Stop Lock", (Object)this);
        try {
            MacXHost macXHost = this;
            synchronized (macXHost) {
                Thread tmp = this.tileScanner;
                this.tileScanner = null;
                this.runningApps = null;
                long waitStart = System.currentTimeMillis();
                long waitUntil = waitStart + 5000L;
                long dt = 5001L;
                do {
                    try {
                        this.setSharing(false);
                        this.stopNative();
                        if (tmp == Thread.currentThread()) {
                            LogSupport.message((Object)this, (String)"stop", (String)("WARNING: called from TileScanner thread!\n" + Debug.getStackTrace((Throwable)new RuntimeException())));
                            break;
                        }
                        if (tmp == null) continue;
                        tmp.join(1000L);
                    }
                    catch (Throwable ex) {
                        long elapsed;
                        if (AppShareDebug.HOST.show()) {
                            LogSupport.message((Object)this, (String)"stop", (String)("Thread.join failed: " + Debug.getStackTrace((Throwable)ex)));
                        }
                        if ((elapsed = System.currentTimeMillis() - waitStart) >= 200L) continue;
                        try {
                            Thread.sleep(250L - elapsed);
                        }
                        catch (Throwable ignored) {
                            // empty catch block
                        }
                    }
                } while ((dt = waitUntil - (waitStart = System.currentTimeMillis())) > 1L && tmp != null && tmp.isAlive());
                if (tmp != null && tmp.isAlive()) {
                    LogSupport.exception((Object)this, (String)"stop", (Throwable)new RuntimeException("TileScanner ignored STOP"), (boolean)true, (String)tmp.toString());
                }
                this.terminateNative();
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"stop", (String)"Start/Stop Lock", (Object)this);
        }
    }

    @Override
    public void pauseSending() {
        this.pauseNative();
    }

    @Override
    public void resumeSending() {
        this.resumeNative();
    }

    @Override
    public void flush() {
        this.flushNative();
    }

    @Override
    public void resend(Rectangle rgn) {
        this.resendNative(rgn.x, rgn.y, rgn.width, rgn.height);
    }

    @Override
    public void resend() {
        this.resendNative(-1073741824, -1073741824, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void buttonInput(ButtonInputEvent e) {
        if (!this.isSharing()) {
            return;
        }
        this.setMouseButtonNative(e.getButton(), e.getPressed());
    }

    @Override
    public void keyInput(KeyInputEvent e) {
        if (!this.isSharing()) {
            return;
        }
        int kcode = e.getKeyCode();
        char glyph = e.getUnicode();
        boolean down = e.getPressed();
        if (kcode == 0) {
            kcode = ASKeyUtils.remapGlyph(glyph);
        }
        if (kcode == 0) {
            LogSupport.message((Object)this, (String)"keyInput", (String)("Failed to inject keystroke '" + glyph + "' 0x" + Integer.toHexString(glyph) + " " + (down ? "Down" : "Up") + " due to an invalid virtual keycode."));
            return;
        }
        int nativeCode = MacGuiSupport.translateKeyCode((int)kcode);
        if (nativeCode < 0) {
            LogSupport.message((Object)this, (String)"keyInput", (String)("Failed to inject keystroke '" + glyph + "' 0x" + Integer.toHexString(glyph) + " " + (down ? "Down" : "Up") + ", could not map virtual keycode to native."));
            return;
        }
        this.keyStrokeNative(glyph, nativeCode, down);
    }

    @Override
    public void mouseMoved(MouseMoveEvent e) {
        if (!this.isSharing()) {
            return;
        }
        this.setGlobalMousePosNative(e.getX(), e.getY());
    }

    @Override
    public void scrollWheelMoved(ScrollWheelEvent ev) {
        if (!this.isSharing()) {
            return;
        }
        this.scrollWheelNative(-ev.getAmount());
    }

    public void runningAppsChanged(long[] runningPSN) {
        if (this.runningApps == null) {
            return;
        }
        ArrayList<MacXAppInfo> appList = new ArrayList<MacXAppInfo>();
        for (int ix = 0; ix < this.runningApps.length; ++ix) {
            if (this.runningApps[ix] == null || !(this.runningApps[ix] instanceof MacXAppInfo)) continue;
            MacXAppInfo curApp = (MacXAppInfo)this.runningApps[ix];
            boolean running = false;
            long psn = curApp.getProcessSerial();
            for (int px = 0; px < runningPSN.length; ++px) {
                if (psn != runningPSN[px]) continue;
                appList.add(curApp);
                running = true;
                break;
            }
            if (running) continue;
            if (AppShareDebug.HOST.show()) {
                LogSupport.message((Object)this, (String)"runningAppsChanged", (String)("Application terminated: " + this.runningApps[ix]));
            }
            this.runningApps[ix] = null;
        }
        if (AppShareDebug.HOST.show()) {
            LogSupport.message((Object)this, (String)"runningAppsChanged", (String)("Still running: " + appList));
        }
        this.fireRunningApplicationsChanged(appList.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeLibrary() throws Exception {
        Class<MacXHost> clazz = MacXHost.class;
        synchronized (MacXHost.class) {
            if (libInited) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            libInited = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            MacXHost.setReverseCursorByteOrderNative(TIGER_INTEL_CURSOR_BUG);
            boolean windowsMaySpanDisplays = true;
            if (IS_MAC_MAVERICKS) {
                windowsMaySpanDisplays = false;
                GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
                for (GraphicsDevice dev : genv.getScreenDevices()) {
                    Insets insets;
                    GraphicsConfiguration config;
                    if (dev == null || (config = dev.getDefaultConfiguration()) == null || (insets = GuiUtils.getScreenInsets((GraphicsConfiguration)config)) == null || insets.top >= 16) continue;
                    windowsMaySpanDisplays = true;
                    break;
                }
            }
            MacXHost.setWindowsMaySpanDisplaysNative(windowsMaySpanDisplays);
            MacOSXPlatform.CarbonLock cLock = MacOSXPlatform.getCarbonLock();
            Runnable initializer = new Runnable(){

                @Override
                public void run() {
                    MacXHost.initializeLibraryNative();
                }
            };
            cLock.runCarbon(initializer);
            return;
        }
    }

    private void getGlobalMousePos(Point pos) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Cannot call from Swing thread");
        }
        this.getGlobalMousePosNative(pos);
    }

    private boolean isPointShared(int x, int y) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Cannot call from Swing thread");
        }
        return this.isPointSharedNative(x, y);
    }

    private long[] getProcessIDs(Object[] list) {
        long[] result = new long[list.length];
        for (int ix = 0; ix < list.length; ++ix) {
            result[ix] = ((MacXAppInfo)list[ix]).getProcessSerial();
        }
        return result;
    }

    private boolean appsIncludesClassic(Object[] list) {
        for (int ix = 0; ix < list.length; ++ix) {
            if (!((MacXAppInfo)list[ix]).isClassic()) continue;
            return true;
        }
        return false;
    }

    private static native void setReverseCursorByteOrderNative(boolean var0);

    private static native void setWindowsMaySpanDisplaysNative(boolean var0);

    private static native int getVersionNative();

    private static native void initializeLibraryNative();

    private static native void finalizeLibraryNative();

    private native Rectangle[] getWindowListNative();

    private native ApplicationInformation[] getApplicationListNative(String var1, String var2);

    private native Rectangle getApplicationBoundsNative(long[] var1, boolean var2);

    private native void initializeNative(short var1, int var2, int var3, boolean var4, boolean var5);

    private native void terminateNative();

    private native void setColourReductionModeNative(int var1);

    private native void startRegionNative(int var1, int var2, int var3, int var4);

    private native void startAppNative(long[] var1, boolean var2);

    private native void stopNative();

    private native void changeRegionNative(int var1, int var2, int var3, int var4);

    private native void pauseNative();

    private native void resumeNative();

    private native void resendNative(int var1, int var2, int var3, int var4);

    private native void flushNative();

    private native void getGlobalMousePosNative(Point var1);

    private native void setGlobalMousePosNative(int var1, int var2);

    private native void setMouseButtonNative(int var1, boolean var2);

    private native void scrollWheelNative(int var1);

    private native void keyStrokeNative(char var1, int var2, boolean var3);

    private native boolean isPointSharedNative(int var1, int var2);

    private native boolean isFrontAppSharedNative();

    private native boolean frontIntersectsRegionNative();

    private native boolean setIgnoredWindowNative(Window var1);

    private native boolean raiseWindowLevelNative(Window var1, boolean var2);

    private native void setIsLionNative(boolean var1);

    static {
        try {
            System.loadLibrary(JNI_LIB_NAME);
            libLoaded = true;
            int libVersion = 0;
            try {
                libVersion = MacXHost.getVersionNative();
            }
            catch (Throwable t) {
                libVersion = 131072;
            }
            LogSupport.message((String)("Loaded native library appsharemac, version: " + (libVersion >> 16) + "." + (libVersion >> 8 & 0xFF) + "." + (libVersion & 0xFF)));
        }
        catch (Throwable t) {
            libLoaded = false;
            if (AppShareDebug.HOST.show()) {
                LogSupport.message(MacXHost.class, (String)"<clinit>", (String)("Failed to load native library: appsharemac\n" + Debug.getStackTrace((Throwable)t)));
            }
            LogSupport.message(MacXHost.class, (String)"<clinit>", (String)("java.library.path=" + System.getProperty("java.library.path")));
        }
    }

    private class FloatingWindowListener
    extends ComponentAdapter {
        private FloatingWindowListener() {
        }

        @Override
        public void componentShown(ComponentEvent ev) {
            Window w = null;
            try {
                w = (Window)ev.getComponent();
            }
            catch (Throwable ignored) {
                w = null;
            }
            if (w != null) {
                final Window toFloat = w;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (MacXHost.this.isShowing()) {
                            MacXHost.this.raiseWindowLevelNative(toFloat, true);
                        }
                    }
                };
                SwingRunnerSupport.invokeLater((Runnable)r);
            }
        }
    }
}

