/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module.macosx;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.module.ApplicationInformation;
import com.elluminate.gui.GuiUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Icon;

public final class MacXAppInfo
implements ApplicationInformation {
    private static final String CLASSIC_PATH = "/System/Library/CoreServices/Classic Startup.app";
    private static final String[] SUPPRESS_CLASSIC = new String[]{"/ClassicAuxInput", "/System Folder/Classic", "/System Folder/Classic Support", "/System Folder/Classic Support UI"};
    private static final String JAVA_HOME = "/System/Library/Frameworks/JavaVM.framework";
    private static final Icon JAVA_ICON = MacXAppInfo.getJavaIcon();
    private final long psn;
    private final Long key;
    private final String name;
    private String path;
    private final ArrayList windows = new ArrayList();
    private Icon icon;
    private final boolean classic;

    MacXAppInfo(long p, String nm, String pth, boolean isClassic) {
        this.psn = p;
        this.key = new Long(this.psn);
        this.name = nm;
        this.path = pth == null && isClassic ? CLASSIC_PATH : pth;
        this.classic = isClassic;
        if (this.path != null) {
            this.icon = this.path.startsWith("/usr/bin/java") || this.path.startsWith(JAVA_HOME) ? JAVA_ICON : MacXAppInfo.getFileIcon(this.path);
        }
    }

    void addWindow(String title) {
        if (title == null) {
            return;
        }
        if (title.length() == 0) {
            return;
        }
        if (!this.classic) {
            this.windows.add(title);
        } else {
            for (int ix = 0; ix < SUPPRESS_CLASSIC.length; ++ix) {
                if (!SUPPRESS_CLASSIC[ix].equals(title)) continue;
                return;
            }
            File f = new File(title);
            if (f.exists()) {
                this.windows.add(f);
            }
        }
    }

    @Override
    public String getAppName() {
        return this.name;
    }

    @Override
    public String getAppPath() {
        return this.path;
    }

    @Override
    public int getWindowCount() {
        return this.windows.size();
    }

    @Override
    public String getWindowTitle(int which) {
        if (this.classic) {
            return ((File)this.windows.get(which)).getName();
        }
        return (String)this.windows.get(which);
    }

    @Override
    public Icon getWindowIcon(int which) {
        if (!this.classic) {
            return null;
        }
        return GuiUtils.getFileIcon((File)((File)this.windows.get(which)));
    }

    @Override
    public String[] getWindowTitles() {
        String[] result = new String[this.windows.size()];
        if (!this.classic) {
            return this.windows.toArray(result);
        }
        for (int ix = 0; ix < result.length; ++ix) {
            result[ix] = this.getWindowTitle(ix);
        }
        return result;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Icon getAppIcon() {
        return this.icon;
    }

    public long getProcessSerial() {
        return this.psn;
    }

    public String getName() {
        return this.name;
    }

    public boolean isClassic() {
        return this.classic;
    }

    public String toString() {
        String title;
        StringBuffer result = new StringBuffer();
        result.append(this.name);
        if (this.windows.size() == 1 && (title = this.getWindowTitle(0)).trim().length() > 0) {
            result.append(" '" + title + "'");
        }
        if (AppShareDebug.HOST.show()) {
            result.append(" #" + Long.toHexString(this.psn) + " " + this.path);
        }
        return result.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof MacXAppInfo)) {
            return false;
        }
        MacXAppInfo otherApp = (MacXAppInfo)other;
        if (otherApp.psn != this.psn) {
            return false;
        }
        return otherApp.windows.equals(this.windows);
    }

    public int hashCode() {
        int lo = (int)this.psn;
        int hi = (int)(this.psn >> 32);
        return lo ^ hi;
    }

    private static Icon getFileIcon(String file) {
        if (file == null) {
            return null;
        }
        return GuiUtils.getFileIcon((File)new File(file));
    }

    private static Icon getJavaIcon() {
        String classpath = System.getProperty("java.class.path");
        if (classpath == null) {
            classpath = System.getProperty("sun.boot.class.path");
        }
        if (classpath == null) {
            classpath = "/System/Library/Frameworks/JavaVM.framework/Classes/classes.jar";
        }
        StringTokenizer parser = new StringTokenizer(classpath, ":");
        while (parser.hasMoreTokens()) {
            Icon result;
            String token = parser.nextToken();
            if (!token.endsWith(".jar") || (result = MacXAppInfo.getFileIcon(token)) == null) continue;
            return result;
        }
        return MacXAppInfo.getFileIcon("/System/Library/Frameworks/JavaVM.framework/Classes/dt.jar");
    }
}

