/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.module.Java6Translucency;
import com.elluminate.groupware.appshare.module.Java7Translucency;
import com.elluminate.groupware.appshare.module.MacTranslucency;
import com.elluminate.platform.Platform;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.Window;

public abstract class TranslucencyHelper {
    protected static final boolean IS_MAC = Platform.getPlatform() == 2;
    protected static final boolean IS_LINUX = Platform.getOS() == 300;
    protected static final boolean MAC_LEOPARD = Platform.checkOSVersion((int)202, (String)"10.5+");
    protected static final boolean JAVA_6U10 = Platform.checkJavaVersion((String)"1.6.0_10+");
    protected static final boolean JAVA_7 = Platform.checkJavaVersion((String)"1.7+");
    protected static final boolean LINUX_TRANS_BUG = IS_LINUX && Platform.is64BitAddressable();
    protected static final boolean TRANS_OVERRIDE = Boolean.getBoolean("com.elluminate.live.allowTranslucency");
    protected static final String MACOS_FIX_VERSION = System.getProperty("com.elluminate.macos.transVersion");
    protected static final boolean MACOS_TRANS_FIXED = MACOS_FIX_VERSION == null ? false : Platform.checkJavaVersion((String)MACOS_FIX_VERSION);

    public static TranslucencyHelper create() {
        TranslucencyHelper result = null;
        if (JAVA_7) {
            result = new Java7Translucency();
        } else if (JAVA_6U10) {
            result = new Java6Translucency();
        } else if (MAC_LEOPARD) {
            result = new MacTranslucency();
        }
        return result;
    }

    public abstract boolean isAvailable();

    public abstract boolean isWindowTranslucencySupported();

    public abstract GraphicsConfiguration getCompatibleGC(GraphicsDevice var1);

    public abstract void setWindowOpaque(Window var1, boolean var2);

    public abstract void setWindowShape(Window var1, Shape var2);

    protected GraphicsDevice getDefaultDevice() {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return gEnv.getDefaultScreenDevice();
    }
}

