/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import java.util.EventObject;

public final class TilesEncodingEvent
extends EventObject {
    private byte[] encoding;
    private boolean sendAck;

    public TilesEncodingEvent(Object source, byte[] encoding) {
        super(source);
        if (encoding == null) {
            throw new IllegalArgumentException("Illegal encoding: null");
        }
        this.encoding = encoding;
        this.sendAck = false;
    }

    public TilesEncodingEvent(Object source, byte[] encodingBuf, int encodingOff, int encodingLen) {
        super(source);
        if (encodingBuf == null) {
            throw new IllegalArgumentException("Illegal encodingBuf: null");
        }
        this.encoding = new byte[encodingLen];
        System.arraycopy(encodingBuf, encodingOff, this.encoding, 0, encodingLen);
        this.sendAck = false;
    }

    public TilesEncodingEvent(Object source, boolean sendAck) {
        super(source);
        this.encoding = null;
        this.sendAck = sendAck;
    }

    public byte[] getEncoding() {
        return this.encoding;
    }

    public boolean getAcknowledge() {
        return this.sendAck;
    }
}

