/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.util.Preferences;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.security.MessageDigest;
import java.util.HashMap;

class RemoteControl {
    static final String REMOTE_CONTROL_PROMPT = "prompt";
    static final String REMOTE_CONTROL_PASSWORD = "password";
    static final String REMOTE_CONTROL_ALWAYS = "always";
    static final String REMOTE_CONTROL_DEFAULT = "prompt";
    static final char[] REMOTE_CONTROL_PASSWORD_DEFAULT = null;
    private static final String REMOTE_CONTROL_PREF = ".remoteControl";
    private static final String REMOTE_CONTROL_PASSWORD_PREF = ".remoteControlPassword";
    private static HashMap challenges = new HashMap();
    private static MessageDigest digester = null;
    private static String optionOverride = null;
    private static String passwordOverride = null;

    private RemoteControl() {
    }

    static void setOption(String prefix, Preferences preferences, String option) {
        if (!(option == null || option.equals("prompt") || option.equals(REMOTE_CONTROL_PASSWORD) || option.equals(REMOTE_CONTROL_ALWAYS))) {
            return;
        }
        preferences.setSetting(prefix + REMOTE_CONTROL_PREF, option);
        optionOverride = null;
    }

    static String getOption(String prefix, Preferences preferences) {
        String opt = preferences.getSetting(prefix + REMOTE_CONTROL_PREF, "prompt");
        if (opt.equals(REMOTE_CONTROL_ALWAYS)) {
            return REMOTE_CONTROL_ALWAYS;
        }
        if (opt.equals(REMOTE_CONTROL_PASSWORD)) {
            return REMOTE_CONTROL_PASSWORD;
        }
        return "prompt";
    }

    static void setOptionOverride(String option) {
        if (option == null || !option.equals("prompt") && !option.equals(REMOTE_CONTROL_PASSWORD) && !option.equals(REMOTE_CONTROL_ALWAYS)) {
            return;
        }
        optionOverride = option;
    }

    static String getEffectiveOption(String prefix, Preferences preferences) {
        String opt = optionOverride;
        if (opt != null) {
            if (opt.equals(REMOTE_CONTROL_ALWAYS)) {
                return REMOTE_CONTROL_ALWAYS;
            }
            if (opt.equals(REMOTE_CONTROL_PASSWORD)) {
                return REMOTE_CONTROL_PASSWORD;
            }
            return "prompt";
        }
        return RemoteControl.getOption(prefix, preferences);
    }

    static void setPassword(String prefix, Preferences preferences, char[] password) {
        String pw = null;
        if (password != null && password.length > 0) {
            byte[] bytes = RemoteControl.convertCharsToBytes(password);
            pw = RemoteControl.encryptPassword(bytes);
            RemoteControl.zeroArray(bytes);
        }
        preferences.setSetting(prefix + REMOTE_CONTROL_PASSWORD_PREF, pw);
        passwordOverride = null;
    }

    static char[] getPassword(String prefix, Preferences preferences) {
        String pw = preferences.getSetting(prefix + REMOTE_CONTROL_PASSWORD_PREF);
        if (pw != null && pw.length() > 0) {
            byte[] bytes = RemoteControl.decryptPassword(pw);
            char[] chrs = RemoteControl.convertBytesToChars(bytes);
            RemoteControl.zeroArray(bytes);
            return chrs;
        }
        return REMOTE_CONTROL_PASSWORD_DEFAULT;
    }

    static void setPasswordOverride(char[] password) {
        String pw = null;
        if (password != null && password.length > 0) {
            byte[] bytes = RemoteControl.convertCharsToBytes(password);
            pw = RemoteControl.encryptPassword(bytes);
            RemoteControl.zeroArray(bytes);
        }
        passwordOverride = pw;
    }

    private static char[] getPasswordOverride() {
        String pw = passwordOverride;
        if (pw != null) {
            byte[] bytes = RemoteControl.decryptPassword(pw);
            char[] chrs = RemoteControl.convertBytesToChars(bytes);
            RemoteControl.zeroArray(bytes);
            return chrs;
        }
        return null;
    }

    static char[] getEffectivePassword(String prefix, Preferences preferences) {
        char[] chrs = RemoteControl.getPasswordOverride();
        if (chrs == null) {
            chrs = RemoteControl.getPassword(prefix, preferences);
        }
        return chrs;
    }

    static byte[] seedPasswordChallenge(short whom) {
        byte[] seed = RemoteControl.hashPassword(null);
        if (seed == null) {
            return null;
        }
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = (byte)(Math.random() * 256.0);
        }
        ChallengeRec rec = new ChallengeRec(seed);
        challenges.put(ShortList.get((short)whom), rec);
        return seed;
    }

    static boolean authenticate(String prefix, Preferences preferences, short whom, byte[] givenPassword) {
        if (givenPassword == null) {
            return false;
        }
        if (whom < 2) {
            return false;
        }
        byte[] pwhash = RemoteControl.getEffectivePasswordHash(prefix, preferences);
        try {
            Short key = ShortList.get((short)whom);
            ChallengeRec rec = (ChallengeRec)challenges.remove(key);
            if (rec == null) {
                return false;
            }
            if (rec.seedVector == null) {
                return false;
            }
            if (rec.isExpired()) {
                return false;
            }
            if (rec.seedVector.length != pwhash.length) {
                return false;
            }
            byte[] master = RemoteControl.encodePassword(pwhash, rec.seedVector);
            if (master.length != givenPassword.length) {
                return false;
            }
            for (int i = 0; i < master.length; ++i) {
                if (master[i] == givenPassword[i]) continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            LogSupport.exception(RemoteControl.class, (String)"authenticatePassword", (Throwable)t, (boolean)true);
            return false;
        }
    }

    static void zeroArray(byte[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = 0;
            }
        }
    }

    static void zeroArray(char[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = '\u0000';
            }
        }
    }

    static byte[] encodePassword(char[] password, byte[] seed) {
        byte[] bytes = RemoteControl.convertCharsToBytes(password);
        if (bytes == null) {
            return null;
        }
        byte[] data = RemoteControl.hashPassword(bytes);
        RemoteControl.zeroArray(bytes);
        return RemoteControl.encodePassword(data, seed);
    }

    private static byte[] encodePassword(byte[] data, byte[] seed) {
        byte[] tmp = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            tmp[i] = (byte)(data[i] ^ seed[i]);
        }
        return RemoteControl.hashPassword(tmp);
    }

    private static byte[] getEffectivePasswordHash(String prefix, Preferences preferences) {
        char[] chrs = RemoteControl.getEffectivePassword(prefix, preferences);
        byte[] bytes = RemoteControl.convertCharsToBytes(chrs);
        RemoteControl.zeroArray(chrs);
        byte[] hash = RemoteControl.hashPassword(bytes);
        RemoteControl.zeroArray(bytes);
        return hash;
    }

    private static String encryptPassword(byte[] data) {
        if (data == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            int datum = data[i] & 0xFF;
            if (datum < 16) {
                result.append("0");
            }
            result.append(Integer.toHexString(datum));
        }
        return result.toString();
    }

    private static byte[] decryptPassword(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() % 2 != 0) {
            return null;
        }
        boolean pos = false;
        byte[] data = new byte[s.length() / 2];
        for (int i = 0; i < s.length() - 1; i += 2) {
            byte b = 0;
            int val = Character.digit(s.charAt(i), 16);
            if (val < 0) {
                return null;
            }
            b = (byte)(val << 4);
            val = Character.digit(s.charAt(i + 1), 16);
            if (val < 0) {
                return null;
            }
            data[i / 2] = b = (byte)(b | (byte)(val & 0xF));
        }
        return data;
    }

    private static byte[] hashPassword(byte[] data) {
        if (digester == null) {
            return new byte[0];
        }
        digester.reset();
        if (data != null) {
            digester.update(data);
        }
        return digester.digest();
    }

    private static byte[] convertCharsToBytes(char[] chars) {
        if (chars == null) {
            return null;
        }
        byte[] bytes = new byte[chars.length * 2];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i * 2] = (byte)(chars[i] >> 8);
            bytes[i * 2 + 1] = (byte)(chars[i] & 0xFF);
        }
        return bytes;
    }

    private static char[] convertBytesToChars(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] chars = new char[bytes.length / 2];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(bytes[i * 2] << 8 | bytes[i * 2 + 1] & 0xFF);
        }
        return chars;
    }

    static {
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (Throwable t) {
            digester = null;
            LogSupport.exception(RemoteControl.class, (String)"<init>", (Throwable)t, (boolean)true);
        }
    }

    private static final class ChallengeRec {
        long expires = 0L;
        byte[] seedVector = null;

        ChallengeRec(byte[] seed) {
            this.seedVector = seed;
            this.expires = System.currentTimeMillis() + 300000L;
        }

        boolean isExpired() {
            return System.currentTimeMillis() > this.expires;
        }
    }
}

