/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.module.TranslucencyHelper;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class Java7Translucency
extends TranslucencyHelper {
    private boolean available = false;
    private boolean translucencySupport = false;
    private boolean shapeSupport = false;
    private Method isCapableMethod;
    private Method setShapeMethod;

    Java7Translucency() {
        try {
            this.setShapeMethod = Window.class.getMethod("setShape", Shape.class);
            this.isCapableMethod = GraphicsConfiguration.class.getMethod("isTranslucencyCapable", new Class[0]);
            if (TRANS_OVERRIDE || !LINUX_TRANS_BUG) {
                if (TRANS_OVERRIDE && LINUX_TRANS_BUG) {
                    LogSupport.message(Java7Translucency.class, (String)"<init>", (String)"Transparency override in effect.");
                }
                this.available = this.checkPerPixelTranslucency();
            }
        }
        catch (Throwable t) {
            LogSupport.message(Java7Translucency.class, (String)"<init>", (String)Debug.getStackTrace((Throwable)t));
            this.available = false;
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public boolean isWindowTranslucencySupported() {
        return this.translucencySupport;
    }

    @Override
    public GraphicsConfiguration getCompatibleGC(GraphicsDevice gDev) {
        if (!this.available) {
            throw new UnsupportedOperationException("No shaped/translucent window support.");
        }
        if (gDev == null) {
            gDev = this.getDefaultDevice();
        }
        GraphicsConfiguration gc = gDev.getDefaultConfiguration();
        Rectangle bounds = gc.getBounds();
        if (this.isCapable(gc)) {
            return gc;
        }
        GraphicsConfiguration[] gcList = gDev.getConfigurations();
        for (int ix = 0; ix < gcList.length; ++ix) {
            gc = gcList[ix];
            if (!bounds.equals(gc.getBounds()) || !this.isCapable(gc)) continue;
            return gc;
        }
        LogSupport.message(Java7Translucency.class, (String)"getCompatibleGC", (String)"No translucency capable configuration available.");
        throw new UnsupportedOperationException("No capable configuration found for device.");
    }

    @Override
    public void setWindowOpaque(Window win, boolean opaque) {
    }

    @Override
    public void setWindowShape(Window win, Shape shape) {
        if (!this.shapeSupport) {
            LogSupport.message(Java7Translucency.class, (String)"setWindowShape", (String)"shaped windows not available");
            return;
        }
        try {
            this.setShapeMethod.invoke((Object)win, shape);
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"setWindowShape", (String)Debug.getStackTrace((Throwable)t));
        }
    }

    private boolean checkPerPixelTranslucency() {
        if (IS_MAC && !MACOS_TRANS_FIXED && !TRANS_OVERRIDE) {
            return false;
        }
        try {
            GraphicsDevice gDev = this.getDefaultDevice();
            if (gDev == null) {
                LogSupport.message(Java7Translucency.class, (String)"checkPerPixelTranslucency", (String)"Unable to obtain default GraphicsDevice.");
                return false;
            }
            Class<?> trns = Class.forName("java.awt.GraphicsDevice$WindowTranslucency");
            Method mthd = GraphicsDevice.class.getMethod("isWindowTranslucencySupported", trns);
            Field translucent = trns.getField("TRANSLUCENT");
            Field perPixelTranslucent = trns.getField("PERPIXEL_TRANSLUCENT");
            Field perPixelTransparent = trns.getField("PERPIXEL_TRANSPARENT");
            Boolean result = (Boolean)mthd.invoke((Object)gDev, translucent.get(null));
            boolean bl = this.translucencySupport = TRANS_OVERRIDE || result != false;
            if (!this.translucencySupport) {
                LogSupport.message(Java7Translucency.class, (String)"checkPerPixelTranslucency", (String)"Window translucency not supported by JRE.");
            }
            result = (Boolean)mthd.invoke((Object)gDev, perPixelTransparent.get(null));
            this.shapeSupport = result;
            if (this.shapeSupport) {
                return true;
            }
            result = (Boolean)mthd.invoke((Object)gDev, perPixelTranslucent.get(null));
            if (result.booleanValue()) {
                LogSupport.message(Java7Translucency.class, (String)"checkPerPixelTranslucency", (String)"No shaped window support, faking it with translucency.");
                return true;
            }
            LogSupport.message(Java7Translucency.class, (String)"checkPerPixelTranslucency", (String)"Per-pixel translucency not supported by JRE.");
        }
        catch (Throwable t) {
            LogSupport.message(Java7Translucency.class, (String)"checkPerPixelTranslucency", (String)Debug.getStackTrace((Throwable)t));
        }
        return false;
    }

    private boolean isCapable(GraphicsConfiguration gc) {
        try {
            Boolean result = (Boolean)this.isCapableMethod.invoke((Object)gc, new Object[0]);
            if (result.booleanValue()) {
                return true;
            }
        }
        catch (Throwable t) {
            LogSupport.message(Java7Translucency.class, (String)"isCapable", (String)Debug.getStackTrace((Throwable)t));
        }
        return false;
    }
}

