/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import java.util.EventObject;

public final class CanvasDefinitionEvent
extends EventObject {
    private short color;
    private short height;
    private int historyCnt;
    private short width;
    private short x;
    private short y;

    public CanvasDefinitionEvent(Object source, int width, int height, int color, int historyCnt) {
        this(source, 0, 0, width, height, color, historyCnt);
    }

    public CanvasDefinitionEvent(Object source, int x, int y, int width, int height, int color, int historyCnt) {
        super(source);
        if (x < 0 || x >= 4096) {
            throw new IllegalArgumentException("Illegal x: " + width);
        }
        if (y < 0 || y >= 4096) {
            throw new IllegalArgumentException("Illegal y: " + width);
        }
        if (width < 0 || width > 4096) {
            throw new IllegalArgumentException("Illegal width: " + width);
        }
        if (height < 0 || height > 4096) {
            throw new IllegalArgumentException("Illegal height: " + height);
        }
        if (x + width > 4096) {
            throw new IllegalArgumentException("Illegal x+width: " + x + " + " + width + " = " + (x + width));
        }
        if (y + height > 4096) {
            throw new IllegalArgumentException("Illegal y+height: " + y + " + " + height + " = " + (y + height));
        }
        if (color < 0 || color > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal color: " + color);
        }
        if (historyCnt < 0 || historyCnt > 65535) {
            throw new IllegalArgumentException("Illegal historyCnt: " + historyCnt);
        }
        this.x = (short)x;
        this.y = (short)y;
        this.width = (short)width;
        this.height = (short)height;
        this.color = (short)color;
        this.historyCnt = historyCnt;
    }

    public short getColor() {
        return this.color;
    }

    public short getX() {
        return this.x;
    }

    public short getY() {
        return this.y;
    }

    public short getHeight() {
        return this.height;
    }

    public int getHistoryCount() {
        return this.historyCnt;
    }

    public short getWidth() {
        return this.width;
    }
}

