/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.AppShareTileDefn;
import com.elluminate.groupware.appshare.module.AOIChangeEvent;
import com.elluminate.groupware.appshare.module.AOIChangeListener;
import com.elluminate.groupware.appshare.module.ApertureFrame;
import com.elluminate.groupware.appshare.module.AppShareBean;
import com.elluminate.groupware.appshare.module.ApplicationInformation;
import com.elluminate.groupware.appshare.module.ButtonInputEvent;
import com.elluminate.groupware.appshare.module.ButtonInputListener;
import com.elluminate.groupware.appshare.module.CanvasDefinitionEvent;
import com.elluminate.groupware.appshare.module.CanvasDefinitionListener;
import com.elluminate.groupware.appshare.module.CursorChangeEvent;
import com.elluminate.groupware.appshare.module.CursorChangeListener;
import com.elluminate.groupware.appshare.module.CursorDefinitionEvent;
import com.elluminate.groupware.appshare.module.CursorDefinitionListener;
import com.elluminate.groupware.appshare.module.CursorMoveEvent;
import com.elluminate.groupware.appshare.module.CursorMoveListener;
import com.elluminate.groupware.appshare.module.HighlighterAPI;
import com.elluminate.groupware.appshare.module.KeyInputEvent;
import com.elluminate.groupware.appshare.module.KeyInputListener;
import com.elluminate.groupware.appshare.module.MonitorEvent;
import com.elluminate.groupware.appshare.module.MonitorListener;
import com.elluminate.groupware.appshare.module.MouseMoveEvent;
import com.elluminate.groupware.appshare.module.MouseMoveListener;
import com.elluminate.groupware.appshare.module.RunningApplicationEvent;
import com.elluminate.groupware.appshare.module.RunningApplictaionListener;
import com.elluminate.groupware.appshare.module.ScrollWheelEvent;
import com.elluminate.groupware.appshare.module.ScrollWheelListener;
import com.elluminate.groupware.appshare.module.ShutDownEvent;
import com.elluminate.groupware.appshare.module.ShutDownListener;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.groupware.appshare.module.TilesEncodingEvent;
import com.elluminate.groupware.appshare.module.TilesEncodingListener;
import com.elluminate.gui.ModalDialog;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.EventListener;

public abstract class AppSharingHost
implements ButtonInputListener,
KeyInputListener,
MouseMoveListener,
ScrollWheelListener {
    private static final short CLEAR15 = Short.MIN_VALUE;
    private static final boolean HAS_BACKING_STORE_BUG = Platform.getPlatform() == 1 && Platform.checkJREVersion((String)"1.6.0_10+") && !Platform.checkJREVersion((String)"1.6.0_12+");
    public static final int NONE = 0;
    public static final int DESKTOP = 1;
    public static final int REGION = 2;
    public static final int APPLICATION = 3;
    public static final int REDUCE_NONE = 0;
    public static final int REDUCE_MIN = 1;
    public static final int REDUCE_STD = 2;
    public static final int REDUCE_HIGH = 3;
    public static final int REDUCE_MAX = 4;
    public static final int STOP_NO_REASON = 0;
    public static final int STOP_BY_SERVER = 1;
    public static final int STOP_APP_EXIT = 2;
    public static final int STOP_SCREEN_SIZE = 3;
    public static final int STOP_HOST_ERROR = 4;
    public AppShareBean appBean = null;
    private CanvasDefinitionListener canvasLst = null;
    private CursorDefinitionListener cursorDefLst = null;
    private CursorMoveListener cursorMoveLst = null;
    private CursorChangeListener cursorChgLst = null;
    private TilesEncodingListener tileLst = null;
    private AOIChangeListener areaLst = null;
    private ShutDownListener shutDownLst = null;
    private MonitorListener monitorLst = null;
    private RunningApplictaionListener runningAppLst = null;
    private volatile boolean shutdownPending = false;
    private int prevRow = -1;
    private int prevCol = -1;
    protected Frame appFrame = null;
    protected I18n i18n = I18n.create((Object)this);
    protected Imps imps;
    private int capabilityLimit = 3;
    protected final Rectangle displayBounds = new Rectangle();
    protected final Rectangle areaOfInterest = new Rectangle();
    private boolean apertureShown = false;
    private Color apertureColor = AppShareBean.DFT_AOI_COLOR;
    private HighlighterAPI highlighter = null;
    protected boolean useOpenGL;

    protected AppSharingHost() {
    }

    public void setBean(AppShareBean bean) {
        this.appBean = bean;
    }

    public final int getCapabilities() {
        return Math.min(this.capabilityLimit, this.getBaseCapabilities());
    }

    protected int getBaseCapabilities() {
        return 0;
    }

    void setCapabilityLimit(int limit) {
        this.capabilityLimit = limit;
    }

    public boolean isExcludeMenuBarSupported() {
        return false;
    }

    public boolean isOpenGLSupported() {
        return false;
    }

    public void setAppFrame(Frame frame) {
        this.appFrame = frame;
    }

    public void setImps(Imps imps) {
        this.imps = imps;
    }

    public Imps getImps() {
        return this.imps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCanvasDefinitionListener(CanvasDefinitionListener listener) {
        Debug.lockEnter((Object)this, (String)"addCanvasDefinitionListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.canvasLst != null) {
                throw new RuntimeException("Too many canvas definition listeners.");
            }
            this.canvasLst = listener;
        }
        Debug.lockLeave((Object)this, (String)"addCanvasDefinitionListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCursorChangeListener(CursorChangeListener listener) {
        Debug.lockEnter((Object)this, (String)"addCursorChangeListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.cursorChgLst != null) {
                throw new RuntimeException("Too many cursor change listeners.");
            }
            this.cursorChgLst = listener;
        }
        Debug.lockLeave((Object)this, (String)"addCursorChangeListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCursorDefinitionListener(CursorDefinitionListener listener) {
        Debug.lockEnter((Object)this, (String)"addCursorDefinitionListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.cursorDefLst != null) {
                throw new RuntimeException("Too many cursor definition listeners.");
            }
            this.cursorDefLst = listener;
        }
        Debug.lockLeave((Object)this, (String)"addCursorDefinitionListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCursorMoveListener(CursorMoveListener listener) {
        Debug.lockEnter((Object)this, (String)"addCursorMoveListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.cursorMoveLst != null) {
                throw new RuntimeException("Too many cursor movement listeners.");
            }
            this.cursorMoveLst = listener;
        }
        Debug.lockLeave((Object)this, (String)"addCursorMoveListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTilesEncodingListener(TilesEncodingListener listener) {
        Debug.lockEnter((Object)this, (String)"addTilesEncodingListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.tileLst != null) {
                throw new RuntimeException("Too many tiles encoding listeners.");
            }
            this.tileLst = listener;
        }
        Debug.lockLeave((Object)this, (String)"addTilesEncodingListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAOIChangeListener(AOIChangeListener listener) {
        Debug.lockEnter((Object)this, (String)"addAOIChangeListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.areaLst != null) {
                throw new RuntimeException("Too many AOI change listeners.");
            }
            this.areaLst = listener;
        }
        Debug.lockLeave((Object)this, (String)"addAOIChangeListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutDownListener(ShutDownListener listener) {
        Debug.lockEnter((Object)this, (String)"addShutDownListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.shutDownLst != null) {
                throw new RuntimeException("Too many shut down listeners.");
            }
            this.shutDownLst = listener;
        }
        Debug.lockLeave((Object)this, (String)"addShutDownListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitorListener(MonitorListener listener) {
        Debug.lockEnter((Object)this, (String)"addMonitorListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.monitorLst != null) {
                throw new RuntimeException("Too many monitor listeners.");
            }
            this.monitorLst = listener;
        }
        Debug.lockLeave((Object)this, (String)"addMonitorListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRunningApplictaionListener(RunningApplictaionListener l) {
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.runningAppLst != null) {
                throw new RuntimeException("Too many running application listeners.");
            }
            this.runningAppLst = l;
        }
    }

    protected void fireCanvasDefinition(int width, int height, int color, int historyCnt) {
        this.fireCanvasDefinition(0, 0, width, height, color, historyCnt);
    }

    protected void fireCanvasDefinition(int x, int y, int width, int height, int color, int historyCnt) {
        CanvasDefinitionListener l;
        this.displayBounds.setLocation(0, 0);
        this.displayBounds.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        if (this.apertureShown && ApertureFrame.isAvailable()) {
            this.showAperture();
        }
        if ((l = this.canvasLst) == null) {
            return;
        }
        try {
            l.canvasDefined(new CanvasDefinitionEvent(this, x, y, width, height, color, historyCnt));
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireCanvasDefinition", (Throwable)ex, (boolean)true);
        }
    }

    protected void fireCursorChange(int index) {
        CursorChangeListener l = this.cursorChgLst;
        if (l == null) {
            return;
        }
        try {
            l.cursorChanged(new CursorChangeEvent(this, index));
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireCursorChange", (Throwable)ex, (boolean)true);
        }
    }

    protected void fireCursorDefinition(int index, int width, int height, int hotspotX, int hotspotY, short[] pixels) {
        CursorDefinitionListener l = this.cursorDefLst;
        if (l == null) {
            return;
        }
        try {
            int lastCol;
            int lastRow;
            int row;
            int firstCol;
            int col;
            int firstRow;
            for (firstRow = 0; firstRow < height && firstRow < hotspotY; ++firstRow) {
                for (col = 0; col < width && pixels[firstRow * width + col] == Short.MIN_VALUE; ++col) {
                }
                if (col < width) break;
            }
            for (firstCol = 0; firstCol < width && firstCol < hotspotX; ++firstCol) {
                for (row = firstRow; row < height && pixels[row * width + firstCol] == Short.MIN_VALUE; ++row) {
                }
                if (row < height) break;
            }
            for (lastRow = height - 1; lastRow > firstRow; --lastRow) {
                for (col = firstCol; col < width && pixels[lastRow * width + col] == Short.MIN_VALUE; ++col) {
                }
                if (col < width) break;
            }
            for (lastCol = width - 1; lastCol > firstCol; --lastCol) {
                for (row = firstRow; row <= lastRow && pixels[row * width + lastCol] == Short.MIN_VALUE; ++row) {
                }
                if (row <= lastRow) break;
            }
            int newHeight = lastRow - firstRow + 1;
            int newWidth = lastCol - firstCol + 1;
            for (row = 0; row < newHeight; ++row) {
                for (col = 0; col < newWidth; ++col) {
                    short pixel = pixels[(row + firstRow) * width + col + firstCol];
                    if (pixel < 0 && pixel != Short.MIN_VALUE) {
                        pixel = (short)(pixel ^ 0xFFFF);
                    }
                    pixels[row * newWidth + col] = pixel;
                }
            }
            height = newHeight;
            width = newWidth;
            l.cursorDefined(new CursorDefinitionEvent((Object)this, index, width, height, hotspotX -= firstCol, hotspotY -= firstRow, pixels));
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireCursorDefinition", (Throwable)ex, (boolean)true);
        }
    }

    protected void fireCursorDefinition(int index, int width, int height, int hotspotX, int hotspotY, int[] pixels) {
        CursorDefinitionListener l = this.cursorDefLst;
        if (l == null) {
            return;
        }
        try {
            int lastCol;
            int lastRow;
            int row;
            int firstCol;
            int col;
            int firstRow;
            for (firstRow = 0; firstRow < height && firstRow < hotspotY; ++firstRow) {
                for (col = 0; col < width && (pixels[firstRow * width + col] & 0xFF000000) == 0; ++col) {
                }
                if (col < width) break;
            }
            for (firstCol = 0; firstCol < width && firstCol < hotspotX; ++firstCol) {
                for (row = firstRow; row < height && (pixels[row * width + firstCol] & 0xFF000000) == 0; ++row) {
                }
                if (row < height) break;
            }
            for (lastRow = height - 1; lastRow > firstRow; --lastRow) {
                for (col = firstCol; col < width && (pixels[lastRow * width + col] & 0xFF000000) == 0; ++col) {
                }
                if (col < width) break;
            }
            for (lastCol = width - 1; lastCol > firstCol; --lastCol) {
                for (row = firstRow; row <= lastRow && (pixels[row * width + lastCol] & 0xFF000000) == 0; ++row) {
                }
                if (row <= lastRow) break;
            }
            int newHeight = lastRow - firstRow + 1;
            int newWidth = lastCol - firstCol + 1;
            if (newWidth != width) {
                for (row = 0; row < newHeight; ++row) {
                    int idx1 = (row + firstRow) * width + firstCol;
                    int idx2 = row * newWidth;
                    if (idx1 == idx2) continue;
                    System.arraycopy(pixels, idx1, pixels, idx2, newWidth);
                }
            } else if (newHeight != height && firstRow > 0) {
                System.arraycopy(pixels, firstRow * width + firstCol, pixels, 0, newWidth * newHeight);
            }
            height = newHeight;
            width = newWidth;
            l.cursorDefined(new CursorDefinitionEvent((Object)this, index, width, height, hotspotX -= firstCol, hotspotY -= firstRow, pixels));
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireCursorDefinition", (Throwable)ex, (boolean)true);
        }
    }

    protected void fireCursorMove(int x, int y) {
        CursorMoveListener l = this.cursorMoveLst;
        if (l == null) {
            return;
        }
        try {
            l.cursorMoved(new CursorMoveEvent(this, x, y));
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireCursorMove", (Throwable)ex, (boolean)true);
        }
    }

    protected void fireTilesEncoding(byte[] encoding) {
        this.fireTilesEncoding(encoding, 0, encoding.length, 0, 0, 0, 0, null);
    }

    protected void fireTilesEncoding(byte[] encoding, int x, int y, int w, int h, short[] pixels) {
        this.fireTilesEncoding(encoding, 0, encoding.length, x, y, w, h, pixels);
    }

    protected void fireTilesEncoding(byte[] encoding, int off, int len, int x, int y, int w, int h, short[] pixels) {
        EventListener l;
        try {
            l = this.tileLst;
            if (l != null) {
                if (AppShareDebug.TILE_INFO.show()) {
                    LogSupport.message((Object)this, (String)"fileTilesEncoding", (String)this.getPartialTileInfo(encoding, off, len));
                }
                l.tilesEncoded(new TilesEncodingEvent(this, encoding, off, len));
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireTilesEncoding", (Throwable)ex, (boolean)true);
        }
        try {
            l = this.monitorLst;
            if (l != null) {
                l.imageChanged(new MonitorEvent(this, new Rectangle(x, y, w, h), pixels));
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireImageChanged", (Throwable)ex, (boolean)true);
        }
    }

    protected void fireFlushTiles(boolean sendAck) {
        TilesEncodingListener l = this.tileLst;
        if (l == null) {
            return;
        }
        try {
            l.flushBufferedTiles(new TilesEncodingEvent((Object)this, sendAck));
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireTilesEncoding", (Throwable)ex, (boolean)true);
        }
    }

    protected void fireAOIChanged(Rectangle area) {
        EventListener l;
        try {
            l = this.areaLst;
            if (l != null) {
                l.AOIChanged(new AOIChangeEvent(this, 0, area));
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireAOIChanged", (Throwable)ex, (boolean)true);
        }
        try {
            l = this.monitorLst;
            if (l != null) {
                l.sharedBoundsChanged(new MonitorEvent(this, area, null));
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireAOIChanged", (Throwable)ex, (boolean)true);
        }
        this.areaOfInterest.setBounds(area);
        this.updateAperture(area);
    }

    protected void fireAOIChanged(int x, int y, int w, int h) {
        this.fireAOIChanged(new Rectangle(x, y, w, h));
    }

    protected void fireShutDown(final int reason) {
        this.prevRow = -1;
        this.prevCol = -1;
        if (AppShareDebug.HOST.show()) {
            Thread.dumpStack();
        }
        if (this.shutDownLst == null) {
            return;
        }
        if (this.shutdownPending) {
            return;
        }
        WorkerThread shutdownThread = new WorkerThread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ShutDownListener l = AppSharingHost.this.shutDownLst;
                    if (l != null) {
                        l.shutDown(new ShutDownEvent((Object)this, reason));
                    }
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)((Object)this), (String)"fireShutDown", (Throwable)ex, (boolean)true);
                }
                finally {
                    AppSharingHost.this.shutdownPending = false;
                }
            }
        };
        this.shutdownPending = true;
        shutdownThread.start();
    }

    protected void fireImageChanged(int x, int y, int w, int h, short[] pixels) {
        MonitorListener l = this.monitorLst;
        if (l == null) {
            return;
        }
        try {
            l.imageChanged(new MonitorEvent(this, new Rectangle(x, y, w, h), pixels));
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireImageChanged", (Throwable)ex, (boolean)true);
        }
    }

    protected void fireRunningApplicationsChanged(Object[] appInfo) {
        RunningApplictaionListener l = this.runningAppLst;
        if (l == null) {
            return;
        }
        try {
            l.runningApplicationsChanged(new RunningApplicationEvent(this, appInfo));
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"fireRunningApplictaionListener", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public abstract void keyInput(KeyInputEvent var1);

    @Override
    public abstract void buttonInput(ButtonInputEvent var1);

    @Override
    public abstract void mouseMoved(MouseMoveEvent var1);

    @Override
    public void scrollWheelMoved(ScrollWheelEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCanvasDefinitionListener(CanvasDefinitionListener listener) {
        Debug.lockEnter((Object)this, (String)"removeCanvasDefinitionListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.canvasLst != listener) {
                return;
            }
            this.canvasLst = null;
        }
        Debug.lockLeave((Object)this, (String)"removeCanvasDefinitionListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCursorChangeListener(CursorChangeListener listener) {
        Debug.lockEnter((Object)this, (String)"removeCursorChangeListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.cursorChgLst != listener) {
                return;
            }
            this.cursorChgLst = null;
        }
        Debug.lockLeave((Object)this, (String)"removeCursorChangeListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCursorDefinitionListener(CursorDefinitionListener listener) {
        Debug.lockEnter((Object)this, (String)"removeCursorDefinitionListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.cursorDefLst != listener) {
                return;
            }
            this.cursorDefLst = null;
        }
        Debug.lockLeave((Object)this, (String)"removeCursorDefinitionListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCursorMoveListener(CursorMoveListener listener) {
        Debug.lockEnter((Object)this, (String)"removeCursorMoveListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.cursorMoveLst != listener) {
                return;
            }
            this.cursorMoveLst = null;
        }
        Debug.lockLeave((Object)this, (String)"removeCursorMoveListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTilesEncodingListener(TilesEncodingListener listener) {
        Debug.lockEnter((Object)this, (String)"removeTilesEncodingListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.tileLst != listener) {
                return;
            }
            this.tileLst = null;
        }
        Debug.lockLeave((Object)this, (String)"removeTilesEncodingListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAOIChangeListener(AOIChangeListener listener) {
        Debug.lockEnter((Object)this, (String)"removeAOIChangeListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.areaLst != listener) {
                return;
            }
            this.areaLst = null;
        }
        Debug.lockLeave((Object)this, (String)"removeAOIChangeListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutDownListener(ShutDownListener listener) {
        Debug.lockEnter((Object)this, (String)"removeShutDownListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.shutDownLst != listener) {
                return;
            }
            this.shutDownLst = null;
        }
        Debug.lockLeave((Object)this, (String)"removeShutDownListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitorListener(MonitorListener listener) {
        Debug.lockEnter((Object)this, (String)"removeMonitorListener", null, (Object)this);
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.monitorLst != listener) {
                return;
            }
            this.monitorLst = null;
        }
        Debug.lockLeave((Object)this, (String)"removeMonitorListener", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRunningApplictaionListener(RunningApplictaionListener l) {
        AppSharingHost appSharingHost = this;
        synchronized (appSharingHost) {
            if (this.runningAppLst != l) {
                return;
            }
            this.runningAppLst = null;
        }
    }

    public abstract void pauseSending();

    public abstract void resumeSending();

    public abstract void setBackgroundColor(Color var1);

    public abstract void setHistoryCount(int var1);

    public abstract void setColorReduction(int var1);

    public void setSharing(boolean on) {
    }

    public boolean extraPrivilegesAvailable() {
        return false;
    }

    public boolean requestExtraPrivileges() {
        return false;
    }

    public void releaseExtraPrivileges() {
    }

    public void setExcludeMenuBar(boolean exclude) {
    }

    public boolean getExcludeMenuBar() {
        return false;
    }

    public void showRegion(Rectangle rgn) {
        throw new RuntimeException("Region showing unsupported.");
    }

    public boolean isLiveRegionResizeAvailable() {
        return false;
    }

    public void changeRegion(Rectangle region) {
        throw new UnsupportedOperationException("Live region sharing resize not supported by this platform.");
    }

    public void showApplications(Object[] appList, boolean raise) {
        throw new RuntimeException("Application showing unsupported.");
    }

    public abstract boolean isShowing();

    public abstract boolean isShowingRegion();

    public abstract boolean isShowingApplications();

    public abstract void stop();

    public void stop(int reasonCode) {
        String reason;
        this.stop();
        switch (reasonCode) {
            case 0: {
                return;
            }
            case 1: {
                reason = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHARINGHOST_SERVERSTOPREASON);
                break;
            }
            case 2: {
                reason = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHARINGHOST_APPEXITREASON);
                break;
            }
            case 3: {
                reason = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHARINGHOST_SCREENSIZEREASON);
                break;
            }
            case 4: {
                reason = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHARINGHOST_HOSTERRORREASON);
                break;
            }
            default: {
                reason = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHARINGHOST_INVALIDREASON, new Object[]{"" + reasonCode});
            }
        }
        LightweightTimer t = new LightweightTimer(new Runnable(){

            @Override
            public void run() {
                ModalDialog.showMessageDialogAsync((int)120, (Component)AppSharingHost.this.appFrame, (Object)reason, (String)AppSharingHost.this.i18n.getString((PropertiesEnum)StringsProperties.APPSHARINGHOST_STOPMESSAGETITLE), (int)0);
            }
        });
        t.scheduleIn(333L);
    }

    public abstract void flush();

    public abstract void resend(Rectangle var1);

    public abstract void resend();

    public Rectangle[] getWindowRects() {
        return new Rectangle[0];
    }

    public ApplicationInformation[] getApplicationList(ApplicationInformation[] prevList, String me) {
        return new ApplicationInformation[0];
    }

    public Rectangle getAppDisplayBounds(Object[] appList) {
        return new Rectangle();
    }

    private String getPartialTileInfo(byte[] enc, int off, int len) {
        StringBuffer buf = new StringBuffer();
        byte hdr = enc[off++];
        byte type = (byte)(hdr & 0xF);
        int r = -1;
        int c = -1;
        switch (hdr & 0x60) {
            case 96: {
                if (this.prevRow < 0) break;
                r = this.prevRow + 1;
                c = this.prevCol;
                break;
            }
            case 32: {
                if (this.prevCol < 0) break;
                r = this.prevRow;
                c = this.prevCol + 1;
                break;
            }
            case 64: {
                if (this.prevCol < 0) break;
                r = this.prevRow;
                c = this.prevCol - 1;
                break;
            }
            default: {
                c = enc[off++] & 0xFF;
                r = enc[off++] & 0xFF;
            }
        }
        if (r >= 0) {
            this.prevRow = r;
            this.prevCol = c;
            buf.append("(");
            buf.append(r);
            buf.append(",");
            buf.append(c);
            buf.append(")=");
        } else {
            buf.append("(?,?)=");
        }
        buf.append(AppShareTileDefn.typeName((byte)type));
        return buf.toString();
    }

    public boolean setIgnoredWindow(Window w) {
        return true;
    }

    public void setWindowFloating(Window w, boolean floating) {
        w.setAlwaysOnTop(floating);
    }

    public static boolean isApertureAvailable() {
        return ApertureFrame.isAvailable();
    }

    public boolean isApertureShown() {
        return this.apertureShown;
    }

    public void setApertureShown(boolean show) {
        this.apertureShown = show;
    }

    public void setApertureColor(Color c) {
        this.apertureColor = c;
    }

    public void setPauseState(boolean paused) {
        if (this.highlighter != null) {
            this.highlighter.setPaused(paused);
        }
    }

    protected void showAperture() {
        this.highlighter = this.createHighlighter();
        if (this.highlighter != null) {
            this.highlighter.start(this.areaOfInterest);
        }
    }

    void updateAperture(Rectangle aoi) {
        if (this.highlighter != null) {
            this.highlighter.setRegion(aoi);
        }
    }

    protected void hideAperture() {
        if (this.highlighter != null) {
            this.highlighter.stop();
        }
        this.highlighter = null;
    }

    void doSnapshot() {
        this.appBean.snapImage(2);
    }

    void doPause(boolean paused) {
        this.appBean.setPaused(paused);
    }

    protected HighlighterAPI createHighlighter() {
        return new DefaultHighlighter();
    }

    private class DefaultHighlighter
    implements HighlighterAPI {
        private ApertureFrame aperture = null;

        private DefaultHighlighter() {
        }

        @Override
        public boolean isStarted() {
            return this.aperture != null;
        }

        @Override
        public void start(final Rectangle region) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (AppShareDebug.AOI_DISPLAY.show()) {
                        LogSupport.message((Object)this, (String)"run", (String)("Display bounds=" + AppSharingHost.this.displayBounds + " aperture=" + region));
                    }
                    if (DefaultHighlighter.this.aperture == null) {
                        try {
                            DefaultHighlighter.this.aperture = new ApertureFrame(AppSharingHost.this, AppSharingHost.this.apertureColor, AppSharingHost.this.displayBounds);
                            Rectangle winShape = HAS_BACKING_STORE_BUG ? new Rectangle(0, 0, 1, 1) : new Rectangle(0, 0, 0, 0);
                            DefaultHighlighter.this.aperture.setWindowShape(winShape);
                        }
                        catch (UnsupportedOperationException unopx) {
                            LogSupport.message((Object)this, (String)"showAperture", (String)"Unable to highlight AOI.");
                            if (AppShareDebug.HOST.show()) {
                                LogSupport.message((Object)this, (String)"showAperture", (String)Debug.getStackTrace((Throwable)unopx));
                            }
                            return;
                        }
                        catch (Throwable t) {
                            LogSupport.message((Object)this, (String)"showAperture", (String)Debug.getStackTrace((Throwable)t));
                            DefaultHighlighter.this.aperture = null;
                            return;
                        }
                    }
                    DefaultHighlighter.this.aperture.setVisible(true);
                    DefaultHighlighter.this.aperture.setAperture(region);
                }
            };
            SwingRunnerSupport.invokeLater((Runnable)r);
        }

        @Override
        public void stop() {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (DefaultHighlighter.this.aperture == null) {
                        return;
                    }
                    DefaultHighlighter.this.aperture.setVisible(false);
                    DefaultHighlighter.this.aperture.dispose();
                    DefaultHighlighter.this.aperture = null;
                }
            };
            SwingRunnerSupport.invokeLater((Runnable)r);
        }

        @Override
        public Rectangle getRegion() {
            return this.aperture.getAperture();
        }

        @Override
        public void setRegion(final Rectangle region) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (DefaultHighlighter.this.aperture == null) {
                        return;
                    }
                    DefaultHighlighter.this.aperture.setAperture(region);
                    if (AppSharingHost.this.isShowingApplications()) {
                        DefaultHighlighter.this.aperture.setVisible(region != null && !region.isEmpty());
                    }
                }
            };
            SwingRunnerSupport.invokeOnEventThread((Runnable)r);
        }

        @Override
        public boolean isPaused() {
            return false;
        }

        @Override
        public void setPaused(final boolean paused) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (DefaultHighlighter.this.aperture != null) {
                        DefaultHighlighter.this.aperture.setPauseState(paused);
                    }
                }
            };
            SwingRunnerSupport.invokeOnEventThread((Runnable)r);
        }

        @Override
        public boolean isVisible() {
            return this.aperture.isVisible();
        }

        @Override
        public void setVisible(final boolean visible) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    DefaultHighlighter.this.aperture.setVisible(visible);
                }
            };
            SwingRunnerSupport.invokeOnEventThread((Runnable)r);
        }
    }
}

