/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.moduleloading.Module;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.module.AppShareBean;
import com.elluminate.groupware.appshare.module.AppSharePublisher;
import com.elluminate.groupware.appshare.module.FilteredKeysPrefsPanel;
import com.elluminate.groupware.appshare.module.HostingOptionsPrefsPanel;
import com.elluminate.groupware.appshare.module.PauseSharingCmd;
import com.elluminate.groupware.appshare.module.RemoteControlPrefsPanel;
import com.elluminate.groupware.appshare.module.ResumeSharingCmd;
import com.elluminate.groupware.appshare.module.ShareApplicationCmd;
import com.elluminate.groupware.appshare.module.ShareScreenCmd;
import com.elluminate.groupware.appshare.module.ShareScreenRegionCmd;
import com.elluminate.groupware.appshare.module.SimulatedKeyStroke;
import com.elluminate.groupware.appshare.module.SimulatedKeysPrefsPanel;
import com.elluminate.groupware.appshare.module.StopSharingCmd;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.groupware.appshare.module.ViewingPrefsPanel;
import com.elluminate.groupware.imps.ParticipantSelectionListener;
import com.elluminate.groupware.imps.ParticipantSelectorAPI;
import com.elluminate.groupware.imps.PlaybackTimeAPI;
import com.elluminate.groupware.imps.PlaybackTimeListener;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.groupware.imps.module.AuxiliaryControllerAPI;
import com.elluminate.groupware.imps.module.PresentationModeAPI;
import com.elluminate.groupware.imps.view.ViewAPI;
import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.module.PermissionFeatureFactory;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.KeyConfigPanel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ArraySet;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@Singleton
public final class AppShareModule
extends AbstractClientModule
implements PropertyChangeListener,
ParticipantSelectionListener,
ModulePublisherInfo,
PreferencesPanelOwner,
MetaDataListener,
ActionFeatureListener,
CRPermissionChangeListener,
PlaybackTimeListener {
    public static final String REVOKE_KEY = "revokeHotKey";
    public static final String STOP_KEY = "stopHostingHotKey";
    public static final String SNAP_KEY = "snap2WbdKey";
    static final String OLD_STOP_KEY = "stopHotKey";
    static final String OLD_SNAP_KEY = "snapImageKey";
    private static final String SCALE_TO_FIT_PREF = ".scaleToFit";
    private static final boolean SCALE_TO_FIT_DEFAULT = false;
    private static final long PRESENTATION_GRACE = 500L;
    private I18n i18n;
    private Frame top = null;
    private AppShareBean appBean = null;
    private Client client = null;
    private ClientList clients = null;
    private ParticipantSelectorAPI sel = null;
    private Imps imps = null;
    private volatile boolean recursive = false;
    private boolean presentablePending = false;
    private Runnable updateUITask;
    PresentationModeAPI presentationAPI = null;
    ChangeListener presentationListener = null;
    private AuxiliaryControllerAPI auxapi = null;
    private Provider<AppShareBean> beanProvider;
    private AppSharePublisher msgPublisher;
    private DialogParentProvider parentProvider;
    private ClientProvider clientProvider;
    private Preferences preferences = null;
    private boolean visible = false;
    private boolean installed = false;
    private ConferencingEngine confEngine;
    private Provider<StopSharingCmd> StopSharingCmd;
    private Provider<PauseSharingCmd> PauseSharingCmd;
    private Provider<ResumeSharingCmd> ResumeSharingCmd;
    private Provider<ShareApplicationCmd> ShareApplicationCmd;
    private Provider<ShareScreenCmd> ShareScreenCmd;
    private Provider<ShareScreenRegionCmd> ShareScreenRegionCmd;
    private FeatureBroker broker;
    private ActionFeature startHostingFeature;
    private ActionFeature stopHostingFeature;
    private ActionFeature shareDesktopMenuFeature;
    private ActionFeature giveCtlMenuFeature;
    private ActionFeature takeCtlMenuFeature;
    private ActionFeature releaseCtlFeature;
    private ActionFeature rmtStartMenuFeature;
    private ActionFeature rmtCtlMenuFeature;
    private ActionFeature requestCursorControlActionBar;
    private BooleanFeature scaleToFitFeature;
    private ActionFeature otherKeyFeature;
    private BooleanFeature previewToolFeature;
    private ActionFeature markupToolFeature;
    private ActionFeature markupToolWithDelayFeature;
    private BooleanFeature pauseFeature;
    private ActionFeature pauseActionBar;
    private ActionFeature releaseExtraPrivilegesFeature;
    private ActionFeature requestExtraPrivilegesFeature;
    private ActionFeature rmtStopPopupFeature;
    private ActionFeature takeCtlPopupFeature;
    private ActionFeature releaseCtlPopupFeature;
    private ActionFeature rmtStartPopupFeature;
    private ActionFeature rmtCtlPopupFeature;
    private ActionFeature giveCtlPopupFeature;
    private ActionFeature winMenuFeature;
    private ArrayList arrayKeys;
    private ComponentFeature appsharePanelFeature;
    private ComponentFeature filteredKeysPrefPanel;
    private ComponentFeature hostingOptionPrefsPanel;
    private ComponentFeature remoteControlPrefsPanel;
    private ComponentFeature simulatedKeysPrefsPanel;
    private ComponentFeature viewingPrefsPanel;
    private Provider<FilteredKeysPrefsPanel> filteredKeysPrefsPanelProvider;
    private Provider<HostingOptionsPrefsPanel> hostingOptionsPrefsPanelProvider;
    private Provider<RemoteControlPrefsPanel> remoteControlPrefsPanelProvider;
    private Provider<SimulatedKeysPrefsPanel> simulatedKeysPrefsPanelProvider;
    private Provider<ViewingPrefsPanel> viewingPrefsPanelProvider;
    private CRSession session;
    private PermissionFeatureFactory permissionFeatureFactory;
    private ContentCaptureProvider contentCaptureProvider;
    private volatile boolean presentPending = false;

    @Inject
    public AppShareModule(I18n i18n) {
        this.i18n = i18n;
    }

    private void initModule() {
        this.client = this.clientProvider.get();
        this.clients = this.client.getClientList();
        this.updateUITask = new Runnable(){

            @Override
            public void run() {
                AppShareModule.this.updateUISwing();
            }
        };
        this.sel = (ParticipantSelectorAPI)this.imps.findBest(ParticipantSelectorAPI.class);
        this.sel.addSelectionListener((ParticipantSelectionListener)this);
        this.presentationListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                if (AppShareDebug.PRESENT.show()) {
                    LogSupport.message((Object)this, (String)"stateChanged", (String)("origin=" + ev.getSource()));
                }
                AppShareModule.this.updateUI();
            }
        };
        this.configure(this.clientProvider.get(), this.parentProvider.getDialogParent());
        this.updateUI();
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    protected void initParentProvider(DialogParentProvider dpp) {
        this.parentProvider = dpp;
    }

    @Inject
    protected void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    protected void initAppShareBeanProvider(Provider<AppShareBean> bp) {
        this.beanProvider = bp;
    }

    @Inject
    protected void initAppSharePublisher(AppSharePublisher pub) {
        this.msgPublisher = pub;
    }

    @Inject
    protected void initVersionManager(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    protected void initPreferences(Preferences prefs) {
        this.preferences = prefs;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initStopSharingCmd(Provider<StopSharingCmd> cp) {
        this.StopSharingCmd = cp;
    }

    @Inject
    public void initPauseSharingCmd(Provider<PauseSharingCmd> cp) {
        this.PauseSharingCmd = cp;
    }

    @Inject
    public void initResumeSharingCmd(Provider<ResumeSharingCmd> cp) {
        this.ResumeSharingCmd = cp;
    }

    @Inject
    public void initShareApplicationCmd(Provider<ShareApplicationCmd> cp) {
        this.ShareApplicationCmd = cp;
    }

    @Inject
    public void initShareScreenCmd(Provider<ShareScreenCmd> cp) {
        this.ShareScreenCmd = cp;
    }

    @Inject
    public void initShareScreenRegionCmd(Provider<ShareScreenRegionCmd> cp) {
        this.ShareScreenRegionCmd = cp;
    }

    @Inject
    public void initHostingOptionsPrefsProvider(Provider<HostingOptionsPrefsPanel> hostOptionsProvider) {
        this.hostingOptionsPrefsPanelProvider = hostOptionsProvider;
    }

    @Inject
    public void initFilteredKeysPrefsProvider(Provider<FilteredKeysPrefsPanel> filteredKeysProvider) {
        this.filteredKeysPrefsPanelProvider = filteredKeysProvider;
    }

    @Inject
    public void initRemoteControlPrefsProvider(Provider<RemoteControlPrefsPanel> RemoteControlProvider) {
        this.remoteControlPrefsPanelProvider = RemoteControlProvider;
    }

    @Inject
    public void initSimulatedKeysPrefsPanelProvider(Provider<SimulatedKeysPrefsPanel> simulatedKeysProvider) {
        this.simulatedKeysPrefsPanelProvider = simulatedKeysProvider;
    }

    @Inject
    public void initViewingPrefsPanellProvider(Provider<ViewingPrefsPanel> viewingProvider) {
        this.viewingPrefsPanelProvider = viewingProvider;
    }

    @Inject
    protected void initPermissionFeatureFactory(PermissionFeatureFactory permissionFeatureFactory) {
        this.permissionFeatureFactory = permissionFeatureFactory;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    protected void initContentCaptureProvider(ContentCaptureProvider contentCaptureProvider) {
        this.contentCaptureProvider = contentCaptureProvider;
    }

    public String getPrefix() {
        return this.getClass().getName();
    }

    public String getTitle() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_TITLE);
    }

    public Icon getIcon() {
        return this.i18n.getIcon("AppShareModule.icon");
    }

    public String getNameOfModule() {
        return "ApplicationSharing";
    }

    public String getDisplayNameOfModule() {
        return this.getTitle();
    }

    public Icon getModuleIcon() {
        return this.getIcon();
    }

    public AppShareBean getAppBean() {
        return (AppShareBean)this.beanProvider.get();
    }

    public Class<?>[] getCommandClasses() {
        return new Class[]{StopSharingCmd.class, PauseSharingCmd.class, ResumeSharingCmd.class, ShareApplicationCmd.class, ShareScreenCmd.class, ShareScreenRegionCmd.class};
    }

    public boolean isContentVisible() {
        if (this.appBean == null) {
            return false;
        }
        return this.appBean.isViewing();
    }

    public boolean prepareToPresent() {
        if (this.appBean == null) {
            return false;
        }
        if (this.appBean.isViewing()) {
            return false;
        }
        if (!this.presentPending && this.appBean.isHosting()) {
            String title = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_QUERYSTOPTITLE);
            String msg = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_QUERYSTOP);
            int choice = ModalDialog.showConfirmDialog((Component)this.appBean, (Object)msg, (String)title, (int)0);
            if (choice == 1) {
                return false;
            }
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        AppShareModule.this.appBean.stopHosting(0);
                    }
                    finally {
                        AppShareModule.this.presentPending = false;
                    }
                }
            };
            this.presentPending = true;
            this.appBean.queueAction(r, true, true);
        }
        return true;
    }

    AuxiliaryControllerAPI getAuxAPI() {
        if (this.auxapi == null) {
            this.auxapi = (AuxiliaryControllerAPI)this.imps.findBest(AuxiliaryControllerAPI.class);
        }
        return this.auxapi;
    }

    PresentationModeAPI getPresentationAPI() {
        return this.presentationAPI;
    }

    public Frame getTopFrame() {
        return this.top;
    }

    String getRevokeKey() {
        if (this.takeCtlMenuFeature == null) {
            return null;
        }
        return this.takeCtlMenuFeature.getKeyStroke();
    }

    private void configure(Client theClient, Frame top) {
        this.top = top;
        this.presentationAPI = (PresentationModeAPI)this.imps.findBest(PresentationModeAPI.class);
        if (this.presentationAPI != null) {
            this.presentationAPI.addPresentationStateListener(this.presentationListener);
        }
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addClientPropertyChangeListener("AppShare.access", (PropertyChangeListener)this);
        this.clients.addClientPropertyChangeListener("AppShare.host", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("AppShare.enabled", (PropertyChangeListener)this);
        this.appBean = (AppShareBean)this.beanProvider.get();
        this.appBean.setClient(this.client);
        this.appBean.setModule(this);
        this.appBean.setColorCompression(2);
        this.appBean.addPropertyChangeListener("state", this);
        this.appBean.addPropertyChangeListener("size", this);
        this.appBean.addPropertyChangeListener("scale", this);
        this.appBean.addPropertyChangeListener("remoteStarter", this);
        this.clients.addClientListener(new ClientListener(){

            public void onRemoveClient(ClientEvent e) {
            }

            public void onAddClient(ClientEvent e) {
                AppShareModule.this.handleAddClient(e);
            }
        });
    }

    private void handleAddClient(ClientEvent e) {
        if (e.isMe()) {
            this.clients.getMyClient().addPropertyChangeListener("AppShare.access", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AppShareModule.this.sendEnableStateRouterMessage((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
                }
            });
        }
    }

    protected void sendEnableStateRouterMessage(Boolean oldValue, Boolean newValue) {
        if (oldValue != newValue && newValue != null) {
            if (newValue.booleanValue()) {
                this.msgPublisher.sendAppShareEnabledMessage();
            } else {
                this.msgPublisher.sendAppShareDisabledMessage();
            }
        }
    }

    public void setQuality(int q) {
        if (q < 0 || q > 4) {
            throw new IllegalArgumentException("Invalid image quality level: " + q);
        }
        this.appBean.setColorCompression(q);
    }

    private void unconfigure() {
        if (this.presentationAPI != null) {
            this.presentationAPI.removePresentationStateListener(this.presentationListener);
            this.presentationAPI.setPresentable((Object)this, false);
            this.presentationAPI = null;
        }
        if (this.appBean != null) {
            this.appBean.stop();
            this.appBean = null;
        }
    }

    public void setLinearity(PlaybackTimeListener.Linearity linearity) {
        if (this.appBean != null) {
            this.appBean.setNonLinear(linearity == PlaybackTimeListener.Linearity.SEEKING);
        }
    }

    public void resetSession() {
    }

    public Object getCurrentState() {
        int st;
        StringBuilder result = null;
        AppShareBean bean = this.appBean;
        if (bean != null && (st = bean.getState()) != 1) {
            result = new StringBuilder();
            result.append(AppShareBean.getStateName(st));
            Rectangle aoi = bean.getAOI();
            result.append(" AOI=" + aoi.x + "," + aoi.y + " " + aoi.width + "x" + aoi.height);
            if (bean.isHosting()) {
                String info = bean.getShareDescription();
                if (info != null && info.trim().length() > 0) {
                    result.append(" apps=");
                    result.append(info.trim());
                }
                result.append(" paused=" + bean.isPaused());
                result.append("\nxmit=" + bean.getXmitWindowInfo());
                result.append("\nrecv=" + bean.getXmitWindowInfo());
            } else {
                Dimension dim = bean.getSize();
                if (dim != null) {
                    result.append(" size=" + dim.width + "x" + dim.height);
                }
                result.append(" scaling=" + bean.isScaling());
            }
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("size")) {
            boolean empty;
            Dimension siz = (Dimension)e.getNewValue();
            boolean bl = empty = siz.width <= 0 || siz.height <= 0;
            if (empty && this.isVisible()) {
                this.setVisible(false);
            } else if (!empty) {
                boolean presentingOther = false;
                boolean presentingMe = false;
                if (this.presentationAPI != null && this.presentationAPI.isPresenting()) {
                    presentingOther = this.presentationAPI.getPresentedModule() != this;
                    boolean bl2 = presentingMe = !presentingOther;
                }
                if (AppShareDebug.SIZE.show()) {
                    LogSupport.message((Object)this, (String)"propertyChange", (String)("size=" + siz));
                }
                if (this.isInstalled() && !presentingMe && !this.isVisible()) {
                    this.setVisible(true);
                }
            }
            SwingRunnerSupport.invokeLater((Runnable)this.updateUITask);
        } else {
            this.updateUI();
        }
    }

    public void reportScalingState(boolean scaling) {
        if (this.scaleToFitFeature != null) {
            this.scaleToFitFeature.setValue((Object)scaling);
        }
    }

    public void updateUI() {
        SwingRunnerSupport.invokeOnEventThread((Runnable)this.updateUITask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUISwing() {
        try {
            this.recursive = true;
            this.reportScalingState(this.appBean == null ? false : this.appBean.isScaling());
            if (!this.clients.isPropertyShared("AppShare.enabled")) {
                this.setVisible(false);
                if (AppShareDebug.UI.show()) {
                    LogSupport.message((Object)this, (String)"updateUI", (String)"AppShare.enabled is FALSE");
                }
                return;
            }
            if (this.appBean == null) {
                return;
            }
            this.updateUIElements();
        }
        finally {
            this.recursive = false;
        }
    }

    private void updateUIElements() {
        boolean showAuxTool;
        boolean showPause;
        boolean notBridge;
        Chair chair = ChairProtocol.getChair((ClientList)this.clients);
        ClientInfo me = this.clients.getMyClient();
        if (me == null) {
            return;
        }
        this.appBean.setHostName();
        short myGrp = me.getGroupID();
        int nSel = this.sel == null ? 0 : this.sel.getSelectedParticipantCount();
        List selected = null;
        boolean amSelected = false;
        boolean hostSelected = false;
        boolean controllerSelected = false;
        boolean accessSelected = false;
        boolean rmtStarterSelected = false;
        short rmtStartAddr = this.appBean == null ? (short)-32767 : (short)this.appBean.getRemoteStarter();
        TelephonyAPI telephony = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        boolean bl = notBridge = telephony == null;
        if (nSel > 0) {
            CRParticipant part;
            selected = this.sel.getSelectedParticipants();
            Iterator i$ = selected.iterator();
            while (i$.hasNext() && (part = (CRParticipant)i$.next()) != null) {
                notBridge |= telephony != null && !telephony.isBridge(part.getID());
                if (part.isMe()) {
                    amSelected = true;
                }
                if (part.getRoom() == null || part.getRoom().getID() != myGrp) continue;
                PropertyAccessAPI props = part.getPropertyStore();
                if (part.getID() == rmtStartAddr && !amSelected) {
                    rmtStarterSelected = true;
                }
                if (props.getProperty("AppShare.host", false)) {
                    hostSelected = true;
                }
                if (props.getProperty("AppShare.control", false)) {
                    controllerSelected = true;
                }
                accessSelected = props.getProperty("AppShare.access", false);
            }
        }
        int state = this.appBean == null ? 0 : this.appBean.getState();
        boolean presentingOther = false;
        boolean presentingMe = false;
        boolean presentationEngaged = false;
        if (this.presentationAPI != null && this.presentationAPI.isPresenting()) {
            presentingMe = this.presentationAPI.getPresentedModule() == this;
            presentingOther = !presentingMe && this.presentationAPI.getPresentedModule() != null;
            presentationEngaged = this.presentationAPI.isPresentationEngaged();
        }
        boolean amChair = chair.isMe();
        boolean inMode = true;
        boolean canModeSwitch = false;
        ViewAPI viewAPI = (ViewAPI)this.imps.findBest(ViewAPI.class);
        if (viewAPI != null) {
            inMode = viewAPI.getMode() == ViewMode.APPSHARE;
            canModeSwitch = amChair;
        }
        boolean playback = this.appBean != null && this.appBean.isPrerecorded();
        boolean access = me.getProperty("AppShare.access", false);
        boolean enabled = this.clients.getProperty("AppShare.enabled", false);
        boolean able = this.appBean == null ? false : this.appBean.canHost();
        boolean canHost = access && enabled && able && !playback;
        boolean canHostRegion = canHost && this.appBean != null && this.appBean.canHostRegions();
        boolean canHostApps = canHost && this.appBean != null && this.appBean.canHostApps();
        boolean idle = state == 1;
        boolean hosting = this.appBean != null && this.appBean.isHosting() && !playback;
        boolean paused = this.appBean != null && this.appBean.isPaused() && !playback;
        boolean sharing = hosting & (this.appBean == null ? false : this.appBean.isShared());
        boolean viewing = this.appBean == null ? false : this.appBean.isViewing();
        boolean controller = state == 3 && !playback;
        boolean isRemoteStarter = this.appBean == null ? false : this.appBean.isRemoteStarter();
        boolean wasStartedRemote = this.appBean == null ? false : this.appBean.isHostingForRemoteStart();
        boolean canStart = canHost && idle;
        boolean canGive = hosting && nSel == 1 && !controllerSelected && !amSelected && !hostSelected;
        boolean canTake = sharing;
        boolean canRelease = controller && !playback;
        boolean canReleasePopup = canRelease && nSel == 1 && (amSelected || hostSelected);
        boolean canRemoteStart = notBridge && nSel == 1 && access && enabled && idle && accessSelected && !amSelected && !playback && !presentingOther;
        boolean canRemoteStop = viewing && (amChair || isRemoteStarter) && !playback;
        boolean canRemoteCtl = access && viewing && !controller && !playback;
        boolean canRemoteStopPopup = canRemoteStop && nSel == 1 && hostSelected && !amSelected;
        boolean canRemoteCtlPopup = canRemoteCtl && nSel == 1 && hostSelected && !amSelected;
        boolean canMarkup = this.appBean.getImageAcceptor() != null && this.appBean.getImageAcceptor().isAccessible(1);
        boolean showHost = canHost || canRemoteStop;
        boolean enableHost = canHost && !presentingOther || canRemoteStop;
        boolean bl2 = showPause = enabled && hosting;
        boolean showWindow = this.appBean == null ? false : this.appBean.isPresented() && (!presentingMe || !presentationEngaged);
        boolean bl3 = showAuxTool = this.auxapi != null && hosting;
        if (AppShareDebug.UI.show()) {
            LogSupport.message((Object)this, (String)"updateUIElements", (String)("Enabled=" + enabled + " Access=" + access + " Able=" + able + " Playback=" + playback + " PresentingOther=" + presentingOther + " PresentingMe=" + presentingMe + " Hosting=" + hosting + (wasStartedRemote ? "(remote=" + rmtStartAddr + ")" : "") + " Viewing=" + viewing + " State=" + AppShareBean.getStateName(state) + (idle ? ":idle" : "") + (viewing ? ":view" : "") + (hosting ? ":host" : "") + (sharing ? ":share" : "") + (controller ? ":ctrl" : "") + (paused ? ":paused" : "") + " Chair=" + amChair + " ShowHost=" + showHost + " ShowPause=" + showPause + " CanGive=" + canGive + " CanTake=" + canTake + " CanRelease=" + canRelease + " CanHost=" + canHost + " CanRemoteStart=" + canRemoteStart + " CanRemoteStop=" + canRemoteStop + (canRemoteStopPopup ? "(+PartMenu)" : "") + " CanRemoteCtl=" + canRemoteCtl + " ShowWindow=" + showWindow + " ShowAuxTool=" + showAuxTool + " nSelected=" + nSel + " amSelected=" + amSelected + " HostSelected=" + hostSelected + " CtrlSelected=" + controllerSelected + " AccessSelected=" + accessSelected + " RmtStarterSelected=" + rmtStarterSelected + " isVisible=" + this.isVisible()));
        }
        boolean presentable = false;
        if (this.presentationAPI != null && this.presentationAPI.isAvailable()) {
            boolean bl4 = presentable = hosting || viewing;
            if (this.presentationAPI.isPresentable((Object)this) != presentable) {
                if (AppShareDebug.UI.show()) {
                    LogSupport.message((Object)this, (String)"updateUIElements", (String)("presentable=" + presentable + " mod.isPresentable=" + this.presentationAPI.isPresentable((Object)this) + " hosting=" + hosting + " viewing=" + viewing));
                }
                if (presentable) {
                    this.presentationAPI.setPresentable((Object)this, presentable);
                } else if (!this.presentablePending) {
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            boolean presentable;
                            AppShareModule.this.presentablePending = false;
                            if (AppShareModule.this.presentationAPI == null) {
                                return;
                            }
                            boolean playback = AppShareModule.this.appBean != null && AppShareModule.this.appBean.isPrerecorded();
                            boolean hosting = AppShareModule.this.appBean != null && AppShareModule.this.appBean.isHosting() && !playback;
                            boolean viewing = AppShareModule.this.appBean == null ? false : AppShareModule.this.appBean.isViewing();
                            boolean bl = presentable = hosting || viewing;
                            if (AppShareModule.this.presentationAPI.isPresentable((Object)AppShareModule.this) == presentable) {
                                return;
                            }
                            if (AppShareDebug.UI.show()) {
                                LogSupport.message((Object)this, (String)"run(updateUIElements)", (String)("presentable=" + presentable + " mod.isPresentable=" + AppShareModule.this.presentationAPI.isPresentable((Object)AppShareModule.this) + " hosting=" + hosting + " viewing=" + viewing));
                            }
                            AppShareModule.this.presentationAPI.setPresentable((Object)AppShareModule.this, presentable);
                        }
                    };
                    LightweightTimer timer = new LightweightTimer(2, task);
                    timer.scheduleIn(500L);
                    this.presentablePending = true;
                }
            }
        }
        switch (state) {
            case 1: {
                this.enableFeatureItem(this.pauseFeature, false, false, "pause");
                break;
            }
            case 2: {
                this.enableFeatureItem(this.pauseFeature, false, false, "pause");
                break;
            }
            case 3: {
                this.enableFeatureItem(this.pauseFeature, false, false, "pause");
                break;
            }
            case 4: {
                this.enableFeatureItem(this.pauseFeature, false, false, "pause");
                break;
            }
            case 5: {
                this.enableFeatureItem(this.pauseFeature, false, false, "pause");
                break;
            }
            case 6: {
                this.enableFeatureItem(this.pauseFeature, true, false, "pause");
                break;
            }
            case 9: {
                this.enableFeatureItem(this.pauseFeature, true, true, "pause");
                break;
            }
            case 7: {
                this.enableFeatureItem(this.pauseFeature, true, false, "pause");
                break;
            }
            case 8: {
                this.enableFeatureItem(this.pauseFeature, true, false, "pause");
            }
        }
        if (hosting) {
            if (((Boolean)this.previewToolFeature.getValue()).booleanValue()) {
                this.previewToolFeature.setDescription(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_PREVIEWHIDETOOLTIP));
            } else {
                this.previewToolFeature.setDescription(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_PREVIEWSHOWTOOLTIP));
            }
        }
        this.startHostingFeature.setEnabled(canStart && (inMode || canModeSwitch));
        this.shareDesktopMenuFeature.setEnabled(canStart && (inMode || canModeSwitch));
        this.giveCtlMenuFeature.setEnabled(canGive);
        this.takeCtlMenuFeature.setEnabled(canTake);
        this.rmtStartMenuFeature.setEnabled(canRemoteStart);
        this.rmtCtlMenuFeature.setEnabled(canRemoteCtl);
        this.pauseFeature.setEnabled(showPause);
        this.previewToolFeature.setEnabled(hosting);
        this.markupToolFeature.setEnabled(hosting && canMarkup);
        this.markupToolWithDelayFeature.setEnabled(hosting && canMarkup);
        this.broker.setFeaturePublished((Feature)this.winMenuFeature, showWindow);
        this.broker.setFeaturePublished((Feature)this.startHostingFeature, canStart);
        this.broker.setFeaturePublished((Feature)this.shareDesktopMenuFeature, canHostRegion);
        this.requestExtraPrivilegesFeature.setEnabled(canHost && idle && !this.appBean.haveExtraPrivileges);
        this.requestExtraPrivilegesFeature.setEnabled(canHost && idle && this.appBean.haveExtraPrivileges);
        if (this.appBean.extraPrivilegesAvailable) {
            this.broker.setFeaturePublished((Feature)this.requestExtraPrivilegesFeature, canHost);
            this.broker.setFeaturePublished((Feature)this.releaseExtraPrivilegesFeature, canHost);
        }
        this.scaleToFitFeature.setEnabled(viewing);
        this.broker.setFeaturePublished((Feature)this.scaleToFitFeature, viewing);
        this.broker.setFeaturePublished((Feature)this.giveCtlMenuFeature, canHost);
        this.broker.setFeaturePublished((Feature)this.takeCtlMenuFeature, canHost);
        this.broker.setFeaturePublished((Feature)this.releaseCtlFeature, controller || sharing);
        this.broker.setFeaturePublished((Feature)this.rmtStartMenuFeature, canHost);
        this.broker.setFeaturePublished((Feature)this.rmtCtlMenuFeature, canHost && viewing);
        for (int i = 0; i < this.arrayKeys.size(); ++i) {
            ActionFeature action = (ActionFeature)this.arrayKeys.get(i);
            action.setEnabled(controller);
            this.broker.addFeature((Feature)((ActionFeature)this.arrayKeys.get(i)));
        }
        this.otherKeyFeature.setEnabled(controller);
        this.broker.addFeature((Feature)this.otherKeyFeature);
        this.broker.setFeaturePublished((Feature)this.previewToolFeature, canHost);
        this.broker.setFeaturePublished((Feature)this.markupToolFeature, canHost);
        this.broker.setFeaturePublished((Feature)this.markupToolWithDelayFeature, canHost);
        this.broker.setFeaturePublished((Feature)this.pauseFeature, canHost);
        if (this.appBean.appHost != null) {
            this.appBean.appHost.setPauseState(paused);
        }
        this.requestCursorControlActionBar.setEnabled(this.rmtCtlMenuFeature.isEnabled());
        this.broker.setFeaturePublished((Feature)this.requestCursorControlActionBar, canHost && viewing);
        this.pauseActionBar.setEnabled(showPause);
        this.broker.setFeaturePublished((Feature)this.pauseActionBar, showPause);
        if (paused) {
            this.pauseActionBar.setName(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_RESUMEACTIONTEXT));
        } else {
            this.pauseActionBar.setName(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_PAUSEACTIONTEXT));
        }
        boolean canStop = hosting && showHost || amChair && viewing && showHost;
        this.stopHostingFeature.setEnabled(canStop);
        this.broker.setFeaturePublished((Feature)this.stopHostingFeature, canStop);
        if (viewing && this.appBean != null) {
            this.appBean.setScaling(this.appBean.isScaling());
        }
        this.appsharePanelFeature.setEnabled(viewing || hosting);
        if (AppShareDebug.UI.show()) {
            LogSupport.message((Object)this, (String)"updateUIElements", (String)("showWindow=" + showWindow + ", setVisible=" + this.isVisible()));
        }
        if (showWindow != this.isVisible()) {
            this.setVisible(showWindow);
        }
    }

    private void enableFeatureItem(BooleanFeature feature, boolean enable, boolean select, String tip) {
        String fullTip = "AppShareModule." + tip + (select ? "OnTip" : "OffTip");
        String tipText = this.i18n.getStringLegacy(fullTip);
        feature.setEnabled(enable);
        feature.setValue((Object)select);
        feature.setDescription(tipText);
    }

    public void participantSelectionChanged() {
        this.updateUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionFeatureEvent event) {
        Object src = event.getSource();
        if (src == null) {
            return;
        }
        if (src == this.startHostingFeature) {
            ViewAPI viewAPI = (ViewAPI)this.imps.findBest(ViewAPI.class);
            if (viewAPI != null) {
                Chair chair = ChairProtocol.getChair((ClientList)this.clients);
                if (viewAPI.getMode() != ViewMode.APPSHARE && chair.isMe()) {
                    viewAPI.requestMode(ViewMode.APPSHARE);
                }
            }
            this.appBean.requestToHost();
            this.updateUI();
        } else if (src == this.stopHostingFeature) {
            if (this.appBean.isHosting()) {
                this.appBean.stop();
            } else {
                this.appBean.sendRemoteStop();
            }
            this.updateUI();
        } else if (src == this.giveCtlMenuFeature) {
            if (this.sel != null) {
                if (this.sel.getSelectedParticipantCount() != 1) {
                    return;
                }
                List to = this.sel.getSelectedParticipants();
                CRParticipant who = (CRParticipant)to.get(0);
                if (who.getRoom().getID() != this.client.getGroupID()) {
                    String grp = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.group");
                    ModalDialog.showMessageDialogAsync((int)-1, (Component)this.top, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_OUTOFGROUPMSG, new Object[]{grp}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_OUTOFGROUPTITLE, new Object[]{grp}), (int)0);
                    return;
                }
                this.appBean.giveControl(who.getID(), true);
            }
        } else if (src == this.shareDesktopMenuFeature) {
            if (!this.appBean.changeState(1, 4)) {
                return;
            }
            try {
                this.appBean.startHosting(null, null);
            }
            finally {
                this.appBean.changeState(4, 1);
            }
        } else if (src == this.takeCtlMenuFeature) {
            this.appBean.takeControl();
        } else if (src == this.releaseCtlFeature) {
            if (this.appBean.isShared()) {
                this.appBean.takeControl();
            } else if (this.appBean.isControlling()) {
                this.appBean.releaseControl();
            }
        } else if (src == this.rmtStartMenuFeature) {
            if (this.sel != null && this.sel.getSelectedParticipantCount() == 1) {
                List to = this.sel.getSelectedParticipants();
                CRParticipant who = (CRParticipant)to.get(0);
                if (who.getRoom().getID() != this.client.getGroupID()) {
                    String grp = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.group");
                    ModalDialog.showMessageDialogAsync((int)-1, (Component)this.top, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_BADGROUPRMTSTARTMSG, new Object[]{grp}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_BADGROUPRMTSTARTTITLE, new Object[]{grp}), (int)0);
                    return;
                }
                this.appBean.sendRemoteStart(who.getID(), 1, 0);
            }
        } else if (src == this.rmtCtlMenuFeature || src == this.requestCursorControlActionBar) {
            ClientInfo to = null;
            if (src == this.rmtCtlMenuFeature || src == this.requestCursorControlActionBar) {
                to = this.clients.get(this.appBean.getHost());
            }
            if (to != null) {
                if (to.getGroupID() != this.client.getGroupID()) {
                    String grp = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.group");
                    ModalDialog.showMessageDialogAsync((int)-1, (Component)this.top, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_BADGROUPRMTSTARTMSG, new Object[]{grp}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_BADGROUPRMTSTARTTITLE, new Object[]{grp}), (int)0);
                    return;
                }
                this.appBean.sendRemoteStart(to.getAddress(), 4, 0);
            }
        } else if (src == this.winMenuFeature) {
            Window w;
            if (this.appBean != null && this.isVisible() && (w = SwingUtilities.windowForComponent(this.appBean)) != null && w.isShowing()) {
                w.toFront();
            }
        } else if (src == this.markupToolFeature) {
            this.appBean.snapImage();
        } else if (src == this.markupToolWithDelayFeature) {
            this.appBean.snapImage(10);
        } else if (src == this.otherKeyFeature) {
            this.appBean.asyncHelper.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AppShareModule.this.appBean.getState() != 3) {
                        return;
                    }
                    if (((AppShareModule)AppShareModule.this).appBean.host == -32767) {
                        return;
                    }
                    KeyConfigPanel content = new KeyConfigPanel(0, 0, true);
                    int which = ModalDialog.showOptionDialog((Component)AppShareModule.this.appBean, (Object)content, (String)AppShareModule.this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_SENDOTHERKEYTITLE), (int)2, (int)-1, null, null, null, (Object)content.getPrimaryComponent());
                    if (which != 0) {
                        return;
                    }
                    AppShareModule.this.appBean.simulateKey(AppShareModule.this.appBean, content.getKeyCode(), content.getKeyModifiers());
                }
            });
        } else if (src == this.pauseActionBar) {
            this.pauseFeature.setValue((Object)((Boolean)this.pauseFeature.getValue() == false ? 1 : 0));
        }
    }

    public void metaDataChanged(MetaDataEvent ev) {
        Object src = ev.getSource();
        boolean selected = Boolean.parseBoolean(ev.getNewValue().toString());
        if (this.recursive) {
            return;
        }
        if (src == this.pauseFeature) {
            this.appBean.setPaused(selected);
        } else if (src == this.scaleToFitFeature) {
            this.appBean.setScaling((Boolean)this.scaleToFitFeature.getValue());
        } else if (src == this.previewToolFeature) {
            if (!this.appBean.isHosting()) {
                return;
            }
            if (this.getAuxAPI() != null && this.getAuxAPI().isAuxiliaryShowing()) {
                return;
            }
            if (((Boolean)this.previewToolFeature.getValue()).booleanValue()) {
                this.appBean.showPreviewDialog();
            } else {
                this.appBean.hidePreviewDialog();
            }
        }
    }

    public void loadPreferences(String prefix, Preferences preferences) {
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AppShareModule.this.preferenceChange(e);
            }
        };
        this.registerPreferenceChangeListener(prefix + ".colorCompression", l);
        this.registerPreferenceChangeListener(prefix + ".keystrokes", l);
        this.registerPreferenceChangeListener(prefix + ".keyfilter", l);
        this.registerPreferenceChangeListener(prefix + SCALE_TO_FIT_PREF, l);
        int vers = preferences.getIntegerSetting(prefix + ".prefsVersion", 0);
        switch (vers) {
            default: 
        }
        if (vers != 1) {
            preferences.setSetting(prefix + ".prefsVersion", 1);
        }
        if (preferences != null) {
            int q = preferences.getIntegerSetting(prefix + ".colorCompression", 2);
            q = Math.min(q, 4);
            q = Math.max(q, 0);
            this.setQuality(q);
            boolean scaleVal = preferences.getBooleanSetting(prefix + SCALE_TO_FIT_PREF, false);
            if (this.contentCaptureProvider.get().isContentCaptureEnabled() && !this.contentCaptureProvider.get().isEchoingData()) {
                scaleVal = false;
            }
            try {
                this.reportScalingState(scaleVal);
                if (this.appBean != null) {
                    this.appBean.setScaling(scaleVal);
                }
            }
            catch (Throwable t) {
                this.reportScalingState(false);
            }
        }
    }

    private void preferenceChange(PropertyChangeEvent e) {
        String prefix;
        String name = e.getPropertyName();
        if (name.equals((prefix = this.getPrefix()) + ".colorCompression")) {
            int q = Preferences.integerValue((Object)e.getNewValue(), (int)-1);
            if (q != -1) {
                this.setQuality(q);
            }
        } else if (name.equals(prefix + ".keystrokes")) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AppShareModule.this.updateUI();
                    AppShareModule.this.appBean.reloadSimulatedKeystrokes();
                }
            });
        } else if (name.equals(prefix + ".keyfilter")) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    AppShareModule.this.appBean.loadFilteredKeystrokes();
                }
            });
        } else if (name.equals(prefix + SCALE_TO_FIT_PREF)) {
            boolean enabled = Preferences.booleanValue((Object)e.getNewValue(), (boolean)false);
            if (this.appBean.isScaling() != enabled) {
                this.appBean.setScaling(enabled);
                this.updateUI();
            }
        }
    }

    protected void setHostLimited(boolean isLimited) {
    }

    public void start() {
        this.confEngine.registerCommand(this.StopSharingCmd);
        this.confEngine.registerCommand(this.PauseSharingCmd);
        this.confEngine.registerCommand(this.ResumeSharingCmd);
        this.confEngine.registerCommand(this.ShareApplicationCmd);
        this.confEngine.registerCommand(this.ShareScreenCmd);
        this.confEngine.registerCommand(this.ShareScreenRegionCmd);
    }

    public void stop() {
    }

    public void attach() {
        this.initModule();
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.addPlaybackTimeListener((PlaybackTimeListener)this);
        }
        this.setVisible(true);
        this.installed = true;
    }

    public void detach() {
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.removePlaybackTimeListener((PlaybackTimeListener)this);
        }
        this.unconfigure();
        this.installed = false;
    }

    public void setupUI() {
        this.createFeatures();
        this.broker.setFeaturePublished((Feature)this.appsharePanelFeature, true);
    }

    public void cleanupUI() {
        this.broker.setFeaturePublished((Feature)this.appsharePanelFeature, false);
    }

    private void registerPreferenceChangeListener(String setting, PropertyChangeListener listener) {
        if (this.preferences != null) {
            this.preferences.addSettingChangeListener(setting, listener);
        }
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    private String getPresentedModuleTitle(Module pm) {
        Object value = this.getMethodValue(pm, "getTitle", new Class[0], new Object[0]);
        return value != null ? value.toString() : "N/A";
    }

    private Object getMethodValue(Object owner, String methodName, Class<?>[] params, Object[] args) {
        if (owner != null) {
            Method method = this.getMethod(owner.getClass(), methodName, params);
            try {
                return method.invoke(owner, args);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private Method getMethod(Class<?> clazz, String methodName, Class<?>[] params) {
        Method method = null;
        try {
            method = clazz.getMethod(methodName, params);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return method;
    }

    private void createFeatures() {
        String name = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_STARTHOSTINGNAME);
        String desc = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_STARTHOSTINGDESC);
        this.startHostingFeature = this.broker.createActionFeature((Object)this, "/appshare/startHostingFeature", name, desc);
        this.startHostingFeature.setEnabled(false);
        this.startHostingFeature.setInteractive(true);
        this.stopHostingFeature = this.broker.createActionFeature((Object)this, "/appshare/stopHostingFeature", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_STOPACTIONTEXT), null);
        this.stopHostingFeature.setEnabled(false);
        this.shareDesktopMenuFeature = this.broker.createActionFeature((Object)this, "/appshare/shareDesktopMenu", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_SHAREDESKTOPMENUITEM), null);
        this.shareDesktopMenuFeature.setEnabled(false);
        this.giveCtlMenuFeature = this.broker.createActionFeature((Object)this, "/appshare/giveCtlMenu", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_GIVECTLMENUTEXT), null);
        this.takeCtlMenuFeature = this.broker.createActionFeature((Object)this, "/appshare/takeCtlMenu", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_TAKECTLMENUTEXT), null);
        this.releaseCtlFeature = this.broker.createActionFeature((Object)this, "/appshare/releaseTool", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_RELEASECTLMENUTEXT), null);
        this.releaseCtlFeature.setDefaultIcon(this.i18n.getImage("AppShareModule.releaseIcon"));
        this.rmtStartMenuFeature = this.broker.createActionFeature((Object)this, "/appshare/rmtStartMenu", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_RMTSTARTMENUTEXT), null);
        this.rmtCtlMenuFeature = this.broker.createActionFeature((Object)this, "/appshare/rmtCtlMenu", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_RMTCONTROLMENUTEXT), this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_STATUSBAR_REQCONTROLTIP));
        this.rmtCtlMenuFeature.setDefaultIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.APPSHAREBEAN_STATUSBAR_REQCONTROLICON));
        this.requestCursorControlActionBar = this.broker.createActionFeature((Object)this, "/appshare/requestCursorControlActionBar", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_REQUESTCURSORCONTROLACTIONTEXT), null);
        this.scaleToFitFeature = this.broker.createBooleanFeature((Object)this, "/appshare/scaleToFit", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_SCALETOFIT), null);
        this.scaleToFitFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_SCALETOFIT));
        this.scaleToFitFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_SCALETOFIT));
        this.scaleToFitFeature.setTrueIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.APPSHAREBEAN_STATUSBAR_SCALINGONICON));
        this.scaleToFitFeature.setFalseIcon(this.i18n.getImage((PropertiesEnum)StringsProperties.APPSHAREBEAN_STATUSBAR_SCALINGONICON));
        String data = this.preferences.getSetting(AppShareModule.class.getName() + ".keystrokes");
        ArrayList keys = data != null ? SimulatedKeyStroke.parseSet(data) : SimulatedKeyStroke.makeDefaultSet();
        this.otherKeyFeature = this.broker.createActionFeature((Object)this, "/appshare/sendKeys/other", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_SENDOTHERKEYITEM), null);
        this.otherKeyFeature.setInteractive(true);
        this.arrayKeys = new ArrayList();
        for (final SimulatedKeyStroke key : keys) {
            ActionFeature actionKey = this.broker.createActionFeature((Object)this, "/appshare/sendKeys/" + key.getKeyCode() + key.getKeyModifiers(), key.getKeystroke(), null);
            actionKey.addHint("location", this.otherKeyFeature.getHintValue("location"));
            actionKey.addHint("menuType", this.otherKeyFeature.getHintValue("menuType"));
            ArraySet subMemu = new ArraySet();
            subMemu.add((Object)this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_TITLE));
            subMemu.add((Object)this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_SENDKEYMENU));
            actionKey.addHint("menus.submenus.name", (Object)subMemu);
            actionKey.addActionFeatureListener(new ActionFeatureListener(){

                public void actionPerformed(ActionFeatureEvent event) {
                    AppShareModule.this.appBean.simulateKey(AppShareModule.this.appBean, key.getKeyCode(), key.getKeyModifiers());
                }
            });
            this.arrayKeys.add(actionKey);
        }
        this.previewToolFeature = this.broker.createBooleanFeature((Object)this, "/appshare/previewTool", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_PREVIEWSHOWMENUITEM), null);
        this.previewToolFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_PREVIEWHIDEMENUITEM));
        this.previewToolFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_PREVIEWSHOWMENUITEM));
        this.previewToolFeature.setTrueIcon(this.i18n.getImage("AppShareBean.auxPreviewIcon"));
        this.previewToolFeature.setFalseIcon(this.i18n.getImage("AppShareBean.auxPreviewIcon"));
        this.markupToolFeature = this.broker.createActionFeature((Object)this, "/appshare/markupTool", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_MARKUPMENUITEM), null);
        this.markupToolFeature.setDefaultIcon(this.i18n.getImage("AppShareBean.markupToolIcon"));
        this.markupToolWithDelayFeature = this.broker.createActionFeature((Object)this, "/appshare/markupToolWithDelay", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_DELAYMARKUPMENUITEM), null);
        this.pauseFeature = this.broker.createBooleanFeature((Object)this, "/appshare/pause", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_PAUSEMENUTEXT), null);
        this.pauseFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_PAUSEMENUTEXT));
        this.pauseFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_PAUSEMENUTEXT));
        this.pauseFeature.setTrueIcon(this.i18n.getImage("AppShareModule.pauseOnIcon"));
        this.pauseFeature.setFalseIcon(this.i18n.getImage("AppShareModule.pauseOffIcon"));
        this.pauseActionBar = this.broker.createActionFeature((Object)this, "/appshare/pauseActionBar", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_PAUSEACTIONTEXT), null);
        this.winMenuFeature = this.broker.createActionFeature((Object)this, "/appshare/winMenu", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_WINDOWMENUTEXT), null);
        this.requestExtraPrivilegesFeature = this.broker.createActionFeature((Object)this, "/appshare/requestExtraPrivilege", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_REQUESTEXTRAPRIVILEGES), null);
        this.releaseExtraPrivilegesFeature = this.broker.createActionFeature((Object)this, "/appshare/releaseExtraPrivilege", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREBEAN_RELEASEEXTRAPRIVILEGES), null);
        this.appsharePanelFeature = this.broker.createComponentFeature((Object)this, "/appshare/canvas", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return AppShareModule.this.appBean;
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_TITLE));
        this.appsharePanelFeature.setEnabled(false);
        this.filteredKeysPrefPanel = this.broker.createComponentFeature((Object)this, "/appshare/prefs/filterKeys", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)AppShareModule.this.filteredKeysPrefsPanelProvider.get();
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.FILTEREDKEYS_TITLE));
        this.hostingOptionPrefsPanel = this.broker.createComponentFeature((Object)this, "/appshare/prefs/hostingOption", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)AppShareModule.this.hostingOptionsPrefsPanelProvider.get();
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.HOSTINGOPTIONS_TITLE));
        this.remoteControlPrefsPanel = this.broker.createComponentFeature((Object)this, "/appshare/prefs/remoteControl", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)AppShareModule.this.remoteControlPrefsPanelProvider.get();
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.REMOTECONTROL_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.REMOTECONTROL_TITLE));
        this.simulatedKeysPrefsPanel = this.broker.createComponentFeature((Object)this, "/appshare/prefs/simulatedKeys", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)AppShareModule.this.simulatedKeysPrefsPanelProvider.get();
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.SIMULATEDKEYS_TITLE));
        this.viewingPrefsPanel = this.broker.createComponentFeature((Object)this, "/appshare/prefs/viewing", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)AppShareModule.this.viewingPrefsPanelProvider.get();
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.VIEWINGPREFSPANEL_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.VIEWINGPREFSPANEL_TITLE));
        this.startHostingFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.stopHostingFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.shareDesktopMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.giveCtlMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.takeCtlMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.releaseCtlFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.otherKeyFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.rmtStartMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.rmtCtlMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.requestCursorControlActionBar.addActionFeatureListener((ActionFeatureListener)this);
        this.scaleToFitFeature.addValueChangeListener((MetaDataListener)this);
        this.previewToolFeature.addValueChangeListener((MetaDataListener)this);
        this.markupToolFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.markupToolWithDelayFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.pauseFeature.addValueChangeListener((MetaDataListener)this);
        this.pauseActionBar.addActionFeatureListener((ActionFeatureListener)this);
        this.winMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.requestExtraPrivilegesFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.releaseExtraPrivilegesFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.broker.announceFeature((Feature)this.markupToolFeature);
        this.broker.announceFeature((Feature)this.takeCtlMenuFeature);
        this.broker.announceFeature((Feature)this.startHostingFeature);
        this.broker.announceFeature((Feature)this.stopHostingFeature);
        this.broker.setFeaturePublished((Feature)this.filteredKeysPrefPanel, true);
        this.broker.setFeaturePublished((Feature)this.hostingOptionPrefsPanel, true);
        this.broker.setFeaturePublished((Feature)this.remoteControlPrefsPanel, true);
        this.broker.setFeaturePublished((Feature)this.simulatedKeysPrefsPanel, true);
        this.broker.setFeaturePublished((Feature)this.viewingPrefsPanel, true);
        BooleanFeature bf = this.permissionFeatureFactory.createPermissionFeature((Object)this, "AppSharePermission", "/appshare/appSharePermission", this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_MENUTEXT), "ScreenSharing", this.i18n);
        bf.setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREMODULE_MENUTEXT_ACCESSIBLENAME));
        this.session.registerAnnotation("AppShareActivityAnnotation", (Object)0);
        this.session.registerAnnotation("AppShareLagAnnotation", (Object)0);
        this.session.addPermissionChangeListener("AppSharePermission", (CRPermissionChangeListener)this);
    }

    public void onPermissionValueChange(CRPermissionChangeEvent event) {
        CRPermission permission = (CRPermission)event.getSource();
        CRParticipant p = this.session.getParticipantById(permission.getID());
        if (p != null && p.isMe()) {
            if (this.appBean != null && !this.appBean.hasHostingPermission()) {
                if (this.appBean.isHosting()) {
                    this.appBean.stop();
                } else if (this.appBean.isSelecting()) {
                    this.appBean.changeState(4, 1);
                }
            }
            if (this.appBean != null) {
                this.appBean.configurePanel();
            }
            this.updateUI();
        }
    }

    public void onPermissionDefaultChange(CRPermissionChangeEvent event) {
    }
}

