/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.activity.module;

import com.elluminate.classroom.client.messaging.Message;
import java.util.ArrayList;
import java.util.List;

public class ActivityMessage {
    private Message originalMessage;
    private String displayName;
    private String textDesc;
    private String fromModule;
    private String header;
    private boolean fromMe = false;
    private List<String> additionalInfo;
    private final long sessionTime;
    private final long systemTime;
    private int volume;

    public ActivityMessage(String name, String desc, List<String> extraInfo, long sessionTime, long systemTime, String hdr, boolean fromMe, int volume) {
        if (desc == null) {
            throw new IllegalArgumentException("Text description can not be null");
        }
        if (sessionTime <= 0L) {
            throw new IllegalArgumentException("Invalid timestamp value");
        }
        this.displayName = name == null ? "" : name;
        this.textDesc = desc;
        this.additionalInfo = extraInfo == null ? new ArrayList() : extraInfo;
        this.sessionTime = sessionTime;
        this.systemTime = systemTime;
        this.header = hdr;
        this.fromMe = fromMe;
        this.volume = volume;
    }

    public ActivityMessage(Message orig) {
        this.originalMessage = orig;
        this.displayName = orig.getMessageType().getDisplayName();
        this.sessionTime = orig.getSessionTime();
        this.systemTime = orig.getSystemTime();
        this.textDesc = orig.getText();
        this.fromMe = orig.isSentByMe();
        this.fromModule = orig.getPublisherInfo().getModuleName();
        this.volume = orig.getMessageType().getVolume();
        if (orig.getExtraInfo() != null) {
            if (orig.getExtraInfo().getDetails() != null) {
                this.additionalInfo = orig.getExtraInfo().getDetails();
            }
            this.header = orig.getExtraInfo().getHeader();
        } else {
            this.additionalInfo = new ArrayList<String>();
        }
    }

    public long getSessionTimeOfMessageMillis() {
        return this.sessionTime;
    }

    public long getSystemTimeOfMessageMillis() {
        return this.systemTime;
    }

    public String getTextDescription() {
        return this.textDesc;
    }

    public List<String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getHeader() {
        return this.header;
    }

    public boolean isFromMe() {
        return this.fromMe;
    }

    public String getOrigModuleName() {
        return this.fromModule;
    }

    public int getVolume() {
        return this.volume;
    }

    public Message getOriginalMessage() {
        return this.originalMessage;
    }

    public String toString() {
        String info = "";
        info = info + "displayName[" + this.displayName + "] ";
        info = info + "additionalInfo[" + this.additionalInfo + "] ";
        info = info + "fromMe[" + this.fromMe + "] ";
        info = info + "fromModule[" + this.fromModule + "] ";
        info = info + "header[" + this.header + "] ";
        info = info + "originalMessage[" + this.originalMessage + "] ";
        info = info + "sessionTime[" + this.sessionTime + "] ";
        info = info + "systemTime[" + this.systemTime + "] ";
        info = info + "textDesc[" + this.textDesc + "] ";
        info = info + "volume[" + this.volume + "] ";
        return info;
    }
}

