/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.activity.accessibility;

import com.elluminate.accessibility.cli.AbstractCommandHandler;
import com.elluminate.accessibility.cli.AccessibilityInterpreter;
import com.elluminate.accessibility.cli.CLICommandAssistanceException;
import com.elluminate.accessibility.cli.CLICommandException;
import com.elluminate.accessibility.cli.CLICommandUsageException;
import com.elluminate.accessibility.cli.CommandMapCommandHandler;
import com.elluminate.accessibility.cli.OptionMapCommandHandler;
import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandInstantiationException;
import com.elluminate.engine.CommandNoPermissionException;
import com.elluminate.engine.CommandNotChairException;
import com.elluminate.engine.CommandNotFoundException;
import com.elluminate.engine.CommandNotOnlineException;
import com.elluminate.engine.CommandNotPlaybackException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.engine.command.AnswerPollCommand;
import com.elluminate.engine.command.Command;
import com.elluminate.engine.command.ConnectTeleconferenceCommand;
import com.elluminate.engine.command.DisconnectTeleconferenceCommand;
import com.elluminate.engine.command.LowerHandCommand;
import com.elluminate.engine.command.PausePlaybackCommand;
import com.elluminate.engine.command.PreviewVideoCommand;
import com.elluminate.engine.command.RaiseHandCommand;
import com.elluminate.engine.command.SendChatMessageCommand;
import com.elluminate.engine.command.SetStatusCommand;
import com.elluminate.engine.command.ShowEmotionCommand;
import com.elluminate.engine.command.StartPlaybackCommand;
import com.elluminate.engine.command.StopAudioCommand;
import com.elluminate.engine.command.StopPlaybackCommand;
import com.elluminate.engine.command.StopVideoCommand;
import com.elluminate.engine.command.TransmitAudioCommand;
import com.elluminate.engine.command.TransmitVideoCommand;
import com.elluminate.engine.model.ChatRecipient;
import com.elluminate.groupware.activity.accessibility.StringsProperties;
import com.elluminate.groupware.imps.AccessibilityCLIAPI;
import com.elluminate.groupware.imps.AccessibilityCLIException;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.QuotedStringTokenizer;
import java.util.ArrayList;

public class AccessibleCLI
extends AccessibilityInterpreter
implements AccessibilityCLIAPI {
    private static I18n i18n = I18n.create(AccessibleCLI.class);

    public AccessibleCLI(boolean playbackMode, ConferencingEngine conferencingEngine) {
        this.setConferencingEngine(conferencingEngine);
        if (!playbackMode) {
            this.registerCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_HANDCOMMAND), HandHandler.class);
            this.registerCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_STATUSCOMMAND), StatusHandler.class);
            this.registerCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_REACTCOMMAND), ReactHandler.class);
            this.registerCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_ANSWERCOMMAND), AnswerHandler.class);
            this.registerCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_TALKCOMMAND), TalkHandler.class);
            this.registerCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_VIDEOCOMMAND), VideoHandler.class);
            this.registerCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_CHATCOMMAND), ChatHandler.class);
            this.registerCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_AUDIOCOMMAND), AudioHandler.class);
        }
        if (playbackMode) {
            this.registerCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_PLAYBACKCOMMAND), PlaybackHandler.class);
        }
    }

    public String getProvider() {
        return "Framework";
    }

    public byte getTier() {
        return 32;
    }

    public boolean processCLICommand(String commandLine) throws AccessibilityCLIException {
        try {
            return super.processCommand(commandLine);
        }
        catch (CLICommandException ex) {
            String dmsg = null;
            if (ex instanceof CLICommandUsageException) {
                CLICommandUsageException cuex = (CLICommandUsageException)ex;
                dmsg = i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_COMMANDUSAGEMESSAGE, new Object[]{cuex.getCommandName() + " " + cuex.getParameterUsage()});
            } else if (ex instanceof CLICommandAssistanceException) {
                CLICommandAssistanceException carex = (CLICommandAssistanceException)ex;
                dmsg = carex.getAssistanceMsg();
            } else {
                Throwable cause = ex.getCause();
                if (cause instanceof CommandNotOnlineException) {
                    dmsg = i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_COMMANDNOTONLINEMESSAGE);
                } else if (cause instanceof CommandNotChairException) {
                    dmsg = i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_COMMANDNOTCHAIRMESSAGE);
                } else if (cause instanceof CommandNoPermissionException) {
                    dmsg = i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_COMMANDNOPERMISSIONMESSAGE);
                } else if (cause instanceof CommandNotPlaybackException) {
                    dmsg = i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_COMMANDNOTPLAYBACKMESSAGE);
                } else if (cause instanceof CommandParameterException) {
                    dmsg = i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_COMMANDPARAMETERMESSAGE);
                } else if (cause instanceof CommandContextException) {
                    dmsg = i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_COMMANDCONTEXTMESSAGE);
                }
            }
            throw new AccessibilityCLIException("A command exception occurred: " + commandLine, dmsg);
        }
    }

    public static class AnswerHandler
    extends OptionMapCommandHandler {
        public AnswerHandler() {
            super(AnswerPollCommand.class);
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_ANSWERNONEPARAMETER), "none");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_ANSWERYESPARAMETER), "yes");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_ANSWERNOPARAMETER), "no");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_ANSWERAPARAMETER), "a");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_ANSWERBPARAMETER), "b");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_ANSWERCPARAMETER), "c");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_ANSWERDPARAMETER), "d");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_ANSWEREPARAMETER), "e");
        }

        public void configureCommand(Command command, Object option) {
            AnswerPollCommand cmd = (AnswerPollCommand)command;
            String resp = (String)option;
            cmd.setResponse(resp);
        }
    }

    public static class AudioHandler
    extends CommandMapCommandHandler {
        public AudioHandler() {
            this.mapCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_AUDIOPHONEPARAMETER), ConnectTeleconferenceCommand.class);
            this.mapCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_AUDIOCOMPUTERPARAMETER), DisconnectTeleconferenceCommand.class);
        }
    }

    public static class ChatHandler
    extends AbstractCommandHandler {
        ArrayList<String> trueRecipients = new ArrayList();
        ArrayList<Integer> trueMsgIndices = new ArrayList();
        String msg = null;

        public String getParameterUsage() {
            return ChatHandler.joinParameters((String[])new String[]{i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_CHATRECIPIENTPARAMETER), i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_CHATMESSAGEPARAMETER)});
        }

        public String getAmbiguousRecipientsMsg() {
            String ambiguousRecipientsList = "";
            String orText = i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_CHATORCONNECTOR);
            for (int i = 0; i < this.trueRecipients.size(); ++i) {
                ambiguousRecipientsList = ambiguousRecipientsList + "\"" + this.trueRecipients.get(i) + "\"" + " " + orText + " ";
            }
            ambiguousRecipientsList = ambiguousRecipientsList.substring(0, ambiguousRecipientsList.length() - orText.length() - 2);
            return i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_CHATAMBIGUOUSRECIPIENTS, new Object[]{ambiguousRecipientsList});
        }

        /*
         * Enabled aggressive block sorting
         */
        public Command prepareCommand(QuotedStringTokenizer args) throws CommandNotFoundException, CommandInstantiationException, CLICommandUsageException, CLICommandAssistanceException {
            int recipParseIndex;
            ArrayList<String> possibleRecipients = new ArrayList<String>();
            ArrayList<Integer> possibleMsgIndices = new ArrayList<Integer>();
            int tokenCount = args.countTokens();
            if (tokenCount < 1) {
                throw new CLICommandUsageException();
            }
            this.msg = args.getRemaining(true);
            SendChatMessageCommand cmd = (SendChatMessageCommand)this.createCommand(SendChatMessageCommand.class);
            if (this.msg.charAt(0) != '@') {
                cmd.addRecipient("this_room");
                cmd.setMessage(this.msg);
                return cmd;
            }
            this.trueRecipients.clear();
            this.trueMsgIndices.clear();
            this.msg = this.msg.substring(1);
            boolean quotedRecipientFound = false;
            block0: for (recipParseIndex = 0; recipParseIndex < this.msg.length(); ++recipParseIndex) {
                int startQuoteIndex;
                if (!quotedRecipientFound && this.msg.charAt(recipParseIndex) == '\"') {
                    quotedRecipientFound = true;
                    if (recipParseIndex + 1 < this.msg.length()) {
                        // empty if block
                    }
                    startQuoteIndex = ++recipParseIndex;
                } else {
                    if (Character.isWhitespace(this.msg.charAt(recipParseIndex))) continue;
                    break;
                }
                while (recipParseIndex < this.msg.length()) {
                    int endQuoteIndex;
                    if (this.msg.charAt(recipParseIndex) == '\"') {
                        endQuoteIndex = recipParseIndex;
                        if (recipParseIndex + 1 < this.msg.length()) {
                            ++recipParseIndex;
                        }
                    } else {
                        ++recipParseIndex;
                        continue;
                    }
                    while (recipParseIndex < this.msg.length() && Character.isWhitespace(this.msg.charAt(recipParseIndex))) {
                        ++recipParseIndex;
                    }
                    possibleRecipients.add(this.msg.substring(startQuoteIndex, endQuoteIndex));
                    possibleMsgIndices.add(recipParseIndex);
                    continue block0;
                }
            }
            if (possibleRecipients.size() == 0) {
                while (recipParseIndex < this.msg.length()) {
                    if (Character.isWhitespace(this.msg.charAt(recipParseIndex)) && recipParseIndex + 1 < this.msg.length() && !Character.isWhitespace(this.msg.charAt(recipParseIndex + 1))) {
                        possibleRecipients.add(this.msg.substring(0, recipParseIndex));
                        possibleMsgIndices.add(recipParseIndex);
                    } else if (recipParseIndex + 1 >= this.msg.length()) {
                        possibleRecipients.add(this.msg.substring(0, recipParseIndex + 1));
                        possibleMsgIndices.add(recipParseIndex + 1);
                    }
                    ++recipParseIndex;
                }
            }
            int recipIndex = 0;
            while (true) {
                int len$;
                ChatRecipient[] arr$;
                String recipient;
                String recipName;
                if (recipIndex < possibleRecipients.size()) {
                    recipName = (String)possibleRecipients.get(recipIndex);
                    recipient = null;
                    arr$ = cmd.getAvailableRecipients();
                    len$ = arr$.length;
                } else {
                    if (this.trueRecipients.size() == 0) {
                        throw new CLICommandUsageException();
                    }
                    if (this.trueRecipients.size() == 1) {
                        cmd.addRecipient(this.trueRecipients.get(0));
                        cmd.setMessage(this.msg.substring(this.trueMsgIndices.get(0)));
                        return cmd;
                    }
                    String ambiguousRecipientMessage = this.getAmbiguousRecipientsMsg();
                    CLICommandAssistanceException exc = new CLICommandAssistanceException();
                    exc.setAssistanceMsg(ambiguousRecipientMessage);
                    throw exc;
                }
                for (int i$ = 0; i$ < len$; ++i$) {
                    ChatRecipient recip = arr$[i$];
                    if (!recipName.trim().equalsIgnoreCase(recip.getDisplayName().trim())) continue;
                    recipient = recip.getName();
                    if (recipient != null) break;
                    recipient = recip.getDisplayName();
                    break;
                }
                if (recipient != null) {
                    this.trueRecipients.add(recipient);
                    this.trueMsgIndices.add((Integer)possibleMsgIndices.get(recipIndex));
                }
                ++recipIndex;
            }
        }
    }

    public static class HandHandler
    extends CommandMapCommandHandler {
        public HandHandler() {
            this.mapCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_HANDUPPARAMETER), RaiseHandCommand.class);
            this.mapCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_HANDDOWNPARAMETER), LowerHandCommand.class);
        }
    }

    public static class PlaybackHandler
    extends CommandMapCommandHandler {
        public PlaybackHandler() {
            this.mapCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_PLAYBACKSTARTPARAMETER), StartPlaybackCommand.class);
            this.mapCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_PLAYBACKPAUSEPARAMETER), PausePlaybackCommand.class);
            this.mapCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_PLAYBACKSTOPPARAMETER), StopPlaybackCommand.class);
        }
    }

    public static class ReactHandler
    extends OptionMapCommandHandler {
        public ReactHandler() {
            super(ShowEmotionCommand.class);
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_REACTLAUGHTERPARAMETER), "laughter");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_REACTAPPLAUSEPARAMETER), "applause");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_REACTCONFUSIONPARAMETER), "confusion");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_REACTDISAPPROVALPARAMETER), "disapproval");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_REACTAPPROVALPARAMETER), "approval");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_REACTFASTERPARAMETER), "faster");
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_REACTSLOWERPARAMETER), "slower");
        }

        public void configureCommand(Command command, Object option) {
            ShowEmotionCommand cmd = (ShowEmotionCommand)command;
            String type = (String)option;
            cmd.setType(type);
        }
    }

    public static class StatusHandler
    extends OptionMapCommandHandler {
        public StatusHandler() {
            super(SetStatusCommand.class);
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_STATUSAWAYPARAMETER), Boolean.FALSE);
            this.mapOption(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_STATUSBACKPARAMETER), Boolean.TRUE);
        }

        public void configureCommand(Command command, Object option) {
            SetStatusCommand cmd = (SetStatusCommand)command;
            Boolean avail = (Boolean)option;
            cmd.setAvailable(avail.booleanValue());
        }
    }

    public static class TalkHandler
    extends CommandMapCommandHandler {
        public TalkHandler() {
            this.mapCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_TALKONPARAMETER), TransmitAudioCommand.class);
            this.mapCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_TALKOFFPARAMETER), StopAudioCommand.class);
        }
    }

    public static class VideoHandler
    extends CommandMapCommandHandler {
        public VideoHandler() {
            this.mapCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_VIDEOPREVIEWPARAMETER), PreviewVideoCommand.class);
            this.mapCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_VIDEOONPARAMETER), TransmitVideoCommand.class);
            this.mapCommand(i18n.getString((PropertiesEnum)StringsProperties.ACCESSIBLECLI_VIDEOOFFPARAMETER), StopVideoCommand.class);
        }
    }
}

