/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.browser.macosx;

import com.elluminate.browser.BrowserDebug;
import com.elluminate.browser.BrowserPaneImpl;
import com.elluminate.browser.NavigationEvent;
import com.elluminate.browser.NavigationListener;
import com.elluminate.browser.UIListener;
import com.elluminate.browser.macosx.DMWebKitView;
import com.elluminate.browser.macosx.StringsProperties;
import com.elluminate.browser.macosx.WebKitFrameFactory;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.event.ModalDialogAsyncRequest;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SerializerThread;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WebKitComponent
extends DMWebKitView
implements BrowserPaneImpl,
HierarchyListener {
    static final String BLANK_URL = "about:blank";
    static final int LOAD_CANCELLED_ERR = -999;
    private static I18n i18n = I18n.create(WebKitComponent.class);
    private static HashMap reloadRequests = new HashMap();
    private ArrayList navListeners = new ArrayList();
    private ArrayList uiListeners = new ArrayList();
    private volatile boolean loading = false;
    private volatile boolean hasTitle = false;
    private volatile String targetURL = null;
    private volatile boolean firstShow = true;
    private LightweightTimer refreshTimer = null;
    private Frame window = null;
    private String curPageURL = null;
    private boolean stopping = false;
    private boolean secondary = false;
    private NavPanel nav = null;
    private ModalDialogAsyncRequest pendingErrorRequest = null;
    private volatile ErrorInfo errorInfo = null;
    private static final String[] PROTOCOLS;
    private static final String URL_SEPARATOR = ":";

    public WebKitComponent() {
        this(0L);
    }

    public WebKitComponent(long nativeView) {
        super(nativeView);
        this.addHierarchyListener(this);
        File downloads = new File(Platform.getTempDir(), "eliveWebTourDownloads");
        if (!downloads.exists()) {
            downloads.mkdirs();
        }
        if (downloads.isDirectory()) {
            WebKitComponent.clearStaleFiles(downloads);
            this.setDownloadLocation(downloads);
        }
        this.refreshTimer = new LightweightTimer(2, new Runnable(){

            @Override
            public void run() {
                Container p = WebKitComponent.this.getParent();
                if (p == null || !p.isShowing()) {
                    return;
                }
                if (WebKitComponent.this.loading || WebKitComponent.this.curPageURL == null) {
                    WebKitComponent.this.refreshTimer.scheduleIn(100L);
                    return;
                }
                WebKitComponent.this.refresh(true);
            }
        });
    }

    private static void clearStaleFiles(File dir) {
        String[] names = dir.list();
        long staleTime = System.currentTimeMillis() - 86400000L;
        if (names == null || names.length < 1) {
            return;
        }
        for (int ix = 0; ix < names.length; ++ix) {
            try {
                File f = new File(dir, names[ix]);
                if (!f.isFile() || f.lastModified() >= staleTime) continue;
                f.delete();
                continue;
            }
            catch (Throwable t) {
                if (!BrowserDebug.BROWSER.show()) continue;
                LogSupport.message(WebKitComponent.class, (String)"clearStaleFiles", (String)("Error deleting file " + names[ix] + " in " + dir + ": " + Debug.getStackTrace((Throwable)t)));
            }
        }
    }

    private Window findWindow() {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof Window)) continue;
            return (Window)c;
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.targetURL != null) {
            if (BrowserDebug.BROWSER.show()) {
                LogSupport.message((Object)this, (String)"addNotify", (String)("Performing deferred page load: " + this.targetURL));
            }
            this.loadPage(this.targetURL);
        }
    }

    private static void createNewWebKitFrame(String initURL, long nativeView, int creatingPolicy, int initX, int initY, int initWidth, int initHeight, boolean isResizable, boolean hasToolbars, boolean hasStatusBar) {
        final WebKitComponent view = new WebKitComponent(nativeView);
        view.setNewWebViewCreatingPolicy(creatingPolicy);
        view.secondary = true;
        if (initWidth > 32) {
            view.prefWidth = initWidth;
        }
        if (initHeight > 32) {
            view.prefHeight = initHeight;
        }
        final JFrame frame = new JFrame();
        view.window = frame;
        frame.setResizable(isResizable);
        frame.setLocation(initX, initY);
        NavPanel navigator = view.createNavPanel(hasToolbars, initURL);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)((Object)view), "Center");
        frame.getContentPane().add((Component)navigator, "North");
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                frame.hide();
                frame.getContentPane().removeAll();
                view.dispose();
                Runnable disposer = new Runnable(){

                    @Override
                    public void run() {
                        frame.dispose();
                    }
                };
                LightweightTimer timer = new LightweightTimer(2, disposer);
                timer.scheduleIn(2500L);
            }
        });
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    frame.pack();
                    frame.show();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                view.requestFocusInWindow();
                view.needResize = true;
            }
        });
    }

    @Override
    public void closeWindow() {
        if (!this.secondary) {
            return;
        }
        if (this.window == null) {
            return;
        }
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebKitComponent.this.window.dispose();
            }
        });
    }

    private NavPanel createNavPanel(boolean showNavPanel, String initURL) {
        if (!this.secondary) {
            throw new IllegalStateException("No internal nav for primary browser");
        }
        if (this.nav == null) {
            this.nav = new NavPanel();
        }
        if (initURL != null) {
            this.nav.setCurrentURL(initURL);
        }
        this.addUIListener(this.nav);
        this.nav.setVisible(showNavPanel);
        return this.nav;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNavigationListener(NavigationListener l) {
        ArrayList arrayList = this.navListeners;
        synchronized (arrayList) {
            if (!this.navListeners.contains(l)) {
                ArrayList nlist = (ArrayList)this.navListeners.clone();
                nlist.add(l);
                this.navListeners = nlist;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNavigationListener(NavigationListener l) {
        ArrayList arrayList = this.navListeners;
        synchronized (arrayList) {
            if (this.navListeners.contains(l)) {
                ArrayList nlist = (ArrayList)this.navListeners.clone();
                nlist.remove(this.navListeners.indexOf(l));
                this.navListeners = nlist;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUIListener(UIListener l) {
        ArrayList arrayList = this.navListeners;
        synchronized (arrayList) {
            if (!this.uiListeners.contains(l)) {
                ArrayList nlist = (ArrayList)this.uiListeners.clone();
                nlist.add(l);
                this.uiListeners = nlist;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUIListener(UIListener l) {
        ArrayList arrayList = this.navListeners;
        synchronized (arrayList) {
            if (this.uiListeners.contains(l)) {
                ArrayList nlist = (ArrayList)this.uiListeners.clone();
                nlist.remove(this.navListeners.indexOf(l));
                this.uiListeners = nlist;
            }
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openURL(String url) {
        ModalDialogAsyncRequest prevReq;
        boolean send = false;
        this.stopping = false;
        if (BrowserDebug.BROWSER.show()) {
            LogSupport.message((Object)this, (String)"openURL", (String)("Open URL: " + url));
        }
        if ((prevReq = this.pendingErrorRequest) != null) {
            prevReq.cancel();
        }
        WebKitComponent webKitComponent = this;
        synchronized (webKitComponent) {
            this.targetURL = url;
            if (!this.firstShow) {
                send = true;
            }
        }
        if (send) {
            this.loadPage(this.targetURL);
        }
    }

    @Override
    public void openURL(String frame, String url) {
        this.stopping = false;
        ModalDialogAsyncRequest prevReq = this.pendingErrorRequest;
        if (prevReq != null) {
            prevReq.cancel();
        }
        super.loadFrame(frame, url);
    }

    @Override
    public boolean hasFrameSupport() {
        return true;
    }

    @Override
    public void goForward() {
        if (BrowserDebug.FWD_BACK.show()) {
            LogSupport.message((Object)this, (String)"goForward", (String)"...");
        }
        this.forwardPage();
    }

    @Override
    public void goBack() {
        if (BrowserDebug.FWD_BACK.show()) {
            LogSupport.message((Object)this, (String)"goBack", (String)"...");
        }
        this.backPage();
    }

    @Override
    public void stop() {
        this.stopping = true;
        this.loading = false;
        if (BrowserDebug.BROWSER.show()) {
            LogSupport.message((Object)this, (String)"stop", (String)("Stopping URL: " + this.curPageURL));
        }
        this.stopLoadingPage();
        this.clearPage();
        this.targetURL = null;
    }

    @Override
    public byte getInitState() {
        if (WebKitComponent.isAvailable()) {
            return 1;
        }
        return -1;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void repaintContent() {
        super.sendRepaintView();
    }

    @Override
    public boolean isPropertySupported(String prop) {
        return false;
    }

    @Override
    public void setProperty(String prop, Object val) {
    }

    @Override
    public Object getProperty(String prop) {
        return null;
    }

    protected void fireOnNavigate(String url) {
        this.fireOnNavigate(new NavigationEvent(this, url));
    }

    protected void fireOnNavigate(String frame, String url) {
        this.fireOnNavigate(new NavigationEvent(this, frame, url));
    }

    protected void fireOnNavigate(NavigationEvent e) {
        if (e == null) {
            return;
        }
        if (this.navListeners == null) {
            return;
        }
        for (NavigationListener l : this.navListeners) {
            try {
                l.onNavigate(e);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireOnNavigate", (Throwable)ex, (boolean)true, (String)e.toString());
            }
        }
    }

    protected void fireOnStop() {
        if (this.navListeners == null) {
            return;
        }
        for (NavigationListener l : this.navListeners) {
            try {
                l.onStop();
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireOnStop", (Throwable)ex, (boolean)true);
            }
        }
    }

    protected void fireSetCurrentURL(String url) {
        for (UIListener l : this.uiListeners) {
            try {
                l.setCurrentURL(url);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireSetCurrentURL", (Throwable)t, (boolean)true);
            }
        }
    }

    protected void fireSetPageTitle(String title) {
        for (UIListener l : this.uiListeners) {
            try {
                l.setPageTitle(title);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireSetCurrentURL", (Throwable)t, (boolean)true);
            }
        }
    }

    protected void fireSetBackEnabled(boolean enabled) {
        for (UIListener l : this.uiListeners) {
            try {
                l.setBackEnabled(enabled);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireSetBackEnabled", (Throwable)t, (boolean)true);
            }
        }
    }

    protected void fireSetFwdEnabled(boolean enabled) {
        for (UIListener l : this.uiListeners) {
            try {
                l.setFwdEnabled(enabled);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"fireSetFwdEnabled", (Throwable)t, (boolean)true);
            }
        }
    }

    @Override
    public void errorOccurred(final String errorDesc, final String url) {
        if (BrowserDebug.ERRORS.show()) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LogSupport.message((Object)this, (String)"errorOccurred", (String)(errorDesc + ": " + url));
                }
            });
        }
    }

    @Override
    public void pageLoadError(final String errorDesc, final String url, final int code) {
        String reloadURL;
        if (BrowserDebug.ERRORS.show()) {
            LogSupport.message((Object)this, (String)"pageLoadError", (String)("Error " + code + " (" + errorDesc + ") referencing URL " + url + "\ntargetURL=" + this.targetURL + " curPageURL=" + this.curPageURL + " prevError=" + this.errorInfo));
        }
        if (!this.loading || this.stopping) {
            return;
        }
        if (this.targetURL != null) {
            reloadURL = this.targetURL;
        } else if (this.curPageURL == null) {
            reloadURL = this.curPageURL;
        } else {
            return;
        }
        if (BLANK_URL.equalsIgnoreCase(reloadURL)) {
            return;
        }
        ErrorInfo prevError = this.errorInfo;
        if (prevError != null && prevError.isPending()) {
            return;
        }
        if (code != -999) {
            SerializerThread.threadInvokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebKitComponent.this.loading = false;
                    ModalDialogAsyncRequest prevReq = WebKitComponent.this.pendingErrorRequest;
                    if (prevReq != null) {
                        prevReq.cancel();
                    }
                    WebKitComponent.this.pendingErrorRequest = ModalDialog.showMessageDialogAsync((int)120, (Component)((Object)WebKitComponent.this), (Object)i18n.getString((PropertiesEnum)StringsProperties.WEBKITCOMPONENT_LOADFAILEDMSG, new Object[]{"" + code, errorDesc, url}), (String)i18n.getString((PropertiesEnum)StringsProperties.WEBKITCOMPONENT_LOADFAILEDTITLE), (int)0);
                }
            });
            return;
        }
        if (reloadRequests.containsKey(reloadURL)) {
            if (BrowserDebug.ERRORS.show() || BrowserDebug.BROWSER.show()) {
                LogSupport.message((Object)this, (String)"pageLoadError", (String)("Discarding, already auto-reloaded page: " + reloadURL));
            }
            return;
        }
        reloadRequests.put(reloadURL, reloadURL);
        SerializerThread.threadInvokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ErrorInfo err = WebKitComponent.this.errorInfo;
                if (err != null && err.isPending()) {
                    return;
                }
                if (err != null && err.check(url, reloadURL)) {
                    return;
                }
                if (BrowserDebug.ERRORS.show()) {
                    LogSupport.message((Object)WebKitComponent.this, (String)"pageLoadError", (String)("Auto-reloading page: " + reloadURL));
                }
                WebKitComponent.this.retryPageLoad(reloadURL, url, 250);
            }
        });
    }

    private void retryPageLoad(final String reloadURL, String faultURL, int delay) {
        ErrorInfo ei;
        this.errorInfo = ei = new ErrorInfo(faultURL, reloadURL, true);
        LightweightTimer timer = new LightweightTimer(new Runnable(){

            @Override
            public void run() {
                ei.clearPending();
                WebKitComponent.this.loadPage(reloadURL);
            }
        });
        timer.scheduleIn((long)delay);
    }

    @Override
    public void startURLLoading(final String url) {
        this.loading = true;
        this.hasTitle = false;
        SerializerThread.threadInvokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BrowserDebug.BROWSER.show()) {
                    LogSupport.message((Object)this, (String)"startURLLoading", (String)url);
                }
                if (!WebKitComponent.this.hasTitle) {
                    WebKitComponent.this.fireSetPageTitle("");
                }
                if (url != null) {
                    WebKitComponent.this.fireOnNavigate(url);
                    WebKitComponent.this.curPageURL = url;
                    WebKitComponent.this.fireSetCurrentURL(url);
                } else {
                    WebKitComponent.this.curPageURL = null;
                }
            }
        });
    }

    @Override
    public void finishURLLoading() {
        this.loading = false;
        SerializerThread.threadInvokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BrowserDebug.BROWSER.show()) {
                    LogSupport.message((Object)this, (String)"finishURLLoading", (String)WebKitComponent.this.curPageURL);
                }
                if (!WebKitComponent.this.hasTitle && WebKitComponent.this.curPageURL != null) {
                    WebKitComponent.this.fireSetPageTitle(WebKitComponent.this.curPageURL);
                }
                if (WebKitComponent.this.stopping && WebKitComponent.BLANK_URL.equalsIgnoreCase(WebKitComponent.this.curPageURL)) {
                    WebKitComponent.this.fireOnStop();
                    WebKitComponent.this.stopping = false;
                }
            }
        });
    }

    @Override
    public void startFrameLoading(final String frameName, final String url) {
        SerializerThread.threadInvokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BrowserDebug.BROWSER.show()) {
                    LogSupport.message((Object)this, (String)"startFrameLoading", (String)(frameName + " => " + url));
                }
                if (frameName != null) {
                    WebKitComponent.this.fireOnNavigate(frameName, url);
                }
            }
        });
    }

    @Override
    public void finishFrameLoading(String frameName) {
    }

    @Override
    public void setURLTitle(final String title) {
        this.hasTitle = title != null;
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BrowserDebug.BROWSER.show()) {
                    LogSupport.message((Object)this, (String)"setURLTitle", (String)title);
                }
                WebKitComponent.this.fireSetPageTitle(title);
            }
        });
    }

    @Override
    public void setURLIcon(ByteBuffer buffer) {
        BufferedImage img = null;
        if (buffer != null) {
            try {
                byte[] data = new byte[buffer.capacity()];
                buffer.get(data);
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                img = ImageIO.read(bis);
                bis.close();
            }
            catch (Throwable t) {
                img = null;
            }
        }
    }

    @Override
    public void setStatusText(final String statusStr) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BrowserDebug.BROWSER.show()) {
                    LogSupport.message((Object)this, (String)"setStatusText", (String)statusStr);
                }
            }
        });
    }

    @Override
    public void setBackButtonEnable(final boolean v) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BrowserDebug.FWD_BACK.show()) {
                    LogSupport.message((Object)this, (String)"setBackButtonEnable", (String)("enabled = " + v));
                }
                WebKitComponent.this.fireSetBackEnabled(v);
            }
        });
    }

    @Override
    public void setForwardButtonEnable(final boolean v) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BrowserDebug.FWD_BACK.show()) {
                    LogSupport.message((Object)this, (String)"setForwardButtonEnable", (String)("enabled = " + v));
                }
                WebKitComponent.this.fireSetFwdEnabled(v);
            }
        });
    }

    @Override
    public void mouseDidMoveOverElement(Object elementInfoObject) {
        super.mouseDidMoveOverElement(elementInfoObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        boolean send = false;
        if (e.getChangeFlags() == 4L) {
            WebKitComponent webKitComponent = this;
            synchronized (webKitComponent) {
                if (this.firstShow) {
                    this.setVisible(true);
                    if (this.refreshTimer != null) {
                        this.refreshTimer.scheduleIn(250L);
                    }
                    this.firstShow = false;
                    if (this.targetURL != null) {
                        send = true;
                    }
                }
            }
        }
        if (send) {
            this.loadPage(this.targetURL);
        }
    }

    static {
        System.getProperties().put("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
        DMWebKitView.setFrameFactory(new WebKitFrameFactory(){

            @Override
            public void createNewFrameForView(String initURL, long nativeView, int creatingPolicy, int initX, int initY, int initWidth, int initHeight, boolean isResizable, boolean hasToolbars, boolean hasStatusBar) {
                WebKitComponent.createNewWebKitFrame(initURL, nativeView, creatingPolicy, initX, initY, initWidth, initHeight, isResizable, hasToolbars, hasStatusBar);
            }
        });
        PROTOCOLS = new String[]{"http", "https"};
    }

    private class ErrorInfo {
        private String faultingURL;
        private String reloadURL;
        private volatile boolean reloadPending;
        private volatile long timestamp;

        ErrorInfo(String fault, String reload, boolean pending) {
            this.faultingURL = fault;
            this.reloadURL = reload;
            this.reloadPending = pending;
            this.timestamp = System.currentTimeMillis();
        }

        boolean check(String fault, String reload) {
            return this.faultingURL.equalsIgnoreCase(fault) && this.reloadURL.equalsIgnoreCase(reload);
        }

        boolean isPending() {
            return this.reloadPending;
        }

        void clearPending() {
            this.reloadPending = false;
        }

        long getAge() {
            return System.currentTimeMillis() - this.timestamp;
        }

        public String toString() {
            return "[" + super.toString() + (this.reloadPending ? " reloading" : "") + " fault=" + this.faultingURL + " reload=" + this.reloadURL + " age=" + this.getAge() + "]";
        }
    }

    private class NavPanel
    extends JPanel
    implements UIListener {
        JButton backBtn;
        JButton fwdBtn;
        JLabel urlLbl;
        JTextField urlFld;

        NavPanel() {
            super(new GridBagLayout());
            this.backBtn = new JButton(i18n.getIcon("WebKitComponent.backBtn"));
            this.fwdBtn = new JButton(i18n.getIcon("WebKitComponent.fwdBtn"));
            this.urlLbl = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.WEBKITCOMPONENT_URLLABEL));
            this.urlFld = new JTextField();
            this.fwdBtn.setEnabled(false);
            this.backBtn.setEnabled(false);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.backBtn, gbc);
            this.add((Component)this.fwdBtn, gbc);
            gbc.insets = new Insets(2, 4, 2, 2);
            this.add((Component)this.urlLbl, gbc);
            gbc.gridwidth = 0;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.urlFld, gbc);
            this.backBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    WebKitComponent.this.backPage();
                }
            });
            this.fwdBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    WebKitComponent.this.forwardPage();
                }
            });
            this.urlFld.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String text = NavPanel.this.urlFld.getText();
                    try {
                        WebKitComponent.this.loadPage(NavPanel.this.checkURL(text));
                    }
                    catch (Throwable t) {
                        ModalDialog.showMessageDialogAsync((int)-1, (Component)((Object)WebKitComponent.this), (Object)i18n.getString((PropertiesEnum)StringsProperties.WEBKITCOMPONENT_BADURLMSG, new Object[]{text, t.getMessage()}), (String)i18n.getString((PropertiesEnum)StringsProperties.WEBKITCOMPONENT_BADURLTITLE), (int)0);
                    }
                }
            });
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.backBtn.setVisible(enabled);
            this.fwdBtn.setVisible(enabled);
            this.urlFld.setEditable(enabled);
        }

        private String checkURL(String urlText) throws MalformedURLException {
            URL url = null;
            int pos = urlText.indexOf(WebKitComponent.URL_SEPARATOR);
            if (pos > 0) {
                String protocol = urlText.substring(0, pos);
                boolean allowed = false;
                for (int ix = 0; ix < PROTOCOLS.length; ++ix) {
                    if (!protocol.equalsIgnoreCase(PROTOCOLS[ix])) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    pos = -1;
                }
            }
            if (pos < 0) {
                urlText = urlText.startsWith("/") ? PROTOCOLS[0] + WebKitComponent.URL_SEPARATOR + urlText : PROTOCOLS[0] + WebKitComponent.URL_SEPARATOR + "//" + urlText;
            }
            url = new URL(urlText);
            return url.toString();
        }

        @Override
        public void setCurrentURL(String urlText) {
            this.urlFld.setText(urlText);
        }

        @Override
        public void setPageTitle(String title) {
            if (WebKitComponent.this.window != null) {
                WebKitComponent.this.window.setTitle(i18n.getString((PropertiesEnum)StringsProperties.WEBKITCOMPONENT_2NDTITLE, new Object[]{title}));
            }
        }

        @Override
        public void setBackEnabled(boolean enabled) {
            this.backBtn.setEnabled(enabled);
        }

        @Override
        public void setFwdEnabled(boolean enabled) {
            this.fwdBtn.setEnabled(enabled);
        }
    }
}

