/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.browser;

import com.elluminate.browser.BrowserDebug;
import com.elluminate.browser.BrowserPaneImpl;
import com.elluminate.browser.NavigationListener;
import com.elluminate.browser.UIListener;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.lang.reflect.Method;
import java.net.URL;

public class BrowserPane
implements BrowserPaneImpl {
    public static final String POPUP_SUPPRESSION_PROP = "browser.popups";
    private static final String[] WIN_CLS = new String[]{"com.elluminate.browser.proxy.ProxyBrowserPaneImpl"};
    private static final String[] MAC_CLS = new String[]{"com.elluminate.browser.macosx.WebKitContainer"};
    private static final String[] GENERIC_CLS = new String[0];
    private static final String[] MAC_CLS_JXBROWSER = new String[]{"com.elluminate.browser.macosx.JxBrowserContainer"};
    private static Class implClass = null;
    private BrowserPaneImpl impl = null;

    public BrowserPane() throws InstantiationException {
        this(false);
    }

    public BrowserPane(boolean isPlayer) throws InstantiationException {
        String[] classes = null;
        switch (Platform.getPlatform()) {
            case 1: {
                classes = WIN_CLS;
                break;
            }
            case 2: {
                if (Platform.checkJavaVersion((String)"1.7+")) {
                    classes = MAC_CLS_JXBROWSER;
                    break;
                }
                classes = MAC_CLS;
                break;
            }
            default: {
                classes = GENERIC_CLS;
            }
        }
        if (classes == null) {
            throw new InstantiationException();
        }
        for (int i = 0; i < classes.length; ++i) {
            try {
                Class<?> cls = Class.forName(classes[i]);
                this.impl = (BrowserPaneImpl)cls.newInstance();
                implClass = cls;
                if (BrowserDebug.SELECTION.show()) {
                    LogSupport.message((String)("Using " + classes[i] + " as browser component."));
                }
                return;
            }
            catch (Throwable t) {
                if (!BrowserDebug.BROWSER.show()) continue;
                LogSupport.message((Object)this, (String)"<init>", (String)Debug.getStackTrace((Throwable)t));
                continue;
            }
        }
        throw new InstantiationException();
    }

    @Override
    public void addNavigationListener(NavigationListener l) {
        this.impl.addNavigationListener(l);
    }

    @Override
    public void removeNavigationListener(NavigationListener l) {
        this.impl.removeNavigationListener(l);
    }

    @Override
    public void addUIListener(UIListener uil) {
        this.impl.addUIListener(uil);
    }

    @Override
    public void removeUIListener(UIListener uil) {
        this.impl.removeUIListener(uil);
    }

    @Override
    public Component getComponent() {
        return this.impl.getComponent();
    }

    @Override
    public boolean hasFrameSupport() {
        return this.impl.hasFrameSupport();
    }

    @Override
    public void openURL(String url) {
        this.impl.openURL(url);
    }

    @Override
    public void openURL(String frame, String url) {
        this.impl.openURL(frame, url);
    }

    public void openURL(URL url) {
        this.impl.openURL(url.toString());
    }

    @Override
    public void goForward() {
        this.impl.goForward();
    }

    @Override
    public void goBack() {
        this.impl.goBack();
    }

    @Override
    public void stop() {
        if (this.impl != null) {
            this.impl.stop();
        }
    }

    @Override
    public void dispose() {
        this.impl.dispose();
        this.impl = null;
    }

    @Override
    public void repaintContent() {
        if (this.impl != null) {
            this.impl.repaintContent();
        }
    }

    @Override
    public byte getInitState() {
        if (this.impl == null) {
            return -1;
        }
        return this.impl.getInitState();
    }

    public static void shutdown() {
        if (implClass == null) {
            return;
        }
        try {
            Method shut = implClass.getMethod("shutdown", null);
            shut.invoke(null, (Object[])null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isPropertySupported(String prop) {
        if (this.impl == null) {
            return false;
        }
        return this.impl.isPropertySupported(prop);
    }

    @Override
    public void setProperty(String prop, Object val) {
        if (this.impl != null) {
            this.impl.setProperty(prop, val);
        }
    }

    @Override
    public Object getProperty(String prop) {
        if (this.impl == null) {
            return null;
        }
        return this.impl.getProperty(prop);
    }
}

