/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.webkit;

import com.jniwrapper.DataBufferFactory;
import com.jniwrapper.Library;
import com.jniwrapper.LibraryLoader;
import com.jniwrapper.MemoryBuffer;
import com.jniwrapper.Pointer;
import com.teamdev.jxbrowser.webkit.BrowserEngine;
import com.teamdev.jxbrowser.webkit.DialogCreator;
import com.teamdev.jxbrowser.webkit.JavaScriptJavaBridge;
import com.teamdev.jxbrowser.webkit.Properties;
import com.teamdev.jxbrowser.webkit.SafariEvents;
import com.teamdev.jxbrowser.webkit.SafariProperties;
import com.teamdev.jxbrowser.webkit.WebBrowserWindow;
import com.teamdev.jxbrowser.webkit.WebPolicyDelegate;
import com.teamdev.jxbrowser.webkit.WindowCreator;
import com.teamdev.jxbrowser.webkit.cocoa.Id;
import com.teamdev.jxbrowser.webkit.cocoa.nsbitmapimagerep.NSBitmapImageRep;
import com.teamdev.jxbrowser.webkit.cocoa.nsdata.NSData;
import com.teamdev.jxbrowser.webkit.cocoa.nsdata.NSMutableData;
import com.teamdev.jxbrowser.webkit.cocoa.nsdate.NSTimeInterval;
import com.teamdev.jxbrowser.webkit.cocoa.nsstring.NSString;
import com.teamdev.jxbrowser.webkit.cocoa.nsstring.NSStringEncoding;
import com.teamdev.jxbrowser.webkit.cocoa.nsurl.NSURL;
import com.teamdev.jxbrowser.webkit.cocoa.nsurlrequest.NSMutableURLRequest;
import com.teamdev.jxbrowser.webkit.cocoa.nsurlrequest.NSURLRequest;
import com.teamdev.jxbrowser.webkit.cocoa.nsurlrequest.NSURLRequestCachePolicy;
import com.teamdev.jxbrowser.webkit.event.BrowserListener;
import com.teamdev.jxbrowser.webkit.events.DOMEventHandler;
import com.teamdev.jxbrowser.webkit.events.FrameLoadEvents;
import com.teamdev.jxbrowser.webkit.events.UIEvents;
import com.teamdev.jxbrowser.webkit.webkit.DOMDocument;
import com.teamdev.jxbrowser.webkit.webkit.DOMEvent;
import com.teamdev.jxbrowser.webkit.webkit.DOMFactory;
import com.teamdev.jxbrowser.webkit.webkit.DOMHTMLDocument;
import com.teamdev.jxbrowser.webkit.webkit.DOMNode;
import com.teamdev.jxbrowser.webkit.webkit.WebFrame;
import com.teamdev.jxbrowser.webkit.webkit.WebPreferences;
import com.teamdev.jxbrowser.webkit.webkit.WebView;
import com.teamdev.jxdesktop.macosx.MainMessageLoop;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.html.HTMLDocument;

public class SafariEngine
implements BrowserEngine {
    private WebView webView;
    private Properties properties;
    private SafariEvents events;
    private WebBrowserWindow browserWindow;
    private Component component;
    private Component parentComponent;
    private DOMFactory domFactory;
    private JavaScriptJavaBridge javaScriptJavaBridge;
    private final Map<Long, Set<Map.Entry<EventListener, Long>>> domEventListeners;

    public SafariEngine() {
        try {
            MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

                public void run() {
                    long l = SafariEngine.this.createWebView();
                    SafariEngine.this.webView = new WebView(false);
                    SafariEngine.this.webView.setValue(l);
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot create Safari component.", exception);
        }
        this.events = new SafariEvents();
        this.events.setEngine(this);
        this.properties = new SafariProperties();
        this.domFactory = new DOMFactory();
        this.domEventListeners = new HashMap<Long, Set<Map.Entry<EventListener, Long>>>();
        this.javaScriptJavaBridge = new JavaScriptJavaBridge();
        this.getFrameLoadEvents().setDomEventHandler(new MyDOMEventHandler());
    }

    private void registerJavaScriptJavaBridge() {
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                SafariEngine.this.registerJavaScriptJavaBridge(SafariEngine.this.getNSView());
            }
        });
    }

    public boolean print() {
        final boolean[] blArray = new boolean[1];
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                blArray[0] = SafariEngine.this.print(SafariEngine.this.getNSView());
            }
        });
        return blArray[0];
    }

    DOMFactory getDomFactory() {
        return this.domFactory;
    }

    public void updateBounds() {
        MainMessageLoop.invokeLater((Runnable)new Runnable(){

            public void run() {
                SafariEngine.this.repaint(SafariEngine.this.getNSView());
            }
        });
    }

    public Document getDocument() {
        final HTMLDocument[] hTMLDocumentArray = new HTMLDocument[]{null};
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                WebFrame webFrame = new WebFrame(SafariEngine.this.webView.mainFrame());
                DOMDocument dOMDocument = webFrame.DOMDocument(SafariEngine.this.domFactory);
                DOMHTMLDocument dOMHTMLDocument = new DOMHTMLDocument(dOMDocument.getPointer(), SafariEngine.this.domFactory);
                hTMLDocumentArray[0] = (HTMLDocument)SafariEngine.this.domFactory.wrap(dOMHTMLDocument, HTMLDocument.class);
            }
        });
        return hTMLDocumentArray[0];
    }

    public Image toImage() {
        final BufferedImage[] bufferedImageArray = new BufferedImage[]{null};
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                long l = SafariEngine.this.getImage(SafariEngine.this.getNSView());
                NSData nSData = new NSData(new Pointer.Void(l));
                NSBitmapImageRep nSBitmapImageRep = NSBitmapImageRep.alloc().initWithData(nSData);
                int n = (int)nSBitmapImageRep.pixelsWide().getValue();
                int n2 = (int)nSBitmapImageRep.pixelsHigh().getValue();
                int n3 = (int)nSBitmapImageRep.bytesPerRow().getValue();
                int n4 = n3 * n2;
                DataBufferFactory dataBufferFactory = DataBufferFactory.getInstance();
                MemoryBuffer memoryBuffer = dataBufferFactory.createExternMemoryBuffer(nSData.bytes().getValue(), n4);
                byte[] byArray = new byte[n4];
                memoryBuffer.readByteArray(0, byArray, 0, byArray.length);
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
                ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n, n2, 4, n3, new int[]{0, 1, 2, 3});
                WritableRaster writableRaster = WritableRaster.createWritableRaster(componentSampleModel, dataBufferByte, new Point());
                BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
                bufferedImage.setData(writableRaster);
                bufferedImageArray[0] = bufferedImage;
            }
        });
        return bufferedImageArray[0];
    }

    public Image toImage(Dimension dimension) {
        final BufferedImage[] bufferedImageArray = new BufferedImage[]{null};
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                long l = SafariEngine.this.getImage(SafariEngine.this.getNSView());
                NSData nSData = new NSData(new Pointer.Void(l));
                NSBitmapImageRep nSBitmapImageRep = NSBitmapImageRep.alloc().initWithData(nSData);
                int n = (int)nSBitmapImageRep.pixelsWide().getValue();
                int n2 = (int)nSBitmapImageRep.pixelsHigh().getValue();
                int n3 = (int)nSBitmapImageRep.bytesPerRow().getValue();
                int n4 = n3 * n2;
                DataBufferFactory dataBufferFactory = DataBufferFactory.getInstance();
                MemoryBuffer memoryBuffer = dataBufferFactory.createExternMemoryBuffer(nSData.bytes().getValue(), n4);
                byte[] byArray = new byte[n4];
                memoryBuffer.readByteArray(0, byArray, 0, byArray.length);
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
                ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n, n2, 4, n3, new int[]{0, 1, 2, 3});
                WritableRaster writableRaster = WritableRaster.createWritableRaster(componentSampleModel, dataBufferByte, new Point());
                BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
                bufferedImage.setData(writableRaster);
                bufferedImageArray[0] = bufferedImage;
            }
        });
        return bufferedImageArray[0];
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    public Component getParentComponent() {
        return this.parentComponent;
    }

    public void navigate(final String string, final boolean bl, final int n) {
        MainMessageLoop.invokeLater((Runnable)new Runnable(){

            public void run() {
                NSURL nSURL = NSURL.NSURL_URLWithString(string);
                String string2 = nSURL.host().UTF8String().toString();
                NSURLRequest nSURLRequest = NSURLRequest.NSURLRequest_requestWithURL(nSURL);
                Id id = nSURLRequest.initWithURL(nSURL, new NSURLRequestCachePolicy(n), new NSTimeInterval(30.0));
                nSURLRequest = new NSURLRequest(id);
                nSURLRequest.setAllowsAnyHTTPSCertificate(bl, string2);
                WebFrame webFrame = new WebFrame(SafariEngine.this.webView.mainFrame());
                webFrame.loadRequest(nSURLRequest);
                nSURL.release();
            }
        });
    }

    public void navigate(String string) {
        this.navigate(string, null);
    }

    public void navigate(String string, String string2) {
        this.navigate(string, string2, 0);
    }

    public void navigate(final String string, final String string2, final int n) {
        if (string2 == null || string2.length() == 0) {
            this.navigate(string, false, n);
            return;
        }
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                NSURL nSURL = NSURL.NSURL_URLWithString(string);
                NSURLRequest nSURLRequest = NSMutableURLRequest.NSMutableURLRequest_requestWithURL(nSURL);
                Id id = nSURLRequest.initWithURL(nSURL, new NSURLRequestCachePolicy(n), new NSTimeInterval(30.0));
                nSURLRequest = new NSURLRequest(id);
                NSMutableURLRequest nSMutableURLRequest = new NSMutableURLRequest(nSURLRequest);
                nSMutableURLRequest.setHTTPMethod("POST");
                nSMutableURLRequest.addValue_forHTTPHeaderField("application/x-www-form-urlencoded", "Content-Type");
                nSMutableURLRequest.addValue_forHTTPHeaderField(String.valueOf(string2.length()), "Content-Length");
                NSMutableData nSMutableData = new NSMutableData(NSMutableData.NSMutableData_data());
                NSString nSString = new NSString(string2);
                nSMutableData.appendData(nSString.dataUsingEncoding(new NSStringEncoding(4)));
                nSMutableURLRequest.setHTTPBody(nSMutableData);
                WebFrame webFrame = new WebFrame(SafariEngine.this.webView.mainFrame());
                webFrame.loadRequest(nSMutableURLRequest);
            }
        });
    }

    public String executeScript(final String string) {
        final String[] stringArray = new String[]{null};
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                stringArray[0] = SafariEngine.this.executeScript(SafariEngine.this.getNSView(), string);
            }
        });
        return stringArray[0];
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getLocationURL() {
        final String[] stringArray = new String[1];
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                stringArray[0] = SafariEngine.this.webView.mainFrameURL();
            }
        });
        return stringArray[0];
    }

    public void setHTML(final String string, final String string2) {
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                WebFrame webFrame = new WebFrame(SafariEngine.this.webView.mainFrame());
                String string3 = string2 == null ? "" : string2;
                NSURL nSURL = new NSURL(NSURL.NSURL_URLWithString(string3));
                webFrame.loadHTMLString_baseURL(string, nSURL);
            }
        });
    }

    public String getHTML() {
        final String[] stringArray = new String[]{null};
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                stringArray[0] = SafariEngine.this.getHTML(SafariEngine.this.getNSView());
            }
        });
        return stringArray[0];
    }

    public String getTextContent() {
        final String[] stringArray = new String[1];
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                WebFrame webFrame = new WebFrame(SafariEngine.this.webView.mainFrame());
                DOMDocument dOMDocument = webFrame.DOMDocument(SafariEngine.this.domFactory);
                Element element = dOMDocument.getDocumentElement();
                stringArray[0] = element.getTextContent();
            }
        });
        return stringArray[0];
    }

    public void stop() {
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                WebFrame webFrame = new WebFrame(SafariEngine.this.webView.mainFrame());
                webFrame.stopLoading();
            }
        });
    }

    public void reload() {
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                WebFrame webFrame = new WebFrame(SafariEngine.this.webView.mainFrame());
                webFrame.reload();
            }
        });
    }

    public void goBack() {
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                SafariEngine.this.back(SafariEngine.this.getNSView());
            }
        });
    }

    public void goForward() {
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                SafariEngine.this.forward(SafariEngine.this.getNSView());
            }
        });
    }

    public boolean canGoBack() {
        final boolean[] blArray = new boolean[1];
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                blArray[0] = SafariEngine.this.webView.canGoBack().getValue();
            }
        });
        return blArray[0];
    }

    public boolean canGoForward() {
        final boolean[] blArray = new boolean[1];
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                blArray[0] = SafariEngine.this.webView.canGoForward().getValue();
            }
        });
        return blArray[0];
    }

    public void dispose() {
        this.events.dispose();
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                SafariEngine.this.disposeWebView(SafariEngine.this.getNSView());
                SafariEngine.this.webView = null;
            }
        });
    }

    public boolean isDisposed() {
        return this.webView == null;
    }

    public void addBrowserListener(BrowserListener browserListener) {
        this.events.addBrowserListener(browserListener);
    }

    public void removeBrowserListener(BrowserListener browserListener) {
        this.events.removeBrowserListener(browserListener);
    }

    public BrowserListener[] getBrowserListeners() {
        return this.events.getBrowserListeners();
    }

    public void setDialogCreator(DialogCreator dialogCreator) {
        this.events.setDialogCreator(dialogCreator);
    }

    public void setWindowCreator(WindowCreator windowCreator) {
        this.events.setWindowCreator(windowCreator);
    }

    public void setWebPolicyDelegate(WebPolicyDelegate webPolicyDelegate) {
        this.events.setWebPolicyDelegate(webPolicyDelegate);
    }

    public WebPolicyDelegate getWebPolicyDelegate() {
        return this.events.getWebPolicyDelegate();
    }

    public void setWebBrowserWindow(WebBrowserWindow webBrowserWindow) {
        this.browserWindow = webBrowserWindow;
    }

    public WebBrowserWindow getWebBrowserWindow() {
        return this.browserWindow;
    }

    public WebPreferences getPreferences() {
        return new WebPreferences(this.webView.preferences());
    }

    public void setPreferences(WebPreferences webPreferences) {
        this.webView.setPreferences(webPreferences);
    }

    public long getNSView() {
        return this.webView.getValue();
    }

    private UIEvents getUIEvents() {
        return this.events.getUIEvents();
    }

    private FrameLoadEvents getFrameLoadEvents() {
        return this.events.getFrameLoadEvents();
    }

    public JavaScriptJavaBridge getJavaScriptJavaBridge() {
        this.registerJavaScriptJavaBridge();
        return this.javaScriptJavaBridge;
    }

    public void unlock() {
        this.unlockWebView(this.getNSView());
    }

    public void lock() {
        this.lockWebView(this.getNSView());
    }

    public void setUserAgent(final String string) {
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                SafariEngine.this.webView.setCustomUserAgent(string);
            }
        });
    }

    public void addEventListener(Node node, final String string, final EventListener eventListener, final boolean bl) {
        if (node == null) {
            throw new NullPointerException("The node parameter cannot be null.");
        }
        if (string == null) {
            throw new NullPointerException("The type parameter cannot be null.");
        }
        if (eventListener == null) {
            throw new NullPointerException("The listener parameter cannot be null.");
        }
        final Node node2 = (Node)this.domFactory.unwrap(node);
        if (!(node2 instanceof DOMNode)) {
            throw new IllegalArgumentException("The node parameter must be com.teamdev.jxbrowser.webkit.webkit.DOMNode.");
        }
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                if (SafariEngine.this.isDisposed()) {
                    return;
                }
                DOMNode dOMNode = (DOMNode)node2;
                long l = dOMNode.getPointer();
                long l2 = SafariEngine.this.addDOMEventListener(SafariEngine.this.getNSView(), l, string, bl);
                if (!SafariEngine.this.domEventListeners.containsKey(l)) {
                    SafariEngine.this.domEventListeners.put(l, new HashSet());
                }
                Set set = (Set)SafariEngine.this.domEventListeners.get(l);
                set.add(new SimpleEntry(eventListener, l2));
            }
        });
    }

    public void removeEventListener(Node node, final String string, final EventListener eventListener, final boolean bl) {
        if (node == null) {
            throw new NullPointerException("The node parameter cannot be null.");
        }
        if (string == null) {
            throw new NullPointerException("The type parameter cannot be null.");
        }
        if (eventListener == null) {
            throw new NullPointerException("The listener parameter cannot be null.");
        }
        final Node node2 = (Node)this.domFactory.unwrap(node);
        if (!(node2 instanceof DOMNode)) {
            throw new IllegalArgumentException("The node parameter must be com.teamdev.jxbrowser.webkit.webkit.DOMNode.");
        }
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                if (SafariEngine.this.isDisposed()) {
                    return;
                }
                DOMNode dOMNode = (DOMNode)node2;
                long l = dOMNode.getPointer();
                if (SafariEngine.this.domEventListeners.containsKey(l)) {
                    Set set = (Set)SafariEngine.this.domEventListeners.get(l);
                    for (Map.Entry entry : set) {
                        if (!((EventListener)entry.getKey()).equals(eventListener)) continue;
                        Long l2 = (Long)entry.getValue();
                        SafariEngine.this.removeDOMEventListener(SafariEngine.this.getNSView(), l, l2, string, bl);
                    }
                }
            }
        });
    }

    public boolean dispatchEvent(Node node, Event event) throws EventException {
        throw new UnsupportedOperationException();
    }

    public boolean isReady() {
        return this.events.getFrameLoadEvents().isReady();
    }

    public void removeAllCache() {
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                SafariEngine.removeAllCachedResponses();
            }
        });
    }

    public void requestFocus() {
        MainMessageLoop.invokeAndWait((Runnable)new Runnable(){

            public void run() {
                SafariEngine.this.requestFocus(SafariEngine.this.getNSView());
            }
        });
    }

    private native void requestFocus(long var1);

    private native boolean back(long var1);

    private native boolean forward(long var1);

    private native void unlockWebView(long var1);

    private native void lockWebView(long var1);

    private native String getHTML(long var1);

    private native String executeScript(long var1, String var3);

    private native long createWebView();

    private native void disposeWebView(long var1);

    private native void repaint(long var1);

    private native long getImage(long var1);

    private native long addDOMEventListener(long var1, long var3, String var5, boolean var6);

    private native void removeDOMEventListener(long var1, long var3, long var5, String var7, boolean var8);

    private native long registerJavaScriptJavaBridge(long var1);

    private native void unregisterJavaScriptJavaBridge(long var1, long var3);

    private native boolean print(long var1);

    public static native void removeAllCachedResponses();

    private native void runLoop(double var1);

    public void runLoop() {
        MainMessageLoop.invokeLater((Runnable)new Runnable(){

            public void run() {
                SafariEngine.this.runLoop(0.01);
            }
        });
    }

    static {
        LibraryLoader libraryLoader = Library.getDefaultLibraryLoader();
        libraryLoader.loadLibrary("jxbrowser.dylib");
        libraryLoader.loadLibrary("/System/Library/Frameworks/WebKit.framework/WebKit");
    }

    private class MyDOMEventHandler
    implements DOMEventHandler {
        private MyDOMEventHandler() {
        }

        public void handleEvent(long l, long l2) {
            DOMEvent dOMEvent = new DOMEvent(l, SafariEngine.this.domFactory);
            Event event = (Event)SafariEngine.this.domFactory.wrap(dOMEvent, Event.class);
            Collection collection = SafariEngine.this.domEventListeners.values();
            for (Set set : collection) {
                for (Map.Entry entry : set) {
                    if ((Long)entry.getValue() != l2) continue;
                    ((EventListener)entry.getKey()).handleEvent(event);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        private SimpleEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SimpleEntry simpleEntry = (SimpleEntry)object;
            if (this.key != null ? !this.key.equals(simpleEntry.key) : simpleEntry.key != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(simpleEntry.value) : simpleEntry.value != null);
        }

        @Override
        public int hashCode() {
            int n = this.key != null ? this.key.hashCode() : 0;
            n = 31 * n + (this.value != null ? this.value.hashCode() : 0);
            return n;
        }
    }
}

