/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module;

import com.elluminate.groupware.video.module.StringsProperties;
import com.elluminate.gui.FontUtils;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class VideoDisplayPanel
extends JComponent
implements ImageProducer {
    private static final long serialVersionUID = 1L;
    private static final int DISPLAY_FILMERNAME_PERCENTCOVERAGE = 0;
    private static final int DISPLAY_PREVIEWTEXT_PERCENTCOVERAGE = 100;
    private static final int DISPLAY_AVATARNAME_PERCENTCOVERAGE = 20;
    private final I18n i18n = I18n.create((Object)this);
    private final String previewText = this.i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_PREVIEWINGWATERMARK);
    private static final int BYTE_MASK = 255;
    private static final int GRN_SHIFT = 8;
    private static final int HALF_16FB = 32768;
    private static final int ONE_16FB = 65536;
    private static final int RED_SHIFT = 16;
    private static final int FRAME_TEXT_MX = 8;
    private static final int FRAME_TEXT_MY = 1;
    private static final int FRAME_TEXT_D = 1;
    private static final Color AVATARPROFILE_BOX_COLOR = new Color(96, 96, 96, 128);
    private static final Color AVATARPROFILE_COLOR = new Color(255, 255, 255, 96);
    private static final int AVATARPROFILE_BOX_ARC = 40;
    private static final Color WATERMARK_BOX_COLOR = new Color(96, 96, 96, 128);
    private static final Color WATERMARK_COLOR = new Color(255, 255, 255, 96);
    private static final int WATERMARK_BOX_ARC = 40;
    private static final int WATERMARK_BOX_MARGIN = 20;
    private static final int WATERMARK_TEXT_MARGIN = 20;
    private volatile boolean displaySizeValid = false;
    private volatile boolean awaitingPaint = false;
    private volatile Color textBackground = WATERMARK_BOX_COLOR;
    private volatile Image videoImage = null;
    private volatile String frameText = null;
    private volatile int frameTextWidth = -1;
    private volatile int frameTextAscent;
    private volatile int frameTextDescent;
    private volatile String nameText = null;
    private volatile Image nameTextImage = null;
    private volatile Image avatarPicture = null;
    private volatile Image avatarPictureImage = null;
    private ColorModel colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    private Vector<ImageConsumer> consumerVec = new Vector();
    private DisplayMode displayMode = DisplayMode.NONE;
    private int displayIndex = -1;
    private boolean displayName = true;
    private int maxWidth;
    private int maxHeight;
    private int frameWidth;
    private int frameHeight;
    private int[] framePix = new int[0];
    private int recvWidth = 1;
    private int recvHeight = 1;
    private int[] recvPix = new int[]{0};
    private Object pixelLock = new Object();

    public VideoDisplayPanel(int maxWidth, int maxHeight) {
        this.displayMode = DisplayMode.NONE;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.frameWidth = 0;
        this.frameHeight = 0;
        Dimension preferredSize = new Dimension(this.frameWidth, this.frameHeight);
        this.setPreferredSize(preferredSize);
        this.setMinimumSize(preferredSize);
        this.videoImage = this.createImage(this);
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
        this.repaint();
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayIndex(int displayIndex) {
        this.displayIndex = displayIndex;
        this.repaint();
    }

    public int getDisplayIndex() {
        return this.displayIndex;
    }

    public void setDisplayName(boolean displayName) {
        this.displayName = displayName;
        this.nameTextImage = null;
    }

    public boolean getDisplayName() {
        return this.displayName;
    }

    public void setFrameText(String text) {
        this.frameText = text;
        this.frameTextWidth = -1;
    }

    public String getFrameText() {
        return this.frameText;
    }

    public void setNameText(String text) {
        this.nameText = text;
        this.nameTextImage = null;
        this.repaint();
    }

    public String getNameText() {
        return this.nameText;
    }

    public void setAvatarPicture(Image picture) {
        this.avatarPicture = picture;
        this.avatarPictureImage = null;
        this.repaint();
    }

    public Image getAvatarPicture() {
        return this.avatarPicture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int Black = Color.black.getRGB();
        Object object = this.pixelLock;
        synchronized (object) {
            int pixelIdx = 0;
            for (int y = 0; y < this.frameHeight; ++y) {
                for (int x = 0; x < this.frameWidth; ++x) {
                    this.framePix[pixelIdx] = Black;
                    ++pixelIdx;
                }
            }
        }
        this.frameTextWidth = -1;
        this.nameTextImage = null;
        this.avatarPictureImage = null;
        this.textBackground = WATERMARK_BOX_COLOR;
        this.awaitingPaint = false;
        if (SwingUtilities.isEventDispatchThread()) {
            this.newPixels();
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    VideoDisplayPanel.this.newPixels();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeFrame(int width, int height) {
        Object object = this.pixelLock;
        synchronized (object) {
            if (width < 0 || width > this.maxWidth) {
                throw new IllegalArgumentException("resizeFrame: width = " + width);
            }
            if (height < 0 || height > this.maxHeight) {
                throw new IllegalArgumentException("resizeFrame: height = " + height);
            }
            if (this.framePix.length < width * height) {
                this.framePix = new int[width * height];
            }
            if (width == this.recvWidth && height == this.recvHeight) {
                System.arraycopy(this.recvPix, 0, this.framePix, 0, width * height);
            } else if (this.recvWidth <= width && this.recvHeight <= height) {
                this.scaleImageUp(this.recvWidth, this.recvHeight, this.recvPix, width, height, this.framePix);
            } else if (this.recvWidth >= width && this.recvHeight >= height) {
                this.scaleImageDown(this.recvWidth, this.recvHeight, this.recvPix, width, height, this.framePix);
            } else {
                throw new IllegalArgumentException("resize: Unsupported scaling: " + this.recvWidth + "x" + this.recvHeight + " -> " + width + "x" + height);
            }
        }
    }

    @Override
    public void addConsumer(ImageConsumer ic) {
        this.startProduction(ic);
    }

    @Override
    public boolean isConsumer(ImageConsumer ic) {
        return this.consumerVec.contains(ic);
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newFrame(int width, int height, int[] newPix) {
        if (this.awaitingPaint) {
            try {
                Thread.sleep(3L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (this.awaitingPaint) {
            this.textBackground = this.textBackground == WATERMARK_BOX_COLOR ? Color.orange : Color.red;
            return;
        }
        this.textBackground = WATERMARK_BOX_COLOR;
        Object object = this.pixelLock;
        synchronized (object) {
            if (width * height > this.recvPix.length) {
                this.recvPix = new int[width * height];
            }
            System.arraycopy(newPix, 0, this.recvPix, 0, width * height);
            this.recvWidth = width;
            this.recvHeight = height;
            if (width == this.frameWidth && height == this.frameHeight) {
                System.arraycopy(this.recvPix, 0, this.framePix, 0, width * height);
            } else if (width <= this.frameWidth && height <= this.frameHeight) {
                this.scaleImageUp(width, height, this.recvPix, this.frameWidth, this.frameHeight, this.framePix);
            } else if (width >= this.frameWidth && height >= this.frameHeight) {
                this.scaleImageDown(width, height, this.recvPix, this.frameWidth, this.frameHeight, this.framePix);
            } else {
                throw new IllegalArgumentException("newFrame: Unsupported scaling: " + width + "x" + height + " -> " + this.frameWidth + "x" + this.frameHeight);
            }
        }
        this.awaitingPaint = true;
        if (SwingUtilities.isEventDispatchThread()) {
            this.newPixels();
        } else {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    VideoDisplayPanel.this.newPixels();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newPixels() {
        Object object = this.pixelLock;
        synchronized (object) {
            Enumeration<ImageConsumer> e = this.consumerVec.elements();
            while (e.hasMoreElements()) {
                ImageConsumer ic = e.nextElement();
                this.sendPixels(ic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics gc) {
        if (!this.displaySizeValid) {
            this.awaitingPaint = false;
            return;
        }
        Object object = this.pixelLock;
        synchronized (object) {
            Graphics2D g2 = (Graphics2D)gc;
            String localFrameText = this.frameText;
            String localNameText = this.nameText;
            int localNameTextPercentCoverage = 0;
            Image localPicture = this.avatarPicture;
            if (this.displayMode == DisplayMode.AVATAR) {
                localNameTextPercentCoverage = 20;
            } else if (this.displayMode == DisplayMode.PREVIEWING) {
                localNameText = this.previewText;
                localNameTextPercentCoverage = 100;
            }
            if (this.displayMode == DisplayMode.AVATAR) {
                if (localPicture != null) {
                    Image localPictureImage;
                    if (this.displayIndex > 0) {
                        localNameText = null;
                    }
                    if ((localPictureImage = this.avatarPictureImage) == null) {
                        Dimension preferredSize = new Dimension(this.frameWidth, this.frameHeight);
                        this.avatarPictureImage = localPictureImage = this.createAvatarImage(localPicture, localNameText, preferredSize, localNameTextPercentCoverage);
                    }
                    g2.drawImage(localPictureImage, 0, 0, this);
                }
            } else {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.drawImage(this.videoImage, 0, 0, this.frameWidth, this.frameHeight, this);
                if (this.displayIndex > 0) {
                    localFrameText = null;
                    localNameText = null;
                }
                if (localFrameText != null) {
                    if (this.frameTextWidth == -1) {
                        FontMetrics fm = g2.getFontMetrics();
                        this.frameTextWidth = fm.stringWidth(localFrameText);
                        this.frameTextAscent = fm.getAscent();
                        this.frameTextDescent = fm.getDescent();
                    }
                    Object saveAntialiasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setColor(this.textBackground);
                    g2.fillRoundRect(1, 1, 17 + this.frameTextWidth, 3 + this.frameTextAscent + this.frameTextDescent, 16, 16);
                    g2.setColor(WATERMARK_COLOR);
                    g2.drawString(localFrameText, 9, 2 + this.frameTextAscent);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, saveAntialiasing);
                }
                if ((this.displayName || this.displayMode == DisplayMode.PREVIEWING) && localNameText != null) {
                    Image localNameImage = this.nameTextImage;
                    if (localNameImage == null) {
                        Dimension preferredSize = new Dimension(this.frameWidth, this.frameHeight);
                        this.nameTextImage = localNameImage = this.createNameImage(localNameText, preferredSize, localNameTextPercentCoverage);
                    }
                    g2.drawImage(localNameImage, 0, 0, this);
                }
            }
            this.awaitingPaint = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPanelSize(int newWidth, int newHeight, boolean displaySizeValid) {
        this.displaySizeValid = displaySizeValid;
        if (!displaySizeValid) {
            return;
        }
        if (newWidth < 1 || newWidth > this.maxWidth) {
            throw new IllegalArgumentException("newWidth = " + newWidth);
        }
        if (newHeight < 1 || newHeight > this.maxHeight) {
            throw new IllegalArgumentException("newHeight = " + newHeight);
        }
        Object object = this.pixelLock;
        synchronized (object) {
            if (newWidth == this.frameWidth && newHeight == this.frameHeight) {
                return;
            }
            this.resizeFrame(newWidth, newHeight);
            this.frameWidth = newWidth;
            this.frameHeight = newHeight;
            Dimension preferredSize = new Dimension(this.frameWidth, this.frameHeight);
            this.setPreferredSize(preferredSize);
            this.setMinimumSize(preferredSize);
            this.invalidate();
            this.videoImage.flush();
            this.videoImage = this.createImage(this);
            this.frameTextWidth = -1;
            this.nameTextImage = null;
            this.avatarPictureImage = null;
        }
    }

    private Image createNameImage(String text, Dimension size, int percentCoverage) {
        Font f;
        float marginScale = (float)size.width / 640.0f;
        if (marginScale > 1.0f) {
            marginScale = 1.0f;
        }
        int boxArc = (int)(40.0f * marginScale);
        int boxMargin = (int)(20.0f * marginScale);
        int textMargin = (int)(20.0f * marginScale);
        BufferedImage bim = new BufferedImage(size.width, size.height, 2);
        Graphics2D g = bim.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (percentCoverage > 0) {
            f = FontUtils.setFontStyleAndSize(null, (int)1, (int)36);
            Dimension s = new Dimension(size.width - 2 * boxMargin - 2 * textMargin, (size.height - 2 * boxMargin - 2 * textMargin) * percentCoverage / 100);
            f = FontUtils.getAdjustedFont((String)text, (Font)f, (Dimension)s, (Component)this);
        } else {
            boxArc = 16;
            f = FontUtils.setFontStyle(null, (int)1);
        }
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        int boxh = fm.getHeight();
        int boxw = fm.stringWidth(text) + 2 * textMargin;
        Rectangle box = new Rectangle((size.width - boxw) / 2, size.height - boxMargin - boxh, boxw, boxh);
        int x = box.x + (box.width - fm.stringWidth(text)) / 2;
        int y = box.y + (box.height - fm.getAscent() - fm.getDescent()) / 2 + fm.getAscent();
        g.setColor(WATERMARK_BOX_COLOR);
        g.fillRoundRect(box.x, box.y, box.width, box.height, boxArc, boxArc);
        g.setColor(WATERMARK_COLOR);
        g.drawString(text, x, y);
        g.dispose();
        return bim;
    }

    private Image createAvatarImage(Image picture, String name, Dimension size, int percentCoverage) {
        float marginScale = (float)size.width / 640.0f;
        if (marginScale > 1.0f) {
            marginScale = 1.0f;
        }
        int boxArc = (int)(40.0f * marginScale);
        boolean outsideMargin = false;
        int insideMargin = 7;
        int avatarMargin = 7;
        int textHeight = 32;
        BufferedImage bim = new BufferedImage(size.width, size.height, 2);
        Graphics2D g = bim.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean haveName = false;
        Rectangle namebox = new Rectangle(0, 0, 0, 0);
        int namex = 0;
        int namey = 0;
        if (name != null) {
            Font f = FontUtils.setFontStyleAndSize(null, (int)1, (int)36);
            int height = 32;
            boxArc = boxArc * 12 / height;
            Dimension s = new Dimension(size.width - 0 - 14, height);
            f = FontUtils.getAdjustedFont((String)name, (Font)f, (Dimension)s, (Component)this);
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            int nameboxw = fm.stringWidth(name) + 14;
            int nameboxh = fm.getHeight();
            namebox = new Rectangle(0, 0, nameboxw, nameboxh);
            namex = namebox.x + (namebox.width - fm.stringWidth(name)) / 2;
            namey = namebox.y + (namebox.height - fm.getAscent() - fm.getDescent()) / 2 + fm.getAscent();
            haveName = true;
        }
        int avatarWidth = picture.getWidth(null);
        int avatarHeight = picture.getHeight(null);
        if (haveName) {
            float scaleY;
            int framingBoxWidth = avatarWidth + 14;
            int framingBoxHeight = avatarHeight + 14;
            float scaleX = (float)framingBoxWidth / (float)size.width;
            if (scaleX < 1.0f) {
                scaleX = 1.0f;
            }
            if ((scaleY = (float)framingBoxHeight / (float)(size.height - namebox.height)) < 1.0f) {
                scaleY = 1.0f;
            }
            float scale = scaleX > scaleY ? scaleX : scaleY;
            int scaledFramingBoxWidth = (int)((double)((float)framingBoxWidth / scale) + 0.5);
            int scaledFramingBoxHeight = (int)((double)((float)framingBoxHeight / scale) + 0.5);
            Rectangle framingBox = new Rectangle(0, 0, scaledFramingBoxWidth, scaledFramingBoxHeight);
            int frameToAvatarOffsetX = framingBox.x + 7;
            int frameToAvatarOffsetY = framingBox.y + 7;
            int scaledAvatarWidth = scaledFramingBoxWidth - 14;
            int scaledAvatarHeight = scaledFramingBoxHeight - 14;
            Rectangle unionBox = new Rectangle(0, 0, framingBox.width > namebox.width ? framingBox.width : namebox.width, framingBox.height + namebox.height);
            int unionToFrameOffsetX = (unionBox.width - framingBox.width) / 2;
            int unionToFrameOffsetY = 0;
            int unionToNameOffsetX = (unionBox.width - namebox.width) / 2;
            int unionToNameOffsetY = framingBox.height;
            int componentToUnionOffsetX = (size.width - unionBox.width) / 2;
            int componentToUnionOffsetY = (size.height - unionBox.height) / 2;
            if (componentToUnionOffsetY < 0) {
                componentToUnionOffsetY = 0;
            }
            g.setColor(AVATARPROFILE_BOX_COLOR);
            g.fillRoundRect(namebox.x + componentToUnionOffsetX + unionToNameOffsetX, namebox.y + componentToUnionOffsetY + unionToNameOffsetY, namebox.width, namebox.height, boxArc, boxArc);
            g.fillRect(framingBox.x + componentToUnionOffsetX + unionToFrameOffsetX, framingBox.y + componentToUnionOffsetY + unionToFrameOffsetY, framingBox.width, framingBox.height);
            g.setColor(AVATARPROFILE_COLOR);
            g.drawString(name, namex + componentToUnionOffsetX + unionToNameOffsetX, namey + componentToUnionOffsetY + unionToNameOffsetY);
            g.drawImage(picture, frameToAvatarOffsetX + componentToUnionOffsetX + unionToFrameOffsetX, frameToAvatarOffsetY + componentToUnionOffsetY + unionToFrameOffsetY, frameToAvatarOffsetX + componentToUnionOffsetX + unionToFrameOffsetX + scaledAvatarWidth, frameToAvatarOffsetY + componentToUnionOffsetY + unionToFrameOffsetY + scaledAvatarHeight, 0, 0, avatarWidth, avatarHeight, null);
        } else {
            float scaleY;
            float scaleX = (float)avatarWidth / (float)size.width;
            if (scaleX < 1.0f) {
                scaleX = 1.0f;
            }
            if ((scaleY = (float)avatarHeight / (float)size.height) < 1.0f) {
                scaleY = 1.0f;
            }
            float scale = scaleX > scaleY ? scaleX : scaleY;
            int scaledPictureWidth = (int)((double)((float)avatarWidth / scale) + 0.5);
            int scaledPictureHeight = (int)((double)((float)avatarHeight / scale) + 0.5);
            int offsetX = (int)((double)(size.width - scaledPictureWidth) / 2.0 + 0.5);
            int offsetY = (int)((double)(size.height - scaledPictureHeight) / 2.0 + 0.5);
            g.setColor(AVATARPROFILE_COLOR);
            g.drawImage(picture, offsetX, offsetY, offsetX + scaledPictureWidth, offsetY + scaledPictureHeight, 0, 0, avatarWidth, avatarHeight, null);
        }
        g.dispose();
        return bim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startProduction(ImageConsumer ic) {
        if (this.consumerVec.contains(ic)) {
            return;
        }
        this.consumerVec.addElement(ic);
        Object object = this.pixelLock;
        synchronized (object) {
            block10: {
                try {
                    if (this.isConsumer(ic)) {
                        ic.setDimensions(this.frameWidth, this.frameHeight);
                    }
                    if (this.isConsumer(ic)) {
                        ic.setColorModel(this.colorModel);
                    }
                    if (this.isConsumer(ic)) {
                        ic.setHints(14);
                    }
                    if (this.isConsumer(ic)) {
                        this.sendPixels(ic);
                    }
                }
                catch (Exception e) {
                    if (!this.isConsumer(ic)) break block10;
                    ic.imageComplete(1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPixels(ImageConsumer ic) {
        Object object = this.pixelLock;
        synchronized (object) {
            if (this.isConsumer(ic)) {
                ic.setPixels(0, 0, this.frameWidth, this.frameHeight, this.colorModel, this.framePix, 0, this.frameWidth);
            }
            if (this.isConsumer(ic)) {
                ic.imageComplete(2);
            }
        }
    }

    @Override
    public void removeConsumer(ImageConsumer ic) {
        this.consumerVec.removeElement(ic);
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    private void scaleImageDown(int srcWidth, int srcHeight, int[] srcPix, int resWidth, int resHeight, int[] resPix) {
        if (srcWidth < resWidth || srcHeight < resHeight) {
            throw new IllegalArgumentException("Invalid scale factor");
        }
        int resHeightM1 = resHeight - 1;
        int resWidthM1 = resWidth - 1;
        int srcHeightM1 = srcHeight - 1;
        int srcWidthM1 = srcWidth - 1;
        int srcWidthXsrcHeight = srcWidth * srcHeight;
        int twoXsrcWidthXsrcHeight = 2 * srcWidthXsrcHeight;
        int resPixIdx = 0;
        int resRowXsrcHeight = 0;
        for (int resRow = 0; resRow < resHeight; ++resRow) {
            int firstSrcRow = resRowXsrcHeight / resHeight;
            int firstSrcRowOff = firstSrcRow * srcWidth;
            int firstSrcRowWt = resHeight - resRowXsrcHeight % resHeight;
            int lastSrcRow = (resRowXsrcHeight + srcHeightM1) / resHeight;
            int lastSrcRowWt = (srcHeight - firstSrcRowWt + resHeightM1) % resHeight + 1;
            int resColXsrcWidth = 0;
            for (int resCol = 0; resCol < resWidth; ++resCol) {
                int accumBlu = 0;
                int accumGrn = 0;
                int accumRed = 0;
                int firstSrcCol = resColXsrcWidth / resWidth;
                int firstSrcColWt = resWidth - resColXsrcWidth % resWidth;
                int lastSrcCol = (resColXsrcWidth + srcWidthM1) / resWidth;
                int lastSrcColWt = (srcWidth - firstSrcColWt + resWidthM1) % resWidth + 1;
                int srcRowOff = firstSrcRowOff;
                int srcRowWt = firstSrcRowWt;
                for (int srcRow = firstSrcRow; srcRow <= lastSrcRow; ++srcRow) {
                    if (srcRow == lastSrcRow) {
                        srcRowWt = lastSrcRowWt;
                    }
                    int srcColWt = firstSrcColWt;
                    int srcPixIdx = srcRowOff + firstSrcCol;
                    srcRowOff += srcWidth;
                    for (int srcCol = firstSrcCol; srcCol <= lastSrcCol; ++srcCol) {
                        if (srcCol == lastSrcCol) {
                            srcColWt = lastSrcColWt;
                        }
                        int pixel = srcPix[srcPixIdx++];
                        int pixelWt = srcColWt * srcRowWt;
                        accumBlu += pixelWt * (pixel & 0xFF);
                        accumGrn += pixelWt * (pixel >> 8 & 0xFF);
                        accumRed += pixelWt * (pixel >> 16 & 0xFF);
                        srcColWt = resWidth;
                    }
                    srcRowWt = resHeight;
                }
                int blu = (accumBlu + accumBlu + srcWidthXsrcHeight) / twoXsrcWidthXsrcHeight;
                int grn = (accumGrn + accumGrn + srcWidthXsrcHeight) / twoXsrcWidthXsrcHeight;
                int red = (accumRed + accumRed + srcWidthXsrcHeight) / twoXsrcWidthXsrcHeight;
                resPix[resPixIdx++] = blu + (grn << 8) + (red << 16);
                resColXsrcWidth += srcWidth;
            }
            resRowXsrcHeight += srcHeight;
        }
    }

    private void scaleImageUp(int srcWidth, int srcHeight, int[] srcPix, int resWidth, int resHeight, int[] resPix) {
        int resBottomOff;
        if (srcWidth > resWidth || srcHeight > resHeight) {
            throw new IllegalArgumentException("Invalid scale factor");
        }
        int resHeightMinus1 = resHeight - 1;
        int resHeightMinus1Recip_16FB = 65536 / resHeightMinus1;
        int resWidthMinus1 = resWidth - 1;
        int resWidthMinus1Recip_16FB = 65536 / resWidthMinus1;
        int srcHeightMinus1 = srcHeight - 1;
        int srcWidthMinus1 = srcWidth - 1;
        int resRowOff = resBottomOff = resWidth * (resHeight - srcHeight);
        int srcRowOff = 0;
        for (int row = 0; row < srcHeight; ++row) {
            int srcRight = srcPix[srcRowOff++];
            int weightLeft = srcWidthMinus1;
            int bluLeft = 0;
            int grnLeft = 0;
            int redLeft = 0;
            int bluRight = srcRight & 0xFF;
            int grnRight = srcRight >> 8 & 0xFF;
            int redRight = srcRight >> 16 & 0xFF;
            for (int c = 0; c < resWidth; ++c) {
                if ((weightLeft -= srcWidthMinus1) < 0) {
                    bluLeft = bluRight;
                    grnLeft = grnRight;
                    redLeft = redRight;
                    srcRight = srcPix[srcRowOff++];
                    bluRight = srcRight & 0xFF;
                    grnRight = srcRight >> 8 & 0xFF;
                    redRight = srcRight >> 16 & 0xFF;
                    weightLeft += resWidthMinus1;
                }
                int weightRight = resWidthMinus1 - weightLeft;
                int blu = resWidthMinus1Recip_16FB * (weightLeft * bluLeft + weightRight * bluRight) + 32768 >> 16;
                int grn = resWidthMinus1Recip_16FB * (weightLeft * grnLeft + weightRight * grnRight) + 32768 >> 16;
                int red = resWidthMinus1Recip_16FB * (weightLeft * redLeft + weightRight * redRight) + 32768 >> 16;
                resPix[resRowOff++] = (red << 16) + (grn << 8) + blu;
            }
        }
        for (int col = 0; col < resWidth; ++col) {
            int resColOff = col;
            int srcColOff = col + resBottomOff;
            int srcBelow = resPix[srcColOff];
            int weightAbove = srcHeightMinus1;
            int bluAbove = 0;
            int grnAbove = 0;
            int redAbove = 0;
            int bluBelow = srcBelow & 0xFF;
            int grnBelow = srcBelow >> 8 & 0xFF;
            int redBelow = srcBelow >> 16 & 0xFF;
            for (int r = 0; r < resHeightMinus1; ++r) {
                if ((weightAbove -= srcHeightMinus1) < 0) {
                    bluAbove = bluBelow;
                    grnAbove = grnBelow;
                    redAbove = redBelow;
                    srcBelow = resPix[srcColOff += resWidth];
                    bluBelow = srcBelow & 0xFF;
                    grnBelow = srcBelow >> 8 & 0xFF;
                    redBelow = srcBelow >> 16 & 0xFF;
                    weightAbove += resHeightMinus1;
                }
                int weightBelow = resHeightMinus1 - weightAbove;
                int blu = resHeightMinus1Recip_16FB * (weightAbove * bluAbove + weightBelow * bluBelow) + 32768 >> 16;
                int grn = resHeightMinus1Recip_16FB * (weightAbove * grnAbove + weightBelow * grnBelow) + 32768 >> 16;
                int red = resHeightMinus1Recip_16FB * (weightAbove * redAbove + weightBelow * redBelow) + 32768 >> 16;
                resPix[resColOff] = (red << 16) + (grn << 8) + blu;
                resColOff += resWidth;
            }
        }
    }

    public static enum DisplayMode {
        NONE,
        PREVIEWING,
        FILMING,
        AVATAR;

    }

    public static class VideoDisplayPanelInfo {
        private String frameText;
        private String nameText;
        private Image avatarPicture;
        private int displayIndex;
        private DisplayMode displayMode;
        private boolean displayName;
        private short filmerAddr;

        public void getViewDisplayPanelInfo(VideoDisplayPanel view, short filmerAddr) {
            this.frameText = view.getFrameText();
            this.nameText = view.getNameText();
            this.avatarPicture = view.getAvatarPicture();
            this.displayIndex = view.getDisplayIndex();
            this.displayMode = view.getDisplayMode();
            this.displayName = view.getDisplayName();
            this.filmerAddr = filmerAddr;
        }

        public short setViewDisplayPanelInfo(VideoDisplayPanel view) {
            view.setFrameText(this.frameText);
            view.setNameText(this.nameText);
            view.setAvatarPicture(this.avatarPicture);
            view.setDisplayIndex(this.displayIndex);
            view.setDisplayMode(this.displayMode);
            view.setDisplayName(this.displayName);
            return this.filmerAddr;
        }
    }
}

