/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware;

import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.PropertyAccessController;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;

public class PropertyACL
implements PropertyAccessController {
    public static final int OWNER = -100000;
    public static final int CHAIR = -100001;
    public static final PropertyACL ServerACL = new PropertyACL();
    public static final PropertyACL ChairACL = new PropertyACL(-100001);
    public static final PropertyACL OwnerACL = new PropertyACL(-100000);
    private int[] allowed = new int[0];

    public PropertyACL() {
    }

    public PropertyACL(int a0) {
        this.allowed = new int[1];
        this.allowed[0] = a0;
    }

    public PropertyACL(int a0, int a1) {
        this.allowed = new int[2];
        this.allowed[0] = a0;
        this.allowed[1] = a1;
    }

    public PropertyACL(int a0, int a1, int a2) {
        this.allowed = new int[1];
        this.allowed[0] = a0;
        this.allowed[1] = a1;
        this.allowed[2] = a2;
    }

    public boolean propertyChangeAllowed(short from, PropertyChangeEvent e) {
        if (from == 0) {
            return true;
        }
        block4: for (int i = 0; i < this.allowed.length; ++i) {
            switch (this.allowed[i]) {
                case -100000: {
                    if (!this.checkOwner(from, e)) continue block4;
                    return true;
                }
                case -100001: {
                    if (!this.checkChair(from, e)) continue block4;
                    return true;
                }
                default: {
                    if (from != this.allowed[i]) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    private ClientList getClientList(Object src) {
        if (src instanceof ClientList) {
            return (ClientList)src;
        }
        if (src instanceof ClientInfo) {
            return ((ClientInfo)src).getClientList();
        }
        if (src instanceof ClientGroup) {
            return ((ClientGroup)src).getClientList();
        }
        return null;
    }

    private boolean checkChair(short addr, PropertyChangeEvent e) {
        ClientList clients = this.getClientList(e.getSource());
        Chair chair = ChairProtocol.getChair(clients);
        return chair.contains(addr);
    }

    private boolean checkOwner(short addr, PropertyChangeEvent e) {
        boolean allow = false;
        try {
            ClientInfo ci = (ClientInfo)e.getSource();
            allow = addr == ci.getAddress();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"checkOwner", (Throwable)ex, (boolean)true);
        }
        return allow;
    }
}

