/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware;

import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.PropertyChangeSet;
import com.elluminate.jinx.PropertyValue;
import com.elluminate.util.log.LogSupport;
import java.util.Iterator;

public class Chair
implements Iterable<ClientInfo> {
    Connection connection = null;
    ClientList clients = null;
    short[] list = null;
    String prop = null;

    Chair(Connection theConnection, String property) {
        this.connection = theConnection;
        this.prop = property;
        if (this.connection == null) {
            this.clients = new ClientList();
        } else {
            this.clients = this.connection.getClientList();
            this.list = (short[])this.clients.getProperty(this.prop);
        }
        if (this.list == null) {
            this.list = new short[0];
        }
        this.validate();
    }

    public Chair(Connection theConnection, Object obj) {
        this.connection = theConnection;
        this.prop = null;
        if (this.connection == null) {
            this.clients = new ClientList();
            this.list = null;
        } else {
            this.clients = this.connection.getClientList();
            try {
                this.list = (short[])obj;
            }
            catch (Exception ex) {
                this.list = null;
            }
        }
        if (this.list == null) {
            this.list = new short[0];
        }
    }

    public boolean isMe() {
        if (this.connection == null) {
            return false;
        }
        return this.contains(this.connection.getAddress());
    }

    public boolean contains(short addr) {
        if (addr == -32767) {
            return false;
        }
        for (int i = 0; i < this.list.length; ++i) {
            if (addr != this.list[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(ClientInfo[] who) {
        if (who == null) {
            return false;
        }
        for (int ix = 0; ix < who.length; ++ix) {
            if (who[ix] == null || !this.contains(who[ix].getAddress())) continue;
            return true;
        }
        return false;
    }

    public boolean containsEvery(ClientInfo[] who) {
        if (who == null) {
            return false;
        }
        for (int ix = 0; ix < who.length; ++ix) {
            if (who[ix] == null) {
                return false;
            }
            if (this.contains(who[ix].getAddress())) continue;
            return false;
        }
        return true;
    }

    public short[] getAddresses() {
        return this.list;
    }

    public int getCount() {
        return this.list.length;
    }

    public ClientInfo[] getClients() {
        ClientInfo[] info = new ClientInfo[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            info[i] = this.clients.get(this.list[i]);
        }
        return info;
    }

    public void add(short addr) {
        ClientInfo ci = this.clients.get(addr);
        if (ci == null) {
            return;
        }
        if (ci.getProperty("chair.role", false)) {
            return;
        }
        ci.setProperty("chair.role", true);
    }

    public void add(ClientInfo[] who) {
        if (this.connection == null) {
            return;
        }
        PropertyChangeSet cset = this.connection.getPropertyChangeSet();
        for (ClientInfo ci : who) {
            if (ci.getProperty("chair.role", false)) continue;
            ci.setProperty(cset, "chair.role", true);
        }
        cset.commit();
    }

    public void remove(short addr) {
        ClientInfo ci = this.clients.get(addr);
        if (ci == null) {
            return;
        }
        if (!ci.getProperty("chair.role", false)) {
            return;
        }
        ci.setProperty("chair.role", false);
    }

    public void remove(ClientInfo[] who) {
        if (this.connection == null) {
            return;
        }
        PropertyChangeSet cset = this.connection.getPropertyChangeSet();
        for (ClientInfo ci : who) {
            if (!ci.getProperty("chair.role", false)) continue;
            ci.setProperty(cset, "chair.role", false);
        }
        cset.commit();
    }

    public boolean isEmpty() {
        return this.list.length == 0;
    }

    @Override
    public Iterator<ClientInfo> iterator() {
        return new Iterator<ClientInfo>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < Chair.this.list.length;
            }

            @Override
            public ClientInfo next() {
                return Chair.this.clients.get(Chair.this.list[this.idx++]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void validate() {
        if (this.prop == null) {
            return;
        }
        if (this.connection == null) {
            return;
        }
        if (this.connection.getAddress() != 0) {
            return;
        }
        ClientList clients = this.connection.getClientList();
        int shift = 0;
        for (int i = 0; i < this.list.length; ++i) {
            ClientInfo ci = clients.get(this.list[i]);
            if (ci == null) {
                LogSupport.error((Object)this, (String)"validate", (String)("Removing bogus " + this.prop + " entry " + this.list[i]));
                ++shift;
                continue;
            }
            if (shift <= 0) continue;
            this.list[i - shift] = this.list[i];
        }
        if (shift > 0) {
            short[] newList = new short[this.list.length - shift];
            System.arraycopy(this.list, 0, newList, 0, newList.length);
            this.list = newList;
            clients.setProperty(this.prop, new PropertyValue(this.list));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Chair (" + this.prop + ")");
        if (this.list.length == 0) {
            buf.append(", no chairs");
        } else {
            for (int i = 0; i < this.list.length; ++i) {
                buf.append(", " + this.list[i]);
            }
        }
        return buf.toString();
    }
}

