/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.client;

import com.elluminate.classroom.client.BrandingI18nProvider;
import com.elluminate.classroom.client.StringsProperties;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;

@Singleton
public class AudioVideoPrefsOwner
implements PreferencesPanelOwner {
    private static final int MAX_SIZE = 16;
    private BrandingI18nProvider branding;
    private I18n i18n;
    private ImageIcon icon;
    private boolean mentionVideo = false;

    @Inject
    public void initBranding(BrandingI18nProvider prov) {
        this.branding = prov;
    }

    @Inject
    public void initI18n(I18nProvider prov) {
        this.i18n = prov.get((Object)this);
    }

    public String getPrefix() {
        return "audioVideo";
    }

    public String getTitle() {
        if (this.mentionVideo) {
            return this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOVIDEOPREFSOWNER_TITLE);
        }
        return this.i18n.getString((PropertiesEnum)StringsProperties.AUDIOVIDEOPREFSOWNER_TITLEWITHOUTVIDEO);
    }

    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        this.icon = this.i18n.getIcon((PropertiesEnum)StringsProperties.AUDIOVIDEOPREFSOWNER_ICON);
        Image img = this.icon.getImage();
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        if (height > 16 || width > 16) {
            if (height > width) {
                width = (int)((float)width / (float)height * 16.0f);
                height = 16;
            } else {
                height = (int)((float)height / (float)width * 16.0f);
                width = 16;
            }
            img = img.getScaledInstance(width, height, 4);
            this.icon = new ImageIcon(img);
        }
        return this.icon;
    }

    public void mentionVideo() {
        this.mentionVideo = true;
    }
}

