/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.classroom.client.messaging.ExtraInfo;
import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.groupware.quiz.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class QuizPublisher {
    private final String UNIQUE_NAME = "QuizPublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    public static final String QUIZ_STARTED = "quiz-started";
    public static final String QUIZ_STOPPED = "quiz-stopped";
    public static final String QUIZ_HANDED_IN = "quiz-handed-in";
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private String modName;
    private String modDisplayName;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public QuizPublisher(MessagePublisher pub, MessagePublisherMetadata meta, MessageRouter rtr, I18n localization, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.metadata = meta;
        this.router = rtr;
        this.i18n = localization;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.QUIZPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    public void sendQuizStartedMessage(String message, boolean isMe) {
        this.sendRouterMsg(message, this.msgTypes.get(QUIZ_STARTED), isMe);
    }

    public void sendQuizStoppedMessage(String message, boolean isMe) {
        this.sendRouterMsg(message, this.msgTypes.get(QUIZ_STOPPED), isMe);
    }

    public void sendQuizHandedInMessage(String message, boolean isMe) {
        this.sendRouterMsg(message, this.msgTypes.get(QUIZ_HANDED_IN), isMe);
    }

    private void sendRouterMsg(String message, MessageType type, String who, boolean isMe) {
        ExtraInfo info = new ExtraInfo();
        info.setHeader(who);
        this.publisher.sendMessageWithExtraInfo(message, info, type, isMe);
    }

    private void sendRouterMsg(String message, MessageType type, boolean isMe) {
        this.publisher.sendTextMessage(message, type, isMe);
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("QuizPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(QUIZ_STARTED, new MessageType(QUIZ_STARTED, this.i18n.getString((PropertiesEnum)StringsProperties.QUIZPUBLISHER_TYPE_QUIZ_STARTED), 5));
        this.msgTypes.put(QUIZ_STOPPED, new MessageType(QUIZ_STOPPED, this.i18n.getString((PropertiesEnum)StringsProperties.QUIZPUBLISHER_TYPE_QUIZ_STOPPED), 5));
        this.msgTypes.put(QUIZ_HANDED_IN, new MessageType(QUIZ_HANDED_IN, this.i18n.getString((PropertiesEnum)StringsProperties.QUIZPUBLISHER_TYPE_QUIZ_HANDED_IN), 5));
    }
}

