/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.participant;

import com.elluminate.classroom.swing.participant.ParticipantList;
import com.elluminate.classroom.swing.participant.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.UIManager;

class SeparatorRenderer
extends ParticipantList.Renderer {
    private I18n i18n = I18n.create((Object)this);

    public SeparatorRenderer() {
        this.setPreferredSize(new Dimension(0, 7));
    }

    @Override
    protected void paintComponent(Graphics g) {
        int y = this.getHeight() / 2;
        g.setColor(UIManager.getColor("Participant.separatorColor"));
        g.drawLine(5, y, this.getWidth() - 5, y);
    }

    @Override
    public void prepare(JList list, Object value, int index, boolean selected, boolean focused, boolean hovered, boolean pressed, Point hoverLocation, boolean hasOptions) {
        this.updateAccessibleInfo(index);
    }

    private void updateAccessibleInfo(int index) {
        this.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.SEPARATOR_RENDERER_AX_NAME, new Object[]{"" + index}));
    }

    @Override
    public Rectangle getOptionsBounds(int row) {
        return null;
    }

    @Override
    public Rectangle getDeviceBounds(int row) {
        return null;
    }

    @Override
    public Rectangle getExpandBounds(int row) {
        return null;
    }

    @Override
    String getPermissionClicked(int row, Point location) {
        return null;
    }

    @Override
    public void clickPermission(String permission, int row) {
    }
}

