/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.participant;

import com.elluminate.classroom.swing.participant.ParticipantList;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermissionStore;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.util.LightweightTimer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.AbstractListModel;
import javax.swing.JSeparator;

class ParticipantListModel
extends AbstractListModel {
    public static final int SORT_NAME = 1;
    public static final int SORT_HAND = 2;
    private final Map<CRPermissionStore, ParticipantState> entireSet = new HashMap<CRPermissionStore, ParticipantState>();
    private final List<Object> visibleList = new LinkedList<Object>();
    private Map<CRRoom, Boolean> expandedRooms = new HashMap<CRRoom, Boolean>();
    private int sortKey = 2;
    private final LinkedBlockingQueue<ParticipantJobData> jobQueue = new LinkedBlockingQueue();
    private final LightweightTimer jobTimer = new LightweightTimer(2, (Runnable)new ParticipantModelUpdateTask());
    private static final int DELAY_BETWEEN_JOBS = 3;
    private static final int MAX_COUNTER_TO_STOP_TIMER = 3;
    private int counterToStopTimer = 0;
    private ParticipantList participantList = null;
    private Object[] selectedValues = null;

    public synchronized void add(CRParticipant participant) {
        this.entireSet.put((CRPermissionStore)participant, new ParticipantState());
        if (this.isVisible((CRPermissionStore)participant)) {
            this.addToVisibleList((CRPermissionStore)participant);
        }
    }

    public synchronized void add(CRRoom room, boolean expanded) {
        this.entireSet.put((CRPermissionStore)room, null);
        this.expandedRooms.put(room, expanded);
        this.addToVisibleList((CRPermissionStore)room);
    }

    public synchronized void remove(CRParticipant participant) {
        this.entireSet.remove(participant);
        this.removeFromVisibleList((CRPermissionStore)participant);
    }

    public synchronized void remove(CRRoom room) {
        this.entireSet.remove(room);
        this.expandedRooms.remove(room);
        this.removeFromVisibleList((CRPermissionStore)room);
    }

    public ParticipantList getParticipantList() {
        return this.participantList;
    }

    public void setParticipantList(ParticipantList participantList) {
        this.participantList = participantList;
    }

    public void clearSelection() {
        this.selectedValues = null;
    }

    public int rowOf(CRParticipant participant) {
        return this.visibleList.indexOf(participant);
    }

    public int rowOf(CRRoom room) {
        return this.visibleList.indexOf(room);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CRParticipant participant, boolean visibility) {
        if (visibility) {
            if (this.entireSet.containsKey(participant)) {
                CRRoom r;
                this.updateVisibleList((CRPermissionStore)participant);
                if (participant.isMe() && (r = participant.getRoom()) != null && !r.isMain() && !this.isRoomExpanded(r)) {
                    this.setRoomExpanded(r, true);
                }
            }
        } else {
            List<Object> list = this.visibleList;
            synchronized (list) {
                int index = this.visibleList.indexOf(participant);
                if (index != -1) {
                    this.fireContentsChanged(this, index, index);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CRRoom room, boolean visibility) {
        block8: {
            block7: {
                if (!visibility) break block7;
                if (!this.entireSet.containsKey(room)) break block8;
                ArrayList<CRParticipant> ps = new ArrayList<CRParticipant>();
                if (this.isRoomExpanded(room)) {
                    Iterator itr = room.getParticipantIterator();
                    while (itr.hasNext()) {
                        CRParticipant p = (CRParticipant)itr.next();
                        ps.add(p);
                        this.visibleList.remove(p);
                    }
                }
                this.updateVisibleList((CRPermissionStore)room);
                for (CRParticipant p : ps) {
                    this.addToVisibleList((CRPermissionStore)p);
                }
                break block8;
            }
            List<Object> list = this.visibleList;
            synchronized (list) {
                int index = this.visibleList.indexOf(room);
                if (index != -1) {
                    this.fireContentsChanged(this, index, index);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLastVisibleEntityInRoom(Object thing) {
        if (!(thing instanceof CRParticipant) && !(thing instanceof CRRoom)) {
            return false;
        }
        List<Object> list = this.visibleList;
        synchronized (list) {
            Object prevObject = null;
            for (Object obj : this.visibleList) {
                if (obj instanceof CRRoom && prevObject == thing) {
                    return true;
                }
                prevObject = obj;
            }
            return prevObject == thing;
        }
    }

    public boolean isRoomExpanded(CRRoom room) {
        if (this.expandedRooms.containsKey(room)) {
            return this.expandedRooms.get(room);
        }
        return true;
    }

    public synchronized void setRoomExpanded(CRRoom room, boolean expanded) {
        this.expandedRooms.put(room, expanded);
        if (room.getNumberOfParticipants() > 0) {
            Iterator itr = room.getParticipantIterator();
            while (itr.hasNext()) {
                this.updateVisibleList((CRPermissionStore)itr.next());
            }
        }
    }

    public int getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(int sortKey) {
        this.sortKey = sortKey;
        this.updateVisibleList();
    }

    private void addToVisibleList(CRPermissionStore object) {
        try {
            ParticipantJobData job = new ParticipantJobData(object, 0);
            this.jobQueue.put(job);
            if (!this.jobTimer.isScheduled()) {
                this.jobTimer.scheduleEvery(3L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void removeFromVisibleList(CRPermissionStore object) {
        try {
            ParticipantJobData job = new ParticipantJobData(object, 1);
            this.jobQueue.put(job);
            if (!this.jobTimer.isScheduled()) {
                this.jobTimer.scheduleEvery(3L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void updateVisibleList() {
        Iterator<CRPermissionStore> itr = this.entireSet.keySet().iterator();
        while (itr.hasNext()) {
            this.updateVisibleList(itr.next());
        }
    }

    private void updateVisibleList(CRPermissionStore object) {
        if (this.isVisible(object)) {
            this.addToVisibleList(object);
        } else {
            this.removeFromVisibleList(object);
        }
    }

    private boolean isVisible(CRPermissionStore object) {
        if (object instanceof CRRoom) {
            return true;
        }
        CRRoom r = ((CRParticipant)object).getRoom();
        if (r == null) {
            return true;
        }
        return this.isRoomExpanded(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        List<Object> list = this.visibleList;
        synchronized (list) {
            return this.visibleList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getElementAt(int index) {
        List<Object> list = this.visibleList;
        synchronized (list) {
            return this.visibleList.get(index);
        }
    }

    private int compare(CRPermissionStore object1, CRPermissionStore object2) {
        if (object1 instanceof CRRoom && object2 instanceof CRRoom) {
            CRRoom r1 = (CRRoom)object1;
            CRRoom r2 = (CRRoom)object2;
            return this.compareRooms(r1, r2);
        }
        if (object1 instanceof CRParticipant && object2 instanceof CRParticipant) {
            CRRoom r2;
            CRParticipant p1 = (CRParticipant)object1;
            CRParticipant p2 = (CRParticipant)object2;
            CRRoom r1 = this.entireSet.get(p1) != null ? this.entireSet.get((Object)p1).room : null;
            CRRoom cRRoom = r2 = this.entireSet.get(p2) != null ? this.entireSet.get((Object)p2).room : null;
            if (r1 == r2) {
                return this.compareParticipants(p1, p2);
            }
            if (r1 == null && r2 != null && r2.isMain()) {
                return this.compareParticipants(p1, p2);
            }
            return this.compareRooms(r1, r2);
        }
        if (object1 instanceof CRRoom) {
            CRRoom r2;
            CRRoom r1 = (CRRoom)object1;
            CRParticipant p2 = (CRParticipant)object2;
            CRRoom cRRoom = r2 = this.entireSet.get(p2) != null ? this.entireSet.get((Object)p2).room : null;
            if (r1 == r2) {
                return -1;
            }
            return this.compareRooms(r1, r2);
        }
        if (object1 instanceof CRParticipant) {
            CRRoom r2;
            CRParticipant p1 = (CRParticipant)object1;
            CRRoom r1 = this.entireSet.get(p1) != null ? this.entireSet.get((Object)p1).room : null;
            if (r1 == (r2 = (CRRoom)object2)) {
                return 1;
            }
            return this.compareRooms(r1, r2);
        }
        return 0;
    }

    private int compareRooms(CRRoom room1, CRRoom room2) {
        String name2;
        String name1 = room1 != null ? room1.getName() : null;
        String string = name2 = room2 != null ? room2.getName() : null;
        if (name1 != null && name2 != null) {
            return name1.compareToIgnoreCase(name2);
        }
        if (name1 == null && name2 == null) {
            return 0;
        }
        if (name1 != null) {
            return 1;
        }
        return -1;
    }

    private int compareParticipants(CRParticipant participant1, CRParticipant participant2) {
        ParticipantState st1 = this.entireSet.get(participant1);
        ParticipantState st2 = this.entireSet.get(participant2);
        if (st1 != null && st2 == null) {
            return -1;
        }
        if (st1 == null && st2 != null) {
            return 1;
        }
        if (st1 == null && st2 == null) {
            return 0;
        }
        if (st1.chair && !st2.chair) {
            return -1;
        }
        if (!st1.chair && st2.chair) {
            return 1;
        }
        String part1Name = participant1.getName();
        String part2Name = participant2.getName();
        if (part1Name.startsWith("Teleconference#")) {
            return -1;
        }
        if (part2Name.startsWith("Teleconference#")) {
            return 1;
        }
        switch (this.sortKey) {
            case 1: {
                return this.compareNames(participant1, participant2);
            }
            case 2: {
                return this.compareHands(participant1, participant2);
            }
        }
        return 0;
    }

    private int compareNames(CRParticipant participant1, CRParticipant participant2) {
        return participant1.getDisplayName().compareToIgnoreCase(participant2.getDisplayName());
    }

    private int compareHands(CRParticipant participant1, CRParticipant participant2) {
        Object hand1 = participant1.getAnnotationValue("HandRaiseAnnotation");
        Object hand2 = participant2.getAnnotationValue("HandRaiseAnnotation");
        int order1 = 0;
        if (hand1 instanceof Number) {
            order1 = ((Number)hand1).intValue();
        }
        int order2 = 0;
        if (hand2 instanceof Number) {
            order2 = ((Number)hand2).intValue();
        }
        if (order1 != 0 && order2 != 0) {
            if (order1 < order2) {
                return -1;
            }
            if (order1 > order2) {
                return 1;
            }
        } else {
            if (order1 != 0 && order2 == 0) {
                return -1;
            }
            if (order1 == 0 && order2 != 0) {
                return 1;
            }
        }
        return this.compareNames(participant1, participant2);
    }

    static /* synthetic */ Object[] access$502(ParticipantListModel x0, Object[] x1) {
        x0.selectedValues = x1;
        return x1;
    }

    private class ParticipantJobData {
        private static final int ADD_TASK = 0;
        private static final int REMOVE_TASK = 1;
        private CRPermissionStore object;
        private short id;
        private int type;

        ParticipantJobData(CRPermissionStore object, int type) {
            this.object = object;
            this.id = object.getID();
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.id;
            result = 31 * result + this.type;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParticipantJobData other = (ParticipantJobData)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            return this.object.getClass() == other.object.getClass();
        }

        private ParticipantListModel getOuterType() {
            return ParticipantListModel.this;
        }
    }

    private class ParticipantModelUpdateTask
    implements Runnable {
        private ParticipantModelUpdateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ParticipantJobData job = (ParticipantJobData)ParticipantListModel.this.jobQueue.peek();
            if (job == null) {
                ParticipantListModel.this.counterToStopTimer++;
                if (ParticipantListModel.this.counterToStopTimer > 3) {
                    ParticipantListModel.this.counterToStopTimer = 0;
                    ParticipantListModel.this.jobTimer.cancel();
                    if (ParticipantListModel.this.selectedValues != null) {
                        ArrayList<Integer> indexes = new ArrayList<Integer>();
                        List list = ParticipantListModel.this.visibleList;
                        synchronized (list) {
                            for (Object obj : ParticipantListModel.this.selectedValues) {
                                int index = ParticipantListModel.this.visibleList.indexOf(obj);
                                if (index < 0) continue;
                                indexes.add(index);
                            }
                        }
                        int[] indices = new int[indexes.size()];
                        for (int idx = 0; idx < indexes.size(); ++idx) {
                            indices[idx] = (Integer)indexes.get(idx);
                        }
                        ParticipantListModel.this.participantList.setSelectedIndices(indices);
                        ParticipantListModel.access$502(ParticipantListModel.this, null);
                    }
                }
                return;
            }
            if (ParticipantListModel.this.selectedValues == null) {
                ParticipantListModel.access$502(ParticipantListModel.this, ParticipantListModel.this.participantList.getSelectedValues());
            }
            int jobType = job.type;
            boolean isModelChanged = false;
            int index = 0;
            List list = ParticipantListModel.this.visibleList;
            synchronized (list) {
                CRPermissionStore object = job.object;
                switch (jobType) {
                    case 0: {
                        ParticipantState st;
                        int old = ParticipantListModel.this.visibleList.indexOf(object);
                        if (old != -1) {
                            ParticipantListModel.this.visibleList.remove(old);
                        }
                        if ((st = (ParticipantState)ParticipantListModel.this.entireSet.get(object)) != null && object instanceof CRParticipant) {
                            CRParticipant p = (CRParticipant)object;
                            st.chair = p.isChair();
                            st.room = p.getRoom();
                        }
                        boolean added = false;
                        for (Object obj : ParticipantListModel.this.visibleList) {
                            if (obj instanceof JSeparator) {
                                if (st != null && st.room != null && st.room.isMain() && st.chair) {
                                    ParticipantListModel.this.visibleList.add(index, object);
                                    added = true;
                                    break;
                                }
                            } else if (ParticipantListModel.this.compare(object, (CRPermissionStore)obj) < 0) {
                                ParticipantListModel.this.visibleList.add(index, object);
                                added = true;
                                break;
                            }
                            ++index;
                        }
                        if (!added) {
                            ParticipantListModel.this.visibleList.add(object);
                            added = true;
                        }
                        isModelChanged = added;
                        break;
                    }
                    case 1: {
                        index = ParticipantListModel.this.visibleList.indexOf(object);
                        if (index == -1) break;
                        ParticipantListModel.this.visibleList.remove(index);
                        isModelChanged = true;
                        break;
                    }
                }
                ParticipantListModel.this.jobQueue.remove();
            }
            if (isModelChanged) {
                ParticipantListModel.this.fireContentsChanged(ParticipantListModel.this, index, index);
            }
        }
    }

    private static class ParticipantState {
        public boolean chair;
        public CRRoom room;

        private ParticipantState() {
        }
    }
}

