/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.participant;

import com.elluminate.classroom.swing.participant.AbstractParticipantTransferHandler;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSession;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

class ParticipantHeaderTransferHandler
extends AbstractParticipantTransferHandler {
    public ParticipantHeaderTransferHandler(CRSession session) {
        super(session);
    }

    @Override
    public boolean importData(JComponent component, Transferable transferable) {
        if (transferable.isDataFlavorSupported(participantListFlavor)) {
            return this.importParticipants(transferable);
        }
        return false;
    }

    private boolean importParticipants(Transferable transferable) {
        if (this.session != null) {
            ArrayList<CRParticipant> droppees = new ArrayList<CRParticipant>();
            try {
                List ids = (List)transferable.getTransferData(participantListFlavor);
                Iterator i$ = ids.iterator();
                while (i$.hasNext()) {
                    short id = (Short)i$.next();
                    CRParticipant p = this.session.getParticipantById(id);
                    if (p == null) continue;
                    droppees.add(p);
                }
            }
            catch (UnsupportedFlavorException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (this.allDroppeesAreInMainRoom(droppees)) {
                ArrayList<CRParticipant> ps = new ArrayList<CRParticipant>();
                for (CRParticipant p : droppees) {
                    if (p.isChair()) continue;
                    ps.add(p);
                }
                if (!ps.isEmpty()) {
                    return this.fireParticipantGesture(2, ps.toArray(new CRParticipant[0]), null);
                }
            } else {
                CRRoom r = this.session.getMainRoom();
                ArrayList<CRParticipant> ps = new ArrayList<CRParticipant>();
                for (CRParticipant p : droppees) {
                    if (r.equals((Object)p.getRoom())) continue;
                    ps.add(p);
                }
                if (!ps.isEmpty()) {
                    return this.fireParticipantGesture(1, ps.toArray(new CRParticipant[0]), r);
                }
            }
        }
        return false;
    }
}

