/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.participant;

import com.elluminate.classroom.swing.ParticipantsPanel;
import com.elluminate.classroom.swing.SwingDebug;
import com.elluminate.classroom.swing.components.SMenuButton;
import com.elluminate.classroom.swing.components.STickedPanel;
import com.elluminate.classroom.swing.participant.ActivityDisplay;
import com.elluminate.classroom.swing.participant.StringsProperties;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRAnnotation;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRAnnotationChangeListener;
import com.elluminate.framework.session.listener.CRParticipantAdapter;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRAnnotationChangeEvent;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.groupware.imps.ProfileDataAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

@Singleton
public class ParticipantConsolePanel
extends JPanel {
    private static final int PICTURE_WIDTH = 25;
    private static final int PICTURE_HEIGHT = 25;
    private static final Border CENTER_BORDER = BorderFactory.createEmptyBorder(5, 3, 3, 3);
    private static final Border CENTER_WITH_BOTTOM_BORDER = BorderFactory.createEmptyBorder(5, 3, 0, 3);
    private static final Object ORDER_KEY = new Object();
    private I18n i18n;
    private Logger logger;
    private ContainerListener menuListener;
    private JLabel pictureField;
    private JLabel nameLabel;
    private ActivityDisplay activityPanel;
    private JLabel statusLabel;
    private JPanel centerPanel;
    private JPanel participantPanel;
    private GridBagConstraints participantConstraints;
    private JPanel roomPanel;
    private SMenuButton roomsButton;
    private STickedPanel bottomPanel;
    private CardPanel sessionPanel;
    private CRSession session;
    private CRParticipant me;
    private Imps imps = null;
    private boolean showProfile = false;
    private GridBagConstraints gbcPictureField;
    private JPanel topPanel;

    @Inject
    public ParticipantConsolePanel(I18nProvider provider, Logger logger) {
        super(new BorderLayout());
        this.i18n = provider.get((Object)this);
        this.logger = logger;
        this.menuListener = new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                ParticipantConsolePanel.this.applySmallFont(e.getChild());
            }
        };
        this.setBorder(UIManager.getBorder("SideBar.contentBorder"));
        this.setOpaque(false);
        this.setBackground(UIManager.getColor("SideBar.contentBackground"));
        this.topPanel = new JPanel(new GridBagLayout());
        this.topPanel.setOpaque(false);
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 5));
        this.add((Component)this.topPanel, "North");
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.setOpaque(false);
        this.centerPanel.setBorder(CENTER_BORDER);
        this.centerPanel.setVisible(false);
        this.add((Component)this.centerPanel, "Center");
        this.bottomPanel = new STickedPanel(9, 0, 0, 0);
        this.bottomPanel.setBackgroundFlat(true);
        this.bottomPanel.setVisible(false);
        this.add((Component)this.bottomPanel, "South");
        this.gbcPictureField = new GridBagConstraints();
        this.gbcPictureField.fill = 2;
        this.gbcPictureField.gridy = 0;
        this.gbcPictureField.anchor = 11;
        this.gbcPictureField.insets.top = 0;
        this.gbcPictureField.gridx = 0;
        this.gbcPictureField.gridwidth = 1;
        this.gbcPictureField.gridheight = 2;
        this.gbcPictureField.weightx = 0.0;
        this.gbcPictureField.insets.left = 0;
        this.pictureField = new JLabel();
        this.pictureField.setPreferredSize(new Dimension(25, 25));
        GridBagConstraints gbcNameLabel = new GridBagConstraints();
        gbcNameLabel.anchor = 10;
        gbcNameLabel.fill = 2;
        gbcNameLabel.gridy = 0;
        gbcNameLabel.insets.top = 0;
        gbcNameLabel.gridx = 1;
        gbcNameLabel.gridwidth = 1;
        gbcNameLabel.gridheight = 1;
        gbcNameLabel.weightx = 1.0;
        gbcNameLabel.insets.left = 6;
        this.nameLabel = new JLabel();
        this.nameLabel.setBorder(BorderFactory.createEmptyBorder(-1, 0, -1, 0));
        this.nameLabel.setForeground(UIManager.getColor("Participant.nameForeground"));
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(1));
        this.topPanel.add((Component)this.nameLabel, gbcNameLabel);
        GridBagConstraints gbcActivityPanel = new GridBagConstraints();
        gbcActivityPanel.anchor = 10;
        gbcActivityPanel.fill = 2;
        gbcActivityPanel.gridy = 0;
        gbcActivityPanel.insets.top = 0;
        gbcActivityPanel.gridx = 2;
        gbcActivityPanel.gridwidth = 1;
        gbcActivityPanel.gridheight = 1;
        gbcActivityPanel.weightx = 0.0;
        gbcActivityPanel.insets.left = 6;
        this.activityPanel = new ActivityDisplay();
        this.activityPanel.setShowingPoll(false);
        this.topPanel.add((Component)this.activityPanel, gbcActivityPanel);
        GridBagConstraints gbcStatusLabel = new GridBagConstraints();
        gbcStatusLabel.anchor = 10;
        gbcStatusLabel.fill = 2;
        gbcStatusLabel.gridy = 1;
        gbcStatusLabel.insets.top = 2;
        gbcStatusLabel.gridx = 1;
        gbcStatusLabel.gridwidth = 2;
        gbcStatusLabel.gridheight = 1;
        gbcStatusLabel.weightx = 1.0;
        gbcStatusLabel.insets.left = 6;
        this.statusLabel = new JLabel();
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(-2, 0, -1, 0));
        Font f = UIManager.getFont("Label.font");
        this.statusLabel.setFont(f.deriveFont((float)(f.getSize() * 11 / 12)));
        this.topPanel.add((Component)this.statusLabel, gbcStatusLabel);
        this.participantPanel = new JPanel(new GridBagLayout());
        this.participantPanel.setOpaque(false);
        this.centerPanel.add((Component)this.participantPanel, "West");
        this.participantConstraints = new GridBagConstraints();
        this.participantConstraints.insets.left = 2;
        this.participantConstraints.insets.right = 2;
        this.roomPanel = new JPanel(new GridBagLayout());
        this.roomPanel.setOpaque(false);
        this.centerPanel.add((Component)this.roomPanel, "Center");
        GridBagConstraints gbcRoomsButton = new GridBagConstraints();
        gbcRoomsButton.weightx = 1.0;
        gbcRoomsButton.fill = 2;
        gbcRoomsButton.insets.left = 2;
        gbcRoomsButton.insets.right = 2;
        this.roomsButton = new SMenuButton();
        this.roomsButton.putClientProperty("JButton.buttonType", "textured");
        this.roomsButton.setPreferredSize(new Dimension(27, 26));
        f = this.roomsButton.getFont();
        this.roomsButton.setFont(f.deriveFont((float)(f.getSize() * 11 / 12)));
        this.roomsButton.setHorizontalAlignment(10);
        this.roomsButton.setVisible(false);
        this.roomsButton.setFocusable(false);
        this.roomsButton.getMenu().addContainerListener(this.menuListener);
        this.roomsButton.getMenu().addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                ParticipantConsolePanel.this.updateRoomsButton();
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                ParticipantConsolePanel.this.updateRoomsButton();
            }
        });
        this.roomPanel.add((Component)this.roomsButton, gbcRoomsButton);
        this.sessionPanel = new CardPanel();
        this.sessionPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.bottomPanel.add(this.sessionPanel);
        Card c = new Card();
        this.sessionPanel.add((Component)c, (Object)ParticipantsPanel.SessionCard.POLL);
        this.sessionPanel.setCard(ParticipantsPanel.SessionCard.POLL);
    }

    private CRParticipant findMe() {
        CRParticipant me = null;
        Iterator partItr = this.session.getParticipantIterator();
        while (partItr.hasNext() && me == null) {
            CRParticipant p = (CRParticipant)partItr.next();
            if (!p.isMe()) continue;
            me = p;
        }
        return me;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initSession(CRSession ses) {
        this.session = ses;
        this.session.addParticipantListener((CRParticipantListener)new CRParticipantAdapter(){

            public void onParticipantJoinedRoom(CRParticipantEvent e) {
                final CRParticipant p = e.getParticipant();
                if (p.isMe()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantConsolePanel.this.updateMe(p);
                        }
                    });
                }
            }

            public void onParticipantLeftRoom(CRParticipantEvent e) {
                CRParticipant p = e.getParticipant();
                if (p.isMe()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantConsolePanel.this.updateMe(null);
                        }
                    });
                } else {
                    CRParticipant me;
                    boolean bridgeLeft = p.getName().startsWith("Teleconference#");
                    if (bridgeLeft && (me = ParticipantConsolePanel.this.findMe()) != null) {
                        ParticipantConsolePanel.this.activityPanel.setParticipant(me);
                    }
                }
            }
        });
        this.session.addAnnotationChangeListener("ProfilePictureAnnotation", new CRAnnotationChangeListener(){

            public void onAnnotationValueChange(CRAnnotationChangeEvent event) {
                final CRParticipant p = ParticipantConsolePanel.this.session.getParticipantById(event.getNewAnnotation().getID());
                if (p.isMe()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantConsolePanel.this.updateMe(p);
                        }
                    });
                }
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Object pl = new CRPermissionChangeListener(){

            public void onPermissionValueChange(CRPermissionChangeEvent e) {
                CRParticipant p;
                CRPermission perm = (CRPermission)e.getSource();
                if (perm.getScope() == CRPermissionScope.PARTICIPANT && (p = ParticipantConsolePanel.this.session.getParticipantById(perm.getID())).isMe()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantConsolePanel.this.updateStatus();
                        }
                    });
                }
            }

            public void onPermissionDefaultChange(CRPermissionChangeEvent e) {
            }
        };
        this.session.addPermissionChangeListener("ChairPermission", pl);
        pl = new CRPermissionChangeListener(){

            public void onPermissionValueChange(CRPermissionChangeEvent e) {
                final CRPermission perm = (CRPermission)e.getSource();
                if (perm.getScope() == CRPermissionScope.PARTICIPANT) {
                    CRParticipant p = ParticipantConsolePanel.this.session.getParticipantById(perm.getID());
                    if (SwingDebug.PARTICIPANT.show()) {
                        ParticipantConsolePanel.this.logger.message((Object)this, "onPermissionValueChange", "participant: " + p + ", permission: " + perm);
                    }
                    boolean permIsAudio = perm.getName().equals("AudioPermission");
                    boolean permIsForBridge = p.getName().startsWith("Teleconference#");
                    if (p.isMe() || permIsAudio && permIsForBridge) {
                        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (SwingDebug.PARTICIPANT.show()) {
                                    ParticipantConsolePanel.this.logger.message((Object)this, "run", "permission " + perm);
                                }
                                ParticipantConsolePanel.this.activityPanel.update(perm, false);
                            }
                        });
                    }
                }
            }

            public void onPermissionDefaultChange(CRPermissionChangeEvent e) {
                final CRPermission perm = (CRPermission)e.getSource();
                if (perm.getScope() == CRPermissionScope.PARTICIPANT) {
                    if (SwingDebug.PARTICIPANT.show()) {
                        ParticipantConsolePanel.this.logger.message((Object)this, "onPermissionDefaultChange", "permission: " + perm);
                    }
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (SwingDebug.PARTICIPANT.show()) {
                                ParticipantConsolePanel.this.logger.message((Object)this, "run", "permission: " + perm);
                            }
                            ParticipantConsolePanel.this.activityPanel.update(perm, true);
                        }
                    });
                }
            }
        };
        this.session.addPermissionChangeListener("AudioPermission", pl);
        this.session.addPermissionChangeListener("VideoPermission", pl);
        this.session.addPermissionChangeListener("ChatPermission", pl);
        this.session.addPermissionChangeListener("AppSharePermission", pl);
        this.session.addPermissionChangeListener("WhiteBoardPermission", pl);
        this.session.addPermissionChangeListener("WebTourPermission", pl);
        this.session.addPermissionChangeListener("CaptionPermission", pl);
        Object al = new CRAnnotationChangeListener(){

            public void onAnnotationValueChange(CRAnnotationChangeEvent e) {
                final CRAnnotation a = e.getNewAnnotation();
                CRParticipant p = ParticipantConsolePanel.this.session.getParticipantById(a.getID());
                if (SwingDebug.PARTICIPANT.show()) {
                    ParticipantConsolePanel.this.logger.message((Object)this, "onAnnotationValueChange", "participant: " + p + ", annotation: " + a);
                }
                if (p.isMe()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (SwingDebug.PARTICIPANT.show()) {
                                ParticipantConsolePanel.this.logger.message((Object)this, "run", "annotation: " + a);
                            }
                            ParticipantConsolePanel.this.activityPanel.update(a);
                        }
                    });
                } else {
                    CRParticipant me;
                    boolean annotIsTelephony = a.getName().equals("TelephonyActivityAnnotation");
                    boolean annotIsForBridge = p.getName().startsWith("Teleconference#");
                    if (annotIsTelephony && annotIsForBridge && (me = ParticipantConsolePanel.this.findMe()) != null) {
                        ParticipantConsolePanel.this.activityPanel.setParticipant(me);
                    }
                }
            }
        };
        this.session.addAnnotationChangeListener("AudioActivityAnnotation", al);
        this.session.addAnnotationChangeListener("AudioLagAnnotation", al);
        this.session.addAnnotationChangeListener("VideoActivityAnnotation", al);
        this.session.addAnnotationChangeListener("VideoLagAnnotation", al);
        this.session.addAnnotationChangeListener("ChatActivityAnnotation", al);
        this.session.addAnnotationChangeListener("ChatLagAnnotation", al);
        this.session.addAnnotationChangeListener("AppShareActivityAnnotation", al);
        this.session.addAnnotationChangeListener("AppShareLagAnnotation", al);
        this.session.addAnnotationChangeListener("WhiteboardActivityAnnotation", al);
        this.session.addAnnotationChangeListener("WhiteboardLagAnnotation", al);
        this.session.addAnnotationChangeListener("WebTourActivityAnnotation", al);
        this.session.addAnnotationChangeListener("WebTourLagAnnotation", al);
        this.session.addAnnotationChangeListener("CaptionActivityAnnotation", al);
        this.session.addAnnotationChangeListener("CaptionLagAnnotation", al);
        this.session.addAnnotationChangeListener("TelephonyActivityAnnotation", al);
        this.session.addAnnotationChangeListener("AudioSetupAnnotation", al);
        al = new CRAnnotationChangeListener(){

            public void onAnnotationValueChange(CRAnnotationChangeEvent e) {
                CRAnnotation a = e.getNewAnnotation();
                CRParticipant p = ParticipantConsolePanel.this.session.getParticipantById(a.getID());
                if (p.isMe()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantConsolePanel.this.updateStatus();
                        }
                    });
                }
            }
        };
        this.session.addAnnotationChangeListener("AwayAnnotation", al);
        ProfileDataAPI profDataAPI = (ProfileDataAPI)this.imps.findBest(ProfileDataAPI.class);
        if (profDataAPI == null) {
            this.showProfile = false;
        } else {
            this.showProfile = true;
            this.topPanel.add((Component)this.pictureField, this.gbcPictureField);
            this.nameLabel.setLabelFor(this.pictureField);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        if (this.centerPanel.isVisible()) {
            g.setColor(UIManager.getColor("Participant.separatorColor"));
            int y = this.centerPanel.getY();
            g.drawLine(0, y, this.getWidth(), y);
        }
    }

    private void updateMe(CRParticipant me) {
        this.me = me;
        if (me != null) {
            Image picture = (Image)me.getAnnotationValue("ProfilePictureAnnotation");
            Icon pic = picture != null ? this.scalePicture(picture, 25, 25) : UIManager.getIcon("Participant.defaultParticipantIcon");
            if (this.showProfile) {
                this.pictureField.setIcon(pic);
            }
            this.nameLabel.setText(me.getDisplayName());
        } else {
            if (this.showProfile) {
                this.pictureField.setIcon(null);
            }
            this.nameLabel.setText(null);
        }
        this.activityPanel.setParticipant(me);
        this.updateStatus();
    }

    private void updateStatus() {
        if (this.me == null) {
            this.statusLabel.setIcon(null);
            this.statusLabel.setText(" ");
            return;
        }
        Object away = this.me.getAnnotationValue("AwayAnnotation");
        if (away != null && away.equals(1)) {
            this.statusLabel.setIcon(UIManager.getIcon("Participant.awayIcon"));
            this.statusLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_AWAY));
            this.statusLabel.setForeground(UIManager.getColor("Participant.awayForeground"));
        } else if (this.me.isChair()) {
            this.statusLabel.setIcon(null);
            this.statusLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_MODERATOR));
            this.statusLabel.setForeground(UIManager.getColor("Participant.statusForeground"));
        } else {
            this.statusLabel.setIcon(null);
            this.statusLabel.setText(" ");
        }
    }

    private Icon scalePicture(Image picture, int width, int height) {
        int w = picture.getWidth(this);
        int h = picture.getHeight(this);
        float xscale = (float)width / (float)w;
        float yscale = (float)height / (float)h;
        float scale = Math.max(xscale, yscale);
        BufferedImage bim = new BufferedImage(width, height, 2);
        Graphics2D og = bim.createGraphics();
        if (og != null) {
            w = (int)((float)w * scale);
            h = (int)((float)h * scale);
            int x = (width - w) / 2;
            int y = (height - h) / 2;
            og.drawImage(picture, x, y, w, h, this);
            og.dispose();
        }
        try {
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(bim, 0);
            mt.waitForAll();
            mt.removeImage(bim, 0);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return new ImageIcon(bim);
    }

    private void applySmallFont(Component component) {
        Font f = component.getFont();
        if (f instanceof UIResource) {
            component.setFont(f.deriveFont((float)(f.getSize() * 11) / 12.0f));
        }
    }

    public static int orderToIndex(float order, Container container) {
        int index = 0;
        for (Component c : container.getComponents()) {
            JComponent jc;
            float o;
            if (c instanceof JComponent && (o = ((Float)(jc = (JComponent)c).getClientProperty(ORDER_KEY)).floatValue()) > order) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void addParticipantAction(JComponent c, float order, ParticipantsPanel.SessionCard relatedCard) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            b.putClientProperty("JButton.buttonType", "textured");
            b.setPreferredSize(new Dimension(27, 26));
        }
        if (c instanceof SMenuButton) {
            JPopupMenu m = ((SMenuButton)c).getMenu();
            m.addContainerListener(this.menuListener);
            for (Component mi : m.getComponents()) {
                this.applySmallFont(mi);
            }
        }
        if (relatedCard == ParticipantsPanel.SessionCard.POLL) {
            this.bottomPanel.setRelated(c);
        }
        c.putClientProperty(ORDER_KEY, Float.valueOf(order));
        int index = ParticipantConsolePanel.orderToIndex(order, this.participantPanel);
        this.participantPanel.add(c, this.participantConstraints, index);
        this.updateCenterPanelVisible();
        this.participantPanel.revalidate();
        this.participantPanel.repaint();
    }

    public void removeParticipantAction(JComponent c) {
        if (c instanceof SMenuButton) {
            JPopupMenu m = ((SMenuButton)c).getMenu();
            m.removeContainerListener(this.menuListener);
        }
        this.participantPanel.remove(c);
        this.updateCenterPanelVisible();
        this.participantPanel.revalidate();
        this.participantPanel.repaint();
    }

    private void updateCenterPanelVisible() {
        boolean vis = false;
        for (Component c : this.participantPanel.getComponents()) {
            if (!c.isVisible()) continue;
            vis = true;
            break;
        }
        if (!vis) {
            for (Component c : this.roomPanel.getComponents()) {
                if (!c.isVisible()) continue;
                vis = true;
                break;
            }
        }
        this.centerPanel.setVisible(vis);
    }

    public void setShowingAllPermissions(boolean showingAllPermissions) {
        this.activityPanel.setSortedLogically(showingAllPermissions);
        this.activityPanel.setShowingAllPermissions(showingAllPermissions);
    }

    public void setRoomName(String roomName) {
        this.roomsButton.setText(roomName != null ? roomName.toUpperCase() : null);
        this.updateRoomsButton();
    }

    private void updateRoomsButton() {
        boolean hasItems = false;
        for (Component c : this.roomsButton.getMenu().getComponents()) {
            if (c instanceof JSeparator || !c.isVisible()) continue;
            hasItems = true;
            break;
        }
        boolean visible = hasItems;
        if (!hasItems) {
            String text = this.roomsButton.getText();
            visible = text != null && text.length() != 0;
        }
        this.roomsButton.setVisible(visible);
        this.roomsButton.setFocusable(hasItems);
        this.roomsButton.setBorderPainted(hasItems);
        this.roomsButton.setContentAreaFilled(hasItems);
        this.roomsButton.setArrowPainted(hasItems);
        this.updateCenterPanelVisible();
        this.roomPanel.revalidate();
        this.roomPanel.repaint();
    }

    public JPopupMenu getRoomsMenu() {
        return this.roomsButton.getMenu();
    }

    public void addSessionDisplay(JComponent component, ParticipantsPanel.SessionCard card) {
        Card c = this.sessionPanel.getCard(card);
        if (c != null) {
            c.addDisplayComponent(component);
        }
    }

    public void removeSessionDisplay(JComponent component, ParticipantsPanel.SessionCard card) {
        Card c = this.sessionPanel.getCard(card);
        if (c != null) {
            c.removeDisplayComponent(component);
        }
    }

    public void addSessionAction(AbstractButton action, ParticipantsPanel.SessionCard card) {
        Card c = this.sessionPanel.getCard(card);
        if (c != null) {
            c.addAction(action);
        }
    }

    public void removeSessionAction(AbstractButton action, ParticipantsPanel.SessionCard card) {
        Card c = this.sessionPanel.getCard(card);
        if (c != null) {
            c.removeAction(action);
        }
    }

    protected void requestFirstFocus() {
        for (Component c : this.centerPanel.getComponents()) {
            if (!(c instanceof JButton)) continue;
            c.requestFocus();
            break;
        }
    }

    private static class Card
    extends JComponent {
        private JPanel displayPanel;
        private GridBagConstraints displayConstraints;
        private JPanel actionPanel;
        private GridBagConstraints actionConstraints;
        private boolean displayable;
        private ComponentListener componentListener;
        private Font font;
        private Font underlineFont;
        private MouseListener hoverListener;

        public Card() {
            this.setLayout(new BorderLayout());
            this.displayPanel = new JPanel(new GridBagLayout());
            this.displayPanel.setOpaque(false);
            this.add((Component)this.displayPanel, "Center");
            this.displayConstraints = new GridBagConstraints();
            this.displayConstraints.insets.left = 6;
            this.displayConstraints.insets.right = 6;
            this.actionPanel = new JPanel(new GridBagLayout());
            this.actionPanel.setOpaque(false);
            this.add((Component)this.actionPanel, "East");
            this.actionConstraints = new GridBagConstraints();
            this.actionConstraints.insets.left = 4;
            this.actionConstraints.insets.right = 4;
            this.componentListener = new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    Card.this.updateDisplayable(true);
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    Card.this.updateDisplayable(false);
                }
            };
            Font f = UIManager.getFont("Button.font");
            this.font = f.deriveFont(0, (float)f.getSize() * 11.0f / 12.0f);
            HashMap<TextAttribute, Integer> attrs = new HashMap<TextAttribute, Integer>();
            attrs.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            this.underlineFont = this.font.deriveFont(attrs);
            this.hoverListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    e.getComponent().setFont(Card.this.underlineFont);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    e.getComponent().setFont(Card.this.font);
                }
            };
        }

        public void addDisplayComponent(JComponent component) {
            component.setFont(this.font);
            this.displayPanel.add((Component)component, this.displayConstraints);
            this.displayPanel.revalidate();
            component.addComponentListener(this.componentListener);
            if (component.isVisible()) {
                this.updateDisplayable(true);
            }
        }

        public void removeDisplayComponent(JComponent component) {
            this.displayPanel.remove(component);
            component.removeComponentListener(this.componentListener);
            if (component.isVisible()) {
                this.updateDisplayable(false);
            }
        }

        public void addAction(AbstractButton action) {
            action.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            action.setContentAreaFilled(false);
            action.setFont(this.font);
            action.addMouseListener(this.hoverListener);
            this.actionPanel.add((Component)action, this.actionConstraints);
            this.actionPanel.revalidate();
            action.addComponentListener(this.componentListener);
            if (action.isVisible()) {
                this.updateDisplayable(true);
            }
        }

        public void removeAction(AbstractButton action) {
            action.removeMouseListener(this.hoverListener);
            this.actionPanel.remove(action);
            action.removeComponentListener(this.componentListener);
            if (action.isVisible()) {
                this.updateDisplayable(false);
            }
        }

        private void updateDisplayable(boolean componentShown) {
            if (componentShown) {
                this.setDisplayable(true);
            } else {
                boolean disp = false;
                for (Component c : this.displayPanel.getComponents()) {
                    if (!c.isVisible()) continue;
                    disp = true;
                    break;
                }
                if (!disp) {
                    for (Component c : this.actionPanel.getComponents()) {
                        if (!c.isVisible()) continue;
                        disp = true;
                        break;
                    }
                }
                this.setDisplayable(disp);
            }
        }

        private void setDisplayable(boolean displayable) {
            boolean old = this.displayable;
            this.displayable = displayable;
            this.firePropertyChange("displayable", old, displayable);
        }
    }

    private class CardPanel
    extends JComponent {
        private CardLayout layout;
        private Map<ParticipantsPanel.SessionCard, Card> cards = new HashMap<ParticipantsPanel.SessionCard, Card>();
        private PropertyChangeListener cardListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                boolean displayable = (Boolean)e.getNewValue();
                ParticipantConsolePanel.this.bottomPanel.setVisible(displayable);
                ParticipantConsolePanel.this.centerPanel.setBorder(displayable ? CENTER_WITH_BOTTOM_BORDER : CENTER_BORDER);
            }
        };

        public CardPanel() {
            this.layout = new CardLayout();
            this.setLayout(this.layout);
            this.add((Component)new JComponent(){}, "none");
        }

        public void setCard(ParticipantsPanel.SessionCard card) {
            this.layout.show(this, card != null ? String.valueOf((Object)card) : "none");
        }

        @Override
        protected void addImpl(Component c, Object constraints, int index) {
            super.addImpl(c, String.valueOf(constraints), index);
            if (constraints instanceof ParticipantsPanel.SessionCard && c instanceof Card) {
                Card card = (Card)c;
                card.addPropertyChangeListener("displayable", this.cardListener);
                this.cards.put((ParticipantsPanel.SessionCard)((Object)constraints), card);
            }
        }

        @Override
        public void remove(int index) {
            Component c;
            if (index < this.getComponentCount() && (c = this.getComponent(index)) instanceof Card) {
                Card card = (Card)c;
                card.removePropertyChangeListener("displayable", this.cardListener);
            }
        }

        public Card getCard(ParticipantsPanel.SessionCard card) {
            return this.cards.get((Object)card);
        }
    }
}

