/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.client.BrandingI18nProvider;
import com.elluminate.classroom.client.GeneralPrefsOwner;
import com.elluminate.classroom.swing.location.StringsProperties;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.Notification;
import com.elluminate.framework.location.SwingLocationHandler;
import com.elluminate.framework.location.SwingLocationHandlerAPI;
import com.elluminate.framework.location.SwingLocationHandlerAdapter;
import com.elluminate.framework.location.SwingLocationHandlerProxy;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.InvalidPreferenceSettingException;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.NotificationWindow;
import com.elluminate.gui.component.PreferencesDialog;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.CTable;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

@Singleton
public class VisualNotificationLocationHandler
extends AbstractPreferencesPanel {
    public static final String LOCATION = "notify.visual";
    public static final Integer DEFAULT_TIMEOUT = new Integer(30);
    public static final String DEFAULT_ENABLED_HINT = "notify.visual.default";
    public static final String DISPLAY_NAME_HINT = "notify.visual.displayName";
    public static final String TIMEOUT_HINT = "notify.visual.timeout";
    public static final String NOTIFIER_LOCATION_PREF = "general.notifierLocation";
    private static I18n i18n = I18n.create((Object)new Object(){});
    private DefaultTableModel tableModel;
    private Map<String, Notification> notifications = new TreeMap<String, Notification>();
    private SwingLocationHandler handler;
    private Logger logger;
    private Preferences prefs;
    private BrandingI18nProvider branding;
    private PreferencesDialog prefsDialog;
    private NotificationWindow notifier;
    private Map<String, Notification> working = null;

    @Inject
    public VisualNotificationLocationHandler(GeneralPrefsOwner owner) {
        super((PreferencesPanelOwner)owner, i18n.getString((PropertiesEnum)StringsProperties.VISUALNOTIFICATIONPREFS_TITLE));
    }

    @Inject
    public void initBrokerAdapter(SwingLocationHandlerProxy proxy) {
        proxy.setHandler((SwingLocationHandlerAPI)new NotifyHandler());
        this.handler = proxy;
    }

    @Inject
    public void initLogger(Logger logger) {
        this.logger = logger;
    }

    @Inject
    public void initNotiferAndPrefs(NotificationWindow w, Preferences prefs) {
        this.notifier = w;
        this.prefs = prefs;
        Point pos = prefs.getPointSetting(NOTIFIER_LOCATION_PREF, null);
        if (pos == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle b = gc.getBounds();
            Insets ins = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            Dimension s = this.notifier.getSize();
            pos = new Point(b.x + b.width - ins.right - s.width - 10, b.y + b.height - ins.bottom - s.height - 10);
        }
        this.notifier.setLocation(pos);
    }

    @Inject
    public void initBranding(BrandingI18nProvider prov) {
        this.branding = prov;
    }

    @Inject
    public void initPrefsDialog(PreferencesDialog dlg) {
        this.prefsDialog = dlg;
    }

    public LocationHandler getLocationHandler() {
        return this.handler;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout(0, 6));
        this.add((Component)new MultilineLabel(i18n.getString((PropertiesEnum)StringsProperties.VISUALNOTIFICATIONPREFS_EXPLANATION)), "North");
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        TableColumn col = new TableColumn(0);
        col.setHeaderValue(i18n.getString((PropertiesEnum)StringsProperties.VISUALNOTIFICATIONPREFS_NOTIFICATIONCOLUMN));
        col.setCellRenderer(new NameRenderer());
        cm.addColumn(col);
        col = new TableColumn(1);
        col.setHeaderValue(i18n.getString((PropertiesEnum)StringsProperties.VISUALNOTIFICATIONPREFS_ENABLEDCOLUMN));
        col.setMaxWidth(100);
        col.setCellRenderer(new EnabledRenderer());
        cm.addColumn(col);
        this.tableModel = new DefaultTableModel(0, 2){

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 1) {
                    return Boolean.class;
                }
                return super.getColumnClass(column);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                super.setValueAt(value, row, column);
                VisualNotificationLocationHandler.this.setModified(true);
            }
        };
        CTable t = new CTable((TableModel)this.tableModel, (TableColumnModel)cm);
        t.setColumnAlignment(1, 0);
        t.setRowHeight(20);
        t.setPreferredScrollableViewportSize(new Dimension(1, 200));
        JScrollPane sp = new JScrollPane((Component)t, 22, 31);
        this.add(sp);
    }

    protected void populate(Preferences preferences) {
        this.tableModel.setRowCount(0);
        this.working = new TreeMap<String, Notification>(this.notifications);
        for (String path : this.working.keySet()) {
            Notification n = this.working.get(path);
            String pref = this.getOwnerPrefix() + path.replace('/', '.');
            Boolean dft = (Boolean)n.getHintValue(DEFAULT_ENABLED_HINT, (Object)Boolean.FALSE);
            Boolean en = preferences.getBooleanSetting(pref, dft.booleanValue());
            String name = (String)n.getHintValue(DISPLAY_NAME_HINT, (Object)"UNKNOWN <Missing notify.visual.displayName hint>");
            this.tableModel.addRow(new Object[]{name, en});
        }
    }

    protected void apply(Preferences preferences) throws InvalidPreferenceSettingException {
        int i = 0;
        for (String path : this.working.keySet()) {
            String pref = this.getOwnerPrefix() + path.replace('/', '.');
            Boolean en = (Boolean)this.tableModel.getValueAt(i++, 1);
            preferences.setSetting(pref, en.booleanValue());
        }
    }

    protected void reset(Preferences preferences) {
        for (String path : this.notifications.keySet()) {
            Notification n = this.notifications.get(path);
            String pref = this.getOwnerPrefix() + path.replace('/', '.');
            Boolean dft = (Boolean)n.getHintValue(DEFAULT_ENABLED_HINT, (Object)Boolean.FALSE);
            preferences.setSetting(pref, dft.booleanValue());
        }
    }

    private String getPref(Notification n) {
        return this.getOwnerPrefix() + n.getPath().replace('/', '.');
    }

    private void queueNotification(Notification n) {
        Boolean dft;
        String pref = this.getPref(n);
        if (!this.prefs.getBooleanSetting(pref, (dft = (Boolean)n.getHintValue(DEFAULT_ENABLED_HINT, (Object)Boolean.FALSE)).booleanValue())) {
            return;
        }
        ImageIcon icon = this.branding.get().getIcon((PropertiesEnum)BrandingI18nProvider.Values.COLLABORATE_SYS_ICON);
        String message = n.getMessage();
        String explanation = null;
        Integer timeout = (Integer)n.getHintValue(TIMEOUT_HINT, (Object)DEFAULT_TIMEOUT);
        int pos = message.indexOf(10);
        if (pos > 0) {
            explanation = message.substring(pos + 1);
            message = message.substring(0, pos);
        }
        this.notifier.queueNotification(n.getPath(), (Icon)icon, message, explanation, timeout.intValue(), n.getTimestamp());
    }

    private void abortNotification(Notification n) {
        this.notifier.cancel(n.getPath());
    }

    private static class EnabledRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public EnabledRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            if (value instanceof Boolean) {
                this.setSelected((Boolean)value);
            } else {
                this.setSelected(false);
            }
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            if (focused) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            return this;
        }
    }

    private static class NameRenderer
    extends DefaultTableCellRenderer {
        private NameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            if (focused) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            return this;
        }
    }

    class NotifyHandler
    extends SwingLocationHandlerAdapter {
        NotifyHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void announceNotificationSwing(Notification n) {
            Map map = VisualNotificationLocationHandler.this.notifications;
            synchronized (map) {
                if (VisualNotificationLocationHandler.this.notifications.isEmpty()) {
                    VisualNotificationLocationHandler.this.prefsDialog.addPanel((AbstractPreferencesPanel)VisualNotificationLocationHandler.this);
                }
                VisualNotificationLocationHandler.this.notifications.put(n.getPath(), n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deliverNotificationSwing(Notification n) {
            Map map = VisualNotificationLocationHandler.this.notifications;
            synchronized (map) {
                if (!VisualNotificationLocationHandler.this.notifications.containsKey(n.getPath())) {
                    VisualNotificationLocationHandler.this.logger.error((Object)this, "deliverNotificationSwing", "Notification delivered without announcement - " + n.getPath());
                    return;
                }
                VisualNotificationLocationHandler.this.queueNotification(n);
            }
        }

        public void abortNotificationSwing(Notification n) {
            VisualNotificationLocationHandler.this.abortNotification(n);
        }
    }
}

