/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.groupware.imps.view.ViewMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class NotificationSupport {
    private final Map<ViewMode, Map<String, List<Feature>>> modes = new HashMap<ViewMode, Map<String, List<Feature>>>();

    NotificationSupport() {
    }

    public void addInterestedFeature(Feature feature, String notification) {
        this.addInterestedFeature(feature, notification, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterestedFeature(Feature feature, String notification, ViewMode mode) {
        Map<ViewMode, Map<String, List<Feature>>> map = this.modes;
        synchronized (map) {
            List<Feature> fs;
            Map<String, List<Feature>> features = this.modes.get(mode);
            if (features == null) {
                features = new HashMap<String, List<Feature>>();
                this.modes.put(mode, features);
            }
            if ((fs = features.get(notification)) == null) {
                fs = new ArrayList<Feature>();
                features.put(notification, fs);
            }
            fs.add(feature);
        }
    }

    public void removeInterestedFeature(Feature feature, String notification) {
        this.removeInterestedFeature(feature, notification, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterestedFeature(Feature feature, String notification, ViewMode mode) {
        Map<ViewMode, Map<String, List<Feature>>> map = this.modes;
        synchronized (map) {
            List<Feature> fs;
            Map<String, List<Feature>> features = this.modes.get(mode);
            if (features != null && (fs = features.get(notification)) != null) {
                fs.remove(feature);
                if (fs.isEmpty()) {
                    features.remove(notification);
                    if (features.isEmpty()) {
                        this.modes.remove(mode);
                    }
                }
            }
        }
    }

    public void notifyInterestedFeatures(String notification) {
        this.notifyInterestedFeatures(notification, (Object)null);
    }

    public void notifyInterestedFeatures(String notification, Object value) {
        this.notifyInterestedFeatures(notification, null, value);
    }

    public void notifyInterestedFeatures(String notification, ViewMode mode) {
        this.notifyInterestedFeatures(notification, mode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInterestedFeatures(String notification, ViewMode mode, Object value) {
        Map<ViewMode, Map<String, List<Feature>>> map = this.modes;
        synchronized (map) {
            List<Feature> fs;
            Map<String, List<Feature>> features = this.modes.get(mode);
            if (features != null && (fs = features.get(notification)) != null) {
                for (Feature f : fs) {
                    if (f instanceof ActionFeature) {
                        ActionFeature af = (ActionFeature)f;
                        af.fireActionFeatureListeners(value);
                        continue;
                    }
                    if (!(f instanceof BooleanFeature) || !(value instanceof Boolean)) continue;
                    BooleanFeature bf = (BooleanFeature)f;
                    Boolean bv = (Boolean)value;
                    if (!bf.isMutable()) continue;
                    bf.setValue((Object)bv);
                }
            }
        }
    }
}

