/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.NavigationPanel;
import com.elluminate.classroom.swing.components.SButton;
import com.elluminate.classroom.swing.components.SCheckBox;
import com.elluminate.classroom.swing.components.SToggleButton;
import com.elluminate.classroom.swing.location.MenuSectionSupport;
import com.elluminate.classroom.swing.location.ScreenListFeatureAdapter;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.ListFeature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.Notification;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.feature.ValueFeature;
import com.elluminate.framework.feature.whiteboard.ScreenInfo;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.framework.location.ActionFeatureAdapter;
import com.elluminate.framework.location.ActionFeatureAdapterProvider;
import com.elluminate.framework.location.BooleanFeatureAdapter;
import com.elluminate.framework.location.BooleanFeatureAdapterProvider;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.framework.location.StringFeatureAdapter;
import com.elluminate.framework.location.StringFeatureAdapterProvider;
import com.elluminate.gui.swing.CCheckBoxMenuItem;
import com.elluminate.gui.swing.CMenuItem;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class NavigationLocationHandler
extends AbstractSwingLocationHandler {
    private static final String LOCATION = "navigation";
    private static final String AREA = "navigationArea";
    private static final String OPTIONS_MENU_AREA = "optionsMenu";
    private static final String PREVIOUS_ACTION_AREA = "previousAction";
    private static final String NEXT_ACTION_AREA = "nextAction";
    private static final String SELECTOR_AREA = "selector";
    private static final String OPTION_AREA = "optionArea";
    private static final String CONTENT_LIST = "contentList";
    private static final String MENU_SECTION = "navigationMenuSection";
    private static final String PANEL_SECTION = "panelSection";
    private static final String ORDER = "order";
    private static final String NAV_DOCKED = "navigation.docked";
    private static final String COMPONENT_TYPE = "componentType";
    private Map<Feature, FeatureAdapter> adapters = new HashMap<Feature, FeatureAdapter>();
    private MenuSectionSupport menuSupport = new MenuSectionSupport();
    private NavigationPanel navigationPanel;
    private ActionFeatureAdapterProvider actionAdapterProvider;
    private BooleanFeatureAdapterProvider booleanAdapterProvider;
    private StringFeatureAdapterProvider stringAdapterProvider;
    private ScreenListFeatureAdapter screenListAdapter;

    @Inject
    public void initBrokerAdapter(BrokerAdapter brokerAdapter) {
        brokerAdapter.addLocationHandler(LOCATION, (LocationHandler)this);
    }

    @Inject
    public void initAdapterProviders(ActionFeatureAdapterProvider actionAdapterProvider, BooleanFeatureAdapterProvider booleanAdapterProvider, StringFeatureAdapterProvider stringAdapterProvider) {
        this.actionAdapterProvider = actionAdapterProvider;
        this.booleanAdapterProvider = booleanAdapterProvider;
        this.stringAdapterProvider = stringAdapterProvider;
    }

    @Inject
    public void initScreenListAdapter(ScreenListFeatureAdapter adapter) {
        this.screenListAdapter = adapter;
    }

    public void setNavigationPanel(NavigationPanel navigationPanel) {
        this.navigationPanel = navigationPanel;
        this.menuSupport.setMenu(navigationPanel.getOptionsMenu());
        this.menuSupport.addSection(PANEL_SECTION);
    }

    protected void addFeatureSwing(Feature feature) {
        Object area = feature.getHintValue(AREA);
        if (area.equals(OPTIONS_MENU_AREA)) {
            this.addMenuOption(feature);
        } else if (area.equals(PREVIOUS_ACTION_AREA)) {
            this.addPreviousAction(feature);
        } else if (area.equals(NEXT_ACTION_AREA)) {
            this.addNextAction(feature);
        } else if (area.equals(SELECTOR_AREA)) {
            this.addSelector(feature);
        } else if (area.equals(OPTION_AREA)) {
            this.addPanelOption(feature);
        } else if (area.equals(CONTENT_LIST)) {
            this.addContentList(feature);
        }
    }

    protected void removeFeatureSwing(Feature feature) {
        Object area = feature.getHintValue(AREA);
        if (area.equals(OPTIONS_MENU_AREA)) {
            this.removeMenuOption(feature);
        } else if (area.equals(PREVIOUS_ACTION_AREA)) {
            this.removePreviousAction(feature);
        } else if (area.equals(NEXT_ACTION_AREA)) {
            this.removeNextAction(feature);
        } else if (area.equals(SELECTOR_AREA)) {
            this.removeSelector(feature);
        } else if (area.equals(OPTION_AREA)) {
            this.removePanelOption(feature);
        } else if (area.equals(CONTENT_LIST)) {
            this.removeContentList(feature);
        }
    }

    protected void deliverNotificationSwing(Notification n) {
        if (n.hasHint(NAV_DOCKED)) {
            boolean dock = (Boolean)n.getHintValue(NAV_DOCKED, (Object)false);
            this.navigationPanel.setDocked(dock);
        } else {
            this.logger.message((Object)this, "deliverNotificationSwing", "Ignoring notification: " + n);
        }
    }

    protected void abortNotificationSwing(Notification n) {
        this.logger.message((Object)this, "abortNotificationSwing", "Ignoring notification: " + n);
    }

    protected void announceNotificationSwing(Notification n) {
    }

    private void addMenuOption(Feature feature) {
        CMenuItem c = null;
        ActionFeatureAdapter a = null;
        if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            CMenuItem mi = new CMenuItem();
            ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, af, (AbstractButton)mi, null);
            aa.setHasText(true);
            c = mi;
            a = aa;
        } else if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            CCheckBoxMenuItem cbmi = new CCheckBoxMenuItem();
            BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)cbmi, null);
            ba.setHasText(true);
            c = cbmi;
            a = ba;
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            Object section = feature.getHintValue(MENU_SECTION);
            float order = ((Float)feature.getHintValue(ORDER, Float.class)).floatValue();
            this.menuSupport.add((JComponent)c, String.valueOf(section), order);
        }
    }

    private void removeMenuOption(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.menuSupport.remove((JComponent)a.getComponent());
            a.dispose();
        }
    }

    private void addPreviousAction(Feature feature) {
        SButton c = null;
        ActionFeatureAdapter a = null;
        if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            SButton b = new SButton();
            ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, af, (AbstractButton)b, null);
            aa.setHasIcon(true);
            aa.setHasToolTip(true);
            c = b;
            a = aa;
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            this.navigationPanel.addPreviousButton(c);
        }
    }

    private void removePreviousAction(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.navigationPanel.removePreviousButton((AbstractButton)a.getComponent());
            a.dispose();
        }
    }

    private void addNextAction(Feature feature) {
        SButton c = null;
        ActionFeatureAdapter a = null;
        if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            SButton b = new SButton();
            ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, af, (AbstractButton)b, null);
            aa.setHasIcon(true);
            aa.setHasToolTip(true);
            c = b;
            a = aa;
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            this.navigationPanel.addNextButton(c);
        }
    }

    private void removeNextAction(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.navigationPanel.removeNextButton((AbstractButton)a.getComponent());
            a.dispose();
        }
    }

    private void addSelector(Feature feature) {
        if (feature instanceof ListFeature) {
            ListFeature lf = this.screenListAdapter.getListFeature();
            if (lf == feature) {
                return;
            }
            if (lf != null) {
                throw new IllegalStateException("Already have a list feature");
            }
            lf = (ListFeature)feature;
            JComboBox cb = this.screenListAdapter.getCombo();
            if (cb == null) {
                cb = new JComboBox();
            }
            this.screenListAdapter.init(cb, (ListFeature<ScreenInfo>)lf);
            this.adapters.put((Feature)lf, this.screenListAdapter);
            JLabel label = this.screenListAdapter.getAlternateLabel();
            if (label != null) {
                this.navigationPanel.removeSelectorComponent(label);
            }
            this.navigationPanel.addSelectorComponent(cb);
        } else if (feature instanceof ActionFeature) {
            this.screenListAdapter.initGotoAction((ActionFeature)feature);
            this.adapters.put(feature, this.screenListAdapter);
        } else if (feature instanceof ValueFeature) {
            ValueFeature<ScreenInfo> vf = this.screenListAdapter.getSelectedScreenFeature();
            if (vf == feature) {
                return;
            }
            if (vf != null) {
                throw new IllegalStateException("Already have a value feature");
            }
            JLabel label = this.screenListAdapter.getAlternateLabel();
            if (label == null) {
                label = new JLabel(){

                    @Override
                    public void setText(String text) {
                        super.setText(text);
                        this.setToolTipText(text);
                    }
                };
            }
            this.screenListAdapter.initSelectedFeature(label, (ValueFeature<ScreenInfo>)((ValueFeature)feature));
            this.adapters.put(feature, this.screenListAdapter);
            if (!this.screenListAdapter.isComboActive()) {
                this.navigationPanel.addSelectorComponent(label);
            }
        }
    }

    private void removeSelector(Feature feature) {
        if (this.adapters.get(feature) == this.screenListAdapter) {
            this.adapters.remove(feature);
            if (feature instanceof ListFeature) {
                JLabel label;
                if (this.screenListAdapter.getListFeature() != feature) {
                    throw new IllegalArgumentException("wrong list feature");
                }
                JComboBox cb = this.screenListAdapter.getCombo();
                if (cb != null) {
                    this.navigationPanel.removeSelectorComponent(cb);
                }
                this.screenListAdapter.removeListFeature();
                if (this.screenListAdapter.getSelectedScreenFeature() != null && (label = this.screenListAdapter.getAlternateLabel()) != null) {
                    this.navigationPanel.addSelectorComponent(label);
                }
            } else if (feature instanceof ActionFeature) {
                if (this.screenListAdapter.getGotoAction() != feature) {
                    throw new IllegalArgumentException("wrong action feature");
                }
                this.screenListAdapter.removeGotoAction();
            } else if (feature instanceof ValueFeature) {
                JComboBox cb;
                if (this.screenListAdapter.getSelectedScreenFeature() != feature) {
                    throw new IllegalArgumentException("wrong value feature");
                }
                JLabel label = this.screenListAdapter.getAlternateLabel();
                if (label != null) {
                    this.navigationPanel.removeSelectorComponent(label);
                }
                this.screenListAdapter.removeSelectedScreenFeature();
                if (this.screenListAdapter.getListFeature() != null && (cb = this.screenListAdapter.getCombo()) != null) {
                    this.navigationPanel.addSelectorComponent(cb);
                }
            }
            if (this.screenListAdapter.isEmpty()) {
                this.screenListAdapter.dispose();
            }
        }
    }

    private void addPanelOption(Feature feature) {
        JComponent c = null;
        StringFeatureAdapter a = null;
        if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            boolean isCheckBox = false;
            if (bf.hasHint(COMPONENT_TYPE) && bf.getHintValue(COMPONENT_TYPE).equals("checkBox")) {
                isCheckBox = true;
            }
            BooleanFeatureAdapter ba = null;
            if (isCheckBox) {
                SCheckBox cb = new SCheckBox();
                cb.setForeground(Color.WHITE);
                ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)cb, null);
                ba.setHasText(true);
                ba.setHasIcon(false);
                ba.setHasToolTip(true);
                c = cb;
            } else {
                SToggleButton tb = new SToggleButton();
                ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)tb, null);
                ba.setHasText(false);
                ba.setHasIcon(true);
                ba.setHasToolTip(true);
                c = tb;
            }
            a = ba;
        } else if (feature instanceof StringFeature) {
            StringFeatureAdapter adapt;
            StringFeature sf = (StringFeature)feature;
            if (sf.isMutable()) {
                JTextField fld = new JTextField();
                adapt = this.stringAdapterProvider.get(LOCATION, sf, fld, null);
                c = fld;
                a = adapt;
            } else {
                JLabel lbl = new JLabel();
                adapt = this.stringAdapterProvider.get(LOCATION, sf, lbl, null);
                c = lbl;
                a = adapt;
            }
            adapt.setHasText(true);
            adapt.setHasToolTip(true);
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            float order = ((Float)feature.getHintValue(ORDER, Float.class)).floatValue();
            this.navigationPanel.addOption(c, order);
        }
    }

    private void removePanelOption(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.navigationPanel.removeOption((JComponent)a.getComponent());
            a.dispose();
        }
    }

    private void addContentList(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            Component c = cf.getComponent();
            this.navigationPanel.addContentList(c);
        }
    }

    private void removeContentList(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            this.navigationPanel.removeContentList(cf.getComponent());
            if (!this.navigationPanel.isDocked()) {
                this.navigationPanel.setDocked(true);
            }
        }
    }
}

