/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.ModeController;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.groupware.imps.view.ViewMode;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumMap;
import java.util.Map;

public class ModeControllerLocationHandler
extends AbstractSwingLocationHandler {
    private static final String LOCATION = "modeController";
    private Map<ViewMode, String> modes = new EnumMap<ViewMode, String>(ViewMode.class);
    private MetaDataListener modeListener;
    private ModeController modeController;
    private EnumeratedFeature<String> modeFeature;
    private boolean recursive = false;

    public ModeControllerLocationHandler() {
        this.modes.put(ViewMode.WHITEBOARD, "WHITEBOARD");
        this.modes.put(ViewMode.APPSHARE, "APPSHARE");
        this.modes.put(ViewMode.WEBTOUR, "WEBTOUR");
        this.modeListener = new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent e) {
                String id = e.getID();
                if (id.equals("ValueFeature.value")) {
                    ModeControllerLocationHandler.this.updateMode((String)e.getNewValue());
                }
            }
        };
    }

    @Inject
    public void initBrokerAdapter(BrokerAdapter brokerAdapter) {
        brokerAdapter.addLocationHandler(LOCATION, (LocationHandler)this);
    }

    public void setModeController(ModeController modeController) {
        this.modeController = modeController;
        modeController.addModeChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (ModeControllerLocationHandler.this.recursive) {
                    return;
                }
                ViewMode mode = (ViewMode)e.getNewValue();
                if (ModeControllerLocationHandler.this.modes.containsKey(mode)) {
                    ModeControllerLocationHandler.this.modeFeature.requestValue(ModeControllerLocationHandler.this.modes.get(mode));
                }
            }
        });
    }

    protected void addFeatureSwing(Feature feature) {
        if (feature instanceof EnumeratedFeature && this.modeFeature == null) {
            this.modeFeature = (EnumeratedFeature)feature;
            this.modeFeature.addValueChangeListener(this.modeListener);
            this.modeFeature.addMetaDataListener("Feature.enabled", this.modeListener);
            this.updateMode((String)this.modeFeature.getValue());
            this.updateEnabled(this.modeFeature.isEnabled());
        }
    }

    protected void removeFeatureSwing(Feature feature) {
        if (this.modeFeature == feature) {
            this.modeFeature.removeValueChangeListener(this.modeListener);
            this.modeFeature.removeMetaDataListener("Feature.enabled", this.modeListener);
            this.modeFeature = null;
        }
    }

    private void updateMode(String value) {
        ViewMode mode = null;
        for (ViewMode m : this.modes.keySet()) {
            if (!this.modes.get(m).equals(value)) continue;
            mode = m;
            break;
        }
        this.recursive = true;
        this.modeController.setMode(mode);
        this.recursive = false;
    }

    private void updateEnabled(boolean enabled) {
        for (ViewMode m : this.modes.keySet()) {
            this.modeController.setModeEnabled(m, enabled);
        }
    }
}

