/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class MenuSectionSupport {
    private static final String SECTION_PROPERTY = "__section__";
    private static final String ORDER_PROPERTY = "__order__";
    private JPopupMenu menu;
    private Map<String, JSeparator> separators = new HashMap<String, JSeparator>();
    private ComponentListener itemListener = new ComponentAdapter(){

        @Override
        public void componentShown(ComponentEvent e) {
            MenuSectionSupport.this.updateSeparatorVisible(e.getComponent(), true);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            MenuSectionSupport.this.updateSeparatorVisible(e.getComponent(), false);
        }
    };

    public JPopupMenu getMenu() {
        return this.menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSection(String sectionName) {
        Map<String, JSeparator> map = this.separators;
        synchronized (map) {
            return this.separators.containsKey(sectionName);
        }
    }

    public void setMenu(JPopupMenu menu) {
        JMenuItem mi = new JMenuItem();
        mi.setVisible(false);
        menu.add(mi);
        this.menu = menu;
    }

    public void addSection(String section) {
        JPopupMenu.Separator sep = new JPopupMenu.Separator();
        sep.putClientProperty(SECTION_PROPERTY, section);
        sep.setVisible(false);
        this.separators.put(section, sep);
        this.menu.add(sep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(JComponent item, String section, float order) {
        Object object = this.menu.getTreeLock();
        synchronized (object) {
            int index;
            JSeparator sep = this.separators.get(section);
            if (sep != null && (index = this.menu.getComponentIndex(sep)) != -1) {
                ++index;
                int insertionIndex = -1;
                while (index < this.menu.getComponentCount()) {
                    float o;
                    Component c = this.menu.getComponent(index);
                    if (c instanceof JSeparator) {
                        insertionIndex = index;
                        break;
                    }
                    if (c instanceof JComponent && (o = this.getItemOrder(c)) > order) {
                        insertionIndex = index;
                        break;
                    }
                    ++index;
                }
                item.putClientProperty(SECTION_PROPERTY, section);
                item.putClientProperty(ORDER_PROPERTY, Float.valueOf(order));
                this.menu.add((Component)item, insertionIndex);
                if (item.isVisible()) {
                    this.updateSeparatorVisible(item, true);
                }
                item.addComponentListener(this.itemListener);
            }
        }
    }

    public void remove(JComponent item) {
        if (this.menu.isAncestorOf(item)) {
            item.removeComponentListener(this.itemListener);
            this.menu.remove(item);
            this.updateSeparatorVisible(item, false);
        }
    }

    private String getItemSection(Component item) {
        Object prop;
        if (item instanceof JComponent && (prop = ((JComponent)item).getClientProperty(SECTION_PROPERTY)) instanceof String) {
            return (String)prop;
        }
        return null;
    }

    private float getItemOrder(Component item) {
        Object prop;
        if (item instanceof JComponent && (prop = ((JComponent)item).getClientProperty(ORDER_PROPERTY)) instanceof Number) {
            return ((Number)prop).floatValue();
        }
        return -1.0f;
    }

    private boolean hasItemsVisibleAbove(JSeparator separator) {
        boolean visible = false;
        int index = this.menu.getComponentIndex(separator);
        if (index > 0) {
            --index;
            while (index >= 0) {
                if (this.menu.getComponent(index).isVisible()) {
                    visible = true;
                    break;
                }
                --index;
            }
        }
        return visible;
    }

    private String getNextVisibleSection(Component item) {
        String section = this.getItemSection(item);
        int index = this.menu.getComponentIndex(item);
        if (index != -1) {
            ++index;
            while (index < this.menu.getComponentCount()) {
                String sec;
                Component c = this.menu.getComponent(index);
                if (c.isVisible() && !(sec = this.getItemSection(c)).equals(section)) {
                    return sec;
                }
                ++index;
            }
        }
        return null;
    }

    private void updateSeparatorVisible(Component item, boolean itemShown) {
        String section = this.getItemSection(item);
        if (section != null) {
            if (itemShown) {
                JSeparator sep = this.separators.get(section);
                if (sep != null && this.hasItemsVisibleAbove(sep)) {
                    sep.setVisible(true);
                }
                if ((section = this.getNextVisibleSection(item)) != null && (sep = this.separators.get(section)) != null) {
                    sep.setVisible(true);
                }
            } else {
                int index;
                JSeparator sep = this.separators.get(section);
                if (sep != null && (index = this.menu.getComponentIndex(sep)) != -1) {
                    Component c;
                    ++index;
                    boolean visible = false;
                    while (index < this.menu.getComponentCount() && section.equals(this.getItemSection(c = this.menu.getComponent(index)))) {
                        if (c.isVisible()) {
                            visible = true;
                            break;
                        }
                        ++index;
                    }
                    if (!visible) {
                        sep.setVisible(false);
                        section = this.getNextVisibleSection(sep);
                        if (section != null && (sep = this.separators.get(section)) != null) {
                            sep.setVisible(false);
                        }
                    }
                }
            }
        }
    }
}

